/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug;

import com.ibm.bsf.BSFManager;
import com.ibm.debug.DebugAgent;
import com.ibm.debug.DebugAttachAgent;
import com.ibm.debug.DebugComponentImpl;
import com.ibm.debug.DebugEJBCollaborator;
import com.ibm.debug.DebugWebAppInvocationCollaborator;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaborator;
import java.util.ArrayList;
import java.util.List;

public class DebugAppServerComponentImpl
extends ComponentImpl {
    private boolean debugMode = false;
    EJBContainer ejbcontainer = null;
    WebContainerService webContainerService = null;
    DebugComponentImpl debugComponentImpl = null;
    public static DebugAgent fDebugAgent;
    public static List debugClassFilters;
    private static final TraceComponent tc;
    private static ActionThread fActionThread;
    private static volatile int fXsltDebugEnabled;
    private static InterruptedException fInterruptedException;
    public static final String DEFAULT_FACTORY_KEY = "javax.xml.transform.TransformerFactory";
    public static final String DEBUG_TRANSFORM_CLASS = "com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerFactory";

    public void initialize(Object config2) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize()");
        }
        this.debugMode = Boolean.getBoolean("was.debug.mode");
        Tr.debug(tc, "Server debugMode is " + this.debugMode);
        if (this.debugMode) {
            this.debugComponentImpl = (DebugComponentImpl)this.getService(DebugComponentImpl.class);
            if (this.debugComponentImpl != null) {
                List filters = this.debugComponentImpl.getDebugFilterClasses();
                debugClassFilters = new ArrayList();
                for (int i = 0; i < filters.size(); ++i) {
                    String filter = (String)filters.get(i);
                    debugClassFilters.add(filter);
                }
                this.releaseService(this.debugComponentImpl);
            }
            Tr.debug(tc, "registering EJB Debug Collaborator");
            this.ejbcontainer = (EJBContainer)this.getService(EJBContainer.class);
            if (this.ejbcontainer != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "registering EJB Debug Collaborator");
                }
                this.ejbcontainer.addCollaborator(new DebugEJBCollaborator());
                this.releaseService(this.ejbcontainer);
            }
            this.webContainerService = (WebContainerService)this.getService(WebContainerService.class);
            if (this.webContainerService != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "registering Web Container Debug Collaborator");
                }
                this.webContainerService.addWebAppCollaborator((WebAppCollaborator)new DebugWebAppInvocationCollaborator());
                this.releaseService(this.webContainerService);
            }
            fDebugAgent = new DebugAgent();
            fDebugAgent.initialize();
            if (this.attachAgentEnabled()) {
                DebugAttachAgent.initialize();
                this.debugAttachAgentIsReady();
            }
            this.performActions();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (this.debugMode) {
            DebugComponentImpl debugCI;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "starting BSFDebugManager");
            }
            if ((debugCI = (DebugComponentImpl)this.getService(DebugComponentImpl.class)) != null) {
                System.setProperty("com.ibm.bsf.serverPort", String.valueOf(debugCI.getBSFDebugPort()));
                this.releaseService(debugCI);
            }
            BSFManager.initBSFDebugManager();
            this.debugBSFPortisSet();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void debugBSFPortisSet() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BSFDebugManager started");
        }
    }

    public void debugAttachAgentIsReady() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DebugAttachAgent is ready");
        }
    }

    public boolean attachAgentEnabled() {
        String enabled = System.getProperty("com.ibm.debug.attach.agent.enabled");
        return enabled == null || !enabled.equals("false");
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getName() {
        return "com.ibm.debug.DebugComponentImpl";
    }

    public String getState() {
        return "working";
    }

    void performActions() {
        if (fXsltDebugEnabled == 1) {
            System.setProperty(DEFAULT_FACTORY_KEY, DEBUG_TRANSFORM_CLASS);
        } else if (fXsltDebugEnabled == 0 && DEBUG_TRANSFORM_CLASS.equals(System.getProperty(DEFAULT_FACTORY_KEY))) {
            System.clearProperty(DEFAULT_FACTORY_KEY);
        }
        if (fActionThread == null) {
            fActionThread = new ActionThread();
            fActionThread.start();
        }
    }

    static {
        tc = Tr.register(DebugAppServerComponentImpl.class.getName(), "DebugAppServerComponent");
        fActionThread = null;
        fXsltDebugEnabled = 0;
        fInterruptedException = new InterruptedException();
    }

    private class ActionThread
    extends Thread {
        ActionThread() {
            this.setName("com.ibm.debug.DebugAppServerComponentImpl.ActionThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ActionThread actionThread = this;
            synchronized (actionThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException e2) {
                    fActionThread = null;
                    DebugAppServerComponentImpl.this.performActions();
                }
            }
        }
    }
}

