/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DebugAttachAgent {
    private static final int SUCCESS = 0;
    private static final int BAD_XML = 1;
    private static final int SUPER_ADAPTER_NOT_FOUND = 2;
    private static final int ELEMENT_CREATION_FAILED = 3;
    private static final int USER_DISABLED = 4;
    private static boolean fIsInitialized = false;
    private static volatile int fIsAttached = 0;
    private static volatile String fSuperAdapterId = "";
    private static volatile String fDaemonHost = "";
    private static volatile int fDaemonPort = -1;
    private static final Object fWaitObject = new Object();
    private static Thread fWaitThread = null;
    private static InterruptedException fInterruptedException = new InterruptedException();
    private static final TraceComponent tc = Tr.register(DebugAttachAgent.class.getName(), "DebugComponent");

    public static void initialize() {
        if (fIsInitialized) {
            return;
        }
        Tr.debug(tc, "Initializing attach agent.");
        System.setProperty("com.ibm.debug.service.register.class", "com.ibm.debug.DebugAttachAgent");
        System.setProperty("com.ibm.debug.service.register.method", "registerElement");
        fIsInitialized = true;
    }

    public static boolean xsltEnabled() {
        String string = System.getProperty("com.ibm.debug.attach.agent.xslt.enabled");
        return string == null || !string.equals("false");
    }

    public static Object registerElement(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Registering: " + string);
        }
        if (fIsAttached == 0) {
            Tr.debug(tc, "Returning wait object.");
            if (fWaitThread == null) {
                fWaitThread = new WaitThread();
                fWaitThread.start();
            }
            return fWaitObject;
        }
        DaemonConversation daemonConversation = null;
        try {
            daemonConversation = new DaemonConversation(fDaemonHost, fDaemonPort);
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception creating DaemonConversation: " + exception);
            return null;
        }
        String string2 = DebugAttachAgent.getXMLString(string);
        if (string2 == null) {
            Tr.debug(tc, "XML registration string is null.");
            return null;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sending XML string to deamon: " + string2);
            }
            int n = daemonConversation.startConversation(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result of startConversation: " + n);
            }
            switch (n) {
                case 0: {
                    return daemonConversation.getSocket();
                }
                case 1: 
                case 2: 
                case 4: {
                    daemonConversation.closeSocket();
                    return null;
                }
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception from startConversation: " + exception);
        }
        daemonConversation.closeSocket();
        return null;
    }

    private static String getXMLString(String string) {
        Object object;
        CharArrayReader charArrayReader;
        Object object2;
        DOMParser dOMParser = new DOMParser();
        try {
            object2 = string.toCharArray();
            charArrayReader = new CharArrayReader((char[])object2);
            object = new InputSource(charArrayReader);
            dOMParser.parse((InputSource)object);
        }
        catch (SAXException sAXException) {
            Tr.debug(tc, "Exception parsing XML registration string: " + sAXException);
            return null;
        }
        catch (IOException iOException) {
            Tr.debug(tc, "Exception parsing XML registration string: " + iOException);
            return null;
        }
        object2 = dOMParser.getDocument();
        charArrayReader = new DocumentImpl();
        object = charArrayReader.createElement("superAdapter");
        charArrayReader.appendChild((Node)object);
        object.setAttribute("id", fSuperAdapterId);
        NodeList nodeList = object2.getElementsByTagName("extensionElement");
        if (nodeList == null || nodeList.getLength() <= 0) {
            return null;
        }
        Node node = nodeList.item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() <= 0) {
            return null;
        }
        Element element = charArrayReader.createElement(node.getNodeName());
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            element.setAttribute(node2.getNodeName(), node2.getNodeValue());
        }
        object.appendChild(element);
        String string2 = null;
        try {
            string2 = DebugAttachAgent.serializeDocument((Document)((Object)charArrayReader));
        }
        catch (IOException iOException) {
            Tr.debug(tc, "Exception serializing final XML string: " + iOException);
        }
        return string2;
    }

    private static String serializeDocument(Document document) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndenting(true);
        outputFormat.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8"), outputFormat);
        serializer.asDOMSerializer().serialize(document);
        return byteArrayOutputStream.toString("UTF8");
    }

    private static class WaitThread
    extends Thread {
        public WaitThread() {
            this.setName("com.ibm.debug.DebugAttachAgent.WaitThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WaitThread waitThread = this;
            synchronized (waitThread) {
                try {
                    Tr.debug(tc, "Waiting for connection.");
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Tr.debug(tc, "Got connection.");
                    fWaitThread = null;
                    Object object = fWaitObject;
                    synchronized (object) {
                        fWaitObject.notifyAll();
                    }
                }
            }
        }
    }

    private static class DaemonConversation {
        private static final int VERSION = -2;
        private static final String LAUNCH_CONFIG_ID_PROPERTY = "LaunchConfigTypeID";
        private static final String LAUNCH_CONFIG_ID_VALUE = "com.ibm.debug.wsa.ExtensionElementAttach";
        private static final String XML_PROPERTY = "XML";
        private Socket fSocket;
        private DataInputStream fInputStream;
        private DataOutputStream fOutputStream;

        public DaemonConversation(String string, int n) throws Exception {
            try {
                this.fSocket = new Socket(fDaemonHost, fDaemonPort);
                this.fSocket.setTcpNoDelay(true);
                this.fInputStream = new DataInputStream(this.fSocket.getInputStream());
                this.fOutputStream = new DataOutputStream(this.fSocket.getOutputStream());
            }
            catch (UnknownHostException unknownHostException) {
                this.closeSocket();
                throw unknownHostException;
            }
            catch (IOException iOException) {
                this.closeSocket();
                throw iOException;
            }
        }

        public int startConversation(String string) throws Exception {
            try {
                this.sendInitialInfo(string);
                this.readKey();
                return this.readResultCode();
            }
            catch (Exception exception) {
                this.closeSocket();
                throw exception;
            }
        }

        public Socket getSocket() {
            return this.fSocket;
        }

        public void closeSocket() {
            if (this.fSocket != null && !this.fSocket.isClosed()) {
                try {
                    this.fSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void sendInitialInfo(String string) throws Exception {
            this.fOutputStream.writeInt(-2);
            this.fOutputStream.writeInt(2);
            this.fOutputStream.writeInt(LAUNCH_CONFIG_ID_PROPERTY.length());
            this.fOutputStream.writeBytes(LAUNCH_CONFIG_ID_PROPERTY);
            this.fOutputStream.writeInt(LAUNCH_CONFIG_ID_VALUE.length());
            this.fOutputStream.writeBytes(LAUNCH_CONFIG_ID_VALUE);
            this.fOutputStream.writeInt(XML_PROPERTY.length());
            this.fOutputStream.writeBytes(XML_PROPERTY);
            this.fOutputStream.writeInt(string.length());
            this.fOutputStream.writeBytes(string);
            this.fOutputStream.flush();
        }

        private void readKey() throws Exception {
            this.fInputStream.readInt();
        }

        private int readResultCode() throws Exception {
            int n = this.fInputStream.readInt();
            return n;
        }
    }
}

