/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug;

import com.ibm.debug.DebugAppServerComponentImpl;
import com.ibm.debug.DebugBreakpoints;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppInvocationCollaborator;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class DebugWebAppInvocationCollaborator
implements WebAppInvocationCollaborator {
    protected String uriName = null;
    private static final TraceComponent tc = Tr.register(DebugWebAppInvocationCollaborator.class.getName(), "DebugComponent");

    public void preInvoke(WebComponentMetaData webComponentMetaData) {
        if (!this.checkfilterlist(webComponentMetaData.getImplementationClass()) && webComponentMetaData.getWebComponentType() == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JSP adding breakpoint at <init> in " + webComponentMetaData.getImplementationClass());
            }
            String string = "()V";
            DebugBreakpoints.debugJSPBreakpoint(webComponentMetaData.getImplementationClass(), "<init>", this.uriName, string);
        }
    }

    public void postInvoke(WebComponentMetaData webComponentMetaData) {
    }

    public void preInvoke(WebComponentMetaData webComponentMetaData, ServletRequest servletRequest, ServletResponse servletResponse) {
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "preInvoke for " + this.getMethod(((HttpServletRequest)servletRequest).getMethod()) + " in " + webComponentMetaData.getImplementationClass());
        }
        if (!this.checkfilterlist(webComponentMetaData.getImplementationClass())) {
            if (webComponentMetaData.getWebComponentType() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SERVLET adding breakpoint at " + this.getMethod(((HttpServletRequest)servletRequest).getMethod()) + " in " + webComponentMetaData.getImplementationClass());
                }
                string = ((HttpServletRequest)servletRequest).getRequestURI();
                this.setURIName(string);
                DebugBreakpoints.debugServletBreakpoint(webComponentMetaData.getImplementationClass(), this.getMethod(((HttpServletRequest)servletRequest).getMethod()));
            } else if (webComponentMetaData.getWebComponentType() == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JSP adding breakpoint at _jspService in " + webComponentMetaData.getImplementationClass());
                }
                String string2 = "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V";
                DebugBreakpoints.debugJSPBreakpoint(webComponentMetaData.getImplementationClass(), "_jspService", ((HttpServletRequest)servletRequest).getRequestURI(), string2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "some other value " + webComponentMetaData.getWebComponentType());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke");
        }
    }

    public void postInvoke(WebComponentMetaData webComponentMetaData, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    protected String getMethod(String string) {
        if (string.equals("GET")) {
            return "doGet";
        }
        if (string.equals("POST")) {
            return "doPost";
        }
        if (string.equals("HEAD")) {
            return "doHead";
        }
        if (string.equals("PUT")) {
            return "doPut";
        }
        if (string.equals("DELETE")) {
            return "doDelete";
        }
        if (string.equals("OPTIONS")) {
            return "doOptions";
        }
        if (string.equals("TRACE")) {
            return "doTrace";
        }
        return string;
    }

    protected boolean checkfilterlist(String string) {
        if (DebugAppServerComponentImpl.debugClassFilters != null) {
            for (int i = 0; i < DebugAppServerComponentImpl.debugClassFilters.size(); ++i) {
                String string2 = (String)DebugAppServerComponentImpl.debugClassFilters.get(i);
                int n = string2.indexOf(42);
                if (!(n != -1 ? string.startsWith(string2 = string2.substring(0, n)) : string.equals(string2))) continue;
                return true;
            }
        }
        return false;
    }

    protected String getURIName() {
        return this.uriName;
    }

    protected void setURIName(String string) {
        this.uriName = string;
    }
}

