/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.impl.LineBreakpoint;
import com.ibm.debug.transform.impl.NodeLocation;
import com.ibm.debug.xdi.XDILineBreakpoint;
import com.ibm.debug.xdi.util.CanonicalURI;
import java.util.ArrayList;
import java.util.Iterator;

public final class DebugBreakpointTable {
    public final ArrayList m_breakpoints = new ArrayList();
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public final void createLineBreakpoint(String fileNameURI, int lineNumber, int charStart, int charEnd) {
        LineBreakpoint breakpoint = LineBreakpoint.newInstance(fileNameURI, lineNumber, charStart, charEnd);
        this.m_breakpoints.add(breakpoint);
    }

    public final void deleteLineBreakpoint(XDILineBreakpoint lbp) {
        CanonicalURI uri = CanonicalURI.getInstance(lbp.getFileName());
        int lineNumber = lbp.getLineNumber();
        int charStart = lbp.getCharStart();
        int charEnd = lbp.getCharEnd();
        int pos = 0;
        Iterator iter = this.m_breakpoints.iterator();
        while (iter.hasNext()) {
            if (((LineBreakpoint)iter.next()).isEqualTo(uri, lineNumber, charStart, charEnd)) {
                this.m_breakpoints.remove(pos);
                break;
            }
            ++pos;
        }
    }

    public final boolean isEnabledBreakpoint(String fileNameURI, int lineNumber, int charStart, int charEnd) {
        CanonicalURI uri = CanonicalURI.getInstance(fileNameURI);
        Iterator iter = this.m_breakpoints.iterator();
        while (iter.hasNext()) {
            LineBreakpoint lineBreak = (LineBreakpoint)iter.next();
            if (!lineBreak.isEqualTo2(uri, lineNumber, charStart, charEnd) || !lineBreak.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public final LineBreakpoint getEnabledXmlBreakpoint(NodeLocation nodeLoc) {
        Iterator iter = this.m_breakpoints.iterator();
        while (iter.hasNext()) {
            LineBreakpoint lineBreak = (LineBreakpoint)iter.next();
            if (!lineBreak.getNodeLocation().equals2(nodeLoc) || !lineBreak.isEnabled()) continue;
            return lineBreak;
        }
        return null;
    }

    public final void setLineBreakpointEnabled(XDILineBreakpoint lbp, boolean enable) {
        String fileNameURI = lbp.getFileName();
        CanonicalURI uri = CanonicalURI.getInstance(fileNameURI);
        int lineNumber = lbp.getLineNumber();
        int charStart = lbp.getCharStart();
        int charEnd = lbp.getCharEnd();
        Iterator iter = this.m_breakpoints.iterator();
        while (iter.hasNext()) {
            LineBreakpoint breakpoint = (LineBreakpoint)iter.next();
            if (!breakpoint.isEqualTo2(uri, lineNumber, charStart, charEnd)) continue;
            breakpoint.setEnabled(enable);
            break;
        }
    }

    public final Iterator getEnabledBreakpoints() {
        ArrayList<LineBreakpoint> tempBreakpoints = new ArrayList<LineBreakpoint>();
        Iterator iter = this.m_breakpoints.iterator();
        while (iter.hasNext()) {
            LineBreakpoint breakpoint = (LineBreakpoint)iter.next();
            if (!breakpoint.isEnabled()) continue;
            tempBreakpoints.add(breakpoint);
        }
        return tempBreakpoints.iterator();
    }
}

