/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.CanonicalURI;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import org.apache.xml.utils.IntVector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DebugDocumentImpl
implements DebugDocument {
    private final IntVector m_lineOffsetTable = new IntVector();
    private String m_generatedFileContents = null;
    private char[] m_documentChars = null;
    final boolean m_generated;
    final String m_uriName;
    final int m_uniqueId;
    private static final char[] systemEOL = System.getProperty("line.separator").toCharArray();
    private static final char[] windowsEOL = new char[]{'\r', '\n'};
    private static final char[] unixEOL = new char[]{'\n'};
    static final int SHIFT = 1;
    private int[] m_lineOffsetArray;
    private XMLParser m_parsed = null;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    DebugDocumentImpl(String uriName, int id, boolean isGenerated) {
        this.m_uniqueId = id;
        this.m_uriName = uriName != null ? (uriName = CanonicalURI.getCanonicalURI(uriName)) : "null";
        if (!isGenerated && uriName != null && this.m_uriName != null && this.m_uriName.startsWith("xdi-generated-")) {
            isGenerated = true;
        }
        this.m_generated = isGenerated;
    }

    public final void setSerializedDocumentContents(String string) {
        this.m_generatedFileContents = string;
        if (this.m_generatedFileContents != null) {
            this.m_documentChars = this.m_generatedFileContents.toCharArray();
            int max2 = this.m_documentChars.length;
            if (this.m_documentChars != null) {
                this.m_lineOffsetTable.removeAllElements();
                this.m_lineOffsetTable.addElement(0);
                int cfr_ignored_0 = systemEOL.length;
                int lastSaved = 0;
                int i = 0;
                while (i < max2) {
                    block16: {
                        int j;
                        block15: {
                            block14: {
                                if (i + systemEOL.length - 1 < max2) {
                                    j = 0;
                                    while (j < systemEOL.length) {
                                        if (max2 > i + j && this.m_documentChars[i + j] == systemEOL[j]) {
                                            ++j;
                                            continue;
                                        }
                                        break block14;
                                    }
                                    lastSaved = i += systemEOL.length - 1;
                                    this.m_lineOffsetTable.addElement(i);
                                    ++i;
                                    continue;
                                }
                            }
                            if (i + windowsEOL.length - 1 < max2) {
                                j = 0;
                                while (j < windowsEOL.length) {
                                    if (max2 > i + j && this.m_documentChars[i + j] == windowsEOL[j]) {
                                        ++j;
                                        continue;
                                    }
                                    break block15;
                                }
                                lastSaved = i += windowsEOL.length - 1;
                                this.m_lineOffsetTable.addElement(i);
                                ++i;
                                continue;
                            }
                        }
                        if (i + unixEOL.length - 1 < max2) {
                            j = 0;
                            while (j < unixEOL.length) {
                                if (max2 > i + j && this.m_documentChars[i + j] == unixEOL[j]) {
                                    ++j;
                                    continue;
                                }
                                break block16;
                            }
                            lastSaved = i += unixEOL.length - 1;
                            this.m_lineOffsetTable.addElement(i);
                            ++i;
                            continue;
                        }
                    }
                    ++i;
                }
                if (lastSaved + 0 != max2) {
                    this.m_lineOffsetTable.addElement(max2);
                }
                int lines = this.m_lineOffsetTable.size();
                int[] offsetArray = this.m_lineOffsetArray = new int[lines];
                int idx = 0;
                while (idx < lines) {
                    offsetArray[idx] = this.m_lineOffsetTable.elementAt(idx);
                    ++idx;
                }
            }
        }
    }

    public final int getUniqueId() {
        return this.m_uniqueId;
    }

    public final String getURIName() {
        if (this.m_uniqueId == -1) {
            return null;
        }
        return this.m_uriName;
    }

    public String generatedFile() {
        return this.m_generatedFileContents;
    }

    public final int numCharsToEOL(int line) {
        int[] array = this.m_lineOffsetArray;
        int retval = line < 0 || array == null || array.length <= line ? -1 : array[line];
        return retval;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_uriName);
        sb.append(",");
        sb.append(this.m_uniqueId);
        sb.append(",");
        sb.append(this.m_generated ? "1" : "0");
        return sb.toString();
    }

    public final boolean isGenerated() {
        return this.m_generated;
    }

    public final void createNodesFromSerializedXML() {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            XMLParser ch = this.m_parsed = new XMLParser();
            reader.setContentHandler(ch);
            InputSource is = new InputSource();
            is.setSystemId(this.m_uriName);
            is.setCharacterStream(new StringReader(this.m_generatedFileContents));
            reader.parse(is);
        }
        catch (SAXException sAXException) {
            String msg = XDIMessage.getFormattedString("ER_PARSE_XML_DOC", this.m_uriName);
            XDIMessage.issueMessage(msg);
        }
        catch (IOException iOException) {
            String msg = XDIMessage.getFormattedString("ER_UNABLE_TO_LOCATE_XML_DOC", this.m_uriName);
            XDIMessage.issueMessage(msg);
        }
    }

    private final Node findBestNode(int line, int col) {
        int absOff = this.numCharsToEOL(line - 1);
        Node n = absOff == -1 ? null : (this.m_parsed == null ? null : this.m_parsed.binarySearch(absOff += col - 1, 0, this.m_parsed.m_nodes.size()));
        return n;
    }

    public final int numCharsToStartOfNode(int line, int col) {
        int retval;
        Node n = this.findBestNode(line, col);
        if (n == null) {
            retval = -1;
        } else {
            retval = n.m_absOffset1;
            if (line == 1) {
                ++retval;
            }
        }
        return retval;
    }

    public final int numCharsToEndOfNode(int line, int col) {
        int retval;
        Node n = this.findBestNode(line, col);
        if (n == null) {
            retval = -1;
        } else {
            retval = n.m_absOffset2;
            if (line == 1) {
                ++retval;
            }
        }
        return retval;
    }

    private class Node {
        private static final int TYPE_START_ELEM = 1;
        private static final int TYPE_OTHER = 2;
        private final int m_type;
        private int m_line1;
        private int m_lineOffset1;
        private int m_absOffset1;
        private final int m_line2;
        private final int m_lineOffset2;
        private final int m_absOffset2;

        private Node(int line2, int col2, int type) {
            char ch;
            this.m_line2 = line2;
            this.m_lineOffset2 = col2;
            this.m_type = type;
            int off = DebugDocumentImpl.this.numCharsToEOL(line2 - 1) + (col2 - 1);
            if (type == 1 && off >= 0 && off < DebugDocumentImpl.this.m_documentChars.length && (ch = DebugDocumentImpl.this.m_documentChars[off]) == '>') {
                ++off;
            }
            this.m_absOffset2 = off;
        }

        public void setAbsOffset1(int off) {
            char ch;
            if (this.m_type == 1 && off >= 0 && off < DebugDocumentImpl.this.m_documentChars.length && (ch = DebugDocumentImpl.this.m_documentChars[off]) != '<' && ++off < DebugDocumentImpl.this.m_documentChars.length && (ch = DebugDocumentImpl.this.m_documentChars[off]) != '<') {
                ++off;
            }
            this.m_absOffset1 = off;
        }
    }

    private class XMLParser
    implements ContentHandler {
        final char[] m_fileChars;
        private Vector m_nodes;
        Locator m_loc = null;

        XMLParser() {
            int max2 = DebugDocumentImpl.this.m_generatedFileContents.length();
            this.m_fileChars = new char[max2];
            DebugDocumentImpl.this.m_generatedFileContents.getChars(0, max2, this.m_fileChars, 0);
            this.m_nodes = new Vector();
        }

        public void setDocumentLocator(Locator locator) {
            this.m_loc = locator;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }

        public void endPrefixMapping(String arg0) throws SAXException {
        }

        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            int line = this.m_loc.getLineNumber();
            int col = this.m_loc.getColumnNumber();
            this.newNode(line, col, 1);
        }

        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            int line = this.m_loc.getLineNumber();
            int col = this.m_loc.getColumnNumber();
            this.newNode(line, col, 1);
        }

        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            int line = this.m_loc.getLineNumber();
            int col = this.m_loc.getColumnNumber();
            this.newNode(line, col, 2);
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            int line = this.m_loc.getLineNumber();
            int col = this.m_loc.getColumnNumber();
            int off = DebugDocumentImpl.this.numCharsToEOL(line - 1) + (col - 1);
            if (off >= 0 && off < this.m_fileChars.length) {
                char ch = this.m_fileChars[off];
                while (ch != '>' && ch != '\r' && ch != '\n' && off < this.m_fileChars.length - 1) {
                    ++col;
                    ch = this.m_fileChars[++off];
                }
                if (ch == '>') {
                    ++off;
                    ++col;
                }
            }
            this.newNode(line, col, 2);
        }

        public void processingInstruction(String arg0, String arg1) throws SAXException {
            int line = this.m_loc.getLineNumber();
            int col = this.m_loc.getColumnNumber();
            int off = DebugDocumentImpl.this.numCharsToEOL(line - 1) + (col - 1);
            if (off >= 0 && off < this.m_fileChars.length) {
                char ch = this.m_fileChars[off];
                while (ch != '>' && ch != '\r' && ch != '\n' && off < this.m_fileChars.length - 1) {
                    ++col;
                    ch = this.m_fileChars[++off];
                }
                if (ch == '>') {
                    ++off;
                    ++col;
                }
            }
            this.newNode(line, col, 2);
        }

        public void skippedEntity(String arg0) throws SAXException {
        }

        private void newNode(int line, int col, int type) {
            int iprev = this.m_nodes.size() - 1;
            if (iprev >= 0) {
                Node prev = (Node)this.m_nodes.elementAt(iprev);
                if (prev.m_line2 < line || prev.m_lineOffset2 < col) {
                    Node n = new Node(line, col, type);
                    n.m_line1 = prev.m_line2;
                    n.m_lineOffset1 = prev.m_lineOffset2;
                    n.setAbsOffset1(prev.m_absOffset2);
                    this.m_nodes.add(n);
                }
            } else {
                Node n = new Node(line, col, type);
                n.m_line1 = n.m_line2;
                int col1 = 1;
                int col_guess = col - 2;
                while (1 < col_guess) {
                    char ch;
                    int off = DebugDocumentImpl.this.numCharsToEOL(n.m_line1 - 1) + (col_guess - 1);
                    if (off >= 0 && off < DebugDocumentImpl.this.m_documentChars.length && ((ch = DebugDocumentImpl.this.m_documentChars[off]) == '<' || ch == '>')) {
                        col1 = col_guess;
                        break;
                    }
                    --col_guess;
                }
                n.m_lineOffset1 = col1;
                n.setAbsOffset1(DebugDocumentImpl.this.numCharsToEOL(n.m_line1 - 1) + (col1 - 1));
                this.m_nodes.add(n);
            }
        }

        private Node binarySearch(int absOff, int first, int lastPlus1) {
            int mid;
            Node nmid;
            Node n = first < lastPlus1 ? (absOff < (nmid = (Node)this.m_nodes.elementAt(mid = first + (lastPlus1 - first) / 2)).m_absOffset1 ? this.binarySearch(absOff, first, mid) : (nmid.m_absOffset2 <= absOff ? this.binarySearch(absOff, mid + 1, lastPlus1) : nmid)) : null;
            return n;
        }
    }
}

