/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.impl.DebugDocumentImpl;
import com.ibm.debug.transform.impl.DebugResultDocumentImpl;
import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.transform.intrface.DebugResultDocument;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.CanonicalURI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xml.utils.SystemIDResolver;

public class DebugDocumentManager {
    public static final String COPIED_INPUT_XSL_FROM_STREAM = "copiedStream:input.xsl";
    public static final String COPIED_INPUT_XML_FROM_STREAM = "copiedStream:input.xml";
    public static final String GENERATED_PREFIX = "xdi-generated-";
    private static int m_uniqueAcrossJVM = 0;
    private Hashtable m_URI2InputDoc = new Hashtable();
    private Hashtable m_URI2ResultDoc = new Hashtable();
    private Hashtable m_ID2Doc = new Hashtable();
    private Stack m_redirectStack = new Stack();
    private static final int XDI_DOCUMENT = 0;
    private static final int XDI_RESULT_DOCUMENT = 1;
    private int m_mostRecentlyUpdatedOutputDoc = 0;
    private static int m_ManagerIDCounter = 0;
    private final int m_ManagerID;
    private String m_primaryResultDocURI = "primary-output";
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    DebugDocument getDocument(int uniqueId) {
        Integer key = new Integer(uniqueId);
        DebugDocument ret = null;
        if (this.m_ID2Doc.containsKey(key)) {
            ret = (DebugDocument)this.m_ID2Doc.get(key);
        }
        return ret;
    }

    public DebugDocument getDocument(String uri) {
        String uriCanonical;
        DebugDocument ret = null;
        if (uri == null) {
            uri = "";
        }
        if (this.m_URI2InputDoc.containsKey(uriCanonical = CanonicalURI.getCanonicalURI(uri))) {
            ret = (DebugDocument)this.m_URI2InputDoc.get(uriCanonical);
        } else if (this.m_URI2InputDoc.containsKey(uri)) {
            ret = (DebugDocument)this.m_URI2InputDoc.get(uri);
        }
        return ret;
    }

    public DebugDocument newDocument(String uri, boolean isGenerated) {
        return this.newDocument(uri, 0, isGenerated);
    }

    void popRedirectID() {
        this.m_redirectStack.pop();
    }

    void pushRedirectID(int val) {
        this.m_redirectStack.push(new Integer(val));
    }

    public static String getURIforXSLfromSAX() {
        StringBuffer sb = new StringBuffer();
        sb.append(GENERATED_PREFIX);
        sb.append("SAXinput").append(DebugDocumentManager.getUniqueAcrossJVM()).append(".xsl");
        return sb.toString();
    }

    public static String getURIforXSLfromDOM() {
        StringBuffer sb = new StringBuffer();
        sb.append(GENERATED_PREFIX);
        sb.append("DOMinput").append(DebugDocumentManager.getUniqueAcrossJVM()).append(".xsl");
        return sb.toString();
    }

    public static String getURIforXSLfromStream() {
        StringBuffer sb = new StringBuffer();
        sb.append(GENERATED_PREFIX);
        sb.append("StreamInput").append(DebugDocumentManager.getUniqueAcrossJVM()).append(".xsl");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugDocumentManager() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.m_ManagerID = ++m_ManagerIDCounter;
        }
        DebugDocument doc = this.newDocument("http://built-in.template.rules/default.xsl", true);
        doc.setSerializedDocumentContents("<xsl:template match=\"/\">\n\t<xsl:apply-templates/>\n</xsl:template>\n\n<xsl:template match=\"*\">\n\t<xsl:apply-templates/>\n</xsl:template>\n\n<xsl:template match=\"text()|@*\">\n\t<xsl:value-of select=\".\"/>\n</xsl:template>\n\n<xsl:template match=\"processing-instruction()|comment()\"/>\n");
    }

    void addOutput(GenerateEvent ev) {
        DebugResultDocument doc;
        int key;
        if (!this.m_redirectStack.isEmpty()) {
            key = (Integer)this.m_redirectStack.peek();
            doc = (DebugResultDocument)this.getDocument(key);
        } else {
            doc = this.getResultDocument(this.m_primaryResultDocURI);
            if (doc == null) {
                doc = this.newResultDocument(this.m_primaryResultDocURI);
            }
            key = doc.getUniqueId();
        }
        this.setMostRecentlyUpdatedOutputDoc(key);
        doc.addOutput(ev);
    }

    public ArrayList getUpdateArrayList() {
        ArrayList list = new ArrayList();
        Enumeration enum2 = this.m_URI2ResultDoc.elements();
        while (enum2.hasMoreElements()) {
            DebugResultDocument doc = (DebugResultDocument)enum2.nextElement();
            boolean isMostRecentOutputDoc = doc == this.getCurrentResultDocument();
            list.addAll(doc.getUpdateList(isMostRecentOutputDoc));
        }
        return list;
    }

    public static String getURIforXMLfromSAX() {
        StringBuffer sb = new StringBuffer();
        sb.append(GENERATED_PREFIX);
        sb.append("SAXinput").append(DebugDocumentManager.getUniqueAcrossJVM()).append(".xml");
        return sb.toString();
    }

    public static String getURIforXMLfromDOM() {
        StringBuffer sb = new StringBuffer();
        sb.append(GENERATED_PREFIX);
        sb.append("DOMinput").append(DebugDocumentManager.getUniqueAcrossJVM()).append(".xml");
        return sb.toString();
    }

    public DebugResultDocument getResultDocument(String uri) {
        DebugResultDocument ret = null;
        if (uri == null) {
            uri = "";
        }
        if (this.m_URI2ResultDoc.containsKey(uri = CanonicalURI.getCanonicalURI(uri))) {
            ret = (DebugResultDocument)this.m_URI2ResultDoc.get(uri);
        }
        return ret;
    }

    public DebugResultDocument newResultDocument(String uri) {
        return (DebugResultDocument)this.newDocument(uri, 1, false);
    }

    private static synchronized int getUniqueAcrossJVM() {
        int id = m_uniqueAcrossJVM++;
        return id;
    }

    private DebugDocument newDocument(String uri, int type, boolean isGenerated) {
        DebugDocumentImpl result = null;
        if (uri == null) {
            uri = "";
        }
        int uid = DebugDocumentManager.getUniqueAcrossJVM();
        switch (type) {
            case 0: {
                result = new DebugDocumentImpl(uri, uid, isGenerated);
                break;
            }
            case 1: {
                result = new DebugResultDocumentImpl(uri, uid);
                this.setMostRecentlyUpdatedOutputDoc(result.getUniqueId());
            }
        }
        this.registerDocument(uri, result);
        return result;
    }

    public void registerDocument(String uri, DebugDocument doc) {
        int uniqueId = doc.getUniqueId();
        if (uniqueId == -1) {
            uri = "null";
        }
        uri = CanonicalURI.getCanonicalURI(uri);
        if (doc instanceof DebugResultDocument) {
            this.m_URI2ResultDoc.put(uri, doc);
        } else {
            this.m_URI2InputDoc.put(uri, doc);
            try {
                String absURI = SystemIDResolver.getAbsoluteURI((String)uri, null);
                this.m_URI2InputDoc.put(absURI, doc);
            }
            catch (TransformerException transformerException) {
                String msg = XDIMessage.getFormattedString("ER_GET_ABS_URI", uri);
                XDIMessage.issueMessage(msg);
            }
        }
        this.m_ID2Doc.put(new Integer(uniqueId), doc);
    }

    private DebugResultDocument getCurrentResultDocument() {
        DebugResultDocument resDoc = (DebugResultDocument)this.getDocument(this.m_mostRecentlyUpdatedOutputDoc);
        return resDoc;
    }

    private void setMostRecentlyUpdatedOutputDoc(int uniqueOutputDocID) {
        this.m_mostRecentlyUpdatedOutputDoc = uniqueOutputDocID;
    }

    public void setPrimaryResultDocURI(String uri) {
        this.m_primaryResultDocURI = uri;
    }

    public String getPrimaryResultDocURI() {
        return this.m_primaryResultDocURI;
    }
}

