/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.impl.DebugSession;
import com.ibm.debug.xdi.messages.XDIMessage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class DebugEngineManager {
    private boolean m_globalSuspendMode = false;
    private static DebugEngineManager m_instance = null;
    private final int m_port;
    private final String m_machine;
    private static final int FIRST_ID = 1;
    private static DebugSession[] m_debugSessions = new DebugSession[2];
    private static Hashtable m_Thread2Session = new Hashtable();
    private final Method fRegisterMethod;
    private static final String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><extensionElement extensionId=\"com.ibm.debug.wsa.javaDebugElements\" elementId=\"com.ibm.debug.xsl.javaDebugElement\"/>";
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";
    static /* synthetic */ Class class$0;

    private DebugEngineManager() {
        int port2 = -1;
        String suspendModeString = this.getSystemProperty("com.ibm.debug.xdi.suspend");
        if (suspendModeString != null && suspendModeString.toLowerCase().equals("true")) {
            this.m_globalSuspendMode = true;
        }
        this.m_machine = "localhost";
        String portString = this.getSystemProperty("com.ibm.debug.xdi.port");
        if (portString != null) {
            try {
                port2 = Integer.parseInt(portString);
            }
            catch (Exception exception) {
                String msg = XDIMessage.getFormattedString2("ER_PORT_NOT_INTEGER", portString, this.m_machine);
                XDIMessage.issueMessage(msg);
            }
        }
        this.m_port = port2;
        String className = this.getSystemProperty("com.ibm.debug.service.register.class");
        String methodName = this.getSystemProperty("com.ibm.debug.service.register.method");
        Method method2 = null;
        if (className != null && methodName != null) {
            try {
                Class<?> classObject = Class.forName(className);
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class[] parameters = classArray;
                method2 = classObject.getMethod(methodName, parameters);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        this.fRegisterMethod = method2;
    }

    public static synchronized DebugEngineManager getSingleton() {
        if (m_instance == null) {
            m_instance = new DebugEngineManager();
        }
        return m_instance;
    }

    private String getSystemProperty(final String propName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propName);
            }
        });
    }

    public final synchronized DebugSession createDebugSession() {
        DebugSession session;
        int max2 = m_debugSessions.length;
        int newSessionID = 1;
        while (newSessionID < max2) {
            if (m_debugSessions[newSessionID] == null) break;
            ++newSessionID;
        }
        if (newSessionID + 1 > max2) {
            DebugSession[] tempArray = new DebugSession[max2 * 2 + 1];
            System.arraycopy(m_debugSessions, 0, tempArray, 0, max2);
            m_debugSessions = tempArray;
        }
        Thread thrd = Thread.currentThread();
        DebugEngineManager.m_debugSessions[newSessionID] = session = new DebugSession(newSessionID, thrd);
        m_Thread2Session.put(thrd, session);
        return session;
    }

    public final synchronized Object getSocketOrWaitObject() {
        Object socket_or_wait_object = null;
        if (this.mustGetSocketFromService()) {
            Object result = this.callRegistrationService();
            if (result instanceof Socket) {
                socket_or_wait_object = (Socket)result;
            } else if (result == null) {
                System.out.println("DebugEngineManager: Register failed - running");
            } else {
                socket_or_wait_object = result;
            }
        } else if (this.mustMakeOurOwnSocket()) {
            try {
                socket_or_wait_object = new Socket(this.m_machine, this.m_port);
            }
            catch (UnknownHostException unknownHostException) {
                String msg = XDIMessage.getFormattedString("ER_SOCKET_CONNECT_HOST", this.m_machine);
                XDIMessage.issueMessage(msg);
            }
            catch (IOException iOException) {
                String port2 = Integer.toString(this.m_port);
                String msg = XDIMessage.getFormattedString2("ER_SOCKET_CONNECT", port2, this.m_machine);
                XDIMessage.issueMessage(msg);
            }
        }
        return socket_or_wait_object;
    }

    private boolean mustMakeOurOwnSocket() {
        boolean ret = false;
        if (!this.mustGetSocketFromService() && this.m_port > 0) {
            ret = true;
        }
        return ret;
    }

    final DebugSession getDebugSession(int debugSessionID) {
        DebugSession session = null;
        if (debugSessionID < m_debugSessions.length) {
            session = m_debugSessions[debugSessionID];
        }
        return session;
    }

    final synchronized void removeDebugSession(int debugSessionID) {
        DebugSession ds;
        if (debugSessionID < m_debugSessions.length && (ds = m_debugSessions[debugSessionID]) != null) {
            Thread t = ds.getCreatorThread();
            DebugSession ds2 = (DebugSession)m_Thread2Session.get(t);
            if (ds2 == ds) {
                m_Thread2Session.remove(t);
            }
            DebugEngineManager.m_debugSessions[debugSessionID] = null;
        }
    }

    final synchronized void removeDebugSession(DebugSession ds) {
        int max2 = m_debugSessions.length;
        int id = 0;
        id = 1;
        while (id < max2) {
            if (m_debugSessions[id] == ds) break;
            ++id;
        }
        if (1 <= id) {
            this.removeDebugSession(id);
        }
    }

    public final DebugSession getDebugSession(Thread thread) {
        DebugSession session = null;
        if (m_Thread2Session.containsKey(thread)) {
            session = (DebugSession)m_Thread2Session.get(thread);
        }
        return session;
    }

    private boolean mustGetSocketFromService() {
        return this.fRegisterMethod != null;
    }

    private Object callRegistrationService() {
        Object[] args = new Object[]{xmlString};
        Object result = null;
        try {
            result = this.fRegisterMethod.invoke(null, args);
        }
        catch (IllegalArgumentException e2) {
            System.out.println(e2);
        }
        catch (IllegalAccessException e2) {
            System.out.println(e2);
        }
        catch (InvocationTargetException e2) {
            System.out.println(e2);
        }
        return result;
    }
}

