/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.impl.DebugDocumentImpl;
import com.ibm.debug.transform.intrface.DebugResultDocument;
import com.ibm.debug.xslt.commpacket.Packet;
import com.ibm.debug.xslt.commpacket.PacketResultDocUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xml.serializer.Serializer;

public class DebugResultDocumentImpl
extends DebugDocumentImpl
implements DebugResultDocument {
    private Serializer m_resultTreeHandler = null;
    private String m_tempPendingUpdate = "";
    private boolean m_updatesPending = true;
    private final StringBuffer m_pendingUpdate = new StringBuffer();
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    private void setTempUpdate(String output) {
        this.m_tempPendingUpdate = output;
        if (!this.m_updatesPending && output.length() > 0) {
            this.m_updatesPending = true;
        }
    }

    private void appendToUpdateBuffer(String output) {
        this.m_pendingUpdate.append(output);
        if (!this.m_updatesPending && output.length() > 0) {
            this.m_updatesPending = true;
        }
        this.m_tempPendingUpdate = "";
    }

    public DebugResultDocumentImpl(String uri, int uniqueId) {
        super(uri, uniqueId, false);
    }

    public void addOutput(GenerateEvent ev) {
        switch (ev.m_eventtype) {
            case 12: {
                this.appendToUpdateBuffer(new String(ev.m_characters));
                break;
            }
            case 11: {
                this.setTempUpdate(new String(ev.m_characters));
            }
        }
    }

    public String generatedFile() {
        return null;
    }

    public Collection getUpdateList(boolean isCurrent) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.m_updatesPending) {
            PacketResultDocUpdate pData = new PacketResultDocUpdate(this.m_uriName, this.m_uniqueId, this.m_generated, isCurrent, this.getOutputMethod());
            String data = ((Packet)pData).getData();
            list.add(data);
            list.add(this.m_pendingUpdate.toString());
            list.add(this.m_tempPendingUpdate);
            this.m_pendingUpdate.setLength(0);
            this.m_tempPendingUpdate = "";
            this.m_updatesPending = false;
        }
        return list;
    }

    public String getOutputMethod() {
        Properties props;
        String ret = null;
        if (this.m_resultTreeHandler != null && (props = this.m_resultTreeHandler.getOutputFormat()) != null) {
            ret = props.getProperty("method");
        }
        if (ret == null) {
            ret = "unknown";
        }
        return ret;
    }

    public void setSerializer(Serializer resultTreeHandler) {
        this.m_resultTreeHandler = resultTreeHandler;
    }
}

