/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.impl.DebugBreakpointTable;
import com.ibm.debug.transform.impl.DebugDocumentManager;
import com.ibm.debug.transform.impl.DebugTraceListener;
import com.ibm.debug.transform.impl.LineBreakpoint;
import com.ibm.debug.transform.impl.NodeLocation;
import com.ibm.debug.transform.impl.StackFrame;
import com.ibm.debug.transform.impl.StepMode;
import com.ibm.debug.transform.impl.SuspendState;
import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.xdi.DuplicateRequestException;
import com.ibm.debug.xdi.EvaluationException;
import com.ibm.debug.xdi.InvalidStateException;
import com.ibm.debug.xdi.OperationNotAvailableException;
import com.ibm.debug.xdi.XDIBreakpoint;
import com.ibm.debug.xdi.XDILineBreakpoint;
import com.ibm.debug.xdi.impl.DebugPacket;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerImpl;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.SocketListener;
import com.ibm.debug.xdi.util.SocketManager;
import com.ibm.debug.xdi.util.SocketWriter;
import com.ibm.debug.xdi.util.UniqueID;
import com.ibm.debug.xslt.commpacket.PacketLineBreakPoint;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import org.apache.xalan.Version;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.ElemWithParam;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;

public final class DebugSession {
    private final int m_debugSessionID;
    private SocketWriter m_writer;
    private SocketListener m_socketListener;
    private Socket m_socket;
    private final Thread m_threadThatCreatedThisSession;
    private final DebugBreakpointTable m_breakpointTable;
    private boolean m_suspendMode = false;
    private volatile boolean m_entryExitMode = false;
    private volatile boolean m_filterOutDefaultRuleStackframes = false;
    private volatile boolean m_nodeStepping = false;
    private volatile boolean m_setupIsComplete = false;
    private TransformerThreadInfo[] m_transformerThreads;
    private static final int INITIAL_SIZE = 1;
    private int m_numberOfTransformations = 0;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    DebugSession(int newSessionID, Thread thread) {
        this.m_debugSessionID = newSessionID;
        this.m_breakpointTable = new DebugBreakpointTable();
        this.m_threadThatCreatedThisSession = thread;
        this.m_transformerThreads = new TransformerThreadInfo[1];
    }

    public void attachSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.setTcpNoDelay(true);
                SocketCommunicator debugPacketReaderWriter = new SocketCommunicator();
                this.m_socketListener = new SocketListener(debugPacketReaderWriter, socket, this.m_debugSessionID);
                this.m_socketListener.setDaemonThread(true);
                this.m_socketListener.startThread();
                this.m_writer = new SocketWriter(debugPacketReaderWriter, socket, this.m_debugSessionID);
                this.m_socket = socket;
                while (!this.isSetupComplete()) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
                System.exit(1);
            }
            try {
                this.m_writer.setDaemonThread(true);
                this.m_writer.startThread();
            }
            catch (Exception exception) {
                String session = Integer.toString(this.m_debugSessionID);
                String msg = XDIMessage.getFormattedString("ER_STARTING_SOCKET_THREAD", session);
                XDIMessage.issueMessage(msg);
            }
        }
    }

    public boolean isAttached() {
        boolean ret = this.m_socket != null;
        return ret;
    }

    public Socket detachSocketImmediate() {
        this.disconnect();
        this.cleanup();
        Socket used_before = this.m_socket;
        this.m_socket = null;
        return used_before;
    }

    public Socket detachSocket() {
        Socket returned_socket = null;
        int trans = this.activeDebugTranCount();
        if (trans == 0) {
            this.cleanup();
            returned_socket = this.m_socket;
            this.m_socket = null;
        }
        return returned_socket;
    }

    Thread getCreatorThread() {
        return this.m_threadThatCreatedThisSession;
    }

    public int getDebugSessionID() {
        return this.m_debugSessionID;
    }

    private boolean send(DebugPacket packet) {
        boolean was_sent;
        if (this.m_writer != null) {
            this.m_writer.send(packet);
            was_sent = true;
        } else {
            was_sent = false;
        }
        return was_sent;
    }

    public boolean sendMessage(int transformerId, int requestId, String[] data) {
        DebugPacket packet = new DebugPacket(transformerId, 100, requestId, data);
        boolean was_sent = this.send(packet);
        return was_sent;
    }

    private void createLineBreakpoint(String fileName, int lineNumber, int charStart, int charEnd) {
        this.m_breakpointTable.createLineBreakpoint(fileName, lineNumber, charStart, charEnd);
    }

    private void deleteLineBreakpoint(XDILineBreakpoint breakpoint) {
        this.m_breakpointTable.deleteLineBreakpoint(breakpoint);
    }

    private void setLineBreakpointEnabled(XDILineBreakpoint lbp, boolean enable) {
        this.m_breakpointTable.setLineBreakpointEnabled(lbp, enable);
    }

    private void deleteBreakpoint(XDIBreakpoint breakpoint) {
        if (breakpoint instanceof XDILineBreakpoint) {
            XDILineBreakpoint lbp = (XDILineBreakpoint)breakpoint;
            this.m_breakpointTable.deleteLineBreakpoint(lbp);
        }
    }

    private void setEnabled(XDILineBreakpoint lbp, boolean enable) {
        this.m_breakpointTable.setLineBreakpointEnabled(lbp, enable);
    }

    LineBreakpoint getEnabledXmlBreakpoint(NodeLocation xmlLocation) {
        return this.m_breakpointTable.getEnabledXmlBreakpoint(xmlLocation);
    }

    public Iterator getEnabledBreakpoints() {
        return this.m_breakpointTable.getEnabledBreakpoints();
    }

    public boolean isSuspended() {
        return this.m_suspendMode;
    }

    public boolean getEntryExitMode() {
        return this.m_entryExitMode;
    }

    public boolean shouldFilterOutDefaultRuleStackframes() {
        return this.m_filterOutDefaultRuleStackframes;
    }

    boolean isNodeStepping() {
        return this.m_nodeStepping;
    }

    private void setEntryExitMode(boolean enable) {
        this.m_entryExitMode = enable;
    }

    private void setNodeStepping(boolean enable) {
        this.m_nodeStepping = enable;
    }

    private void setFilterBuiltinRules(boolean filterOut) {
        this.m_filterOutDefaultRuleStackframes = filterOut;
    }

    public boolean getCalloutMode(int transformerID) {
        TransformerThreadInfo tti = this.getTransformInfo(transformerID);
        if (tti == null) {
            return false;
        }
        boolean enabled = this.getTransformInfo((int)transformerID).m_calloutEnabled;
        return enabled;
    }

    private void setExtensionElementMode(int transformerID, boolean enable) {
        TransformerThreadInfo tti = this.getTransformInfo(transformerID);
        if (tti == null) {
            return;
        }
        this.getTransformInfo((int)transformerID).m_calloutEnabled = enable;
    }

    public void setStepPending(int transformID, boolean pending) {
        TransformerThreadInfo transformInfo = this.getTransformInfo(transformID);
        if (transformInfo != null) {
            DebugTransformerImpl transformation = transformInfo.getTransform();
            SuspendState susp = transformInfo.getSuspendState();
            if (susp == SuspendState.NORMAL_SUSPENDED || susp == SuspendState.FAKE_SUSPEND) {
                transformInfo.setStepPending(pending);
            } else {
                String session = Integer.toString(this.m_debugSessionID);
                String tran_uri = transformation.getStylesheetURIName();
                String msg = XDIMessage.getFormattedString2("ER_STEP_PENDING", session, tran_uri);
                XDIMessage.issueMessage(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeTransformation(DebugTransformerImpl transformation) {
        DebugTransformerImpl debugTransformerImpl = transformation;
        synchronized (debugTransformerImpl) {
            try {
                ((Object)((Object)transformation)).notifyAll();
            }
            catch (Exception exception) {
                String session = Integer.toString(this.m_debugSessionID);
                String uri = transformation.getStylesheetURIName();
                String msg = XDIMessage.getFormattedString2("ER_COULD_NOT_RESUME_TRANS", session, uri);
                XDIMessage.issueMessage(msg);
            }
        }
    }

    private void disconnect() {
        int threads = this.getNumTransformerThreads();
        int i = 0;
        while (i < threads) {
            this.disconnect(i);
            ++i;
        }
    }

    private synchronized void setupIsComplete() {
        this.m_setupIsComplete = true;
    }

    public synchronized boolean isSetupComplete() {
        return this.m_setupIsComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTransformation(int transformID) {
        TransformerThreadInfo transformInfo = this.getTransformInfo(transformID);
        if (transformInfo != null && this.m_writer != null) {
            DebugTransformerImpl transformation;
            DebugTransformerImpl debugTransformerImpl = transformation = transformInfo.getTransform();
            synchronized (debugTransformerImpl) {
                try {
                    this.setSuspended(transformID, SuspendState.NORMAL_SUSPENDED);
                    ((Object)((Object)transformation)).wait();
                }
                catch (InterruptedException interruptedException) {
                    String session = Integer.toString(this.m_debugSessionID);
                    String uri = transformation.getStylesheetURIName();
                    String msg = XDIMessage.getFormattedString2("ER_COULD_NOT_SUSPEND_TRANS", session, uri);
                    XDIMessage.issueMessage(msg);
                }
            }
        }
    }

    private synchronized int activeDebugTranCount() {
        int count = 0;
        int mx = this.m_transformerThreads.length;
        int idx = 0;
        while (idx < mx) {
            if (this.m_transformerThreads[idx] != null) {
                ++count;
            }
            ++idx;
        }
        return count;
    }

    private void cleanup() {
        if (this.m_writer != null) {
            if (this.m_writer.isAliveThread()) {
                this.m_writer.stopThread();
            }
            if (this.m_socketListener.isAliveThread()) {
                this.m_socketListener.stopThread();
            }
        }
        this.m_writer = null;
        this.m_socketListener = null;
        this.m_numberOfTransformations = 0;
    }

    public int addTransformer(DebugTransformerImpl transformer, DebugTraceListener listener) {
        int index;
        if ((index = this.m_numberOfTransformations++) + 1 > this.m_transformerThreads.length) {
            int length = this.m_transformerThreads.length;
            TransformerThreadInfo[] tempArray = new TransformerThreadInfo[length * 2 + 1];
            System.arraycopy(this.m_transformerThreads, 0, tempArray, 0, length);
            this.m_transformerThreads = tempArray;
        }
        this.m_transformerThreads[index] = new TransformerThreadInfo(transformer, listener);
        return index;
    }

    private int getTransformID(Thread thread) {
        int i = 0;
        while (i < this.m_transformerThreads.length) {
            TransformerThreadInfo transInfo = this.m_transformerThreads[i];
            if (transInfo != null && transInfo.getJavaThread() == thread) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getTransformID(DebugTransformerImpl transformer) {
        int i = 0;
        while (i < this.m_transformerThreads.length) {
            TransformerThreadInfo transInfo = this.m_transformerThreads[i];
            if (transInfo != null && transInfo.getTransformer() == transformer) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private TransformerThreadInfo getTransformInfo(int transformID) {
        return this.m_transformerThreads[transformID];
    }

    public DebugTransformerImpl getTransform(int transformerId) {
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti == null) {
            return null;
        }
        return this.getTransformInfo(transformerId).getTransform();
    }

    private int getNumTransformerThreads() {
        return this.m_transformerThreads.length;
    }

    public void removeTransformer(int transformerID) {
        this.m_transformerThreads[transformerID] = null;
        Socket con2adapter = this.detachSocket();
        if (con2adapter != null) {
            try {
                con2adapter.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    private void resume() {
        if (this.m_suspendMode) {
            int i = 0;
            while (i < this.m_transformerThreads.length) {
                this.resume(i);
                ++i;
            }
            this.m_suspendMode = false;
        }
    }

    private void resume(int transformID) {
        TransformerThreadInfo transformInfo = this.m_transformerThreads[transformID];
        if (transformInfo != null) {
            DebugTransformerImpl transformation = transformInfo.getTransformer();
            this.resumeTransformation(transformation);
        }
    }

    private void disconnect(int transformerId) {
        DebugTransformerImpl transformer = null;
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti != null) {
            transformer = tti.getTransform();
        }
        if (transformer != null) {
            if (!this.getTransformInfo(transformerId).isSuspended()) {
                this.suspendTransformation(transformerId);
            }
            this.getTransformInfo(transformerId).getTraceListener().disconnectTransform();
            this.m_transformerThreads[transformerId] = null;
            this.resumeTransformation(transformer);
        }
    }

    public void setSuspended(int transformerId, SuspendState suspended) throws ArrayIndexOutOfBoundsException {
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti == null) {
            return;
        }
        this.getTransformInfo(transformerId).setSuspended(suspended);
    }

    public void setJavaThread(int transformID, Thread thrd) {
        TransformerThreadInfo tti = this.getTransformInfo(transformID);
        if (tti == null) {
            return;
        }
        this.getTransformInfo(transformID).m_thread = thrd;
    }

    public void setStack(int transformerId, DebugTraceListener.Frames stack) throws ArrayIndexOutOfBoundsException {
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti == null) {
            return;
        }
        this.getTransformInfo(transformerId).setStackFrames(stack);
    }

    public boolean isConstructingRTF(int transformerId) {
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti == null) {
            return false;
        }
        return !this.getTransformInfo(transformerId).getRTFStack().empty();
    }

    void addOutputRTF(int transformerId, GenerateEvent ev) {
        Stack rtfStack = this.getTransformInfo(transformerId).getRTFStack();
        if (rtfStack != null && rtfStack.size() > 0) {
            ((IncompleteRTFInfo)rtfStack.peek()).addOutput(ev);
        }
    }

    public void pushRTF(int transformerId, ElemTemplateElement rtfVar, int dtmNode) {
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti == null) {
            return;
        }
        IncompleteRTFInfo rtfInfo = new IncompleteRTFInfo(rtfVar, dtmNode);
        this.getTransformInfo(transformerId).getRTFStack().push(rtfInfo);
    }

    public void popRTF(int transformerId) {
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti == null) {
            return;
        }
        IncompleteRTFInfo rtfInfo = (IncompleteRTFInfo)this.getTransformInfo(transformerId).getRTFStack().pop();
        if (rtfInfo.getVariable() != null) {
            this.getTransformInfo(transformerId).getVarToRTFValueHash().put(rtfInfo.getVariable(), rtfInfo.getOutput().toString());
        }
    }

    public void setGlobalVariables(int transformerId, ArrayList globVars) throws ArrayIndexOutOfBoundsException {
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti == null) {
            return;
        }
        this.getTransformInfo(transformerId).setGlobalVariables(globVars);
    }

    boolean hasSetGlobalVariables(int transformerId) throws ArrayIndexOutOfBoundsException {
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti == null) {
            return false;
        }
        return this.getTransformInfo(transformerId).hasSetGlobalVariables();
    }

    ArrayList buildVariableStrings(int transformerId) {
        LinkedHashMap<String, StackFrame.VarInfo> localVarName2VarInfo = new LinkedHashMap<String, StackFrame.VarInfo>();
        ArrayList<String> varList = new ArrayList<String>();
        TransformerThreadInfo transformerInfo = this.getTransformInfo(transformerId);
        if (transformerInfo == null) {
            return varList;
        }
        if (transformerInfo.getStackFrames() == null) {
            return varList;
        }
        int frameId = transformerInfo.getStackFrames().size() - 1;
        XPathContext xpathContext = transformerInfo.getTransform().getXPathContext();
        xpathContext.getContextNode();
        int startFrameId = frameId;
        DebugTraceListener.Frames threadStackFrames = transformerInfo.getStackFrames();
        while (threadStackFrames.getFrame(startFrameId).getForEach()) {
            --startFrameId;
        }
        int j = startFrameId;
        while (j <= frameId) {
            StackFrame stackFrame = transformerInfo.getStackFrames().getFrame(j);
            int vars = stackFrame.numVariables();
            int i = 0;
            while (i < vars) {
                StackFrame.VarInfo varInfo = stackFrame.getVarInfo(i);
                String name2 = varInfo.getName();
                if (name2 != null) {
                    localVarName2VarInfo.put(name2, varInfo);
                }
                ++i;
            }
            ++j;
        }
        StackFrame.VarInfo[] globVars = transformerInfo.getGlobalVariables();
        int max2 = globVars.length;
        int idx = 0;
        while (idx < max2) {
            StackFrame.VarInfo globVarInfo = globVars[idx];
            String varName = globVarInfo.getName();
            if (varName != null && localVarName2VarInfo.get(varName) == null) {
                this.addToVariableList(varList, globVarInfo, transformerInfo, xpathContext, transformerId, false);
            }
            ++idx;
        }
        Object[] objs = localVarName2VarInfo.values().toArray();
        max2 = objs.length;
        idx = 0;
        while (idx < max2) {
            StackFrame.VarInfo localVarInfo = (StackFrame.VarInfo)objs[idx];
            this.addToVariableList(varList, localVarInfo, transformerInfo, xpathContext, transformerId, true);
            ++idx;
        }
        Stack rtfStack = transformerInfo.getRTFStack();
        int i = 0;
        while (i < rtfStack.size()) {
            IncompleteRTFInfo rtfInfo = (IncompleteRTFInfo)rtfStack.elementAt(i);
            ElemTemplateElement elemVar = rtfInfo.getVariable();
            if (elemVar != null) {
                StringBuffer varString = new StringBuffer();
                if (elemVar instanceof ElemVariable) {
                    varString.append(((ElemVariable)elemVar).getName());
                } else if (elemVar instanceof ElemWithParam) {
                    varString.append(((ElemWithParam)elemVar).getName());
                } else {
                    varString.append("error");
                    String msg = XDIMessage.getFormattedString("ER_FAIL_VARIABLE_EVAL");
                    XDIMessage.issueMessage(msg);
                }
                varString.append(',');
                varString.append(transformerInfo.idGenerator.getID(elemVar));
                varString.append(',');
                String output = rtfInfo.getOutput().toString();
                output = output.concat(rtfInfo.getTempOutput());
                varString.append(this.buildIncompleteRTFString(output));
                varList.add(varString.toString());
            }
            ++i;
        }
        return varList;
    }

    private void addToVariableList(ArrayList varList, StackFrame.VarInfo varInfo, TransformerThreadInfo transformerInfo, XPathContext xpathContext, int transformerId, boolean isLocalVar) {
        String varName = varInfo.getName();
        ElemVariable var = varInfo.getElemVariable();
        try {
            String val = varInfo.getCachedValue();
            if (val == null) {
                StringBuffer varString = new StringBuffer();
                varString.append(varName);
                varString.append(",");
                int varId = transformerInfo.idGenerator.getID(var);
                varString.append(varId);
                varString.append(",");
                XObject result = isLocalVar ? xpathContext.getVarStack().getLocalVariable(xpathContext, var.getIndex()) : xpathContext.getVarStack().getGlobalVariable(xpathContext, var.getIndex());
                if (result.getType() == 5) {
                    String valueString = (String)transformerInfo.getVarToRTFValueHash().get(var);
                    varString.append(this.buildValueString(result, transformerId, valueString));
                } else {
                    varString.append(this.buildValueString(result, transformerId));
                }
                val = varString.toString();
                varInfo.setCachedValue(val);
                varInfo.setVarId(varId);
            }
            varList.add(val);
        }
        catch (Exception exception) {
            String msgName = varName == null ? "null" : varName;
            String msg = XDIMessage.getFormattedString("ER_FAIL_VARIABLE_EVAL", msgName);
            XDIMessage.issueMessage(msg);
        }
    }

    private String buildValueString(XObject result, int transformerId, String rtfValueString) {
        TransformerThreadInfo transInfo = this.getTransformInfo(transformerId);
        if (transInfo == null) {
            return "*** BAD VALUE ***";
        }
        XPathContext xpathContext = this.getTransformInfo(transformerId).getTransform().getXPathContext();
        StringBuffer varString = new StringBuffer();
        DTMIterator nl = null;
        varString.append(result.getType());
        varString.append(",");
        switch (result.getType()) {
            case 3: {
                varString.append('\"');
                varString.append(((XString)result).str());
                varString.append('\"');
                break;
            }
            case 1: {
                varString.append(((XBoolean)result).str());
                break;
            }
            case 2: {
                varString.append(((XNumber)result).str());
                break;
            }
            case 5: {
                nl = ((XRTreeFrag)result).asNodeIterator();
            }
            case 4: {
                ArrayList<Integer> nodes = new ArrayList<Integer>();
                if (nl == null) {
                    nl = ((XNodeSet)result).iter();
                }
                int currentPos = -1;
                currentPos = nl.getCurrentPos();
                nl.setShouldCacheNodes(true);
                DTMIterator clone = null;
                try {
                    clone = nl.cloneWithReset();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    String msg = XDIMessage.getFormattedString("ER_XPATH_REPRESENTATION");
                    XDIMessage.issueMessage(msg);
                    break;
                }
                int pos = clone.nextNode();
                while (-1 != pos) {
                    nodes.add(new Integer(pos));
                    pos = clone.nextNode();
                }
                nl.runTo(-1);
                nl.setCurrentPos(currentPos);
                varString.append(this.buildNodeSetString(nodes.iterator(), xpathContext, rtfValueString, transformerId));
                break;
            }
            case 0: {
                Object obj = result.object();
                if (obj != null) {
                    varString.append(String.valueOf(obj.getClass().getName()) + "@" + Integer.toHexString(obj.hashCode()));
                    break;
                }
                varString.append("null");
                break;
            }
            default: {
                varString.append("<not implemented>");
            }
        }
        return varString.toString();
    }

    private String buildIncompleteRTFString(String rtfValueString) {
        StringBuffer stackString = new StringBuffer();
        stackString.append(5);
        stackString.append(",null,-1,0");
        stackString.append(",-1");
        stackString.append(",-1,-1");
        stackString.append(",-1,-1,-1,-1");
        stackString.append(",");
        stackString.append(-1);
        stackString.append(",");
        stackString.append(9);
        stackString.append(",#document,0,");
        stackString.append(rtfValueString.length());
        stackString.append(",");
        stackString.append(rtfValueString);
        return stackString.toString();
    }

    private String buildNodeSetString(Iterator nodes, XPathContext xpathContext, String rtfValueString, int transformerId) {
        StringBuffer stackString = new StringBuffer();
        boolean first = true;
        while (nodes.hasNext()) {
            int contextNode = (Integer)nodes.next();
            DTM dtm = xpathContext.getDTM(contextNode);
            if (!first) {
                stackString.append(",");
            } else {
                first = false;
            }
            SourceLocator locator = dtm.getSourceLocatorFor(contextNode);
            TransformerThreadInfo transInfo = this.getTransformInfo(transformerId);
            if (transInfo != null && locator != null) {
                int off;
                String docURI = dtm.getSourceLocatorFor(contextNode).getSystemId();
                DebugDocument doc = this.getTransformInfo(transformerId).getTraceListener().getDocument(docURI);
                if (doc == null) {
                    DebugDocumentManager docManager = this.getTransformInfo(transformerId).getTraceListener().getTraceDocManager();
                    doc = docManager.newDocument(docURI, false);
                }
                stackString.append(doc);
                stackString.append(",");
                stackString.append(locator.getLineNumber());
                int line = locator.getLineNumber();
                int col = locator.getColumnNumber();
                int absOff2 = doc.numCharsToEndOfNode(line, col - 1);
                int absOff1 = absOff2 == -1 ? -1 : doc.numCharsToStartOfNode(line, col - 1);
                stackString.append(",");
                stackString.append(absOff1);
                stackString.append(",");
                stackString.append(absOff2);
                if (line > 0 && absOff1 != -1) {
                    int line1 = line - 1;
                    while (line1 >= 0 && absOff1 - doc.numCharsToEOL(line1) - 1 < 0) {
                        --line1;
                    }
                    off = absOff1 - doc.numCharsToEOL(line1) - 1;
                    if (off < 0) {
                        off = -1;
                    }
                    int loc1Line = line1 + 1;
                    stackString.append(",").append(loc1Line).append(",").append(off);
                } else {
                    stackString.append(",-1,-1");
                }
                if (line > 0 && absOff2 != -1) {
                    int numCharsToEOL = doc.numCharsToEOL(line - 1);
                    off = absOff2 - numCharsToEOL - 2;
                    int loc2Line = line;
                    stackString.append(",").append(loc2Line).append(",").append(off);
                } else {
                    stackString.append(",-1,-1");
                }
            } else {
                stackString.append("null,-1,0");
                stackString.append(",");
                stackString.append(-1);
                stackString.append(",-1,-1");
                stackString.append(",-1,-1,-1,-1");
            }
            stackString.append(",");
            stackString.append(contextNode);
            stackString.append(",");
            stackString.append(dtm.getNodeType(contextNode));
            stackString.append(",");
            stackString.append(dtm.getNodeName(contextNode));
            stackString.append(",");
            boolean hasChildren = false;
            hasChildren = dtm.getFirstChild(contextNode) != -1 || dtm.getFirstAttribute(contextNode) != -1 || dtm.getFirstNamespaceNode(contextNode, false) != -1;
            stackString.append(hasChildren ? "1" : "0");
            stackString.append(",");
            switch (dtm.getNodeType(contextNode)) {
                case 3: 
                case 8: {
                    stackString.append(dtm.getNodeValue(contextNode).length());
                    stackString.append(",");
                    stackString.append(dtm.getNodeValue(contextNode));
                    break;
                }
                default: {
                    if (rtfValueString == null) {
                        stackString.append("0");
                        break;
                    }
                    stackString.append(rtfValueString.length());
                    stackString.append(",");
                    stackString.append(rtfValueString);
                }
            }
        }
        return stackString.toString();
    }

    private String buildValueString(XObject result, int transformerId) {
        return this.buildValueString(result, transformerId, null);
    }

    public boolean isTranSuspended(int transformerId) {
        TransformerThreadInfo tti = this.getTransformInfo(transformerId);
        if (tti == null) {
            return false;
        }
        boolean susp = this.getTransformInfo(transformerId).isSuspended();
        return susp;
    }

    static /* synthetic */ void access$0(DebugSession debugSession) {
        debugSession.resume();
    }

    static /* synthetic */ void access$1(DebugSession debugSession, String string, int n, int n2, int n3) {
        debugSession.createLineBreakpoint(string, n, n2, n3);
    }

    static /* synthetic */ void access$3(DebugSession debugSession, XDIBreakpoint xDIBreakpoint) {
        debugSession.deleteBreakpoint(xDIBreakpoint);
    }

    static /* synthetic */ void access$4(DebugSession debugSession, XDILineBreakpoint xDILineBreakpoint, boolean bl) {
        debugSession.setEnabled(xDILineBreakpoint, bl);
    }

    static /* synthetic */ String access$7(DebugSession debugSession, XObject xObject, int n) {
        return debugSession.buildValueString(xObject, n);
    }

    static /* synthetic */ void access$9(DebugSession debugSession, int n) {
        debugSession.disconnect(n);
    }

    static /* synthetic */ void access$10(DebugSession debugSession) {
        debugSession.setupIsComplete();
    }

    static /* synthetic */ void access$11(DebugSession debugSession, boolean bl) {
        debugSession.setEntryExitMode(bl);
    }

    static /* synthetic */ void access$12(DebugSession debugSession, boolean bl) {
        debugSession.setFilterBuiltinRules(bl);
    }

    static /* synthetic */ void access$13(DebugSession debugSession, boolean bl) {
        debugSession.setNodeStepping(bl);
    }

    static /* synthetic */ void access$14(DebugSession debugSession, int n, boolean bl) {
        debugSession.setExtensionElementMode(n, bl);
    }

    private static class TransformerThreadInfo {
        private final DebugTransformerImpl m_transform;
        private DebugTraceListener.Frames m_frames = null;
        private SuspendState m_suspendState = SuspendState.NOT_SUSPENDED;
        private boolean m_hasSetGlobals = false;
        private final DebugTraceListener m_listener;
        boolean m_calloutEnabled = false;
        private Stack m_RTFStack = new Stack();
        private Hashtable m_varToRTFValueString = new Hashtable();
        private StackFrame.VarInfo[] m_globalVariables = new StackFrame.VarInfo[0];
        private Thread m_thread;
        private boolean m_stepPending = false;
        UniqueID idGenerator = new UniqueID();

        TransformerThreadInfo(DebugTransformerImpl transform, DebugTraceListener listener) {
            this.m_transform = transform;
            this.m_listener = listener;
        }

        DebugTransformerImpl getTransform() {
            return this.m_transform;
        }

        void setStackFrames(DebugTraceListener.Frames frames) {
            this.m_frames = frames;
        }

        DebugTraceListener.Frames getStackFrames() {
            return this.m_frames;
        }

        boolean isSuspended() {
            return this.getSuspendState() != SuspendState.NOT_SUSPENDED;
        }

        void setSuspended(SuspendState suspended) {
            this.m_suspendState = suspended;
        }

        StackFrame.VarInfo[] getGlobalVariables() {
            return this.m_globalVariables;
        }

        void setGlobalVariables(ArrayList globList) {
            int max2 = globList.size();
            this.m_globalVariables = new StackFrame.VarInfo[max2];
            int i = 0;
            while (i < max2) {
                this.m_globalVariables[i] = (StackFrame.VarInfo)globList.get(i);
                ++i;
            }
            this.m_hasSetGlobals = true;
        }

        boolean hasSetGlobalVariables() {
            return this.m_hasSetGlobals;
        }

        DebugTraceListener getTraceListener() {
            return this.m_listener;
        }

        Stack getRTFStack() {
            return this.m_RTFStack;
        }

        Hashtable getVarToRTFValueHash() {
            return this.m_varToRTFValueString;
        }

        SuspendState getSuspendState() {
            return this.m_suspendState;
        }

        String getJavaThreadName() {
            return this.m_thread.getName();
        }

        String getJavaThreadGroupName() {
            return this.m_thread.getThreadGroup().getName();
        }

        void setStepPending(boolean pending) {
            this.m_stepPending = pending;
        }

        private boolean stepIsPending() {
            return this.m_stepPending;
        }

        private DebugTransformerImpl getTransformer() {
            return this.m_transform;
        }

        private Thread getJavaThread() {
            return this.m_thread;
        }
    }

    private class IncompleteRTFInfo {
        private ElemTemplateElement m_variable;
        private int m_rootNode;
        private StringBuffer m_output;
        private String m_tempOutput;

        private IncompleteRTFInfo(ElemTemplateElement variable, int rootNode) {
            this.m_variable = variable;
            this.m_rootNode = rootNode;
            this.m_output = new StringBuffer();
            this.m_tempOutput = "";
        }

        private StringBuffer getOutput() {
            return this.m_output;
        }

        private int getRootNode() {
            return this.m_rootNode;
        }

        private String getTempOutput() {
            return this.m_tempOutput;
        }

        private ElemTemplateElement getVariable() {
            return this.m_variable;
        }

        private void addOutput(GenerateEvent ev) {
            switch (ev.m_eventtype) {
                case 12: {
                    this.m_output.append(ev.m_characters);
                    this.m_tempOutput = "";
                    break;
                }
                case 11: {
                    this.m_tempOutput = new String(ev.m_characters);
                }
            }
        }
    }

    private class SocketCommunicator
    implements SocketManager {
        private SocketCommunicator() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestReceived(DebugPacket debugPacket) {
            transformerId = debugPacket.getTransformerId();
            requestId = debugPacket.getRequestId();
            dataArray = debugPacket.getData();
            data = null;
            if (dataArray.length > 0) {
                data = dataArray[0];
            }
            switch (requestId) {
                case 12: {
                    DebugSession.access$0(DebugSession.this);
                    return;
                }
                case 11: {
                    isSuspended = DebugSession.this.isSuspended();
                    this.sendReply(-1, 11, isSuspended);
                    return;
                }
                case 14: {
                    lineNumber = 0;
                    fileName = null;
                    try {
                        packet = new PacketLineBreakPoint(data);
                        fileName = packet.getDocURI();
                        lineNumber = packet.getLineNumber();
                        charStart = packet.getCharStart();
                        charEnd = packet.getCharEnd();
                        DebugSession.access$1(DebugSession.this, fileName, lineNumber, charStart, charEnd);
                        return;
                    }
                    catch (Exception v0) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        line = Integer.toString(lineNumber);
                        msg = XDIMessage.getFormattedString3("ER_CREATE_BREAKPOINT", session, line, fileName);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                }
                case 15: {
                    lineNumber = 0;
                    fileName = null;
                    try {
                        packet = new PacketLineBreakPoint(data);
                        fileName = packet.getDocURI();
                        lineNumber = packet.getLineNumber();
                        charStart = packet.getCharStart();
                        charEnd = packet.getCharEnd();
                        lbp = new BreakpointParameter(fileName, lineNumber, charStart, charEnd);
                        DebugSession.access$3(DebugSession.this, lbp);
                        return;
                    }
                    catch (Exception v1) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        line = Integer.toString(lineNumber);
                        msg = XDIMessage.getFormattedString3("ER_DELETE_BREAKPOINT", session, line, fileName);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                }
                case 16: {
                    lineNumber = 0;
                    fileName = null;
                    try {
                        packet = new PacketLineBreakPoint(data);
                        fileName = packet.getDocURI();
                        lineNumber = packet.getLineNumber();
                        charStart = packet.getCharStart();
                        charEnd = packet.getCharEnd();
                        enable = packet.getEnable();
                        lbp = new BreakpointParameter(fileName, lineNumber, charStart, charEnd);
                        DebugSession.access$4(DebugSession.this, lbp, enable);
                        return;
                    }
                    catch (Exception v2) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        line = Integer.toString(lineNumber);
                        msg = XDIMessage.getFormattedString3("ER_ENABLE_BREAKPOINT", session, line, fileName);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                }
                case 54: {
                    try {
                        this.suspend(transformerId, data.charAt(0) == '1');
                        this.sendReply(transformerId, 54);
                        return;
                    }
                    catch (InvalidStateException v3) {
                        this.sendErrorReply(transformerId, 54, null);
                        return;
                    }
                    catch (OperationNotAvailableException v4) {
                        this.sendErrorReply(transformerId, 54, null);
                        return;
                    }
                }
                case 53: {
                    try {
                        transformInfo = DebugSession.access$5(DebugSession.this, transformerId);
                        suspendState = transformInfo.getSuspendState();
                        if (suspendState == SuspendState.NOT_SUSPENDED) {
                            session = Integer.toString(DebugSession.access$2(DebugSession.this));
                            sheet = DebugSession.this.getTransform(transformerId).getStylesheetURIName();
                            msg = XDIMessage.getFormattedString2("ER_RESUME_TRAN", session, sheet);
                            XDIMessage.issueMessage(msg);
                            return;
                        }
                        if (suspendState == SuspendState.NORMAL_SUSPENDED) {
                            DebugSession.access$6(DebugSession.this, transformerId);
                            return;
                        }
                        if (suspendState != SuspendState.FAKE_SUSPEND) return;
                        DebugSession.this.setSuspended(transformerId, SuspendState.NOT_SUSPENDED);
                        return;
                    }
                    catch (ArrayIndexOutOfBoundsException v5) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        transformNumber = Integer.toString(transformerId);
                        msg = XDIMessage.getFormattedString2("ER_INVALID_TRANID", session, transformNumber);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                    catch (NullPointerException v6) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        sheet_uri = DebugSession.this.getTransform(transformerId).getStylesheetURIName();
                        msg = XDIMessage.getFormattedString2("ER_NPE_IN_TRAN", session, sheet_uri);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                }
                case 21: {
                    try {
                        reply = DebugSession.access$5(DebugSession.this, transformerId).getTraceListener().getDocument(Integer.parseInt(data)).generatedFile();
                        this.sendReply(transformerId, 21, reply);
                        return;
                    }
                    catch (ArrayIndexOutOfBoundsException v7) {
                        return;
                    }
                    catch (NullPointerException v8) {
                        return;
                    }
                }
                case 60: {
                    try {
                        reply = this.buildChildNodeSetStrings(Integer.parseInt(data), transformerId);
                        this.sendReply(transformerId, 60, reply);
                        return;
                    }
                    catch (ArrayIndexOutOfBoundsException v9) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        tranid = Integer.toString(transformerId);
                        msg = XDIMessage.getFormattedString2("ER_FETCH_CHILD_NODES_ID", session, tranid);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                    catch (NullPointerException v10) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        sheet_uri = DebugSession.this.getTransform(transformerId).getStylesheetURIName();
                        msg = XDIMessage.getFormattedString2("ER_FETCH_CHILD_NODES_NPE", session, sheet_uri);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                }
                case 52: {
                    try {
                        try {
                            if (DebugSession.access$5(DebugSession.this, transformerId).isSuspended()) ** GOTO lbl145
                            this.sendErrorReply(transformerId, 52, new String[]{"Transformer must be suspended for this request."});
                            ** GOTO lbl-1000
lbl145:
                            // 1 sources

                            DebugSession.access$5(DebugSession.this, transformerId).getTraceListener().setProcessingRequest(true);
                            newData = this.buildStackString(transformerId, Integer.parseInt(data));
                            DebugSession.access$5(DebugSession.this, transformerId).getTraceListener().setProcessingRequest(false);
                            this.sendReply(transformerId, 52, newData.toArray(new String[newData.size()]));
                        }
                        catch (ArrayIndexOutOfBoundsException v11) {
                            this.sendErrorReply(transformerId, 52, new String[]{"Error"});
                        }
                        catch (NullPointerException v12) {
                            this.sendErrorReply(transformerId, 52, new String[]{"Error"});
                        }
                        catch (RuntimeException v13) {
                            this.sendErrorReply(transformerId, 52, new String[]{"Error"});
                        }
                    }
                    catch (Throwable msg) {
                        sheet_uri = null;
                        DebugSession.access$5(DebugSession.this, transformerId).getTraceListener().setProcessingRequest(false);
                        throw msg;
                    }
                }
lbl-1000:
                // 5 sources

                {
                    sheet_uri = null;
                    DebugSession.access$5(DebugSession.this, transformerId).getTraceListener().setProcessingRequest(false);
                    return;
                }
                case 64: {
                    try {
                        stepType = Integer.parseInt(data);
                        this.setStepRequest(transformerId, stepType);
                        return;
                    }
                    catch (InvalidStateException v14) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        sheet_uri = DebugSession.this.getTransform(transformerId).getStylesheetURIName();
                        msg = XDIMessage.getFormattedString2("ER_STEP_PENDING", session, sheet_uri);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                    catch (DuplicateRequestException v15) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        sheet_uri = DebugSession.this.getTransform(transformerId).getStylesheetURIName();
                        msg = XDIMessage.getFormattedString2("ER_ALREADY_STEP_PENDING", session, sheet_uri);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                }
                case 65: {
                    try {
                        this.clearStepRequest(transformerId);
                        return;
                    }
                    catch (InvalidStateException v16) {
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        sheet_uri = DebugSession.this.getTransform(transformerId).getStylesheetURIName();
                        msg = XDIMessage.getFormattedString2("INTERNAL_CLEAR_PENDING_STEP", session, sheet_uri);
                        XDIMessage.issueMessage(msg);
                        return;
                    }
                }
                case 59: {
                    try {
                        try {
                            transformInfo = DebugSession.access$5(DebugSession.this, transformerId);
                            if (DebugSession.access$5(DebugSession.this, transformerId).isSuspended()) ** GOTO lbl206
                            this.sendErrorReply(transformerId, 59, new String[]{"Transformer must be suspended for this request."});
                            ** GOTO lbl-1000
lbl206:
                            // 1 sources

                            transformation = transformInfo.getTransform();
                            dtl = transformation.getTraceListener();
                            dtl.setProcessingRequest(true);
                            varString = DebugSession.access$7(DebugSession.this, this.evaluateExpression(data, transformerId), transformerId);
                            dtl.setProcessingRequest(false);
                            this.sendReply(transformerId, 59, varString);
                        }
                        catch (ArrayIndexOutOfBoundsException v17) {
                        }
                        catch (NullPointerException v18) {
                        }
                        catch (EvaluationException npe) {
                            this.sendErrorReply(transformerId, 59, new String[]{npe.getMessage()});
                        }
                    }
                    catch (Throwable var14_86) {
                        msg = null;
                        DebugSession.access$5(DebugSession.this, transformerId).getTraceListener().setProcessingRequest(false);
                        throw var14_86;
                    }
                }
lbl-1000:
                // 5 sources

                {
                    msg = null;
                    DebugSession.access$5(DebugSession.this, transformerId).getTraceListener().setProcessingRequest(false);
                    return;
                }
                case 13: {
                    DebugSession.access$8(DebugSession.this);
                    return;
                }
                case 58: {
                    DebugSession.access$9(DebugSession.this, transformerId);
                    return;
                }
                case 70: {
                    DebugSession.access$10(DebugSession.this);
                    return;
                }
                case 18: {
                    DebugSession.access$11(DebugSession.this, data.charAt(0) == '1');
                    return;
                }
                case 17: {
                    DebugSession.access$12(DebugSession.this, data.charAt(0) == '1');
                    return;
                }
                case 22: {
                    DebugSession.access$13(DebugSession.this, data.charAt(0) == '1');
                    return;
                }
                case 61: {
                    try {
                        threadName = this.getJavaThreadName(transformerId);
                    }
                    catch (InvalidStateException v19) {
                        threadName = "COUDN'T GET THREAD NAME";
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        sheet_uri = DebugSession.this.getTransform(transformerId).getStylesheetURIName();
                        msg = XDIMessage.getFormattedString2("INTERNAL_GET_THREADNAME", session, sheet_uri);
                        XDIMessage.issueMessage(msg);
                    }
                    this.sendReply(transformerId, 61, threadName);
                    return;
                }
                case 62: {
                    try {
                        groupName = this.getJavaThreadGroupName(transformerId);
                    }
                    catch (InvalidStateException v20) {
                        groupName = "COULDN'T GET JAVA THREAD GROUP NAME";
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        sheet_uri = DebugSession.this.getTransform(transformerId).getStylesheetURIName();
                        msg = XDIMessage.getFormattedString2("INTERNAL_GET_THREADGROUPNAME", session, sheet_uri);
                        XDIMessage.issueMessage(msg);
                    }
                    this.sendReply(transformerId, 62, groupName);
                    return;
                }
                case 63: {
                    try {
                        isTransformSuspended = this.isSuspended2(transformerId);
                    }
                    catch (InvalidStateException v21) {
                        isTransformSuspended = false;
                    }
                    this.sendReply(transformerId, 63, isTransformSuspended);
                    return;
                }
                case 66: {
                    try {
                        uri_name = this.getStylesheetURIName(transformerId);
                    }
                    catch (InvalidStateException v22) {
                        uri_name = "BAD";
                        session = Integer.toString(DebugSession.access$2(DebugSession.this));
                        tranid = Integer.toString(transformerId);
                        msg = XDIMessage.getFormattedString2("ER_GET_SHEET_URI", session, tranid);
                        XDIMessage.issueMessage(msg);
                    }
                    this.sendReply(transformerId, 66, new String[]{uri_name});
                    return;
                }
                case 67: {
                    try {
                        xslt_processor_name = this.getName(transformerId);
                    }
                    catch (InvalidStateException v23) {
                        xslt_processor_name = "BAD";
                        msg = XDIMessage.getFormattedString("ER_GET_PROCESSOR_NAME");
                        XDIMessage.issueMessage(msg);
                    }
                    this.sendReply(transformerId, 67, new String[]{xslt_processor_name});
                    return;
                }
                case 68: {
                    inCallout = this.isInExtensionElement(transformerId);
                    this.sendReply(transformerId, 68, inCallout);
                    return;
                }
                case 69: {
                    callout = "1".equals(data) != false;
                    DebugSession.access$14(DebugSession.this, transformerId, callout);
                    return;
                }
            }
        }

        public void replyReceived(DebugPacket debugPacket) {
            int transformerId = debugPacket.getTransformerId();
            int requestId = debugPacket.getRequestId();
            String[] dataArray = debugPacket.getData();
            if (dataArray.length > 0) {
                String cfr_ignored_0 = dataArray[0];
            }
            switch (requestId) {
                case 1: {
                    try {
                        DebugSession.this.resume(transformerId);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public void writeExceptionReceived(Exception e2) {
            DebugSession.this.disconnect();
        }

        public void listenExceptionReceived(Exception e2) {
            DebugSession.this.disconnect();
        }

        private void sendReply(int transformerId, int messageID, boolean bool) {
            String data = bool ? "1" : "0";
            String[] array = new String[]{data};
            this.sendReply(transformerId, messageID, array);
        }

        private boolean sendReply(int transformerId, int requestId, String[] data) {
            DebugPacket packet = new DebugPacket(transformerId, 101, requestId, data);
            boolean was_sent = DebugSession.this.send(packet);
            return was_sent;
        }

        private void sendReply(int transformerId, int messageID) {
            String[] array = new String[1];
            this.sendReply(transformerId, messageID, array);
        }

        private boolean sendErrorReply(int transformerId, int requestId, String[] data) {
            DebugPacket packet = new DebugPacket(transformerId, -102, requestId, data);
            boolean was_sent = DebugSession.this.send(packet);
            return was_sent;
        }

        private void sendReply(int transformerId, int messageID, String data) {
            String[] array = new String[]{data};
            this.sendReply(transformerId, messageID, array);
        }

        private void suspend(int transformerID, boolean immediate) throws InvalidStateException, OperationNotAvailableException {
            boolean success = DebugSession.this.getTransformInfo(transformerID).getTraceListener().suspend(immediate);
            DebugSession.this.getTransformInfo(transformerID).getTraceListener().setStepMode(StepMode.NO_STEPPING);
            if (!success) {
                throw new InvalidStateException();
            }
        }

        private String[] buildChildNodeSetStrings(int contextNode, int transformerId) {
            XPathContext xpathContext = DebugSession.this.getTransformInfo(transformerId).getTransform().getXPathContext();
            DTM dtm = xpathContext.getDTM(contextNode);
            ArrayList<Integer> childNodes = new ArrayList<Integer>();
            ArrayList<Integer> nsNodes = new ArrayList<Integer>();
            ArrayList<Integer> attrNodes = new ArrayList<Integer>();
            int curNode = dtm.getFirstAttribute(contextNode);
            while (curNode != -1) {
                attrNodes.add(new Integer(curNode));
                curNode = dtm.getNextAttribute(curNode);
            }
            curNode = dtm.getFirstNamespaceNode(contextNode, false);
            while (curNode != -1) {
                nsNodes.add(new Integer(curNode));
                curNode = dtm.getNextNamespaceNode(contextNode, curNode, false);
            }
            curNode = dtm.getFirstChild(contextNode);
            while (curNode != -1) {
                childNodes.add(new Integer(curNode));
                curNode = dtm.getNextSibling(curNode);
            }
            return new String[]{this.buildNodeSetString2(attrNodes.iterator(), xpathContext, transformerId), this.buildNodeSetString2(nsNodes.iterator(), xpathContext, transformerId), this.buildNodeSetString2(childNodes.iterator(), xpathContext, transformerId)};
        }

        private String buildNodeSetString2(Iterator nodes, XPathContext xpathContext, int transformerId) {
            return DebugSession.this.buildNodeSetString(nodes, xpathContext, null, transformerId);
        }

        private ArrayList buildStackString(int transformerId, int cachedFrames) {
            ArrayList<String> frames = new ArrayList<String>();
            TransformerThreadInfo transformerInfo = DebugSession.this.getTransformInfo(transformerId);
            DebugTraceListener listener = transformerInfo.getTraceListener();
            int frameCount = Math.max(0, Math.min(listener.getLowestStackFrame() - 1, cachedFrames));
            frames.add(Integer.toString(frameCount));
            int numFrames = transformerInfo.getStackFrames().size();
            int i = 0;
            while (i < numFrames) {
                StringBuffer stackString = new StringBuffer();
                StackFrame frame = DebugSession.this.getTransformInfo(transformerId).getStackFrames().getFrame(i);
                if (frame.isViewable()) {
                    if (frameCount > 0) {
                        --frameCount;
                    } else {
                        try {
                            ((Integer)frame.getContextNodeset().get(frame.getContextPosition() - 1)).intValue();
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                        stackString.append(transformerInfo.idGenerator.getID(frame));
                        stackString.append(",");
                        stackString.append(frame.getLineNumber());
                        stackString.append(",");
                        stackString.append(frame.getAbsoluteCharNumber());
                        stackString.append(",");
                        stackString.append(frame.getAbsoluteEndCharNumber());
                        stackString.append(",");
                        stackString.append(frame.getLoc1CharOffset());
                        stackString.append(",");
                        stackString.append(frame.getLoc2LineNumber());
                        stackString.append(",");
                        stackString.append(frame.getLoc2CharOffset());
                        stackString.append(",");
                        if (frame.getMode() != null) {
                            stackString.append(frame.getMode());
                        } else {
                            stackString.append("#");
                        }
                        stackString.append(",");
                        stackString.append(frame.getPriority());
                        stackString.append(",");
                        DebugDocument doc = transformerInfo.getTraceListener().getDocument(frame.getAbsoluteURI());
                        if (doc == null) {
                            DebugDocumentManager documentManager = transformerInfo.getTraceListener().getTraceDocManager();
                            doc = documentManager.newDocument(frame.getAbsoluteURI(), false);
                        }
                        stackString.append(doc.toString());
                        stackString.append(",");
                        stackString.append(frame.getContextPosition());
                        stackString.append(",");
                        Iterator nodes = frame.getContextNodeset().iterator();
                        XPathContext xpathContext = transformerInfo.getTransform().getXPathContext();
                        stackString.append(this.buildNodeSetString2(nodes, xpathContext, transformerId));
                        stackString.append(",");
                        stackString.append("#");
                        frames.add(stackString.toString());
                        ArrayList varArray = null;
                        varArray = i == numFrames - 1 ? DebugSession.this.buildVariableStrings(transformerId) : frame.getVariableStrings();
                        frames.add(String.valueOf(varArray.size()));
                        frames.addAll(varArray);
                    }
                }
                ++i;
            }
            listener.setLowestStackFrame(transformerInfo.getStackFrames().countViewableFrames());
            return frames;
        }

        private void setStepRequest(int transformerID, int type) throws InvalidStateException, DuplicateRequestException {
            TransformerThreadInfo transformInfo = DebugSession.this.getTransformInfo(transformerID);
            SuspendState suspendState = transformInfo.getSuspendState();
            if (suspendState == SuspendState.NORMAL_SUSPENDED || suspendState == SuspendState.FAKE_SUSPEND) {
                StepMode stepmode = StepMode.getInstance(type);
                transformInfo.getTraceListener().setStepMode(stepmode);
                DebugSession.this.setStepPending(transformerID, true);
            } else {
                String session = Integer.toString(DebugSession.this.m_debugSessionID);
                String sheet_uri = DebugSession.this.getTransform(transformerID).getStylesheetURIName();
                String msg = XDIMessage.getFormattedString2("INTERNAL_SET_STEP_REQUEST", session, sheet_uri);
                XDIMessage.issueMessage(msg);
            }
        }

        private void clearStepRequest(int transformerID) throws InvalidStateException {
            TransformerThreadInfo transformInfo = DebugSession.this.getTransformInfo(transformerID);
            SuspendState suspendState = transformInfo.getSuspendState();
            if (suspendState == SuspendState.NORMAL_SUSPENDED || suspendState == SuspendState.FAKE_SUSPEND) {
                transformInfo.getTraceListener().setStepMode(StepMode.NO_STEPPING);
                transformInfo.setStepPending(false);
            } else {
                String session = Integer.toString(DebugSession.this.m_debugSessionID);
                String sheet_uri = DebugSession.this.getTransform(transformerID).getStylesheetURIName();
                String msg = XDIMessage.getFormattedString2("INTERNAL_CLEAR_STEP_REQUEST", session, sheet_uri);
                XDIMessage.issueMessage(msg);
            }
        }

        private XObject evaluateExpression(String exp, int transformerId) throws EvaluationException {
            ElemVariable var;
            DebugTransformerImpl transform = DebugSession.this.getTransformInfo(transformerId).getTransform();
            ElemTemplate contextTemplate = transform.getCurrentTemplate();
            XPathContext xpc = transform.getXPathContext();
            int contextNode = xpc.getContextNode();
            Vector<QName> qnameVector = new Vector<QName>();
            Iterator vars = DebugSession.this.getTransformInfo(transformerId).getTransform().getStylesheet().getVariablesAndParamsComposed().iterator();
            while (vars.hasNext()) {
                var = (ElemVariable)vars.next();
                qnameVector.add(var.getName());
            }
            int localStart = qnameVector.size();
            DebugTraceListener.Frames threadStackFrames = DebugSession.this.getTransformInfo(transformerId).getStackFrames();
            if (threadStackFrames.size() > 0) {
                int frameId;
                int startFrameId = frameId = threadStackFrames.size() - 1;
                while (threadStackFrames.getFrame(startFrameId).getForEach()) {
                    --startFrameId;
                }
                int j = startFrameId;
                while (j <= frameId) {
                    StackFrame stackFrame = DebugSession.this.getTransformInfo(transformerId).getStackFrames().getFrame(j);
                    int varmax = stackFrame.numVariables();
                    int i = 0;
                    while (i < varmax) {
                        var = stackFrame.getVarInfo(i).getElemVariable();
                        if (var.getName() != null) {
                            qnameVector.add(var.getName());
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            try {
                XPath xpath = new XPath(exp, (SourceLocator)contextTemplate, (PrefixResolver)contextTemplate, 0, null);
                xpath.fixupVariables(qnameVector, localStart);
                XObject nl = xpath.execute(xpc, contextNode, (PrefixResolver)contextTemplate);
                return nl;
            }
            catch (Exception e2) {
                throw new EvaluationException(e2.getMessage());
            }
        }

        private String getJavaThreadName(int transformerID) throws InvalidStateException {
            String name2 = DebugSession.this.getTransformInfo(transformerID).getJavaThreadName();
            return name2;
        }

        private String getJavaThreadGroupName(int transformerID) throws InvalidStateException {
            String name2 = DebugSession.this.getTransformInfo(transformerID).getJavaThreadGroupName();
            return name2;
        }

        private boolean isSuspended2(int transformerID) throws InvalidStateException {
            boolean isTransformSuspended = DebugSession.this.getTransformInfo(transformerID).isSuspended();
            return isTransformSuspended;
        }

        private String getStylesheetURIName(int transformerID) throws InvalidStateException {
            String name2 = DebugSession.this.getTransform(transformerID).getStylesheetURIName();
            return name2;
        }

        private String getName(int transformerID) throws InvalidStateException {
            return Version.getProduct();
        }

        private boolean isInExtensionElement(int transformerID) {
            DebugTraceListener listener = DebugSession.this.getTransformInfo(transformerID).getTraceListener();
            boolean inCallout = listener.inCallout();
            return inCallout;
        }

        public void threadRunHasEnded() {
        }
    }

    private class BreakpointParameter
    implements XDILineBreakpoint {
        final String m_fileName;
        final int m_lineNumber;
        final int m_charStart;
        final int m_charEnd;
        boolean m_enabled = true;

        public BreakpointParameter(String fileName, int lineNumber, int charStart, int charEnd) {
            this.m_fileName = fileName;
            this.m_lineNumber = lineNumber;
            this.m_charStart = charStart;
            this.m_charEnd = charEnd;
            this.m_enabled = true;
        }

        public String getFileName() {
            return this.m_fileName;
        }

        public int getLineNumber() {
            return this.m_lineNumber;
        }

        public int getCharStart() {
            return this.m_charStart;
        }

        public int getCharEnd() {
            return this.m_charEnd;
        }

        public boolean isInstalled() {
            return false;
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public void setEnabled(boolean enable) {
            this.m_enabled = enable;
        }
    }
}

