/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.impl.DebugDocumentManager;
import com.ibm.debug.transform.impl.DebugSession;
import com.ibm.debug.transform.impl.EventPacket;
import com.ibm.debug.transform.impl.LineBreakpoint;
import com.ibm.debug.transform.impl.NodeLocation;
import com.ibm.debug.transform.impl.StackFrame;
import com.ibm.debug.transform.impl.StepMode;
import com.ibm.debug.transform.impl.SuspendState;
import com.ibm.debug.transform.impl.TemplateLocationManager;
import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.xdi.impl.JavaMethodImpl;
import com.ibm.debug.xdi.impl.XDIBreakpointEventImpl;
import com.ibm.debug.xdi.impl.XDIEntryEventImpl;
import com.ibm.debug.xdi.impl.XDIExitEventImpl;
import com.ibm.debug.xdi.impl.XDIJavaExtensionCallEventImpl;
import com.ibm.debug.xdi.impl.XDIReturnFromExtensionEventImpl;
import com.ibm.debug.xdi.impl.XDIStepEndEventImpl;
import com.ibm.debug.xdi.impl.XDISuspendEventImpl;
import com.ibm.debug.xdi.impl.XDITransformTerminateEventImpl;
import com.ibm.debug.xdi.impl.XDIUserSuspendEventImpl;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerImpl;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.DbgTrace;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.trace.EndSelectionEvent;
import org.apache.xalan.trace.ExtensionEvent;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListenerEx3;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTMIterator;

public class DebugTraceListener
implements TraceListenerEx3 {
    private DebugSession m_debugSession = null;
    private final DebugDocumentManager m_documentManager;
    private int m_transformId = -1;
    private int m_currentXSLTDepth = 0;
    private boolean m_inApplyTemplates = false;
    private volatile int m_inExtensionFunction = 0;
    private ArrayList m_context = new ArrayList();
    private volatile int m_stepFrame;
    private volatile boolean m_ignoreEvents = false;
    private volatile boolean m_processingRequest = false;
    private volatile boolean m_forceSuspend = false;
    private volatile StepMode m_stepMode = StepMode.NO_STEPPING;
    private int m_lowestStackFrame = 0;
    private boolean m_entryEventSent = false;
    private TemplateLocationManager m_templateLocationManager;
    private TemplateLocationManager.TemplateLocation m_lastTemplate = null;
    private Frames m_stack = new Frames();
    private NodeLocation m_XML_LocationWhenLastStopped = null;
    private int m_hack_test_count;
    private String m_prevSysID;
    private DebugDocument m_prevDoc;
    private DebugDocumentManager m_styleSheetDocManager = null;
    private final int m_dbgId = this.nextDbgId();
    private static volatile int dbgId;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    private void setCurrentXmlLocation(NodeLocation XML_Location) {
        this.m_stack.getTopFrame().setCurrentXmlLocation(XML_Location);
    }

    private NodeLocation getCurrentXmlLocation() {
        NodeLocation nl = this.m_stack.getTopFrame().getCurrentXmlLocation();
        return nl;
    }

    private void setXML_LocationWhenLastStopped(NodeLocation xml_location) {
        this.m_XML_LocationWhenLastStopped = xml_location;
    }

    private NodeLocation getXmlLocationWhenLastStopped() {
        return this.m_XML_LocationWhenLastStopped;
    }

    private boolean xmlLocationHasChanged() {
        NodeLocation whenLastStopped;
        NodeLocation current = this.getCurrentXmlLocation();
        boolean xmlContextHasChanged = current != (whenLastStopped = this.getXmlLocationWhenLastStopped()) && whenLastStopped != null;
        return xmlContextHasChanged;
    }

    public DebugTraceListener() {
        this.m_documentManager = new DebugDocumentManager();
    }

    public void setDebugSession(DebugSession session) {
        this.m_debugSession = session;
    }

    public void setId(int transformId) {
        this.m_transformId = transformId;
    }

    public void traceEnd(TracerEvent ev) {
        boolean canViewStackframe;
        if (this.m_ignoreEvents || this.m_processingRequest || this.m_inExtensionFunction > 0) {
            return;
        }
        --this.m_currentXSLTDepth;
        this.clearDeeperVariables(this.m_currentXSLTDepth + 2);
        NodeLocation transformLine = new NodeLocation(ev.m_styleNode, true, this.getDocQuick(ev.m_styleNode.getSystemId()));
        if (ev.m_styleNode != null) {
            this.updateLineNumber(ev.m_styleNode, 1);
        }
        boolean isFrameForEach = false;
        boolean isVariableRTF = false;
        switch (ev.m_styleNode.getXSLToken()) {
            case 28: {
                StackFrame sf;
                if (this.m_stack.size() <= 0 || !(sf = this.m_stack.getTopFrame()).getForEach() || sf.getInForEach() != 0) break;
                isFrameForEach = true;
                break;
            }
            case 78: {
                isFrameForEach = true;
                break;
            }
            case 41: 
            case 73: {
                ElemVariable var = (ElemVariable)ev.m_styleNode;
                if (var.getSelect() != null || var.getFirstChildElem() == null) break;
                StackFrame sf = this.m_stack.getTopFrame();
                sf.pushVariable(var, this.m_currentXSLTDepth);
                isVariableRTF = true;
            }
        }
        EventPacket ep = new EventPacket();
        boolean bl = canViewStackframe = !this.m_debugSession.shouldFilterOutDefaultRuleStackframes() || !transformLine.isDefaultTemplateRule();
        if (this.m_forceSuspend && canViewStackframe) {
            ep.addEvent(new XDIUserSuspendEventImpl(null));
        }
        this.addBreakpointEvent(ep, transformLine, isFrameForEach, false, 1);
        if (ep.size() > 0 || canViewStackframe) {
            this.addEntryEvent(ep);
        }
        this.sendEventPacket(ep, this.m_templateLocationManager.getTemplateLocation(ev.m_styleNode, 1));
        switch (ev.m_styleNode.getXSLToken()) {
            case 28: {
                StackFrame sf = null;
                if (this.m_stack.size() <= 0) break;
                sf = this.m_stack.getTopFrame();
                if (sf.getForEach() && sf.getInForEach() == 0) {
                    this.removeStackFrame();
                    sf = this.m_stack.getTopFrame();
                }
                sf.setInForEach(sf.getInForEach() - 1);
                break;
            }
            case 50: {
                this.m_inApplyTemplates = false;
                break;
            }
            case 19: 
            case 88: {
                this.removeStackFrame();
                break;
            }
            case 41: 
            case 73: {
                if (isVariableRTF) break;
                StackFrame sf = this.m_stack.getTopFrame();
                sf.pushVariable((ElemVariable)ev.m_styleNode, this.m_currentXSLTDepth);
                break;
            }
        }
    }

    public void selectEnd(EndSelectionEvent ev) throws TransformerException {
        if (this.m_ignoreEvents || this.m_processingRequest || this.m_inExtensionFunction > 0) {
            return;
        }
    }

    public void generated(GenerateEvent ev) {
        if (this.m_ignoreEvents || this.m_processingRequest || this.m_inExtensionFunction > 0) {
            return;
        }
        if (this.m_debugSession.isConstructingRTF(this.m_transformId)) {
            this.m_debugSession.addOutputRTF(this.m_transformId, ev);
        } else {
            this.m_documentManager.addOutput(ev);
        }
    }

    public void selected(SelectionEvent ev) throws TransformerException {
        boolean inForEach;
        if (this.m_ignoreEvents || this.m_processingRequest || this.m_inExtensionFunction > 0) {
            return;
        }
        StackFrame sf = null;
        if (this.m_stack.size() > 0) {
            sf = this.m_stack.getTopFrame();
        }
        boolean bl = inForEach = sf != null && sf.getInForEach() == 1;
        if (this.m_inApplyTemplates || inForEach) {
            ElemTemplateElement ete = ev.m_styleNode;
            switch (ete.getXSLToken()) {
                case 17: 
                case 28: 
                case 50: {
                    break;
                }
                default: {
                    return;
                }
            }
            if (ev.m_selection.getType() == 4) {
                this.setContextNodeSet(ev.m_selection.iter());
            }
        }
    }

    public void trace(TracerEvent ev) {
        ++this.m_currentXSLTDepth;
        this.clearDeeperVariables(this.m_currentXSLTDepth);
        try {
            boolean canViewStackframe;
            if (this.m_ignoreEvents || this.m_processingRequest || this.m_inExtensionFunction > 0) {
                return;
            }
            SourceLocator sourceLoc = null;
            NodeLocation transformLine = new NodeLocation((SourceLocator)ev.m_styleNode, this.getDocQuick(ev.m_styleNode.getSystemId()));
            boolean inForEach = false;
            switch (ev.m_styleNode.getXSLToken()) {
                case 19: 
                case 88: {
                    break;
                }
                default: {
                    if (ev.m_styleNode == null) break;
                    this.updateLineNumber(ev.m_styleNode, 0);
                }
            }
            switch (ev.m_styleNode.getXSLToken()) {
                case 50: {
                    this.m_inApplyTemplates = true;
                }
                case 17: {
                    this.m_debugSession.setStack(this.m_transformId, this.m_stack);
                    if (this.m_stack.size() <= 0) break;
                    StackFrame sf = this.m_stack.getTopFrame();
                    sf.setVariableStrings(this.m_debugSession.buildVariableStrings(this.m_transformId));
                    break;
                }
                case 28: {
                    if (this.m_stack.size() <= 0) break;
                    StackFrame sf = this.m_stack.getTopFrame();
                    sf.setInForEach(sf.getInForEach() + 1);
                    boolean bl = inForEach = sf.getInForEach() == 2;
                    if (!inForEach) break;
                    this.m_debugSession.setStack(this.m_transformId, this.m_stack);
                    sf.setVariableStrings(this.m_debugSession.buildVariableStrings(this.m_transformId));
                    this.addStackFrame(ev.m_styleNode, ev.m_processor, true);
                    int contextNode = ev.m_processor.getXPathContext().getContextNode();
                    sourceLoc = ev.m_processor.getXPathContext().getDTM(contextNode).getSourceLocatorFor(contextNode);
                    break;
                }
                case 88: {
                    if (this.m_stack.size() > 0) {
                        this.m_debugSession.setStack(this.m_transformId, this.m_stack);
                        StackFrame sf = this.m_stack.getTopFrame();
                        sf.setVariableStrings(this.m_debugSession.buildVariableStrings(this.m_transformId));
                    }
                }
                case 19: {
                    DebugTransformerImpl transformer = this.m_debugSession.getTransform(this.m_transformId);
                    ElemTemplateElement ete = (ElemTemplateElement)transformer.getCurrentTemplateElements().elementAt(0);
                    if (ete.getXSLToken() == 19 && !this.m_debugSession.hasSetGlobalVariables(this.m_transformId)) {
                        StylesheetRoot stylesheet = ((ElemTemplate)ev.m_styleNode).getStylesheetRoot();
                        ArrayList<StackFrame.VarInfo> globList = new ArrayList<StackFrame.VarInfo>();
                        Iterator it = stylesheet.getVariablesAndParamsComposed().iterator();
                        while (it.hasNext()) {
                            ElemVariable var = (ElemVariable)it.next();
                            StackFrame.VarInfo vi = new StackFrame.VarInfo(var, 0);
                            globList.add(vi);
                        }
                        this.m_debugSession.setGlobalVariables(this.m_transformId, globList);
                    }
                    ElemTemplateElement elemTempElem = ev.m_styleNode;
                    int position = 0;
                    ArrayList callersContextNodeset = null;
                    if (elemTempElem instanceof ElemTemplate && ((ElemTemplate)elemTempElem).getName() != null) {
                        callersContextNodeset = this.m_stack.getTopFrame().getContextNodeset();
                        int currentNodeID = this.getCurrentNodeID(ev.m_processor);
                        position = DebugTraceListener.getContextPosition(currentNodeID, callersContextNodeset);
                    }
                    if (1 <= position) {
                        this.m_context = callersContextNodeset;
                    } else {
                        this.setContextNodeSet(ev.m_processor.getXPathContext().getContextNodeList());
                    }
                    this.addStackFrame(ev.m_styleNode, ev.m_processor, false);
                    int contextNode = ev.m_processor.getXPathContext().getContextNode();
                    sourceLoc = ev.m_processor.getXPathContext().getDTM(contextNode).getSourceLocatorFor(contextNode);
                    break;
                }
                case 46: {
                    break;
                }
            }
            EventPacket ep = new EventPacket();
            boolean bl = canViewStackframe = !this.m_debugSession.shouldFilterOutDefaultRuleStackframes() || !transformLine.isDefaultTemplateRule();
            if (this.m_forceSuspend && canViewStackframe) {
                ep.addEvent(new XDIUserSuspendEventImpl(null));
            }
            if (sourceLoc != null) {
                NodeLocation xmlLine = new NodeLocation(sourceLoc, this.getDocQuick(sourceLoc.getSystemId()));
                this.addBreakpointEvent(ep, xmlLine, false, true, 0);
            }
            this.addBreakpointEvent(ep, transformLine, inForEach, false, 0);
            if (ep.size() > 0 || canViewStackframe) {
                this.addEntryEvent(ep);
            }
            this.sendEventPacket(ep, this.m_templateLocationManager.getTemplateLocation(ev.m_styleNode, 0));
        }
        catch (RuntimeException e2) {
            DbgTrace.println("trace exception: " + e2);
            String excp = "";
            excp = String.valueOf(excp) + e2;
            String msg = XDIMessage.getFormattedString("INTERNAL_EXCEPTION_STACK", excp);
            XDIMessage.issueMessage(msg);
        }
    }

    private void addEntryEvent(EventPacket ep) {
        if (this.m_debugSession.getEntryExitMode() && !this.entryEventWasSent()) {
            ep.addEvent(new XDIEntryEventImpl(null));
            this.setEntryEventWasSent(true);
        }
    }

    private void addBreakpointEvent(EventPacket ep, NodeLocation transformLine, boolean forceNoSuspend, boolean isContext, int pos) {
        TemplateLocationManager.TemplateLocation tl;
        LineBreakpoint lineBreak = null;
        boolean hitBreakpoint = false;
        if (isContext) {
            lineBreak = this.m_debugSession.getEnabledXmlBreakpoint(transformLine);
            hitBreakpoint = lineBreak != null;
            this.setCurrentXmlLocation(transformLine);
        } else if (transformLine.getSourceLocator() != null && transformLine.getSourceLocator() instanceof ElemTemplateElement) {
            Iterator it = this.m_debugSession.getEnabledBreakpoints();
            while (it.hasNext()) {
                lineBreak = (LineBreakpoint)it.next();
                tl = this.m_templateLocationManager.getTemplateLocation(lineBreak.getNodeLocation());
                if (tl == null || tl.getElement() != transformLine.getSourceLocator() || pos != tl.getPosition()) continue;
                hitBreakpoint = true;
                break;
            }
        }
        boolean hasMoved = false;
        if (isContext) {
            hasMoved = true;
        } else if (transformLine.getSourceLocator() != null && transformLine.getSourceLocator() instanceof ElemTemplateElement && (tl = this.m_templateLocationManager.getTemplateLocation((ElemTemplateElement)transformLine.getSourceLocator(), pos)) != null && !(hasMoved = this.xmlLocationHasChanged())) {
            boolean bl = hasMoved = this.m_lastTemplate.getPreviousNodeLocation().getLineNumber() != tl.getPreviousNodeLocation().getLineNumber();
            if (!hasMoved && this.m_debugSession.isNodeStepping()) {
                boolean bl2 = hasMoved = this.m_lastTemplate.getPreviousNodeLocation().getCharStart() != tl.getPreviousNodeLocation().getCharStart() || this.m_lastTemplate.getPreviousNodeLocation().getAbsoluteCharStart() != tl.getPreviousNodeLocation().getAbsoluteCharStart();
            }
        }
        if (!forceNoSuspend) {
            boolean canViewStackframe;
            if (hitBreakpoint) {
                this.setXML_LocationWhenLastStopped(this.getCurrentXmlLocation());
                ep.addEvent(new XDIBreakpointEventImpl(null, lineBreak));
            }
            boolean bl = canViewStackframe = !this.m_debugSession.shouldFilterOutDefaultRuleStackframes() || !transformLine.isDefaultTemplateRule() || this.m_lastTemplate.getNodeLocation().isDefaultTemplateRule();
            if (!(this.m_stepMode == StepMode.NO_STEPPING || isContext || this.m_stepFrame <= this.m_stack.countFrames() && this.m_stepFrame >= 0 || !hasMoved && this.m_stepMode != StepMode.RETURN || !canViewStackframe)) {
                this.setXML_LocationWhenLastStopped(this.getCurrentXmlLocation());
                ep.addEvent(new XDIStepEndEventImpl(null));
            }
        }
    }

    protected void setStepMode(StepMode mode) {
        this.m_stepMode = mode;
        if (this.m_stepMode == StepMode.NO_STEPPING || this.m_stepMode == StepMode.INTO) {
            this.m_stepFrame = -1;
        } else if (this.m_stepMode == StepMode.OVER) {
            this.m_stepFrame = this.m_stack.countFrames() + 1;
        } else if (this.m_stepMode == StepMode.RETURN) {
            this.m_stepFrame = this.m_stack.countFrames();
        }
    }

    protected StepMode getStepMode() {
        return this.m_stepMode;
    }

    protected void disconnectTransform() {
        this.m_ignoreEvents = true;
    }

    private void addStackFrame(ElemTemplateElement styleNode, TransformerImpl processor, boolean isForEach) {
        StackFrame stackFrame = new StackFrame();
        stackFrame.setContextNodeset(new ArrayList(this.m_context));
        stackFrame.setTemplate(this.m_templateLocationManager.getTemplateLocation(styleNode, 0));
        stackFrame.setForEach(isForEach);
        stackFrame.setLastTemplate(this.m_lastTemplate);
        stackFrame.setAbsoluteURI(styleNode.getSystemId());
        if (styleNode.getXSLToken() == 19) {
            ElemTemplate et = (ElemTemplate)styleNode;
            if (et.getMode() != null) {
                stackFrame.setMode(et.getMode().toString());
            }
            stackFrame.setPriority(Double.toString(et.getPriority()));
        }
        new TemplateLocationManager.TemplateLocation(this.m_templateLocationManager);
        this.m_stack.push(stackFrame);
        this.updateContextPosition(processor);
    }

    int getCurrentNodeID(TransformerImpl processor) {
        int id = processor.getXPathContext().getContextNode();
        return id;
    }

    private static int getContextPosition(int currentNodeID, ArrayList context) {
        int position = 0;
        int i = 0;
        while (i < context.size()) {
            if ((Integer)context.get(i) == currentNodeID) {
                position = i + 1;
                break;
            }
            ++i;
        }
        return position;
    }

    private void updateContextPosition(TransformerImpl processor) {
        try {
            StackFrame stackFrame = this.m_stack.getTopFrame();
            int contextNode = processor.getXPathContext().getContextNode();
            int position = DebugTraceListener.getContextPosition(contextNode, this.m_context);
            if (1 <= position) {
                stackFrame.setContextPosition(position);
            } else {
                stackFrame.setContextPosition(1);
                String session = Integer.toString(this.m_debugSession.getDebugSessionID());
                int tran_id = this.getTransformerThreadId();
                String sheet_uri = this.m_debugSession.getTransform(tran_id).getStylesheetURIName();
                String msg = XDIMessage.getFormattedString2("INTERNAL_CONTEXT_POSITION", sheet_uri, session);
                XDIMessage.issueMessage(msg);
            }
        }
        catch (EmptyStackException emptyStackException) {
            DbgTrace.println("Attempted to updateContextPosition on empty stack.");
            String session = Integer.toString(this.m_debugSession.getDebugSessionID());
            int tran_id = this.getTransformerThreadId();
            String sheet_uri = this.m_debugSession.getTransform(tran_id).getStylesheetURIName();
            String msg = XDIMessage.getFormattedString2("INTERNAL_CONTEXT_POSITION", sheet_uri, session);
            XDIMessage.issueMessage(msg);
        }
    }

    private void updateLineNumber(ElemTemplateElement template, int pos) {
        if (this.m_stack.size() > 0) {
            StackFrame topFrame = this.m_stack.getTopFrame();
            topFrame.setTemplate(this.m_templateLocationManager.getTemplateLocation(template, pos));
            topFrame.setAbsoluteURI(template.getSystemId());
        }
    }

    private void removeStackFrame() {
        int viewableCount;
        if (this.m_stack.size() > 0) {
            StackFrame sf = this.m_stack.pop();
            this.m_context = sf.getContextNodeset();
        }
        if (this.m_lowestStackFrame > (viewableCount = this.m_stack.countViewableFrames())) {
            this.m_lowestStackFrame = viewableCount;
        }
    }

    public boolean suspend(boolean immediate) {
        if (immediate && this.m_inExtensionFunction == 0) {
            return false;
        }
        if (this.m_inExtensionFunction > 0) {
            this.m_debugSession.setSuspended(this.m_transformId, SuspendState.FAKE_SUSPEND);
        } else {
            this.m_forceSuspend = true;
        }
        return true;
    }

    public int getTransformerThreadId() {
        return this.m_transformId;
    }

    public void suspendTransform(boolean resetStepping) {
        if (resetStepping) {
            this.setStepMode(StepMode.NO_STEPPING);
            this.m_forceSuspend = false;
        }
        this.m_debugSession.setSuspended(this.m_transformId, SuspendState.NORMAL_SUSPENDED);
        if (resetStepping) {
            this.m_debugSession.setStepPending(this.m_transformId, false);
        }
        this.m_debugSession.suspendTransformation(this.m_transformId);
        this.m_debugSession.setSuspended(this.m_transformId, SuspendState.NOT_SUSPENDED);
    }

    public int getLowestStackFrame() {
        return this.m_lowestStackFrame;
    }

    public void setLowestStackFrame(int i) {
        this.m_lowestStackFrame = i;
    }

    private void setContextNodeSet(DTMIterator nl) {
        int currentPos = -1;
        currentPos = nl.getCurrentPos();
        nl.setShouldCacheNodes(true);
        DTMIterator clone = null;
        try {
            clone = nl.cloneWithReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            DbgTrace.println("     [Can't trace nodelist because it it threw a CloneNotSupportedException]");
            String session = Integer.toString(this.m_debugSession.getDebugSessionID());
            int tran_id = this.getTransformerThreadId();
            String sheet_uri = this.m_debugSession.getTransform(tran_id).getStylesheetURIName();
            String msg = XDIMessage.getFormattedString2("INTERNAL_CONTEXT_POSITION", sheet_uri, session);
            XDIMessage.issueMessage(msg);
            return;
        }
        int pos = clone.nextNode();
        if (-1 != pos) {
            this.m_context = new ArrayList();
            while (-1 != pos) {
                this.m_context.add(new Integer(pos));
                pos = clone.nextNode();
            }
        }
        nl.runTo(-1);
        nl.setCurrentPos(currentPos);
    }

    public void extension(ExtensionEvent ee) {
        Class clazz;
        boolean isRedirect = false;
        if (ee.m_callType == 1) {
            Method method2 = (Method)ee.m_method;
            if (method2.getDeclaringClass().getName().equals("org.apache.xalan.lib.Redirect")) {
                isRedirect = true;
            }
        } else if (ee.m_callType == 0 && (clazz = (Class)ee.m_method).getName().equals("org.apache.xalan.lib.Redirect")) {
            isRedirect = true;
        }
        if (!isRedirect) {
            if (this.m_ignoreEvents || this.m_processingRequest || this.m_inExtensionFunction > 0) {
                ++this.m_inExtensionFunction;
            } else {
                ++this.m_inExtensionFunction;
                if (this.m_debugSession.getCalloutMode(this.m_transformId)) {
                    EventPacket ep = new EventPacket();
                    XDIJavaExtensionCallEventImpl ev = new XDIJavaExtensionCallEventImpl();
                    if (ee.m_callType == 1) {
                        Method method3 = (Method)ee.m_method;
                        String[] parameterTypes = new String[method3.getParameterTypes().length];
                        int i = 0;
                        while (i < method3.getParameterTypes().length) {
                            parameterTypes[i] = method3.getParameterTypes()[i].getName();
                            ++i;
                        }
                        ev.setJavaMethod(new JavaMethodImpl(method3.getDeclaringClass().getName(), method3.getName(), parameterTypes, method3.getReturnType().getName()));
                    } else if (ee.m_callType == 2) {
                        Constructor constructor = (Constructor)ee.m_method;
                        String[] parameterTypes = new String[constructor.getParameterTypes().length];
                        int i = 0;
                        while (i < constructor.getParameterTypes().length) {
                            parameterTypes[i] = constructor.getParameterTypes()[i].getName();
                            ++i;
                        }
                        ev.setJavaMethod(new JavaMethodImpl(constructor.getName(), "<init>", parameterTypes, "void"));
                    } else if (ee.m_callType == 0) {
                        Class clazz2 = (Class)ee.m_method;
                        ev.setJavaMethod(new JavaMethodImpl(clazz2.getName(), "<init>", new String[0], "void"));
                    }
                    ep.addEvent(ev);
                    this.sendEventPacket(ep, null);
                }
            }
        }
    }

    public void extensionEnd(ExtensionEvent ee) {
        Class clazz;
        boolean isRedirect = false;
        if (ee.m_callType == 1) {
            Method method2 = (Method)ee.m_method;
            if (method2.getDeclaringClass().getName().equals("org.apache.xalan.lib.Redirect")) {
                isRedirect = true;
            }
        } else if (ee.m_callType == 0 && (clazz = (Class)ee.m_method).getName().equals("org.apache.xalan.lib.Redirect")) {
            isRedirect = true;
        }
        if (!isRedirect) {
            if (this.m_ignoreEvents || this.m_processingRequest || this.m_inExtensionFunction > 1) {
                --this.m_inExtensionFunction;
            } else {
                --this.m_inExtensionFunction;
                if (this.m_debugSession.isTranSuspended(this.m_transformId)) {
                    this.m_debugSession.suspendTransformation(this.m_transformId);
                }
                if (this.m_debugSession.getCalloutMode(this.m_transformId)) {
                    EventPacket ep = new EventPacket();
                    ep.addEvent(new XDIReturnFromExtensionEventImpl());
                    this.sendEventPacket(ep, null);
                }
            }
        }
    }

    public void setProcessingRequest(boolean b) {
        this.m_processingRequest = b;
    }

    public DebugDocument getDocument(String uri) {
        DebugDocument doc = null;
        if (this.m_styleSheetDocManager != null) {
            doc = this.m_styleSheetDocManager.getDocument(uri);
        }
        if (doc == null) {
            doc = this.getDocQuick(uri);
        }
        return doc;
    }

    private DebugDocument getDocQuick(String sysID) {
        DebugDocument doc;
        if (this.m_prevSysID != null && this.m_prevSysID == sysID) {
            doc = this.m_prevDoc;
        } else {
            doc = this.m_documentManager.getDocument(sysID);
            this.m_prevSysID = sysID;
            this.m_prevDoc = doc;
        }
        return doc;
    }

    public DebugDocument getDocument(int i) {
        DebugDocument doc = null;
        if (this.m_styleSheetDocManager != null) {
            doc = this.m_styleSheetDocManager.getDocument(i);
        }
        if (doc == null) {
            doc = this.m_documentManager.getDocument(i);
        }
        return doc;
    }

    public DebugDocumentManager getTraceDocManager() {
        return this.m_documentManager;
    }

    public boolean sendEventPacket(EventPacket ep, TemplateLocationManager.TemplateLocation tl) {
        ArrayList list;
        boolean hasBreakpointEvent;
        boolean hasUserSuspendEvent;
        boolean needUpdate;
        boolean needSuspend;
        block13: {
            needSuspend = false;
            needUpdate = false;
            hasUserSuspendEvent = false;
            hasBreakpointEvent = false;
            boolean hasExitEvent = false;
            if (ep.size() == 0) {
                return true;
            }
            list = new ArrayList();
            list.addAll(ep.getUpdateList());
            int i = 0;
            while (i < ep.size()) {
                if (ep.elementAt(i) instanceof XDISuspendEventImpl) {
                    needSuspend = true;
                }
                if (needSuspend || ep.elementAt(i) instanceof XDITransformTerminateEventImpl) {
                    needUpdate = true;
                }
                if (ep.elementAt(i) instanceof XDIUserSuspendEventImpl) {
                    hasUserSuspendEvent = true;
                }
                if (ep.elementAt(i) instanceof XDIExitEventImpl) {
                    hasExitEvent = true;
                }
                if (ep.elementAt(i) instanceof XDIBreakpointEventImpl || ep.elementAt(i) instanceof XDIStepEndEventImpl) {
                    hasBreakpointEvent = true;
                }
                ++i;
            }
            if (needSuspend && !hasExitEvent) {
                i = 0;
                while (i < this.m_stack.size()) {
                    if (this.m_stack.getFrame(i).getLineNumber() == 0) {
                        ++i;
                        continue;
                    }
                    break block13;
                }
                return true;
            }
        }
        if (needUpdate) {
            this.m_debugSession.setStack(this.m_transformId, this.m_stack);
            list.addAll(this.m_documentManager.getUpdateArrayList());
        }
        boolean was_sent = this.m_debugSession.sendMessage(this.m_transformId, 51, list.toArray(new String[list.size()]));
        if (needSuspend) {
            this.suspendTransform(hasUserSuspendEvent || hasBreakpointEvent);
            if (tl != null) {
                this.m_lastTemplate = tl;
            }
        }
        return was_sent;
    }

    public TemplateLocationManager getTemplateLocationManager() {
        return this.m_templateLocationManager;
    }

    public void setTemplateLocationManager(TemplateLocationManager manager) {
        this.m_templateLocationManager = manager;
        this.m_lastTemplate = new TemplateLocationManager.TemplateLocation(this.m_templateLocationManager);
    }

    public boolean entryEventWasSent() {
        return this.m_entryEventSent;
    }

    public void setEntryEventWasSent(boolean sent) {
        this.m_entryEventSent = sent;
    }

    public boolean inCallout() {
        boolean inCallout = this.m_inExtensionFunction > 0;
        return inCallout;
    }

    public void setStyleSheetManager(DebugDocumentManager styleSheetDocManager) {
        this.m_styleSheetDocManager = styleSheetDocManager;
    }

    private synchronized int nextDbgId() {
        return ++dbgId;
    }

    private void clearDeeperVariables(int depth) {
        if (this.m_stack.size() > 0) {
            StackFrame sf = this.m_stack.getTopFrame();
            sf.clearDeeperVariables(depth);
        }
    }

    static final class Frames {
        private final Stack m_StackFrames = new Stack();

        Frames() {
        }

        final int size() {
            int count = this.m_StackFrames.size();
            return count;
        }

        private StackFrame getTopFrame() {
            StackFrame sf = (StackFrame)this.m_StackFrames.peek();
            return sf;
        }

        final StackFrame getFrame(int depth) {
            StackFrame sf = (StackFrame)this.m_StackFrames.get(depth);
            return sf;
        }

        private void push(StackFrame sf) {
            this.m_StackFrames.push(sf);
        }

        private StackFrame pop() {
            StackFrame sf = (StackFrame)this.m_StackFrames.pop();
            return sf;
        }

        private int countFrames() {
            int cnt = 0;
            int i = 0;
            while (i < this.size()) {
                StackFrame sf = this.getFrame(i);
                if (!sf.getForEach()) {
                    ++cnt;
                }
                ++i;
            }
            return cnt;
        }

        final int countViewableFrames() {
            int cnt = 0;
            int i = 0;
            while (i < this.size()) {
                StackFrame sf = this.getFrame(i);
                if (sf.isViewable()) {
                    ++cnt;
                }
                ++i;
            }
            return cnt;
        }
    }
}

