/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.impl.NodeLocation;
import com.ibm.debug.xdi.XDILineBreakpoint;
import com.ibm.debug.xdi.util.CanonicalURI;

public class LineBreakpoint
implements XDILineBreakpoint {
    private NodeLocation m_nodeLocation;
    private boolean m_enabled = true;
    private int m_charStart;
    private int m_charEnd;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    private LineBreakpoint(String fileName, int lineNumber, int charStart, int charEnd) {
        this.m_nodeLocation = new NodeLocation(fileName, lineNumber, 1);
        this.m_charStart = charStart;
        this.m_charEnd = charEnd;
    }

    public static LineBreakpoint newInstance(String fileName, int lineNumber, int charStart, int charEnd) {
        LineBreakpoint lbp = new LineBreakpoint(fileName, lineNumber, charStart, charEnd);
        return lbp;
    }

    public void setEnabled(boolean enable) {
        this.m_enabled = enable;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public String toString() {
        return this.m_nodeLocation.toString();
    }

    public boolean equals(LineBreakpoint lb) {
        return this.m_nodeLocation.equals(lb.getNodeLocation());
    }

    public boolean isInstalled() {
        return false;
    }

    public NodeLocation getNodeLocation() {
        return this.m_nodeLocation;
    }

    public int getCharEnd() {
        return this.m_charEnd;
    }

    public int getCharStart() {
        return this.m_charStart;
    }

    public String getFileName() {
        return this.m_nodeLocation.getURI().getURIString();
    }

    public int getLineNumber() {
        return this.m_nodeLocation.getLineNumber();
    }

    public boolean isEqualTo(CanonicalURI uri, int lineNumber, int charStart, int charEnd) {
        return this.m_nodeLocation.isEqualTo(uri, lineNumber, 1) && charEnd == this.m_charEnd && charStart == this.m_charStart;
    }

    public boolean isEqualTo2(CanonicalURI uri, int lineNumber, int charStart, int charEnd) {
        return !(!this.m_nodeLocation.isEqualTo2(uri, lineNumber, 1) || this.m_charStart != -1 && charStart != -1 && this.m_charStart != charStart || this.m_charEnd != -1 && charEnd != -1 && this.m_charEnd != charEnd);
    }
}

