/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.xdi.util.CanonicalURI;
import javax.xml.transform.SourceLocator;
import org.apache.xalan.templates.ElemTemplateElement;

public final class NodeLocation {
    static final int UNDEFINED = -1;
    private CanonicalURI m_uri;
    private int m_lineNumber;
    private int m_charStart;
    private final SourceLocator m_sourceLocator;
    private int m_absoluteCharStart;
    private final DebugDocument m_debugDoc;
    private static final CanonicalURI URI_OF_BUILT_INS = CanonicalURI.getInstance("http://built-in.template.rules/default.xsl");
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    NodeLocation() {
        this.m_debugDoc = null;
        this.m_uri = CanonicalURI.getInstance(null);
        this.m_lineNumber = -1;
        this.m_charStart = -1;
        this.m_sourceLocator = null;
        this.m_absoluteCharStart = -1;
    }

    NodeLocation(String fileURI, int lineNumber, int charStart) {
        this.m_debugDoc = null;
        this.m_uri = CanonicalURI.getInstance(fileURI);
        this.m_lineNumber = lineNumber;
        this.m_charStart = charStart;
        this.m_sourceLocator = null;
        this.m_absoluteCharStart = -1;
    }

    NodeLocation(CanonicalURI uri, int lineNumber, int charStart, int absoluteCharStart, DebugDocument doc) {
        this.m_debugDoc = doc;
        this.m_uri = uri;
        this.m_lineNumber = lineNumber;
        this.m_charStart = charStart;
        this.m_sourceLocator = null;
        this.m_absoluteCharStart = absoluteCharStart;
    }

    NodeLocation(SourceLocator sourceLoc, DebugDocument doc) {
        int toEndOfPrevLine;
        this.m_debugDoc = doc;
        String systemId = sourceLoc.getSystemId();
        this.m_uri = CanonicalURI.getInstance(systemId);
        this.m_lineNumber = sourceLoc.getLineNumber();
        this.m_charStart = sourceLoc.getColumnNumber();
        this.m_sourceLocator = sourceLoc;
        int absCharStart = -1;
        if (doc != null && this.m_charStart > 0 && (toEndOfPrevLine = doc.numCharsToEOL(this.m_lineNumber - 1)) != -1) {
            absCharStart = toEndOfPrevLine + this.m_charStart;
        }
        this.m_absoluteCharStart = absCharStart;
    }

    NodeLocation(ElemTemplateElement sourceLoc, boolean isEnd, DebugDocument doc) {
        this.m_debugDoc = doc;
        String systemId = sourceLoc.getSystemId();
        this.m_uri = CanonicalURI.getInstance(systemId);
        this.m_sourceLocator = sourceLoc;
        if (isEnd) {
            int endLine = sourceLoc.getEndLineNumber();
            if (endLine < 1) {
                endLine = sourceLoc.getLineNumber();
            }
            this.m_lineNumber = endLine;
            this.m_charStart = sourceLoc.getEndColumnNumber();
        } else {
            this.m_lineNumber = sourceLoc.getLineNumber();
            this.m_charStart = sourceLoc.getColumnNumber();
        }
        int charsFromStartOfDocToEndOfPreviousLine = doc == null ? -1 : doc.numCharsToEOL(this.m_lineNumber - 1);
        this.m_absoluteCharStart = charsFromStartOfDocToEndOfPreviousLine != -1 ? charsFromStartOfDocToEndOfPreviousLine + this.m_charStart : -1;
    }

    boolean isEqualTo(CanonicalURI uri, int lineNumber, int charStart) {
        return this.m_uri == uri && this.m_lineNumber == lineNumber && this.m_charStart == charStart;
    }

    boolean isEqualTo2(CanonicalURI uri, int lineNumber, int charStart) {
        return this.m_uri == uri && this.m_lineNumber == lineNumber && (this.m_charStart == -1 || charStart == -1 || this.m_charStart == charStart);
    }

    public String toString() {
        StringBuffer data = new StringBuffer();
        data.append(this.m_uri.getURIString());
        data.append(",");
        data.append(this.m_lineNumber);
        data.append(",");
        data.append(this.m_charStart);
        data.append(",");
        data.append(-1);
        return data.toString();
    }

    public boolean equals(Object nodeLoc) {
        if (!(nodeLoc instanceof NodeLocation)) {
            return false;
        }
        NodeLocation lb = (NodeLocation)nodeLoc;
        return lb != null && lb.getCharStart() == lb.getCharStart() && lb.getAbsoluteCharStart() == this.m_absoluteCharStart && this.m_uri == lb.getURI() && lb.getLineNumber() == this.m_lineNumber;
    }

    public int hashCode() {
        return this.m_uri.getURIString().hashCode() ^ this.m_lineNumber << 8 ^ this.m_charStart;
    }

    boolean isLT(NodeLocation otherLoc) {
        if (otherLoc.getLineNumber() > this.m_lineNumber) {
            return true;
        }
        if (otherLoc.getLineNumber() == this.m_lineNumber) {
            if (otherLoc.getCharStart() > this.m_charStart) {
                return true;
            }
            if (otherLoc.getAbsoluteCharStart() > this.m_absoluteCharStart) {
                return true;
            }
        }
        return false;
    }

    final boolean equals2(NodeLocation xmlLoc) {
        boolean equal = false;
        if (xmlLoc != null) {
            boolean sameLine;
            boolean bl = sameLine = xmlLoc.getLineNumber() == this.m_lineNumber;
            if (sameLine) {
                boolean sameCharStart;
                boolean bl2 = sameCharStart = xmlLoc.getCharStart() == xmlLoc.getCharStart() || this.m_charStart == -1 || xmlLoc.getCharStart() == -1;
                if (sameCharStart) {
                    boolean sameAbsCharstart;
                    boolean bl3 = sameAbsCharstart = xmlLoc.getAbsoluteCharStart() == xmlLoc.getAbsoluteCharStart() || this.m_absoluteCharStart == -1 || xmlLoc.getAbsoluteCharStart() == -1;
                    if (sameAbsCharstart) {
                        boolean sameURI;
                        boolean bl4 = sameURI = this.m_uri != null && (this.m_uri == xmlLoc.getURI() || this.m_uri.getAbsouluteURI() == xmlLoc.getURI());
                        if (!sameURI) {
                            CanonicalURI uri = xmlLoc.getURI();
                            if (this.m_uri.isRelativeUriOf(uri)) {
                                this.m_uri.setAbsouluteURI(uri);
                                equal = true;
                            }
                        } else {
                            equal = true;
                        }
                    }
                }
            }
        }
        return equal;
    }

    int getCharStart() {
        return this.m_charStart;
    }

    CanonicalURI getURI() {
        return this.m_uri;
    }

    int getLineNumber() {
        return this.m_lineNumber;
    }

    SourceLocator getSourceLocator() {
        return this.m_sourceLocator;
    }

    boolean isDefaultTemplateRule() {
        boolean ret = this.m_uri == URI_OF_BUILT_INS;
        return ret;
    }

    int getAbsoluteCharStart() {
        return this.m_absoluteCharStart;
    }

    int getOffsetFromStartOfLine() {
        int off = -1;
        if (this.m_charStart != -1) {
            off = this.m_charStart - 1;
        }
        return off;
    }

    DebugDocument getDebugDoc() {
        return this.m_debugDoc;
    }

    private String toDbgString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    uri                   : ").append(this.m_uri.getURIString()).append('\n');
        sb.append("    m_lineNumber          : ").append(this.m_lineNumber).append('\n');
        sb.append("    m_charStart           : ").append(this.m_charStart).append('\n');
        sb.append("    m_absoluteCharStart   : ").append(this.m_absoluteCharStart).append('\n');
        sb.append("    m_debugDoc            : ").append(this.m_debugDoc).append('\n');
        if (this.m_sourceLocator == null) {
            sb.append("    sourceLocator         : null");
            sb.append('\n');
        } else {
            sb.append("    sourceLocator         : NOT null").append('\n');
            sb.append("    sourceLocator col     : ").append(this.m_sourceLocator.getColumnNumber()).append('\n');
            sb.append("    sourceLocator line    : ").append(this.m_sourceLocator.getLineNumber()).append('\n');
            sb.append("    sourceLocator PubID   : ").append(this.m_sourceLocator.getPublicId()).append('\n');
            sb.append("    sourceLocator SysID   : ").append(this.m_sourceLocator.getSystemId()).append('\n');
        }
        return sb.toString();
    }
}

