/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.impl.NodeLocation;
import com.ibm.debug.transform.impl.TemplateLocationManager;
import com.ibm.debug.transform.intrface.DebugDocument;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xml.utils.QName;

public class StackFrame {
    private int m_contextPosition = -2;
    private ArrayList m_contextNodeset = new ArrayList();
    private int m_inForEach = 0;
    private boolean m_forEach = false;
    private String m_mode;
    private String m_priority;
    private TemplateLocationManager.TemplateLocation m_lastTemplate = null;
    private TemplateLocationManager.TemplateLocation m_template = null;
    private String m_absoluteURI = null;
    private Stack m_variables = new Stack();
    private ArrayList m_variableStrings = new ArrayList();
    private NodeLocation m_xml_location = null;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    StackFrame() {
    }

    int getContextPosition() {
        return this.m_contextPosition;
    }

    int getLineNumber() {
        if (this.m_template == null) {
            return -1;
        }
        return this.m_template.getPreviousNodeLocation().getLineNumber();
    }

    int getAbsoluteCharNumber() {
        if (this.m_template == null) {
            return -1;
        }
        return this.m_template.getPreviousNodeLocation().getAbsoluteCharStart();
    }

    int getAbsoluteEndCharNumber() {
        if (this.m_template == null) {
            return -1;
        }
        return this.m_template.getNodeLocation().getAbsoluteCharStart();
    }

    ArrayList getContextNodeset() {
        return this.m_contextNodeset;
    }

    void setContextPosition(int contextPosition) {
        this.m_contextPosition = contextPosition;
    }

    void setContextNodeset(ArrayList nodeset) {
        this.m_contextNodeset = nodeset;
    }

    private void addNode(int dtmId) {
        this.m_contextNodeset.add(new Integer(dtmId));
    }

    private Stack getVariables() {
        return this.m_variables;
    }

    private ElemVariable popVariable() {
        VarInfo pv = (VarInfo)this.m_variables.pop();
        ElemVariable ev = pv.m_var;
        return ev;
    }

    private ElemVariable removeVariable(int index) {
        VarInfo pv = (VarInfo)this.m_variables.elementAt(index);
        ElemVariable ev = pv.m_var;
        this.m_variables.remove(index);
        return ev;
    }

    int numVariables() {
        return this.m_variables.size();
    }

    VarInfo getVarInfo(int index) {
        VarInfo vi = (VarInfo)this.m_variables.elementAt(index);
        return vi;
    }

    private int getVariableDepth(int index) {
        int depth = ((VarInfo)this.m_variables.elementAt(index)).m_depth;
        return depth;
    }

    void pushVariable(ElemVariable ev, int xsltDepth) {
        this.m_variables.push(new VarInfo(ev, xsltDepth));
    }

    boolean getForEach() {
        return this.m_forEach;
    }

    void setForEach(boolean x) {
        this.m_forEach = x;
    }

    int getInForEach() {
        return this.m_inForEach;
    }

    void setInForEach(int x) {
        this.m_inForEach = x;
    }

    private int getLastLineNumber() {
        if (this.m_lastTemplate == null) {
            return -1;
        }
        return this.m_lastTemplate.getNodeLocation().getLineNumber();
    }

    void setLastTemplate(TemplateLocationManager.TemplateLocation lastTemplate) {
        this.m_lastTemplate = lastTemplate;
    }

    String getAbsoluteURI() {
        return this.m_absoluteURI;
    }

    void setAbsoluteURI(String absoluteURI) {
        this.m_absoluteURI = absoluteURI;
    }

    ArrayList getVariableStrings() {
        return this.m_variableStrings;
    }

    void setVariableStrings(ArrayList list) {
        this.m_variableStrings = list;
    }

    String getMode() {
        return this.m_mode;
    }

    String getPriority() {
        return this.m_priority;
    }

    void setMode(String string) {
        this.m_mode = string;
    }

    void setPriority(String string) {
        this.m_priority = string;
    }

    private boolean isDefaultTemplateRule() {
        return this.getAbsoluteURI().equals("http://built-in.template.rules/default.xsl");
    }

    private TemplateLocationManager.TemplateLocation getLastTemplate() {
        return this.m_lastTemplate;
    }

    boolean isViewable() {
        return true;
    }

    void setTemplate(TemplateLocationManager.TemplateLocation location) {
        this.m_template = location;
        this.getLineNumber();
    }

    void clearDeeperVariables(int depth) {
        int varCount = this.numVariables();
        int varIndex = varCount - 1;
        while (varIndex >= 0) {
            if (this.getVariableDepth(varIndex) >= depth) {
                this.removeVariable(varIndex);
            }
            --varIndex;
        }
    }

    void setCurrentXmlLocation(NodeLocation nl) {
        this.m_xml_location = nl;
    }

    NodeLocation getCurrentXmlLocation() {
        return this.m_xml_location;
    }

    public int getLoc1CharOffset() {
        int off = -1;
        if (this.m_template != null) {
            off = this.m_template.getPreviousNodeLocation().getOffsetFromStartOfLine();
        }
        return off;
    }

    public int getLoc2CharOffset() {
        int off = -1;
        if (this.m_template != null) {
            NodeLocation nl = this.m_template.getNodeLocation();
            int offset_of_first_char_of_next_element = nl.getOffsetFromStartOfLine();
            if (1 <= offset_of_first_char_of_next_element) {
                off = offset_of_first_char_of_next_element - 1;
            } else if (offset_of_first_char_of_next_element == 0) {
                int off_end;
                int last_line_of_this_element;
                DebugDocument dd = nl.getDebugDoc();
                if (dd != null && (last_line_of_this_element = this.getLoc2LineNumber()) != -1 && (off_end = dd.numCharsToEOL(last_line_of_this_element)) != -1) {
                    int off_start;
                    off = off_end;
                    if (2 <= last_line_of_this_element && (off_start = dd.numCharsToEOL(last_line_of_this_element - 1)) != -1) {
                        off = off_end - off_start;
                    }
                    if (off > 0) {
                        --off;
                    }
                }
            } else {
                off = -1;
            }
        }
        return off;
    }

    public int getLoc1LineNumber() {
        NodeLocation nl;
        int line1 = -1;
        if (this.m_template != null && (nl = this.m_template.getPreviousNodeLocation()) != null) {
            line1 = nl.getLineNumber();
        }
        return line1;
    }

    public int getLoc2LineNumber() {
        int last_line_of_this_element = -1;
        if (this.m_template != null) {
            NodeLocation nl = this.m_template.getNodeLocation();
            int first_line_of_next_element = nl.getLineNumber();
            int offset_of_first_char_of_next_element = nl.getOffsetFromStartOfLine();
            last_line_of_this_element = offset_of_first_char_of_next_element == 0 && 2 <= first_line_of_next_element ? first_line_of_next_element - 1 : first_line_of_next_element;
        }
        return last_line_of_this_element;
    }

    private class StackNode {
        private int m_nodeLineNumber = -1;
        private String m_nodeDocURI = null;
        private String m_name = null;

        private StackNode(int nodeLineNumber, String nodeDocURI, String name2) {
            this.m_nodeLineNumber = nodeLineNumber;
            this.m_nodeDocURI = nodeDocURI;
            this.m_name = name2;
        }
    }

    static class VarInfo {
        private final ElemVariable m_var;
        private final int m_depth;
        private String m_cachedValue;
        private int m_varId;

        VarInfo(ElemVariable ev, int depth) {
            this.m_depth = depth;
            this.m_var = ev;
        }

        String getName() {
            QName qn;
            String ret = this.m_var == null ? null : ((qn = this.m_var.getName()) == null ? null : qn.toString());
            return ret;
        }

        int getDepth() {
            return this.m_depth;
        }

        ElemVariable getElemVariable() {
            return this.m_var;
        }

        String getCachedValue() {
            return this.m_cachedValue;
        }

        void setCachedValue(String val) {
            this.m_cachedValue = val;
        }

        public void setVarId(int id) {
            this.m_varId = id;
        }

        public int getVarId() {
            return this.m_varId;
        }
    }
}

