/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.transform.impl;

import com.ibm.debug.transform.impl.DebugTraceListener;
import com.ibm.debug.transform.impl.NodeLocation;
import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugStylesheetRoot;
import com.ibm.debug.xdi.util.CanonicalURI;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemText;
import org.apache.xalan.templates.ElemTextLiteral;

public final class TemplateLocationManager {
    public static final int START = 0;
    public static final int END = 1;
    private final Hashtable m_hashURItoTemplateArray = new Hashtable();
    private final Hashtable m_templateCache = new Hashtable();
    private final Hashtable[] m_reverseTemplateCache = new Hashtable[]{new Hashtable(), new Hashtable()};
    private final Hashtable m_previousLocation = new Hashtable();
    private char[] m_documentChars;
    private final DebugTraceListener m_traceListener;
    private final String m_alternateSourceURI;
    private static final char[] s_eolChars = System.getProperty("line.separator").toCharArray();
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public TemplateLocationManager(DebugStylesheetRoot stylesheetRoot, DebugTraceListener traceListener, String alternateURI) {
        this.m_traceListener = traceListener;
        this.m_alternateSourceURI = alternateURI;
        this.processRootElement((ElemTemplateElement)stylesheetRoot);
        this.processRootElement((ElemTemplateElement)stylesheetRoot.getDefaultRootRule());
        this.processRootElement((ElemTemplateElement)stylesheetRoot.getDefaultRule());
        this.processRootElement((ElemTemplateElement)stylesheetRoot.getDefaultTextRule());
        Hashtable<Object, Object> processedStylesheets = new Hashtable<Object, Object>();
        Object obj = new Object();
        int i = 0;
        while (i < stylesheetRoot.getIncludeCount()) {
            if (processedStylesheets.get(stylesheetRoot.getInclude(i)) == null) {
                this.processRootElement((ElemTemplateElement)stylesheetRoot.getInclude(i));
                processedStylesheets.put(stylesheetRoot.getInclude(i), obj);
            }
            ++i;
        }
        i = 0;
        while (i < stylesheetRoot.getImportCount()) {
            if (processedStylesheets.get(stylesheetRoot.getImport(i)) == null) {
                this.processRootElement((ElemTemplateElement)stylesheetRoot.getImport(i));
                processedStylesheets.put(stylesheetRoot.getImport(i), obj);
            }
            ++i;
        }
    }

    private void processRootElement(ElemTemplateElement element) {
        CanonicalURI uri = CanonicalURI.getInstance(element.getSystemId());
        ArrayList arrayList = this.getArrayFromURI(uri);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.m_documentChars = null;
        if (this.m_traceListener.getDocument(element.getSystemId()) != null && this.m_traceListener.getDocument(element.getSystemId()).generatedFile() != null) {
            this.m_documentChars = this.m_traceListener.getDocument(element.getSystemId()).generatedFile().toCharArray();
        }
        DebugDocument doc = this.m_traceListener.getDocument(element.getSystemId());
        this.processElement(element, arrayList, uri.getURIString(), doc);
        this.putArrayFromURI(uri, arrayList);
    }

    private void putArrayFromURI(CanonicalURI uri, ArrayList arrayList) {
        String uri2;
        this.m_hashURItoTemplateArray.put(uri, arrayList);
        if (uri.getURIString().equals("") && (uri2 = this.m_alternateSourceURI) != null) {
            CanonicalURI canURI2 = CanonicalURI.getInstance(uri2);
            this.m_hashURItoTemplateArray.put(canURI2, arrayList);
        }
    }

    private void processElement(ElemTemplateElement element, ArrayList arrayList, String systemId, DebugDocument doc) {
        String newSystemId = element.getSystemId();
        if (newSystemId != null) {
            newSystemId = CanonicalURI.getCanonicalURI(newSystemId);
        }
        if (newSystemId == null && systemId == null || newSystemId != null && !newSystemId.equals(systemId)) {
            this.processRootElement(element);
        } else {
            TemplateLocation tl = new TemplateLocation(this, element, false, doc, null);
            this.m_reverseTemplateCache[0].put(element, tl);
            arrayList.add(tl);
            ElemTemplateElement child2 = element.getFirstChildElem();
            while (child2 != null) {
                this.processElement(child2, arrayList, systemId, doc);
                child2 = child2.getNextSiblingElem();
            }
            if (!(element.getEndLineNumber() == 0 || element instanceof ElemTextLiteral || element.getLineNumber() == element.getEndLineNumber() && element.getColumnNumber() == element.getEndColumnNumber())) {
                tl = new TemplateLocation(this, element, true, doc, null);
                arrayList.add(tl);
            }
            this.m_reverseTemplateCache[1].put(element, tl);
        }
    }

    /*
     * Unable to fully structure code
     */
    TemplateLocation getTemplateLocation(NodeLocation nodeLocation) {
        result = (TemplateLocation)this.m_templateCache.get(nodeLocation);
        if (result != null) {
            return result;
        }
        uri = nodeLocation.getURI();
        searchArrayList = this.getArrayFromURI(uri);
        if (searchArrayList == null && (absoluteURI = uri.getAbsouluteURI()) != null) {
            searchArrayList = this.getArrayFromURI(absoluteURI);
        }
        if (searchArrayList == null) {
            return null;
        }
        searchArray = searchArrayList.toArray(new TemplateLocation[0]);
        if (searchArray == null) {
            return null;
        }
        loc = this.binarySearch(nodeLocation, searchArray, 0, searchArray.length - 1);
        if (loc != -1) ** GOTO lbl18
        return null;
        while (searchArray[loc].getElement() instanceof ElemText) {
            ++loc;
lbl18:
            // 2 sources

            if (loc < searchArray.length) continue;
        }
        i = loc;
        while (i < searchArray.length) {
            if (!(searchArray[i].getElement() instanceof ElemText)) {
                if (searchArray[i].getNodeLocation().getLineNumber() != nodeLocation.getLineNumber() || searchArray[i].getNodeLocation().getURI() != nodeLocation.getURI()) break;
                if (!(searchArray[i].getElement() instanceof ElemTextLiteral)) {
                    loc = i;
                    break;
                }
            }
            ++i;
        }
        result = searchArray[loc];
        this.m_templateCache.put(nodeLocation, result);
        return result;
    }

    private int binarySearch(NodeLocation nodeLocation, TemplateLocation[] searchArray, int bot, int top) {
        if (bot == top) {
            return bot;
        }
        if (top < bot) {
            return -1;
        }
        int mid = (bot + top) / 2;
        if (nodeLocation.equals(searchArray[mid].getNodeLocation())) {
            return mid;
        }
        if (nodeLocation.isLT(searchArray[mid].getNodeLocation())) {
            return this.binarySearch(nodeLocation, searchArray, bot, mid);
        }
        return this.binarySearch(nodeLocation, searchArray, mid + 1, top);
    }

    TemplateLocation getTemplateLocation(ElemTemplateElement ete, int loc) {
        if (loc != 0 && loc != 1) {
            throw new IllegalArgumentException("Location must be START or END.");
        }
        return (TemplateLocation)this.m_reverseTemplateCache[loc].get(ete);
    }

    private ArrayList getArrayFromURI(CanonicalURI canonicalURI) {
        return (ArrayList)this.m_hashURItoTemplateArray.get(canonicalURI);
    }

    private char[] getEOLChars() {
        return s_eolChars;
    }

    private static int getStartingAngleBracket(char[] chars, int pos) {
        --pos;
        while (pos >= 0) {
            if (chars[pos] == '<') break;
            --pos;
        }
        return pos;
    }

    static /* synthetic */ Hashtable access$0(TemplateLocationManager templateLocationManager) {
        return templateLocationManager.m_previousLocation;
    }

    static /* synthetic */ char[] access$1(TemplateLocationManager templateLocationManager) {
        return templateLocationManager.getEOLChars();
    }

    static /* synthetic */ char[] access$2(TemplateLocationManager templateLocationManager) {
        return templateLocationManager.m_documentChars;
    }

    /*
     * Exception performing whole class analysis.
     */
    public final class TemplateLocation {
        private final NodeLocation nodeLocation;
        private final NodeLocation previousNodeLocation;
        private final ElemTemplateElement element;
        private final boolean isEnd;
        final /* synthetic */ TemplateLocationManager this$0;

        public TemplateLocation(TemplateLocationManager templateLocationManager) {
            this.this$0 = templateLocationManager;
            this.element = null;
            this.nodeLocation = new NodeLocation();
            this.previousNodeLocation = new NodeLocation();
            this.isEnd = false;
        }

        /*
         * Unable to fully structure code
         */
        private TemplateLocation(TemplateLocationManager var1_1, ElemTemplateElement ete, boolean isEnd, DebugDocument doc) {
            block23: {
                this.this$0 = var1_1;
                super();
                this.isEnd = isEnd;
                tempNode = new NodeLocation(ete, isEnd, doc);
                this.element = ete;
                uri = tempNode.getURI();
                tempPrevNode = nl = (NodeLocation)TemplateLocationManager.access$0(var1_1).get(uri);
                if (nl == null) {
                    tempPrevNode = new NodeLocation();
                }
                if (ete instanceof ElemTextLiteral && nl != null) {
                    etl = (ElemTextLiteral)ete;
                    charArray = etl.getChars();
                    eolChars = TemplateLocationManager.access$1(var1_1);
                    eolChars.length;
                    lineCnt = nl.getLineNumber();
                    charCnt = nl.getCharStart() + charArray.length;
                    i = 0;
                    while (i < charArray.length) {
                        if (i + eolChars.length - 1 < charArray.length) {
                            j = 0;
                            while (j < eolChars.length) {
                                if (charArray[i + j] == eolChars[j]) {
                                    ++j;
                                    continue;
                                }
                                ** break block21
                            }
                            ++lineCnt;
                            charCnt = charArray.length - ((i += eolChars.length - 1) + eolChars.length) + 1;
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (charArray[i] == '\n' || charArray[i] == '\r') {
                                ++lineCnt;
                                charCnt = charArray.length - i;
                            }
                        }
                        ++i;
                    }
                    absoluteCharLocation = -1;
                    if (lineCnt == 0) {
                        absoluteCharLocation = 1;
                    } else if (doc != null && (charsToEndOfPrevLine = doc.numCharsToEOL(lineCnt - 1)) != -1) {
                        absoluteCharLocation = charsToEndOfPrevLine + charCnt;
                    }
                    tempNode = new NodeLocation(tempNode.getURI(), lineCnt, charCnt, absoluteCharLocation, doc);
                } else if (doc != null && doc.numCharsToEOL(1) != -1) {
                    pos = tempNode.getAbsoluteCharStart();
                    if (1 < tempNode.getLineNumber()) {
                        --pos;
                        while (pos >= 0) {
                            if (TemplateLocationManager.access$2(var1_1)[pos] != '<') {
                                --pos;
                                continue;
                            }
                            break;
                        }
                    } else {
                        pos -= 2;
                        while (pos >= 0) {
                            if (TemplateLocationManager.access$2(var1_1)[pos] == '<') {
                                if (tempNode.getLineNumber() != 1) break;
                                ++pos;
                                break;
                            }
                            --pos;
                        }
                    }
                    lineCnt = tempNode.getLineNumber();
                    while (lineCnt >= 0) {
                        if (doc.numCharsToEOL(lineCnt) < pos) {
                            tempPrevNode = new NodeLocation(tempNode.getURI(), lineCnt + 1, pos - doc.numCharsToEOL(lineCnt), pos, doc);
                            break block23;
                        }
                        --lineCnt;
                    }
                    tempPrevNode = new NodeLocation(tempNode.getURI(), 1, 1, 1, doc);
                }
            }
            this.nodeLocation = tempNode;
            this.previousNodeLocation = tempPrevNode;
            TemplateLocationManager.access$0(var1_1).put(this.nodeLocation.getURI(), this.nodeLocation);
        }

        public String toString() {
            return String.valueOf(this.previousNodeLocation != null ? this.previousNodeLocation.toString() : "") + " " + this.nodeLocation.toString() + " " + this.element.toString();
        }

        NodeLocation getNodeLocation() {
            return this.nodeLocation;
        }

        ElemTemplateElement getElement() {
            return this.element;
        }

        NodeLocation getPreviousNodeLocation() {
            return this.previousNodeLocation;
        }

        private boolean isEnd() {
            return this.isEnd;
        }

        int getPosition() {
            if (this.isEnd) {
                return 1;
            }
            return 0;
        }

        /* synthetic */ TemplateLocation(TemplateLocationManager templateLocationManager, ElemTemplateElement elemTemplateElement, boolean bl, DebugDocument debugDocument, TemplateLocation templateLocation) {
            this(templateLocationManager, elemTemplateElement, bl, debugDocument);
        }
    }
}

