/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.transform.intrface.TransformationsManager;
import com.ibm.debug.xdi.DuplicateRequestException;
import com.ibm.debug.xdi.InvalidStateException;
import com.ibm.debug.xdi.OperationNotAvailableException;
import com.ibm.debug.xdi.XDIBreakpoint;
import com.ibm.debug.xdi.XDIEvent;
import com.ibm.debug.xdi.XDIEventListener;
import com.ibm.debug.xdi.XDILineBreakpoint;
import com.ibm.debug.xdi.XDITransform;
import com.ibm.debug.xdi.XDITransformManager;
import com.ibm.debug.xdi.impl.Constants;
import com.ibm.debug.xdi.impl.DebugPacket;
import com.ibm.debug.xdi.impl.ExitPointImpl;
import com.ibm.debug.xdi.impl.XDIDisconnectEventImpl;
import com.ibm.debug.xdi.impl.XDIJavaExtensionCallEventImpl;
import com.ibm.debug.xdi.impl.XDILineBreakpointImpl;
import com.ibm.debug.xdi.impl.XDITransformEventImpl;
import com.ibm.debug.xdi.impl.XDITransformImpl;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.FragmentingDataInputStream;
import com.ibm.debug.xdi.util.FragmentingDataOutputStream;
import com.ibm.debug.xdi.util.SocketListener;
import com.ibm.debug.xdi.util.SocketManager;
import com.ibm.debug.xdi.util.SocketWriter;
import com.ibm.debug.xslt.commpacket.PacketLineBreakPoint;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DebugEngineConnection
implements XDITransformManager,
TransformationsManager,
SocketManager {
    private boolean m_suspend = false;
    private Socket m_client = null;
    private FragmentingDataOutputStream m_out = null;
    private FragmentingDataInputStream m_in = null;
    private XDIEventListener m_eventListener = null;
    private volatile boolean m_disconnect = false;
    private String m_managerReplyData = null;
    private final int INTIAL_SIZE = 10;
    private ArrayList m_breakpoints = new ArrayList();
    private SocketWriter m_socketWriter = null;
    private SocketListener m_socketListener = null;
    private boolean m_entryExitMode = false;
    private boolean m_filterOutDefaultRuleStackframes = false;
    private boolean m_nodeStepping = false;
    private TransformerThreadInfo[] m_transformerThreads;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public DebugEngineConnection(Socket socket) {
        this.m_client = socket;
        if (this.m_client != null) {
            try {
                this.m_in = new FragmentingDataInputStream(this.m_client.getInputStream());
                this.m_out = new FragmentingDataOutputStream(this.m_client.getOutputStream());
            }
            catch (Exception e2) {
                String s = e2.toString();
                String msg = XDIMessage.getFormattedString("INTERNAL_EXCEPTION_STACK", s);
                XDIMessage.issueMessage(msg);
            }
        }
        this.m_transformerThreads = new TransformerThreadInfo[10];
        try {
            this.m_socketListener = new SocketListener(this, socket, 0);
            this.m_socketListener.setDaemonThread(true);
            this.m_socketListener.startThread();
            this.m_socketWriter = new SocketWriter(this, socket, 0);
            this.m_socketWriter.setDaemonThread(true);
            this.m_socketWriter.startThread();
        }
        catch (IOException iOException) {}
    }

    public void setEventListener(XDIEventListener eventListener) {
        this.m_eventListener = eventListener;
    }

    public XDITransform[] getTransforms() {
        ArrayList<XDITransformImpl> transforms = new ArrayList<XDITransformImpl>();
        int i = 0;
        while (i < this.m_transformerThreads.length) {
            if (this.m_transformerThreads[i] != null) {
                transforms.add(this.m_transformerThreads[i].getTransform());
            }
            ++i;
        }
        if (transforms.size() == 0) {
            return null;
        }
        return transforms.toArray(new XDITransform[transforms.size()]);
    }

    public XDILineBreakpoint createLineBreakpoint(XDILineBreakpoint crossEngineBreakpoint) {
        String fileName = crossEngineBreakpoint.getFileName();
        int lineNumber = crossEngineBreakpoint.getLineNumber();
        int charStart = crossEngineBreakpoint.getCharStart();
        int charEnd = crossEngineBreakpoint.getCharEnd();
        PacketLineBreakPoint packet = new PacketLineBreakPoint(fileName, lineNumber, charStart, charEnd, false);
        String data = packet.getData();
        this.sendRequest(-1, 14, data);
        XDILineBreakpointImpl breakpoint = new XDILineBreakpointImpl(this, crossEngineBreakpoint);
        this.m_breakpoints.add(breakpoint);
        return breakpoint;
    }

    public XDILineBreakpoint createLineBreakpoint(String fileName, int lineNumber, int charStart, int charEnd) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(DebugPacket debugPacket) {
        int transformerId = debugPacket.getTransformerId();
        int requestId = debugPacket.getRequestId();
        String[] data = debugPacket.getData();
        switch (requestId) {
            case -1: {
                return;
            }
        }
        if (transformerId == -1) {
            DebugEngineConnection debugEngineConnection = this;
            synchronized (debugEngineConnection) {
                this.m_managerReplyData = String.valueOf(requestId) + "," + data[0];
                this.notifyAll();
            }
        }
        XDITransformImpl xDITransformImpl = this.m_transformerThreads[transformerId].getTransform();
        synchronized (xDITransformImpl) {
            this.m_transformerThreads[transformerId].setReply(requestId, debugPacket);
            this.m_transformerThreads[transformerId].getTransform().notifyAll();
        }
    }

    public void requestReceived(DebugPacket debugPacket) {
        int transformerId = debugPacket.getTransformerId();
        int requestId = debugPacket.getRequestId();
        String[] data = debugPacket.getData();
        switch (requestId) {
            case -1: {
                return;
            }
            case 51: {
                try {
                    ArrayList<String> dataList = new ArrayList<String>();
                    ArrayList<XDITransformEventImpl> eventList = new ArrayList<XDITransformEventImpl>();
                    XDITransformImpl transform = null;
                    boolean terminate = false;
                    int i = 0;
                    while (i < data.length) {
                        dataList.add(data[i]);
                        ++i;
                    }
                    Iterator it = dataList.iterator();
                    int count = Integer.parseInt((String)it.next());
                    int i2 = 0;
                    while (i2 < count) {
                        int id = Integer.parseInt((String)it.next());
                        XDITransformEventImpl event2 = (XDITransformEventImpl)((Class)Constants.m_eventList.elementAt(id)).newInstance();
                        switch (id) {
                            case 0: {
                                transform = new XDITransformImpl(this, transformerId);
                                this.addTransformer(transform, transformerId);
                                break;
                            }
                            case 1: {
                                terminate = true;
                            }
                        }
                        if (this.m_transformerThreads.length <= transformerId || this.m_transformerThreads[transformerId] == null) {
                            transform = new XDITransformImpl(this, transformerId);
                            this.addTransformer(transform, transformerId);
                        }
                        transform = this.m_transformerThreads[transformerId].getTransform();
                        event2.setTransform(transform);
                        event2.setManager(this);
                        event2.updateEvent(it);
                        switch (id) {
                            case 7: {
                                transform.setExitPoints(new ExitPointImpl[]{new ExitPointImpl(((XDIJavaExtensionCallEventImpl)event2).getJavaMethod(), true)});
                            }
                        }
                        eventList.add(event2);
                        ++i2;
                    }
                    transform = this.m_transformerThreads[transformerId].getTransform();
                    transform.getDocumentManager().updateList(it);
                    if (terminate) {
                        this.sendReply(transformerId, 1, null);
                        transform.setIsTerminated();
                        this.removeTransformer(transformerId);
                        this.disconnect();
                    }
                    if (this.m_eventListener == null) break;
                    this.m_eventListener.eventNotify(eventList.toArray(new XDIEvent[eventList.size()]));
                }
                catch (NumberFormatException numberFormatException) {
                    String msg = XDIMessage.getFormattedString("INTERNAL_BAD_MESSAGE_FORMAT", data[0]);
                    XDIMessage.issueMessage(msg);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String msg = XDIMessage.getFormattedString("INTERNAL_BAD_MESSAGE_FORMAT", data[0]);
                    XDIMessage.issueMessage(msg);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                break;
            }
            case 58: {
                boolean disconnectDueToError = "1".equals(data[0]);
                String disconnectMessage = data[1];
                new XDIDisconnectEventImpl(disconnectDueToError, disconnectMessage);
                this.cleanup();
                break;
            }
            default: {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        this.sendRequest(-1, 11, null);
        DebugEngineConnection debugEngineConnection = this;
        synchronized (debugEngineConnection) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        StringTokenizer tokenizer = new StringTokenizer(this.m_managerReplyData, ",");
        try {
            if (tokenizer.nextToken().equals(String.valueOf(11))) {
                return tokenizer.nextToken().equals("1");
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void resume() {
        this.sendRequest(-1, 12, null);
    }

    public void sendRequest(int transformerId, int requestType, String data) {
        DebugPacket packet = new DebugPacket(transformerId, 100, requestType, new String[]{data});
        this.m_socketWriter.send(packet);
    }

    public void sendReply(int transformerId, int requestId, String data) {
        DebugPacket packet = new DebugPacket(transformerId, 101, requestId, new String[]{data});
        this.m_socketWriter.send(packet);
    }

    private void addTransformer(XDITransformImpl transformer, int pos) {
        if (pos < this.m_transformerThreads.length) {
            TransformerThreadInfo transformerThread;
            this.m_transformerThreads[pos] = transformerThread = new TransformerThreadInfo(transformer);
        } else {
            TransformerThreadInfo transformerThread;
            int length = this.m_transformerThreads.length;
            TransformerThreadInfo[] tempArray = new TransformerThreadInfo[length * 2];
            System.arraycopy(this.m_transformerThreads, 0, tempArray, 0, length);
            this.m_transformerThreads = tempArray;
            this.m_transformerThreads[pos] = transformerThread = new TransformerThreadInfo(transformer);
        }
    }

    private void removeTransformer(int transformerId) throws IllegalArgumentException {
        if (transformerId >= this.m_transformerThreads.length) {
            throw new IllegalArgumentException("XDITransformManagerImpl.removeTransformer: Position does not correspond to XDITransformObject in array.");
        }
        this.m_transformerThreads[transformerId] = null;
    }

    protected DebugPacket getReply(int uniqueId, int requestId) {
        return this.m_transformerThreads[uniqueId].getReply(requestId);
    }

    protected boolean hasReply(int uniqueId, int requestId) {
        return this.m_transformerThreads[uniqueId].hasReply(requestId);
    }

    public void deleteBreakpoint(XDIBreakpoint breakpoint) {
        int i = 0;
        while (i < this.m_breakpoints.size()) {
            if (this.m_breakpoints.get(i) == breakpoint) {
                XDILineBreakpoint lineBreak = (XDILineBreakpoint)breakpoint;
                PacketLineBreakPoint packet = new PacketLineBreakPoint(lineBreak.getFileName(), lineBreak.getLineNumber(), lineBreak.getCharStart(), lineBreak.getCharEnd(), false);
                String data = packet.getData();
                this.sendRequest(-1, 15, data);
                this.m_breakpoints.remove(i);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("XDITransformerManager.deleteBreakpoint: breakpoint not in table");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.sendRequest(-1, 13, null);
        DebugEngineConnection debugEngineConnection = this;
        synchronized (debugEngineConnection) {
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {}
            this.cleanup();
        }
    }

    public void setupIsComplete() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        this.sendRequest(-1, 70, null);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void terminateAndDisconnect() {
        this.sendRequest(-1, 20, null);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        this.cleanup();
    }

    public void setEntryExitMode(boolean enable) {
        if (this.m_entryExitMode != enable) {
            this.sendRequest(-1, 18, enable ? "1" : "0");
            this.m_entryExitMode = enable;
        }
    }

    public void listenExceptionReceived(Exception e2) {
        this.m_disconnect = true;
        String[] data = new String[]{"0", XDIMessage.getFormattedString("NORMAL_DISCONNECT")};
        DebugPacket debugPacket = new DebugPacket(-1, 100, 58, data);
        if (!(e2 instanceof EOFException)) {
            this.requestReceived(debugPacket);
        }
    }

    public void writeExceptionReceived(Exception e2) {
    }

    public ArrayList getBreakpoints() {
        return this.m_breakpoints;
    }

    public void setFilterBuiltinRules(boolean filterOut) {
        if (this.m_filterOutDefaultRuleStackframes != filterOut) {
            this.sendRequest(-1, 17, filterOut ? "1" : "0");
            this.m_filterOutDefaultRuleStackframes = filterOut;
        }
    }

    public void setNodeStepping(boolean nodeStepping) {
        if (this.m_nodeStepping != nodeStepping) {
            this.sendRequest(-1, 22, nodeStepping ? "1" : "0");
            this.m_nodeStepping = nodeStepping;
        }
    }

    private void cleanup() {
        if (this.m_socketWriter.isAliveThread()) {
            this.m_socketWriter.stopThread();
        }
        if (this.m_socketListener.isAliveThread()) {
            this.m_socketListener.stopThread();
        }
    }

    public void disconnect(int transformerID) throws InvalidStateException {
        XDITransform tran = this.getXDITransform(transformerID);
        tran.disconnect();
    }

    void disconnectImmediate(int transformerID) {
        this.sendRequest(transformerID, 58, null);
    }

    private XDITransform getXDITransform(int transformID) {
        return this.m_transformerThreads[transformID].m_transform;
    }

    public void terminate(int transformerID) throws InvalidStateException {
        XDITransform tran = this.getXDITransform(transformerID);
        tran.terminate();
    }

    public void setEnabled(XDILineBreakpoint lineBP, boolean enable) {
        if (lineBP.isEnabled() != enable) {
            PacketLineBreakPoint packet = new PacketLineBreakPoint(lineBP.getFileName(), lineBP.getLineNumber(), lineBP.getCharStart(), lineBP.getCharEnd(), enable);
            String data1 = packet.getData();
            this.sendRequest(-1, 16, data1);
        }
    }

    public boolean isNodeStepping() {
        return this.m_nodeStepping;
    }

    public void resume(int transformerID) throws InvalidStateException {
        XDITransform t = this.getXDITransform(transformerID);
        t.resume();
    }

    public void suspend(int transformerID, boolean immediate) throws InvalidStateException, OperationNotAvailableException {
        XDITransform t = this.getXDITransform(transformerID);
        t.suspend(immediate);
    }

    public void setStepRequest(int transformerID, int type) throws InvalidStateException, DuplicateRequestException {
        XDITransform t = this.getXDITransform(transformerID);
        t.setStepRequest(type);
    }

    public void clearStepRequest(int transformerID) throws InvalidStateException {
        XDITransform t = this.getXDITransform(transformerID);
        t.clearStepRequest();
    }

    public boolean isSuspended(int transformerID) throws InvalidStateException {
        XDITransform t = this.getXDITransform(transformerID);
        boolean isTranSuspended = t.isSuspended();
        return isTranSuspended;
    }

    public String getJavaThreadName(int transformerID) throws InvalidStateException {
        XDITransform t = this.getXDITransform(transformerID);
        String name2 = t.getJavaThreadName();
        return name2;
    }

    public String getJavaThreadGroupName(int transformerID) throws InvalidStateException {
        XDITransform t = this.getXDITransform(transformerID);
        String name2 = t.getJavaThreadGroupName();
        return name2;
    }

    public String getEvaluationThreadGroupName(int transformerID) throws InvalidStateException {
        return null;
    }

    public String getEvaluationThreadName(int transformerID) throws InvalidStateException {
        return null;
    }

    public String getStylesheetURIName(int transformerID) throws InvalidStateException {
        XDITransform t = this.getXDITransform(transformerID);
        String name2 = t.getStylesheetURIName();
        return name2;
    }

    public String getName(int transformerID) throws InvalidStateException {
        XDITransform t = this.getXDITransform(transformerID);
        String processorName = t.getName();
        return processorName;
    }

    public void setExtensionElementMode(int transformerID, boolean enable) {
        XDITransform t = this.getXDITransform(transformerID);
        t.setExtensionElementMode(enable);
    }

    public boolean isInExtensionElement(int transformerID) {
        XDITransform t = this.getXDITransform(transformerID);
        boolean inCallout = t.isInExtensionElement();
        return inCallout;
    }

    public boolean getCalloutMode(int transformerID) {
        return false;
    }

    public void threadRunHasEnded() {
    }

    public void addDebugEngineConnection(Socket socket) {
    }

    protected class TransformerThreadInfo {
        private XDITransformImpl m_transform = null;
        private Hashtable m_replyTable;

        public TransformerThreadInfo(XDITransformImpl transform) {
            this.m_transform = transform;
            this.m_replyTable = new Hashtable();
        }

        private synchronized void setReply(int requestId, DebugPacket reply) {
            this.m_replyTable.put(new Integer(requestId), reply);
        }

        private synchronized DebugPacket getReply(int requestId) {
            Integer inted = new Integer(requestId);
            DebugPacket ret = (DebugPacket)this.m_replyTable.get(inted);
            if (ret != null) {
                this.m_replyTable.remove(inted);
            }
            return ret;
        }

        private synchronized boolean hasReply(int requestId) {
            return this.m_replyTable.containsKey(new Integer(requestId));
        }

        private XDITransformImpl getTransform() {
            return this.m_transform;
        }
    }
}

