/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.impl.Constants;
import com.ibm.debug.xdi.util.FragmentingDataInputStream;
import com.ibm.debug.xdi.util.FragmentingDataOutputStream;
import java.io.IOException;

public class DebugPacket {
    private int m_transformerId;
    private int m_messageType;
    private int m_requestId;
    private String[] m_data;
    public static int m_dbg_count;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public DebugPacket(int transformerId, int messageType, int requestId, String[] data) {
        this.m_transformerId = transformerId;
        this.m_messageType = messageType;
        this.m_requestId = requestId;
        if (data == null) {
            data = new String[1];
        }
        this.m_data = data;
    }

    public int getTransformerId() {
        return this.m_transformerId;
    }

    public int getMessageType() {
        return this.m_messageType;
    }

    public int getRequestId() {
        return this.m_requestId;
    }

    public String[] getData() {
        return this.m_data;
    }

    public synchronized String toDbgString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n------ count: " + ++m_dbg_count + " -----");
        sb.append("\n    packet hash: " + Integer.toHexString(this.hashCode()));
        sb.append("\n    transformerID: ").append(this.m_transformerId);
        sb.append("\n    messageType  : ").append(Constants.toDbgString(this.m_messageType));
        sb.append("\n    requestType  : ").append(Constants.toDbgString(this.m_requestId));
        if (this.m_data != null) {
            int chars = 0;
            int i = 0;
            while (i < this.m_data.length) {
                if (this.m_data[i] != null) {
                    chars += this.m_data[i].length();
                }
                ++i;
            }
            sb.append("\n    (total chars " + chars + ") ");
            if (chars < 4000) {
                i = 0;
                while (i < this.m_data.length) {
                    sb.append("\n    data[" + i + "] = \"" + this.m_data[i] + "\"");
                    ++i;
                }
            } else {
                sb.append("\n    TO BIG, NOT DISPLAYING");
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public String toString() {
        String ret = this.toDbgString();
        return ret;
    }

    private int debugPacketHeaderRead(FragmentingDataInputStream dis, byte[] header2) throws IOException {
        dis.read(header2, 0, 8);
        this.m_transformerId = header2[0] << 8 | header2[1] & 0xFF;
        this.m_messageType = header2[2] << 8 | header2[3] & 0xFF;
        this.m_requestId = header2[4] << 8 | header2[5] & 0xFF;
        int size = header2[6] << 8 | header2[7] & 0xFF;
        return size;
    }

    private int debugPacketHeaderWrite(FragmentingDataOutputStream fdo, byte[] header2) throws IOException {
        int size = this.m_data != null ? this.m_data.length : 0;
        header2[0] = (byte)(this.m_transformerId >> 8);
        header2[1] = (byte)(this.m_transformerId & 0xFF);
        header2[2] = (byte)(this.m_messageType >> 8);
        header2[3] = (byte)(this.m_messageType & 0xFF);
        header2[4] = (byte)(this.m_requestId >> 8);
        header2[5] = (byte)(this.m_requestId & 0xFF);
        header2[6] = (byte)(size >> 8);
        header2[7] = (byte)(size & 0xFF);
        fdo.write(header2, 0, 8);
        return size;
    }

    private DebugPacket() {
    }

    public static DebugPacket debugPacketRead(FragmentingDataInputStream inStream, byte[] header2) throws IOException {
        DebugPacket packet = new DebugPacket();
        int numberOfStrings = packet.debugPacketHeaderRead(inStream, header2);
        String[] data = new String[numberOfStrings];
        if (numberOfStrings > 0) {
            packet.debugPacketDataRead(inStream, numberOfStrings, data);
        }
        packet.m_data = data;
        return packet;
    }

    public void debugPacketWrite(FragmentingDataOutputStream out, byte[] header2) throws IOException {
        int size = this.debugPacketHeaderWrite(out, header2);
        if (size > 0) {
            this.debugPacketDataWrite(out, size, this.m_data);
        }
    }

    private void debugPacketDataWrite(FragmentingDataOutputStream fdo, int size, String[] data) throws IOException {
        int i = 0;
        while (i < size) {
            if (data[i] != null) {
                fdo.writeLongUTF(data[i]);
            } else {
                fdo.writeLongUTF("");
            }
            ++i;
        }
    }

    private void debugPacketDataRead(FragmentingDataInputStream dis, int size, String[] data) throws IOException {
        int i = 0;
        while (i < size) {
            data[i] = dis.readLongUTF();
            ++i;
        }
    }
}

