/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.messages.XDIMessage;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.URI;
import org.apache.xml.utils.WrappedRuntimeException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class InvokeTransformation {
    private static final String IN_ARG = "-IN";
    private static final String XSL_ARG = "-XSL";
    private static final String OUT_ARG = "-OUT";
    private static final String PARAM_ARG = "-PARAM";
    private static final String XML_ARG = "-XML";
    private static final String HTML_ARG = "-HTML";
    private static final String TEXT_ARG = "-TEXT";
    private static final String VERSION_ARG = "-VERSION";
    private static final String ENCODING_ARG = "-ENCODING";
    private static final String INDENT_ARG = "-INDENT";
    private static final String RECURSION_LIMIT_ARG = "-RECURSION_LIMIT";
    private static final String CONTEXT_ARG = "-CONTEXT";
    private static final String OUTPUT_XML = "xml";
    private static final String OUTPUT_HTML = "html";
    private static final String OUTPUT_TEXT = "text";
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public static void main(String[] args) {
        new InvokeTransformation().run(args);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void run(String[] args) {
        block39: {
            inputFilename = null;
            xslFilename = null;
            resultFilename = null;
            parameterNames = new Vector<String>();
            parameterValues = new Vector<String>();
            outputMethod = null;
            version = null;
            encoding = null;
            indent = null;
            recursionLimit = -1;
            context = null;
            i = 0;
            while (i < args.length) {
                if ((arg = args[i++]).equals("-IN")) {
                    if (args.length <= i) {
                        throw new IllegalArgumentException();
                    }
                    if ((inputFilename = args[i++]).charAt(1) != ':' || inputFilename.charAt(2) != '\\') continue;
                    inputFilename = "file:///" + inputFilename;
                    continue;
                }
                if (arg.equals("-XSL")) {
                    if (args.length <= i) {
                        throw new IllegalArgumentException();
                    }
                    if ((xslFilename = args[i++]).charAt(1) != ':' || xslFilename.charAt(2) != '\\') continue;
                    xslFilename = "file:///" + xslFilename;
                    continue;
                }
                if (arg.equals("-OUT")) {
                    if (args.length <= i) {
                        throw new IllegalArgumentException();
                    }
                    resultFilename = args[i++];
                    continue;
                }
                if (arg.equals("-PARAM")) {
                    if (args.length <= i + 1) {
                        throw new IllegalArgumentException();
                    }
                    parameterNames.add(args[i++]);
                    parameterValues.add(args[i++]);
                    continue;
                }
                if (arg.equals("-XML")) {
                    outputMethod = "xml";
                    continue;
                }
                if (arg.equals("-HTML")) {
                    outputMethod = "html";
                    continue;
                }
                if (arg.equals("-TEXT")) {
                    outputMethod = "text";
                    continue;
                }
                if (arg.equals("-VERSION")) {
                    if (args.length <= i) {
                        throw new IllegalArgumentException();
                    }
                    version = args[i++];
                    continue;
                }
                if (arg.equals("-ENCODING")) {
                    if (args.length <= i) {
                        throw new IllegalArgumentException();
                    }
                    encoding = args[i++];
                    continue;
                }
                if (arg.equals("-INDENT")) {
                    if (args.length <= i) {
                        throw new IllegalArgumentException();
                    }
                    indent = args[i++];
                    continue;
                }
                if (arg.equals("-RECURSION_LIMIT")) {
                    if (args.length <= i) {
                        throw new IllegalArgumentException();
                    }
                    limit = args[i++];
                    try {
                        recursionLimit = Integer.parseInt(limit);
                    }
                    catch (NumberFormatException v0) {
                        recursionLimit = -1;
                    }
                    continue;
                }
                if (!arg.equals("-CONTEXT")) continue;
                if (args.length <= i) {
                    throw new IllegalArgumentException();
                }
                context = args[i++];
            }
            if (inputFilename == null) {
                throw new IllegalArgumentException();
            }
            try {
                tf = TransformerFactory.newInstance();
                if (context != null) {
                    resolver = new XMLResolver(context);
                    tf.setURIResolver(resolver);
                }
                source /* !! */  = null;
                source /* !! */  = xslFilename != null ? new StreamSource(xslFilename) : tf.getAssociatedStylesheet(new StreamSource(inputFilename), null, null, null);
                transformer = tf.newTransformer(source /* !! */ );
                i = 0;
                while (i < parameterNames.size()) {
                    transformer.setParameter((String)parameterNames.elementAt(i), (String)parameterValues.elementAt(i));
                    ++i;
                }
                if (outputMethod != null) {
                    transformer.setOutputProperty("method", outputMethod);
                }
                if (version != null) {
                    transformer.setOutputProperty("version", version);
                }
                if (encoding != null) {
                    transformer.setOutputProperty("encoding", encoding);
                }
                if (indent != null) {
                    transformer.setOutputProperty("indent", indent);
                }
                if (recursionLimit != -1 && transformer instanceof TransformerImpl) {
                    ((TransformerImpl)transformer).setRecursionLimit(recursionLimit);
                }
                if (context != null) {
                    resolver = new XMLResolver(context);
                    transformer.setURIResolver(resolver);
                }
                if (resultFilename != null) {
                    transformer.transform(new StreamSource(inputFilename), new StreamResult(resultFilename));
                } else {
                    transformer.transform(new StreamSource(inputFilename), new StreamResult(System.out));
                }
                break block39;
            }
            catch (Exception e) {
                ** while (e instanceof WrappedRuntimeException)
            }
lbl-1000:
            // 1 sources

            {
                e = ((WrappedRuntimeException)e).getException();
                continue;
            }
lbl115:
            // 1 sources

            errorWriter = new PrintWriter(System.err, true);
            if (e instanceof NullPointerException || e instanceof ClassCastException) {
                e.printStackTrace(errorWriter);
            } else {
                DefaultErrorHandler.printLocation((PrintWriter)errorWriter, (Throwable)e);
                errorWriter.println(e.getMessage());
            }
        }
    }

    public class XMLResolver
    implements URIResolver {
        private String uriContext;
        private Hashtable referencedFiles = new Hashtable();

        public XMLResolver(String context) {
            this.uriContext = context;
        }

        public Source resolve(String href, String base) throws TransformerException {
            String includedFilename = null;
            try {
                if (this.uriContext != null && !this.uriContext.equals("")) {
                    base = this.uriContext;
                    includedFilename = String.valueOf(base) + href;
                } else {
                    URI baseURI = this.createURI(base);
                    URI hrefURI = new URI(baseURI, href);
                    includedFilename = hrefURI.toString();
                }
                DOMParser parser = new DOMParser();
                parser.parse(new InputSource(includedFilename));
                Document xmlDOM = parser.getDocument();
                includedFilename = this.normalizeFilename(includedFilename);
                this.referencedFiles.put(includedFilename, xmlDOM);
                return new DOMSource(xmlDOM);
            }
            catch (URI.MalformedURIException malformedURIException) {
                String msg = XDIMessage.getFormattedString("ER_RESOLVE_HREF", href);
                throw new TransformerException(msg);
            }
            catch (Exception exception) {
                String msg = XDIMessage.getFormattedString("ER_RESOLVE_URI", includedFilename);
                throw new TransformerException(msg);
            }
        }

        public String normalizeFilename(String filename) {
            if (filename.startsWith("file:/")) {
                int i = 5;
                while (i < filename.length()) {
                    if (filename.charAt(i) != '/') break;
                    ++i;
                }
                filename = filename.substring(i, filename.length());
            }
            return filename;
        }

        private URI createURI(String str) {
            try {
                URI uri = new URI(str);
                return uri;
            }
            catch (URI.MalformedURIException malformedURIException) {
                return null;
            }
        }
    }
}

