/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.XDIBreakpoint;
import com.ibm.debug.xdi.XDIBreakpointEvent;
import com.ibm.debug.xdi.XDILineBreakpoint;
import com.ibm.debug.xdi.XDITransform;
import com.ibm.debug.xdi.impl.XDILineBreakpointImpl;
import com.ibm.debug.xdi.impl.XDISuspendEventImpl;
import com.ibm.debug.xdi.util.CanonicalURI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class XDIBreakpointEventImpl
extends XDISuspendEventImpl
implements XDIBreakpointEvent {
    private XDIBreakpoint m_breakpoint = null;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public XDIBreakpointEventImpl(XDITransform transform) {
        this(transform, null);
    }

    public XDIBreakpointEventImpl() {
    }

    public XDIBreakpointEventImpl(XDITransform transform, XDIBreakpoint breakpoint) {
        super(transform);
        this.m_breakpoint = breakpoint;
    }

    public XDIBreakpoint getBreakpoint() {
        XDILineBreakpoint lbp;
        XDIBreakpoint bp = this.m_breakpoint instanceof XDILineBreakpointImpl ? ((lbp = ((XDILineBreakpointImpl)this.m_breakpoint).getCrossEngineBreakpoint()) != null ? lbp : this.m_breakpoint) : this.m_breakpoint;
        return bp;
    }

    public int getEventId() {
        return 2;
    }

    public ArrayList getUpdateList() {
        ArrayList ar = super.getUpdateList();
        ar.add(this.m_breakpoint.toString());
        return ar;
    }

    public void updateEvent(Iterator it) {
        StringTokenizer dataTokenizer = new StringTokenizer((String)it.next(), ",");
        String fileName = dataTokenizer.nextToken();
        CanonicalURI uri = CanonicalURI.getInstance(fileName);
        int lineNumber = Integer.parseInt(dataTokenizer.nextToken());
        int charStart = Integer.parseInt(dataTokenizer.nextToken());
        int charEnd = Integer.parseInt(dataTokenizer.nextToken());
        Iterator iter = this.m_manager.getBreakpoints().iterator();
        while (iter.hasNext()) {
            XDILineBreakpointImpl newBreakpoint = (XDILineBreakpointImpl)iter.next();
            if (!newBreakpoint.isEqualTo(uri, lineNumber, charStart, charEnd)) continue;
            this.m_breakpoint = newBreakpoint;
            break;
        }
    }
}

