/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.XDIDocument;
import com.ibm.debug.xdi.impl.DebugPacket;
import com.ibm.debug.xdi.impl.XDITransformImpl;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.CanonicalURI;

public class XDIDocumentImpl
implements XDIDocument {
    public static final int UNDEFINED = -1;
    private final String m_uriName;
    final int m_uniqueId;
    private String m_generatedFileContents = null;
    final XDITransformImpl m_transformer;
    private final boolean m_generated;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public XDIDocumentImpl(String uriName, int id, boolean isGenerated, XDITransformImpl transformer) {
        this.m_uniqueId = id;
        this.m_uriName = uriName != null ? (uriName = CanonicalURI.getCanonicalURI(uriName)) : "null";
        if (!isGenerated && uriName != null && this.m_uriName != null && this.m_uriName.startsWith("generated:")) {
            isGenerated = true;
        }
        this.m_generated = isGenerated;
        this.m_transformer = transformer;
    }

    public String getURIName() {
        if (this.m_uniqueId == -1) {
            return null;
        }
        return this.m_uriName;
    }

    public int getUniqueId() {
        return this.m_uniqueId;
    }

    public boolean isGenerated() {
        return this.m_generated;
    }

    public String generatedFile() {
        if (this.m_generated && this.m_transformer != null && this.m_generatedFileContents == null) {
            DebugPacket debugPacket;
            this.m_transformer.getManager().sendRequest((short)this.m_transformer.getUniqueEngineId(), 21, String.valueOf(this.m_uniqueId));
            try {
                debugPacket = this.m_transformer.waitForReply(21);
            }
            catch (InterruptedException interruptedException) {
                String msg = XDIMessage.getFormattedString("ER_INTERRUPTED_GENEERATING_FILE");
                XDIMessage.issueMessage(msg);
                return msg;
            }
            String[] reply = debugPacket.getData();
            this.m_generatedFileContents = reply[0];
        }
        return this.m_generatedFileContents;
    }
}

