/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.transform.intrface.AdapterResultDocument;
import com.ibm.debug.xdi.XDIDocument;
import com.ibm.debug.xdi.XDIResultDocument;
import com.ibm.debug.xdi.impl.XDIDocumentImpl;
import com.ibm.debug.xdi.impl.XDIResultDocumentImpl;
import com.ibm.debug.xdi.impl.XDITransformImpl;
import com.ibm.debug.xdi.util.CanonicalURI;
import com.ibm.debug.xslt.commpacket.PacketResultDocUpdate;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class XDIDocumentManager {
    private static final int XDI_DOCUMENT = 0;
    private static final int XDI_RESULT_DOCUMENT = 1;
    private Hashtable m_ID2Doc = new Hashtable();
    private XDITransformImpl m_transformer;
    private Hashtable[] m_hashToDoc = new Hashtable[]{new Hashtable(), new Hashtable()};
    private int m_mostRecentlyUpdatedOutputDoc = 0;
    public static final String GENERATED_PREFIX = "generated:";
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    private void setMostRecentlyUpdatedOutputDoc(int uniqueOutputDocID) {
        this.m_mostRecentlyUpdatedOutputDoc = uniqueOutputDocID;
    }

    private void registerDocument(XDIDocument doc) {
        int uniqueId = doc.getUniqueId();
        int type = doc instanceof XDIResultDocument ? 1 : 0;
        String uri = uniqueId == -1 ? "null" : doc.getURIName();
        uri = CanonicalURI.getCanonicalURI(uri);
        this.m_hashToDoc[type].put(uri, doc);
        this.m_ID2Doc.put(new Integer(uniqueId), doc);
    }

    private AdapterResultDocument newResultHandle(String uri, int uniqueId) {
        if (uri == null) {
            uri = "";
        }
        XDIResultDocumentImpl result = new XDIResultDocumentImpl(uri, uniqueId, this.m_transformer);
        this.registerDocument(result);
        return result;
    }

    private XDIDocument getDocument(String uri, boolean isOutputURI) {
        XDIDocument ret = null;
        if (uri == null) {
            uri = "";
        }
        if (this.m_hashToDoc[isOutputURI ? 1 : 0].containsKey(uri = CanonicalURI.getCanonicalURI(uri))) {
            ret = (XDIDocument)this.m_hashToDoc[isOutputURI ? 1 : 0].get(uri);
        }
        return ret;
    }

    private AdapterResultDocument getResultDocument(String uri) {
        return (AdapterResultDocument)this.getDocument(uri, true);
    }

    private AdapterResultDocument getResultHandle(String docURI, int docID) {
        if (docURI.equals("#")) {
            return null;
        }
        AdapterResultDocument doc = this.getResultDocument(docURI);
        if (doc == null) {
            doc = this.newResultHandle(docURI, docID);
        }
        return doc;
    }

    private XDIDocument getDocument(int uniqueId) {
        Integer key = new Integer(uniqueId);
        XDIDocument ret = null;
        if (this.m_ID2Doc.containsKey(key)) {
            ret = (XDIDocument)this.m_ID2Doc.get(key);
        }
        return ret;
    }

    private XDIDocument getDocument(String uri) {
        return this.getDocument(uri, false);
    }

    private XDIDocument newHandle(String uri, int uniqueId, boolean generated) {
        if (uri == null) {
            uri = "";
        }
        XDIDocumentImpl result = new XDIDocumentImpl(uri, uniqueId, generated, this.m_transformer);
        this.registerDocument(result);
        return result;
    }

    XDIDocumentManager(XDITransformImpl transformer) {
        this.m_transformer = transformer;
    }

    XDIDocument getHandle(StringTokenizer replyFrame) {
        String docURI = replyFrame.nextToken();
        if (docURI.equals("#")) {
            return null;
        }
        int docID = Integer.parseInt(replyFrame.nextToken());
        int generated = Integer.parseInt(replyFrame.nextToken());
        XDIDocument doc = this.getDocument(docURI);
        if (doc == null) {
            doc = this.newHandle(docURI, docID, generated > 0);
        }
        return doc;
    }

    XDIResultDocument[] getResultDocuments() {
        Collection values = this.m_hashToDoc[1].values();
        return values.toArray(new XDIResultDocument[values.size()]);
    }

    XDIResultDocument getCurrentResultDocument() {
        XDIResultDocument resDoc = (XDIResultDocument)this.getDocument(this.m_mostRecentlyUpdatedOutputDoc);
        return resDoc;
    }

    void updateList(Iterator it) {
        String[] str = new String[3];
        int i = 0;
        while (i < 3) {
            if (!it.hasNext()) {
                return;
            }
            str[i] = (String)it.next();
            ++i;
        }
        PacketResultDocUpdate pData = new PacketResultDocUpdate(str[0]);
        AdapterResultDocument doc = this.getResultHandle(pData.getDocURI(), pData.getUniqueDocId());
        if (pData.getIsMostRecentlyUpdated()) {
            this.setMostRecentlyUpdatedOutputDoc(doc.getUniqueId());
        }
        doc.appendToUpdateBuffer(str[1]);
        doc.setTempUpdate(str[2]);
        doc.setOutputMethod(pData.getOutputMethod());
        this.updateList(it);
    }
}

