/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.XDILineBreakpoint;
import com.ibm.debug.xdi.impl.DebugEngineConnection;
import com.ibm.debug.xdi.util.CanonicalURI;

public class XDILineBreakpointImpl
implements XDILineBreakpoint {
    private CanonicalURI m_uri = null;
    private int m_lineNumber = -1;
    private int m_charStart = -1;
    private int m_charEnd = -1;
    private DebugEngineConnection m_engine = null;
    private final XDILineBreakpoint m_crossEngineBreakpoint;
    private boolean m_enabled = true;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public XDILineBreakpointImpl(DebugEngineConnection engine2, XDILineBreakpoint crossEngineBreakpoint) {
        String fileName = crossEngineBreakpoint.getFileName();
        int lineNumber = crossEngineBreakpoint.getLineNumber();
        int charStart = crossEngineBreakpoint.getCharStart();
        int charEnd = crossEngineBreakpoint.getCharEnd();
        this.m_crossEngineBreakpoint = crossEngineBreakpoint;
        this.m_engine = engine2;
        this.m_uri = CanonicalURI.getInstance(fileName);
        this.m_lineNumber = lineNumber;
        this.m_charStart = charStart;
        this.m_charEnd = charEnd;
    }

    public void setEnabled(boolean enable) {
        this.m_engine.setEnabled(this, enable);
        this.m_enabled = enable;
    }

    public int getCharEnd() {
        return this.m_charEnd;
    }

    public int getCharStart() {
        return this.m_charStart;
    }

    public String getFileName() {
        return this.m_uri.getURIString();
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    protected boolean isEqualTo(CanonicalURI fileName, int lineNumber, int charStart, int charEnd) {
        return this.m_uri == fileName && this.m_lineNumber == lineNumber;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isInstalled() {
        return false;
    }

    public DebugEngineConnection getDebugEngineConnection() {
        return this.m_engine;
    }

    public XDILineBreakpoint getCrossEngineBreakpoint() {
        return this.m_crossEngineBreakpoint;
    }
}

