/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.XDIListeningConnector;
import com.ibm.debug.xdi.XDITransformManager;
import com.ibm.debug.xdi.impl.XDITransformManagerImpl;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.SocketUtil;
import com.ibm.debug.xdi.util.ThreadInterface;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class XDIListeningConnectorImpl
implements XDIListeningConnector {
    private ServerSocket m_serverSocket;
    private int m_serverSocketPort;
    private volatile boolean m_keepListeningForConnections = true;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public String startListening() throws IOException {
        int port2;
        if (this.m_serverSocket == null) {
            port2 = SocketUtil.findUnusedLocalPort();
            if (port2 <= 0) {
                String msg = XDIMessage.getFormattedString("ER_SERVER_SOCKET_PORT");
                XDIMessage.issueMessage(msg);
                throw new RuntimeException(msg);
            }
            this.initServer(port2, 4, 1000);
        } else {
            port2 = this.m_serverSocket.getLocalPort();
        }
        return String.valueOf(port2);
    }

    public String startListening(int port2) throws IOException {
        if (this.m_serverSocket == null) {
            if (port2 <= 0) {
                String msg = XDIMessage.getFormattedString("ER_SERVER_SOCKET_PORT");
                XDIMessage.issueMessage(msg);
                throw new RuntimeException(msg);
            }
            this.initServer(port2, 4, 1000);
        } else {
            port2 = this.m_serverSocket.getLocalPort();
        }
        return String.valueOf(port2);
    }

    private synchronized void initServer(int portNumber, int connectAttempts, int sleepInterval) throws IOException {
        boolean connected = false;
        int attempts = 0;
        while (!connected) {
            try {
                this.m_serverSocketPort = portNumber;
                this.m_serverSocket = new ServerSocket(portNumber);
                connected = true;
            }
            catch (IOException excp) {
                if (++attempts == connectAttempts) {
                    throw excp;
                }
                try {
                    Thread.sleep(sleepInterval, 0);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stopListening() throws IOException {
        if (this.m_serverSocket != null) {
            this.m_serverSocket.close();
            this.m_serverSocket = null;
        }
    }

    public XDITransformManager accept() throws IOException {
        Socket socket = this.waitForConnection();
        XDITransformManagerImpl mgr = new XDITransformManagerImpl(socket);
        KeepListeningForConnections listener = new KeepListeningForConnections(mgr);
        if (this.m_serverSocket != null) {
            listener.startThread();
        }
        return mgr;
    }

    private Socket waitForConnection() throws IOException {
        Socket socket = this.m_serverSocket.accept();
        return socket;
    }

    private class KeepListeningForConnections
    implements Runnable,
    ThreadInterface {
        private Thread my_thread;
        private final XDITransformManagerImpl m_mgr;
        private boolean m_daemon = false;

        public KeepListeningForConnections(XDITransformManagerImpl mgr) {
            this.m_mgr = mgr;
        }

        public void run() {
            while (XDIListeningConnectorImpl.this.m_keepListeningForConnections && XDIListeningConnectorImpl.this.m_serverSocket != null) {
                try {
                    Socket socket = XDIListeningConnectorImpl.this.waitForConnection();
                    this.m_mgr.addDebugEngineConnection(socket);
                }
                catch (SocketException socketException) {
                    XDIListeningConnectorImpl.this.m_keepListeningForConnections = false;
                }
                catch (IOException iOException) {
                    XDIListeningConnectorImpl.this.m_keepListeningForConnections = false;
                }
            }
        }

        public void stopThread() {
        }

        public void startThread() {
            this.my_thread = new Thread(this);
            this.my_thread.setName("Listening for engine connections");
            this.setDaemonThread(this.m_daemon);
            this.my_thread.start();
        }

        public void setDaemonThread(boolean b) {
            this.m_daemon = b;
            if (this.my_thread != null) {
                this.my_thread.setDaemon(this.m_daemon);
            }
        }

        public boolean isAliveThread() {
            return false;
        }
    }
}

