/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.XDIDocument;
import com.ibm.debug.xdi.XDINode;
import com.ibm.debug.xdi.impl.DebugPacket;
import com.ibm.debug.xdi.impl.XDITransformImpl;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class XDINodeImpl
implements XDINode {
    private XDITransformImpl m_transform;
    private XDIDocument m_document;
    private String m_nodeName;
    private int m_lineNumber = -1;
    private int m_Loc2LineNumber = -1;
    private int m_CharStart = -1;
    private int m_CharEnd = -1;
    private int m_Loc1CharOffset = -1;
    private int m_endLineCharOffset = -1;
    private boolean m_hasChildren = false;
    private XDINode[] m_children = null;
    private XDINode[] m_attributes = null;
    private XDINode[] m_namespaceNodes = null;
    private int m_nodeId = -1;
    private int m_type = 0;
    private String m_value = "";
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public XDINodeImpl() {
    }

    public XDINodeImpl(XDITransformImpl transform) {
        this.m_transform = transform;
    }

    public XDIDocument getDocument() {
        return this.m_document;
    }

    public void setDocument(XDIDocument document) {
        this.m_document = document;
    }

    public int getStartLineNumber() {
        return this.m_lineNumber;
    }

    public void setStartLineNumber(int lineNumber) {
        this.m_lineNumber = lineNumber;
    }

    public void setCharStart(int offset) {
        this.m_CharStart = offset;
    }

    public void setCharEnd(int offset) {
        this.m_CharEnd = offset;
    }

    public String getName() {
        return this.m_nodeName;
    }

    public void setName(String name2) {
        this.m_nodeName = name2;
    }

    public XDINode[] getAttributes() {
        this.updateChildren();
        return this.m_attributes;
    }

    public XDINode[] getNamespaceNodes() {
        this.updateChildren();
        return this.m_namespaceNodes;
    }

    public XDINode[] getChildren() {
        this.updateChildren();
        return this.m_children;
    }

    public XDINode getParent() {
        return null;
    }

    public int getType() {
        return this.m_type;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean hasChildren() {
        return this.m_hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.m_hasChildren = hasChildren;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(int i) {
        this.m_nodeId = i;
    }

    private void updateChildren() {
        if (this.m_hasChildren && this.m_children == null && this.m_attributes == null && this.m_namespaceNodes == null) {
            this.m_transform.getManager().sendRequest(this.m_transform.getUniqueEngineId(), 60, new Integer(this.getNodeId()).toString());
            try {
                DebugPacket debugPacket = this.m_transform.waitForReply(60);
                String[] reply = debugPacket.getData();
                StringTokenizer stringTokenizer = new StringTokenizer(reply[0], ",");
                this.m_attributes = XDINodeImpl.extractNodeSet(stringTokenizer, this.m_transform);
                stringTokenizer = new StringTokenizer(reply[1], ",");
                this.m_namespaceNodes = XDINodeImpl.extractNodeSet(stringTokenizer, this.m_transform);
                stringTokenizer = new StringTokenizer(reply[2], ",");
                this.m_children = XDINodeImpl.extractNodeSet(stringTokenizer, this.m_transform);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setType(int i) {
        this.m_type = i;
    }

    public void setValue(String string) {
        this.m_value = string;
    }

    public static XDINodeImpl[] extractNodeSet(StringTokenizer replyFrame, XDITransformImpl trans) {
        ArrayList<XDINodeImpl> nodes = new ArrayList<XDINodeImpl>();
        try {
            while (replyFrame.hasMoreTokens()) {
                XDINodeImpl node = new XDINodeImpl(trans);
                XDIDocument doc = trans.getDocumentManager().getHandle(replyFrame);
                if (doc != null) {
                    node.setDocument(doc);
                    int line = Integer.parseInt(replyFrame.nextToken());
                    node.setStartLineNumber(line);
                    int charStart = Integer.parseInt(replyFrame.nextToken());
                    int charEnd = Integer.parseInt(replyFrame.nextToken());
                    node.setCharStart(charStart);
                    node.setCharEnd(charEnd);
                    Integer.parseInt(replyFrame.nextToken());
                    int offsetWithinLine1 = Integer.parseInt(replyFrame.nextToken());
                    Integer.parseInt(replyFrame.nextToken());
                    int offsetWithinLine2 = Integer.parseInt(replyFrame.nextToken());
                    node.setLoc2LineNumber(line);
                    node.setLoc1CharOffset(offsetWithinLine1);
                    node.setLoc2CharOffset(offsetWithinLine2);
                    String nodeId = replyFrame.nextToken();
                    String type = replyFrame.nextToken();
                    String name2 = replyFrame.nextToken();
                    String hasChildren = replyFrame.nextToken();
                    String valueLen = replyFrame.nextToken();
                    node.setNodeId(Integer.parseInt(nodeId));
                    node.setType(Integer.parseInt(type));
                    node.setName(name2);
                    node.setHasChildren(Integer.parseInt(hasChildren) != 0);
                    int nodeValueLength = Integer.parseInt(valueLen);
                    if (nodeValueLength > 0) {
                        String data = replyFrame.nextToken("");
                        node.setValue(data.substring(1, nodeValueLength + 1));
                        if (data.length() > 1 + nodeValueLength) {
                            replyFrame = new StringTokenizer(data.substring(nodeValueLength + 2), ",");
                        }
                    }
                    nodes.add(node);
                    continue;
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return nodes.toArray(new XDINodeImpl[nodes.size()]);
    }

    public int getCharEnd() {
        return this.m_CharEnd;
    }

    public int getCharStart() {
        return this.m_CharStart;
    }

    public int getUniqueId() {
        return this.m_nodeId;
    }

    public int getLoc1LineNumber() {
        return this.m_lineNumber;
    }

    public int getLoc2LineNumber() {
        return this.m_Loc2LineNumber;
    }

    public void setLoc2LineNumber(int line) {
        this.m_Loc2LineNumber = line;
    }

    public int getLoc1CharOffset() {
        return this.m_Loc1CharOffset;
    }

    public void setLoc1CharOffset(int off) {
        this.m_Loc1CharOffset = off;
    }

    public int getLoc2CharOffset() {
        return this.m_endLineCharOffset;
    }

    public void setLoc2CharOffset(int off) {
        this.m_endLineCharOffset = off;
    }
}

