/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.transform.intrface.AdapterResultDocument;
import com.ibm.debug.xdi.impl.XDIDocumentImpl;
import com.ibm.debug.xdi.impl.XDITransformImpl;

public class XDIResultDocumentImpl
extends XDIDocumentImpl
implements AdapterResultDocument {
    private boolean m_updatesPending = true;
    private int m_previousLength = 0;
    private final StringBuffer m_pendingUpdate = new StringBuffer();
    private String m_tempPendingUpdate = "";
    private int m_outputMethod = 0;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public XDIResultDocumentImpl(String uri, int id, XDITransformImpl transformer) {
        super(uri, id, false, transformer);
    }

    public void appendToUpdateBuffer(String output) {
        this.m_pendingUpdate.append(output);
        if (!this.m_updatesPending && output.length() > 0) {
            this.m_updatesPending = true;
        }
        this.m_tempPendingUpdate = "";
    }

    public void setTempUpdate(String output) {
        this.m_tempPendingUpdate = output;
        if (!this.m_updatesPending && output.length() > 0) {
            this.m_updatesPending = true;
        }
    }

    public int getUpdates(StringBuffer buffer) {
        int offset = this.m_previousLength;
        buffer.append(this.m_pendingUpdate);
        buffer.append(this.m_tempPendingUpdate);
        this.m_previousLength += this.m_pendingUpdate.length();
        this.m_pendingUpdate.setLength(0);
        this.m_tempPendingUpdate = "";
        this.m_updatesPending = false;
        return offset;
    }

    public boolean isGenerated() {
        return false;
    }

    public String generatedFile() {
        return null;
    }

    public int getOutputMethod() {
        return this.m_outputMethod;
    }

    public void setOutputMethod(String methodType) {
        if ("xml".equals(methodType)) {
            this.m_outputMethod = 1;
        } else if ("html".equals(methodType)) {
            this.m_outputMethod = 2;
        } else if ("text".equals(methodType)) {
            this.m_outputMethod = 3;
        } else if ("xhtml".equals(methodType)) {
            this.m_outputMethod = 4;
        }
    }
}

