/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.InvalidStackFrameException;
import com.ibm.debug.xdi.XDIContext;
import com.ibm.debug.xdi.XDIDocument;
import com.ibm.debug.xdi.XDIResultDocument;
import com.ibm.debug.xdi.XDIStackFrame;
import com.ibm.debug.xdi.XDITransform;
import com.ibm.debug.xdi.XDIVariable;
import com.ibm.debug.xdi.impl.XDIContextImpl;
import com.ibm.debug.xdi.impl.XDITransformImpl;
import com.ibm.debug.xdi.impl.XDIVariableImpl;
import java.util.Vector;

public class XDIStackFrameImpl
implements XDIStackFrame {
    private int m_stackframeID;
    private XDIContextImpl m_context;
    private int m_charEnd = -1;
    private int m_charStart = -1;
    private int m_lineNumber = -1;
    private final XDITransformImpl m_transform;
    private XDIVariableImpl[] m_vars;
    private String m_mode;
    private String m_priority;
    private XDIDocument m_sourceDocument = null;
    private int m_line2Number = -1;
    private int m_char1Offset = -1;
    private int m_char2Offset = -1;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public XDIStackFrameImpl(XDITransformImpl transform) {
        this.m_transform = transform;
    }

    public XDIContext getContext() {
        return this.m_context;
    }

    public void setContext(XDIContextImpl context) {
        this.m_context = context;
    }

    public XDITransform getTransform() {
        return this.m_transform;
    }

    public String[][] getLabelAttributes() throws InvalidStackFrameException {
        Vector<String[]> v = new Vector<String[]>();
        if (this.m_mode != null && !this.m_mode.equals("#")) {
            v.add(new String[]{"mode", this.m_mode});
        }
        if (this.m_priority != null && !this.m_priority.equals(Double.toString(Double.NEGATIVE_INFINITY)) && !this.m_priority.equals("null")) {
            v.add(new String[]{"priority", this.m_priority});
        }
        if (v.size() > 0) {
            return (String[][])v.toArray((T[])new String[v.size()][2]);
        }
        return null;
    }

    public int getUniqueId() {
        return this.m_stackframeID;
    }

    public XDIVariable[] getVariables() throws InvalidStackFrameException {
        return this.m_vars;
    }

    public void setVariables(XDIVariable[] vars) {
        this.m_vars = (XDIVariableImpl[])vars;
    }

    public void setMode(String string) {
        this.m_mode = string;
    }

    public void setPriority(String string) {
        this.m_priority = string;
    }

    public XDIDocument getSourceDocument() throws InvalidStackFrameException {
        return this.m_sourceDocument;
    }

    public XDIResultDocument getResultDocument() throws InvalidStackFrameException {
        return null;
    }

    public void setSourceDocument(XDIDocument doc) {
        this.m_sourceDocument = doc;
    }

    public int getCharEnd() throws InvalidStackFrameException {
        return this.m_charEnd;
    }

    public int getCharStart() throws InvalidStackFrameException {
        return this.m_charStart;
    }

    public int getLineNumber() throws InvalidStackFrameException {
        return this.m_lineNumber;
    }

    public void setCharEnd(int i) {
        this.m_charEnd = i;
    }

    public void setCharStart(int i) {
        this.m_charStart = i;
    }

    public void setLineNumber(int i) {
        this.m_lineNumber = i;
    }

    public void setUniqueId(int stackframeID) {
        this.m_stackframeID = stackframeID;
    }

    public void setLine1Number(int line1) {
        this.m_lineNumber = line1;
    }

    public void setLine2Number(int line2) {
        this.m_line2Number = line2;
    }

    public void setChar1Offset(int off1) {
        this.m_char1Offset = off1;
    }

    public void setChar2Offset(int off2) {
        this.m_char2Offset = off2;
    }

    public int getLoc1LineNumber() throws InvalidStackFrameException {
        return this.m_lineNumber;
    }

    public int getLoc2LineNumber() throws InvalidStackFrameException {
        return this.m_line2Number;
    }

    public int getLoc1CharOffset() throws InvalidStackFrameException {
        return this.m_char1Offset;
    }

    public int getLoc2CharOffset() throws InvalidStackFrameException {
        return this.m_char2Offset;
    }
}

