/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.DuplicateRequestException;
import com.ibm.debug.xdi.EvaluationException;
import com.ibm.debug.xdi.ExitPoint;
import com.ibm.debug.xdi.InvalidStateException;
import com.ibm.debug.xdi.JavaMethod;
import com.ibm.debug.xdi.OperationNotAvailableException;
import com.ibm.debug.xdi.XDIDocument;
import com.ibm.debug.xdi.XDIResultDocument;
import com.ibm.debug.xdi.XDIStackFrame;
import com.ibm.debug.xdi.XDITransform;
import com.ibm.debug.xdi.XDIValue;
import com.ibm.debug.xdi.XDIVariable;
import com.ibm.debug.xdi.impl.DebugEngineConnection;
import com.ibm.debug.xdi.impl.DebugPacket;
import com.ibm.debug.xdi.impl.ExitPointImpl;
import com.ibm.debug.xdi.impl.JavaMethodImpl;
import com.ibm.debug.xdi.impl.XDIContextImpl;
import com.ibm.debug.xdi.impl.XDIDocumentManager;
import com.ibm.debug.xdi.impl.XDINodeImpl;
import com.ibm.debug.xdi.impl.XDIStackFrameImpl;
import com.ibm.debug.xdi.impl.XDIValueImpl;
import com.ibm.debug.xdi.impl.XDIVariableImpl;
import com.ibm.debug.xdi.messages.XDIMessage;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.Version;

public class XDITransformImpl
implements XDITransform {
    private final int m_uniqueEngineId;
    private final int m_uniqueAdapterId;
    private boolean m_isTerminated = false;
    private DebugEngineConnection m_manager = null;
    private XDIDocumentManager m_documentManager = new XDIDocumentManager(this);
    private Vector m_stackCache = new Vector();
    private ExitPoint[] m_exitPoints = null;
    private String m_javaThreadName = null;
    private String m_javaThreadGroupName = null;
    private static volatile int m_nextAdapterId = 0;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public XDITransformImpl(DebugEngineConnection manager, int transformEngineID) {
        this.m_manager = manager;
        this.m_uniqueEngineId = transformEngineID;
        this.m_uniqueAdapterId = XDITransformImpl.getNextAdapterId();
    }

    public XDIStackFrame[] getStackFrames() throws InvalidStateException {
        Vector<XDIStackFrameImpl> stack;
        int cacheCount;
        block15: {
            DebugPacket debugPacket = null;
            cacheCount = 0;
            if (this.m_isTerminated) {
                this.throwISE("ER_GET_STACK_WHEN_TERM");
            }
            this.sendRequest(52, this.m_stackCache.size());
            try {
                debugPacket = this.waitForReply(52);
            }
            catch (InterruptedException interruptedException) {
                this.throwISE("ER_INTURRUPTED_WAITING_FOR_FRAMES");
            }
            String[] reply = debugPacket.getData();
            stack = new Vector<XDIStackFrameImpl>();
            try {
                int messageType = debugPacket.getMessageType();
                switch (messageType) {
                    case 101: {
                        boolean error = false;
                        cacheCount = Integer.parseInt(reply[0]);
                        int i = 1;
                        while (i < reply.length) {
                            if (error) break block15;
                            StringTokenizer replyFrame = new StringTokenizer(reply[i], ",");
                            XDIStackFrameImpl frame = new XDIStackFrameImpl(this);
                            try {
                                frame.setUniqueId(Integer.parseInt(replyFrame.nextToken()));
                                frame.setLineNumber(Integer.parseInt(replyFrame.nextToken()));
                                frame.setCharStart(Integer.parseInt(replyFrame.nextToken()));
                                frame.setCharEnd(Integer.parseInt(replyFrame.nextToken()));
                                frame.setChar1Offset(Integer.parseInt(replyFrame.nextToken()));
                                frame.setLine2Number(Integer.parseInt(replyFrame.nextToken()));
                                frame.setChar2Offset(Integer.parseInt(replyFrame.nextToken()));
                                frame.setMode(replyFrame.nextToken());
                                frame.setPriority(replyFrame.nextToken());
                                frame.setSourceDocument(this.m_documentManager.getHandle(replyFrame));
                                XDIContextImpl context = new XDIContextImpl();
                                context.setCurrentPosition(Integer.parseInt(replyFrame.nextToken()));
                                context.setNodeSet(XDINodeImpl.extractNodeSet(replyFrame, this));
                                frame.setContext(context);
                            }
                            catch (Exception e2) {
                                error = true;
                                String msg = XDIMessage.getFormattedString("INTERNAL_BAD_STACKFRAME");
                                XDIMessage.issueMessage(msg);
                                msg = e2.toString();
                                msg = XDIMessage.getFormattedString("INTERNAL_EXCEPTION_STACK", msg);
                                XDIMessage.issueMessage(msg);
                            }
                            if (!error) {
                                stack.add(0, frame);
                                replyFrame = new StringTokenizer(reply[++i], ",");
                                if (!replyFrame.hasMoreTokens()) continue;
                                int numVars = Integer.parseInt(replyFrame.nextToken());
                                XDIVariable[] vars = null;
                                if (numVars > 0) {
                                    vars = new XDIVariableImpl[numVars];
                                }
                                int j = 0;
                                while (j < numVars) {
                                    StringTokenizer varString = new StringTokenizer(reply[++i], ",");
                                    String varName = varString.nextToken();
                                    int uniqueID = Integer.parseInt(varString.nextToken());
                                    XDIValue xdiValue = XDIValueImpl.extractValue(varString, this);
                                    vars[j] = new XDIVariableImpl(varName, uniqueID, xdiValue);
                                    ++j;
                                }
                                frame.setVariables(vars);
                                ++i;
                                continue;
                            }
                            this.throwISE("ER_INVALID_STACK_FRAME");
                        }
                        break;
                    }
                    default: {
                        this.throwISE("ER_GET_STACK");
                        break;
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.throwISE("ER_INVALID_STACK_FRAME");
            }
        }
        int j = this.m_stackCache.size() - cacheCount;
        while (j < this.m_stackCache.size()) {
            stack.addElement((XDIStackFrameImpl)this.m_stackCache.elementAt(j));
            ++j;
        }
        this.m_stackCache = stack;
        return stack.toArray(new XDIStackFrame[stack.size()]);
    }

    public void resume() throws InvalidStateException {
        if (this.m_isTerminated) {
            this.throwISE("ER_RESUME_WHEN_TERMINATED");
        }
        this.sendRequest(53);
    }

    public int getUniqueEngineId() {
        return this.m_uniqueEngineId;
    }

    public int getUniqueId() {
        return this.m_uniqueAdapterId;
    }

    public void disconnect() throws InvalidStateException {
        if (this.m_isTerminated) {
            this.throwISE("ER_DISC_WHEN_TERMINATED");
        }
        this.m_manager.disconnectImmediate(this.m_uniqueEngineId);
    }

    public XDIValue evaluateExpression(String expression) throws InvalidStateException, EvaluationException {
        XDIValue var = null;
        DebugPacket debugPacket = null;
        if (this.m_isTerminated) {
            this.throwISE("ER_EXPR_EVAL_WHEN_TERM");
        }
        this.sendRequest(59, expression);
        try {
            debugPacket = this.waitForReply(59);
        }
        catch (InterruptedException interruptedException) {
            String msg = XDIMessage.getFormattedString("ER_INTERRUPT_WAITING__FOR_EXPR_EVAL", expression);
            throw new EvaluationException(msg);
        }
        String[] reply = debugPacket.getData();
        int messageType = debugPacket.getMessageType();
        switch (messageType) {
            case 101: {
                var = XDIValueImpl.extractValue(new StringTokenizer(reply[0], ","), this);
                break;
            }
            default: {
                String msg = XDIMessage.getFormattedString("ER_EXPR_EVAL", expression);
                throw new EvaluationException(msg);
            }
        }
        return var;
    }

    public String getJavaThreadGroupName() throws InvalidStateException {
        if (this.m_isTerminated) {
            this.throwISE("ER_GET_THREAD_NAME_WHEN_TERMINATED");
        }
        if (this.m_javaThreadGroupName == null) {
            DebugPacket debugPacket;
            this.sendRequest(62);
            try {
                debugPacket = this.waitForReply(62);
            }
            catch (InterruptedException interruptedException) {
                this.throwISE("ER_INTERRUPTED_FETCH_THREAD_NAME");
                return null;
            }
            String[] reply = debugPacket.getData();
            int messageType = debugPacket.getMessageType();
            switch (messageType) {
                case 101: {
                    this.m_javaThreadGroupName = reply[0];
                    break;
                }
                default: {
                    this.throwISE("ER_GET_THREAD_NAME");
                }
            }
        }
        return this.m_javaThreadGroupName;
    }

    public String getJavaThreadName() throws InvalidStateException {
        if (this.m_isTerminated) {
            this.throwISE("ER_GET_THREAD_NAME_WHEN_TERMINATED");
        }
        if (this.m_javaThreadName == null) {
            DebugPacket debugPacket;
            this.sendRequest(61);
            try {
                debugPacket = this.waitForReply(61);
            }
            catch (InterruptedException interruptedException) {
                this.throwISE("ER_INTERRUPTED_FETCH_THREAD_NAME");
                return null;
            }
            String[] reply = debugPacket.getData();
            int messageType = debugPacket.getMessageType();
            switch (messageType) {
                case 101: {
                    this.m_javaThreadName = reply[0];
                    break;
                }
                default: {
                    this.throwISE("ER_GET_THREAD_NAME");
                }
            }
        }
        return this.m_javaThreadName;
    }

    public String getName() throws InvalidStateException {
        DebugPacket debugPacket;
        if (this.m_isTerminated) {
            this.throwISE("ER_GET_PRODUCT_WHEN_TERMINATED");
        }
        this.sendRequest(67);
        try {
            debugPacket = this.waitForReply(67);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        String[] reply = debugPacket.getData();
        return reply[0];
    }

    public XDIResultDocument[] getResultDocuments() {
        return this.m_documentManager.getResultDocuments();
    }

    public XDIDocument getSource() throws InvalidStateException {
        if (this.m_isTerminated) {
            this.throwISE("ER_GET_MAIN_DOC_SRC_WHEN_TERMINATED");
        }
        return null;
    }

    public String getStylesheetURIName() throws InvalidStateException {
        DebugPacket debugPacket;
        if (this.m_isTerminated) {
            this.throwISE("ER_GET_MAIN_DOC_SRC_URI_WHEN_TERMINATED");
        }
        this.sendRequest(66);
        try {
            debugPacket = this.waitForReply(66);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        String[] reply = debugPacket.getData();
        return reply[0];
    }

    public String getVersion() throws InvalidStateException {
        if (this.m_isTerminated) {
            this.throwISE("ER_GET_VERSION_WHEN_TERMINATED");
        }
        return Version.getVersion();
    }

    public boolean isSuspended() throws InvalidStateException {
        DebugPacket debugPacket;
        if (this.m_isTerminated) {
            this.throwISE("ER_SUSPEND_WHEN_TERMINATED");
        }
        this.sendRequest(63);
        boolean isSuspended = false;
        try {
            debugPacket = this.waitForReply(63);
        }
        catch (InterruptedException interruptedException) {
            this.throwISE("ER_INTERRUPTED_IS_SUSPENDED");
            return false;
        }
        String[] reply = debugPacket.getData();
        switch (debugPacket.getMessageType()) {
            case 101: {
                isSuspended = "1".equals(reply[0]);
                break;
            }
            default: {
                this.throwISE("ER_IS_SUSPENDED_FAILED");
            }
        }
        return isSuspended;
    }

    private void throwISE(String key) throws InvalidStateException {
        String msg = XDIMessage.getFormattedString(key);
        throw new InvalidStateException(msg);
    }

    public void suspend(boolean immediate) throws InvalidStateException, OperationNotAvailableException {
        DebugPacket debugPacket;
        if (this.m_isTerminated) {
            this.throwISE("ER_SUSPEND_WHEN_TERMINATED");
        }
        this.sendRequest(54, immediate);
        try {
            debugPacket = this.waitForReply(54);
        }
        catch (InterruptedException interruptedException) {
            this.throwISE("ER_INTERRUPTED_SUSPEND");
            return;
        }
        switch (debugPacket.getMessageType()) {
            case 101: {
                break;
            }
            default: {
                if (immediate) {
                    String key = "ER_SUSPEND_IMMEDIATE_FAILED";
                    String msg = XDIMessage.getFormattedString(key);
                    throw new OperationNotAvailableException(msg);
                }
                this.throwISE("ER_SUSPEND_FAILED");
            }
        }
    }

    public void terminate() throws InvalidStateException {
        if (this.m_isTerminated) {
            this.throwISE("ER_TERM_WHEN_TERMINATED");
        }
    }

    protected void setIsTerminated() {
        this.m_isTerminated = true;
    }

    public DebugEngineConnection getManager() {
        return this.m_manager;
    }

    public ExitPoint[] getExitPoints() {
        return this.m_exitPoints;
    }

    public XDIResultDocument getCurrentResultDocument() throws InvalidStateException {
        return this.m_documentManager.getCurrentResultDocument();
    }

    public XDIDocumentManager getDocumentManager() {
        return this.m_documentManager;
    }

    public void setExitPoints(ExitPoint[] points) {
        int max2 = points.length;
        int i = 0;
        while (i < max2) {
            JavaMethod jMethod = points[i].getJavaMethod();
            if ("<init>".equals(jMethod.getMethodName())) {
                String className = jMethod.getClassName();
                JavaMethodImpl stat = new JavaMethodImpl(className, "<clinit>", new String[0], "void");
                ExitPointImpl staticInitializer = new ExitPointImpl(stat, true);
                ExitPoint[] newpoints = new ExitPoint[max2 + 1];
                System.arraycopy(points, 0, newpoints, 0, max2);
                newpoints[max2] = staticInitializer;
                points = newpoints;
                break;
            }
            ++i;
        }
        this.m_exitPoints = points;
    }

    public String getEvaluationThreadGroupName() throws InvalidStateException {
        return null;
    }

    public String getEvaluationThreadName() throws InvalidStateException {
        return null;
    }

    public void clearStepRequest() throws InvalidStateException {
        if (this.m_isTerminated) {
            this.throwISE("ER_CLEAR_STEP_WHEN_TERMINATED");
        }
        this.sendRequest(65);
    }

    public void setStepRequest(int type) throws InvalidStateException, DuplicateRequestException {
        this.sendRequest(64, type);
    }

    public void setExtensionElementMode(boolean enable) {
        this.sendRequest(69, enable);
    }

    public boolean isInExtensionElement() {
        boolean ret = false;
        this.sendRequest(68);
        try {
            DebugPacket reply = this.waitForReply(68);
            if ("1".equals(reply.getData()[0])) {
                ret = true;
            }
        }
        catch (InterruptedException e2) {
            String s = "";
            s = String.valueOf(s) + e2;
            String msg = XDIMessage.getFormattedString("INTERNAL_EXCEPTION_STACK", s);
            XDIMessage.issueMessage(msg);
        }
        return ret;
    }

    private void sendRequest(int messageID) {
        this.sendRequest(messageID, null);
    }

    private void sendRequest(int messageID, String data) {
        this.m_manager.sendRequest(this.m_uniqueEngineId, messageID, data);
    }

    private void sendRequest(int messageID, int value2) {
        String data = Integer.toString(value2);
        this.sendRequest(messageID, data);
    }

    private void sendRequest(int messageID, boolean bool) {
        String data = bool ? "1" : "0";
        this.sendRequest(messageID, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebugPacket waitForReply(int reqId) throws InterruptedException {
        DebugPacket debugPacket = null;
        XDITransformImpl xDITransformImpl = this;
        synchronized (xDITransformImpl) {
            while (true) {
                if (this.m_manager.hasReply(this.m_uniqueEngineId, reqId)) break;
                this.wait();
            }
            debugPacket = this.m_manager.getReply(this.m_uniqueEngineId, reqId);
        }
        return debugPacket;
    }

    private static synchronized int getNextAdapterId() {
        return ++m_nextAdapterId;
    }
}

