/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.XDIBreakpoint;
import com.ibm.debug.xdi.XDIEventListener;
import com.ibm.debug.xdi.XDILineBreakpoint;
import com.ibm.debug.xdi.XDITransform;
import com.ibm.debug.xdi.XDITransformManager;
import com.ibm.debug.xdi.impl.DebugEngineConnection;
import com.ibm.debug.xdi.impl.XDILineBreakpointImpl;
import com.ibm.debug.xdi.util.CanonicalURI;
import java.net.Socket;
import java.util.Vector;

public class XDITransformManagerImpl
implements XDITransformManager {
    private final Vector m_debugEngineConnections = new Vector();
    private final Vector m_allBreakpoints = new Vector();
    XDIEventListener m_eventListener;
    private boolean m_filterBuiltinRules;
    private boolean m_nodeStepping;
    private boolean m_entryExitMode;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public void addMultiEngineBP(OneBreakpointOnAllEngines bp) {
        this.m_allBreakpoints.add(bp);
    }

    public void removeMultiEngineBP(OneBreakpointOnAllEngines bp) {
        this.m_allBreakpoints.remove(bp);
    }

    public XDITransformManagerImpl(Socket s) {
        DebugEngineConnection engine2 = new DebugEngineConnection(s);
        this.m_debugEngineConnections.add(engine2);
    }

    public final void setEventListener(XDIEventListener eventListener) {
        this.m_eventListener = eventListener;
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            engine2.setEventListener(eventListener);
            ++i;
        }
    }

    public final XDITransform[] getTransforms() {
        XDITransform[] ret;
        boolean empty = true;
        Vector<XDITransform> allConnections = new Vector<XDITransform>();
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            XDITransform[] engineTrans = engine2.getTransforms();
            if (engineTrans != null) {
                int t = 0;
                while (t < engineTrans.length) {
                    allConnections.add(engineTrans[t]);
                    empty = false;
                    ++t;
                }
            }
            ++i;
        }
        if (empty) {
            ret = null;
        } else {
            Object[] oArray = allConnections.toArray();
            int total = oArray.length;
            ret = new XDITransform[total];
            int i2 = 0;
            while (i2 < total) {
                ret[i2] = (XDITransform)oArray[i2];
                ++i2;
            }
        }
        return ret;
    }

    public final void resume() {
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            engine2.resume();
            ++i;
        }
    }

    public final boolean isSuspended() {
        boolean suspended = false;
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            suspended = engine2.isSuspended();
            if (suspended) break;
            ++i;
        }
        return suspended;
    }

    public final void setFilterBuiltinRules(boolean enable) {
        this.m_filterBuiltinRules = enable;
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            engine2.setFilterBuiltinRules(this.m_filterBuiltinRules);
            ++i;
        }
    }

    public final void setNodeStepping(boolean enable) {
        this.m_nodeStepping = enable;
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            engine2.setNodeStepping(this.m_nodeStepping);
            ++i;
        }
    }

    public final void setEntryExitMode(boolean enable) {
        this.m_entryExitMode = enable;
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            engine2.setEntryExitMode(this.m_entryExitMode);
            ++i;
        }
    }

    public final XDILineBreakpoint createLineBreakpoint(String fileName, int lineNumber, int charStart, int charEnd) {
        OneBreakpointOnAllEngines bp = new OneBreakpointOnAllEngines(fileName, lineNumber, charStart, charEnd);
        this.addMultiEngineBP(bp);
        return bp;
    }

    public final void deleteBreakpoint(XDIBreakpoint breakpoint) {
        if (breakpoint instanceof OneBreakpointOnAllEngines) {
            OneBreakpointOnAllEngines bp = (OneBreakpointOnAllEngines)breakpoint;
            bp.delete();
        }
    }

    public final void disconnect() {
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            engine2.disconnect();
            ++i;
        }
    }

    public final void terminateAndDisconnect() {
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            engine2.terminateAndDisconnect();
            ++i;
        }
    }

    public final void addDebugEngineConnection(Socket socket) {
        DebugEngineConnection engine2 = new DebugEngineConnection(socket);
        engine2.setEventListener(this.m_eventListener);
        int i = 0;
        while (i < this.m_allBreakpoints.size()) {
            OneBreakpointOnAllEngines crossEngineBreakpoint = (OneBreakpointOnAllEngines)this.m_allBreakpoints.elementAt(i);
            XDILineBreakpoint oneEngineBreakpoint = engine2.createLineBreakpoint(crossEngineBreakpoint);
            if (!crossEngineBreakpoint.isEnabled()) {
                oneEngineBreakpoint.setEnabled(false);
            }
            crossEngineBreakpoint.m_engineBreakpoints.add(oneEngineBreakpoint);
            ++i;
        }
        engine2.setEntryExitMode(this.m_entryExitMode);
        engine2.setFilterBuiltinRules(this.m_filterBuiltinRules);
        engine2.setNodeStepping(this.m_nodeStepping);
        this.m_debugEngineConnections.add(engine2);
        engine2.setupIsComplete();
        engine2.resume();
    }

    public final void setupIsComplete() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        int i = 0;
        while (i < this.m_debugEngineConnections.size()) {
            DebugEngineConnection engine2 = (DebugEngineConnection)this.m_debugEngineConnections.elementAt(i);
            engine2.setupIsComplete();
            ++i;
        }
    }

    private final class OneBreakpointOnAllEngines
    implements XDILineBreakpoint {
        Vector m_engineBreakpoints = new Vector();
        private final String m_filename;
        private final int m_line;
        private final int m_charStart;
        private final int m_charEnd;
        private final CanonicalURI m_uri;
        boolean m_isEnabled = true;

        private OneBreakpointOnAllEngines(String fileName, int lineNumber, int charStart, int charEnd) {
            this.m_uri = CanonicalURI.getInstance(fileName);
            this.m_filename = this.m_uri.getURIString();
            this.m_line = lineNumber;
            this.m_charStart = charStart;
            this.m_charEnd = charEnd;
            int i = 0;
            while (i < XDITransformManagerImpl.this.m_debugEngineConnections.size()) {
                DebugEngineConnection engine2 = (DebugEngineConnection)XDITransformManagerImpl.this.m_debugEngineConnections.elementAt(i);
                XDILineBreakpoint engineBP = engine2.createLineBreakpoint(this);
                if (engineBP != null) {
                    this.m_engineBreakpoints.add(engineBP);
                }
                ++i;
            }
        }

        private final void delete() {
            int i = this.m_engineBreakpoints.size() - 1;
            while (i >= 0) {
                XDILineBreakpointImpl bp = (XDILineBreakpointImpl)this.m_engineBreakpoints.elementAt(i);
                DebugEngineConnection engine2 = bp.getDebugEngineConnection();
                engine2.deleteBreakpoint(bp);
                this.m_engineBreakpoints.remove(i);
                --i;
            }
            XDITransformManagerImpl.this.removeMultiEngineBP(this);
        }

        public final String getFileName() {
            return this.m_filename;
        }

        public final int getLineNumber() {
            return this.m_line;
        }

        public final int getCharStart() {
            return this.m_charStart;
        }

        public final int getCharEnd() {
            return this.m_charEnd;
        }

        public final boolean isInstalled() {
            return false;
        }

        public final boolean isEnabled() {
            return this.m_isEnabled;
        }

        public final void setEnabled(boolean enable) {
            if (this.m_isEnabled != enable) {
                this.m_isEnabled = enable;
                int i = this.m_engineBreakpoints.size() - 1;
                while (i >= 0) {
                    XDILineBreakpointImpl oneEngineBreakpoint = (XDILineBreakpointImpl)this.m_engineBreakpoints.elementAt(i);
                    oneEngineBreakpoint.setEnabled(this.m_isEnabled);
                    --i;
                }
            }
        }
    }
}

