/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.impl;

import com.ibm.debug.xdi.XDIItemValue;
import com.ibm.debug.xdi.XDIValue;
import com.ibm.debug.xdi.impl.XDIAggregateValueImpl;
import com.ibm.debug.xdi.impl.XDINodeImpl;
import com.ibm.debug.xdi.impl.XDINodeValueImpl;
import com.ibm.debug.xdi.impl.XDIResultTreeFragmentValueImpl;
import com.ibm.debug.xdi.impl.XDISimpleValueImpl;
import com.ibm.debug.xdi.impl.XDITransformImpl;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class XDIValueImpl
implements XDIValue {
    private static final String XOBJECT_TYPE_STRING = "String";
    private static final String XOBJECT_TYPE_BOOLEAN = "Boolean";
    private static final String XOBJECT_TYPE_NUMBER = "Number";
    private static final String XOBJECT_TYPE_NODESET = "Nodeset";
    private static final String XOBJECT_TYPE_RTF = "ResultTreeFragment";
    private static final String XOBJECT_TYPE_UNKNOWN = "Unknown";
    private static final String NOT_IMPLEMENTED_YET = "<not implemented>";
    private int m_varType = 0;
    private String m_varTypeString = null;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public String getType() {
        return this.m_varTypeString;
    }

    protected void setType(int type) {
        try {
            this.m_varType = type;
            switch (this.m_varType) {
                case 3: {
                    this.m_varTypeString = XOBJECT_TYPE_STRING;
                    break;
                }
                case 1: {
                    this.m_varTypeString = XOBJECT_TYPE_BOOLEAN;
                    break;
                }
                case 2: {
                    this.m_varTypeString = XOBJECT_TYPE_NUMBER;
                    break;
                }
                case 4: {
                    this.m_varTypeString = XOBJECT_TYPE_NODESET;
                    break;
                }
                case 5: {
                    this.m_varTypeString = XOBJECT_TYPE_RTF;
                    break;
                }
                default: {
                    this.m_varTypeString = XOBJECT_TYPE_UNKNOWN;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.m_varType = 0;
            this.m_varTypeString = XOBJECT_TYPE_UNKNOWN;
        }
    }

    public static XDIValue extractValue(StringTokenizer replyFrame, XDITransformImpl trans) {
        XDIValueImpl var = null;
        int varType = Integer.parseInt(replyFrame.nextToken());
        switch (varType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                var = new XDISimpleValueImpl();
                var.setType(varType);
                ((XDISimpleValueImpl)var).setValueString(replyFrame.nextToken("").substring(1));
                break;
            }
            case 4: {
                var = new XDIAggregateValueImpl();
                XDINodeImpl[] nodes = XDINodeImpl.extractNodeSet(replyFrame, trans);
                ArrayList<XDINodeValueImpl> nodeValueList = new ArrayList<XDINodeValueImpl>();
                int i = 0;
                while (i < nodes.length) {
                    XDINodeValueImpl nodeValue = new XDINodeValueImpl();
                    nodeValue.setNode(nodes[i]);
                    nodeValueList.add(nodeValue);
                    ++i;
                }
                XDIItemValue[] nodeValueArray = nodeValueList.toArray(new XDINodeValueImpl[nodeValueList.size()]);
                ((XDIAggregateValueImpl)var).setItems(nodeValueArray);
                ((XDIAggregateValueImpl)var).setType(varType);
                break;
            }
            case 5: {
                var = new XDIResultTreeFragmentValueImpl();
                ((XDIResultTreeFragmentValueImpl)var).setType(varType);
                XDINodeImpl[] nodes = XDINodeImpl.extractNodeSet(replyFrame, trans);
                if (nodes.length != 1) {
                    ((XDIResultTreeFragmentValueImpl)var).setRootNode(null);
                    break;
                }
                ((XDIResultTreeFragmentValueImpl)var).setRootNode(nodes[0]);
                String value2 = ((XDIResultTreeFragmentValueImpl)var).getRootNode().getValue();
                if (value2 != null) {
                    ((XDIResultTreeFragmentValueImpl)var).setValueString(value2);
                    ((XDINodeImpl)((XDIResultTreeFragmentValueImpl)var).getRootNode()).setValue("");
                }
                if (((XDINodeImpl)((XDIResultTreeFragmentValueImpl)var).getRootNode()).getNodeId() != -1) break;
                ((XDIResultTreeFragmentValueImpl)var).setRootNode(null);
                break;
            }
            default: {
                var = new XDISimpleValueImpl();
                var.setType(varType);
                ((XDISimpleValueImpl)var).setValueString(NOT_IMPLEMENTED_YET);
            }
        }
        return var;
    }
}

