/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.jaxp.xalan.interpreted;

import com.ibm.debug.transform.impl.DebugDocumentManager;
import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.xalan.interpreted.DebugXSLTSchema;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugStylesheetRoot;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerFactory;
import com.ibm.debug.xdi.messages.XDIMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.ToXMLStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DebugStylesheetHandler
extends StylesheetHandler {
    private SerializationHandler m_handler = null;
    private ByteArrayOutputStream m_outBytes = null;
    private byte[] m_streamBytes = null;
    private boolean m_done = false;
    private String m_baseSystemID;
    private final DebugTransformerFactory m_factory;
    private boolean m_generated = false;
    private byte[] m_includeBytes = null;
    private Hashtable m_includedSources = new Hashtable();
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    DebugStylesheetHandler(TransformerFactoryImpl arg0, DebugDocumentManager stylesheetDocManager) throws TransformerConfigurationException {
        super(arg0);
        this.m_factory = (DebugTransformerFactory)arg0;
        DebugXSLTSchema.install(this);
        if (this.m_factory.getSource() != null && this.m_factory.getSource() instanceof StreamSource) {
            StreamSource cfr_ignored_0 = (StreamSource)this.m_factory.getSource();
            this.m_streamBytes = this.m_factory.getSourceBytes();
            String sysID = this.m_factory.getSource().getSystemId();
            if (sysID != null && !sysID.equals("")) {
                this.m_baseSystemID = sysID;
                DebugDocument dd = stylesheetDocManager.getDocument(this.m_baseSystemID);
                if (dd != null && dd.isGenerated()) {
                    this.m_generated = true;
                }
                if (sysID.startsWith("xdi-generated-")) {
                    this.m_generated = true;
                }
            } else {
                this.m_generated = true;
            }
            this.m_done = true;
            return;
        }
        this.m_outBytes = new ByteArrayOutputStream();
        this.m_handler = new ToXMLStream();
        this.m_handler.setOutputFormat(OutputPropertiesFactory.getDefaultMethodProperties((String)"xml"));
        this.m_handler.setOutputStream((OutputStream)this.m_outBytes);
    }

    public void setDocumentLocator(Locator arg0) {
        if (this.m_done) {
            super.setDocumentLocator(arg0);
        } else {
            this.m_handler.setDocumentLocator(arg0);
            if (this.m_baseSystemID == null) {
                this.m_baseSystemID = arg0.getSystemId();
            }
        }
    }

    public void startDocument() throws SAXException {
        if (this.m_done) {
            super.startDocument();
        } else {
            this.m_handler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.m_done) {
            super.endDocument();
        } else {
            this.m_handler.endDocument();
            this.m_done = true;
            ByteArrayInputStream inBytes = new ByteArrayInputStream(this.m_outBytes.toByteArray());
            XMLReader reader = XMLReaderFactory.createXMLReader();
            InputSource inputSource = new InputSource(inBytes);
            if (this.m_baseSystemID == null || this.m_baseSystemID.equals("")) {
                this.m_baseSystemID = DebugDocumentManager.getURIforXSLfromSAX();
            }
            inputSource.setSystemId(this.m_baseSystemID);
            reader.setContentHandler((ContentHandler)((Object)this));
            try {
                reader.parse(inputSource);
            }
            catch (IOException iOException) {
                String doc = this.m_baseSystemID;
                XDIMessage.getFormattedString("ER_PARSE_STYLESHEET_DOC", doc);
            }
        }
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        if (this.m_done) {
            super.startPrefixMapping(arg0, arg1);
        } else {
            this.m_handler.startPrefixMapping(arg0, arg1);
        }
    }

    public void endPrefixMapping(String arg0) throws SAXException {
        if (this.m_done) {
            super.endPrefixMapping(arg0);
        } else {
            this.m_handler.endPrefixMapping(arg0);
        }
    }

    public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
        if (this.m_done) {
            super.startElement(arg0, arg1, arg2, arg3);
        } else {
            this.m_handler.startElement(arg0, arg1, arg2, arg3);
        }
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        if (this.m_done) {
            super.endElement(arg0, arg1, arg2);
        } else {
            this.m_handler.endElement(arg0, arg1, arg2);
        }
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.m_done) {
            super.characters(arg0, arg1, arg2);
        } else {
            this.m_handler.characters(arg0, arg1, arg2);
        }
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.m_done) {
            super.ignorableWhitespace(arg0, arg1, arg2);
        } else {
            this.m_handler.ignorableWhitespace(arg0, arg1, arg2);
        }
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
        if (this.m_done) {
            super.processingInstruction(arg0, arg1);
        } else {
            this.m_handler.processingInstruction(arg0, arg1);
        }
    }

    public void skippedEntity(String arg0) throws SAXException {
        if (this.m_done) {
            super.skippedEntity(arg0);
        } else {
            this.m_handler.skippedEntity(arg0);
        }
    }

    public StylesheetRoot getStylesheetRoot() {
        String system_id = null;
        try {
            StylesheetRoot ssr = super.getStylesheetRoot();
            system_id = ssr.getSystemId();
            DebugStylesheetRoot stylesheetRoot = (DebugStylesheetRoot)ssr;
            if (this.m_outBytes != null) {
                stylesheetRoot.setSourceDocument(this.m_outBytes.toString());
                stylesheetRoot.setGenerated(true);
            } else if (this.m_streamBytes != null) {
                stylesheetRoot.setSourceDocument(new String(this.m_streamBytes));
                stylesheetRoot.setGenerated(this.m_generated);
            }
            stylesheetRoot.setSourceDocumentHash(this.m_includedSources);
            return stylesheetRoot;
        }
        catch (ClassCastException classCastException) {
            String msg = XDIMessage.getFormattedString("INTERNAL_INCONSISTENT_JAXP", system_id);
            XDIMessage.issueMessage(msg);
            return null;
        }
    }

    public void setIncludeBytes(byte[] bs) {
        this.m_includeBytes = bs;
    }

    public void pushStylesheet(Stylesheet arg0) {
        if (this.m_includeBytes != null) {
            this.m_includedSources.put(arg0.getSystemId(), this.m_includeBytes);
            this.m_includeBytes = null;
        }
        super.pushStylesheet(arg0);
    }
}

