/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.jaxp.xalan.interpreted;

import com.ibm.debug.transform.impl.DebugDocumentManager;
import com.ibm.debug.xalan.interpreted.XSLProcessorVersionImpl;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerImpl;
import com.ibm.debug.xdi.messages.XDIMessage;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.xalan.extensions.ExtensionNamespaceSupport;
import org.apache.xalan.extensions.ExtensionNamespacesManager;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;

public class DebugStylesheetRoot
extends StylesheetRoot {
    private static final String EXTENSION_HANDLER_CLASSNAME = "com.ibm.debug.xalan.interpreted.ExtendExtensionHandlerExsltFunction";
    private boolean m_generated = false;
    private Hashtable m_sourceDocumentHash = null;
    private DebugDocumentManager m_stylesheetMgr = null;
    private boolean m_isInstalledDebugENM = false;
    private String m_sourceDocument = null;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    void setStylesheetManager(DebugDocumentManager ddm) {
        this.m_stylesheetMgr = ddm;
    }

    DebugDocumentManager getStylesheetManager() {
        if (this.m_stylesheetMgr == null) {
            this.m_stylesheetMgr = new DebugDocumentManager();
        }
        return this.m_stylesheetMgr;
    }

    private DebugStylesheetRoot(ErrorListener arg0) throws TransformerConfigurationException {
        super(arg0);
        this.fixupDefaultRules();
    }

    public DebugStylesheetRoot(XSLTSchema arg0, ErrorListener arg1) throws TransformerConfigurationException {
        super(arg0, arg1);
        this.fixupDefaultRules();
    }

    public Transformer newTransformer() {
        DebugTransformerImpl trans = new DebugTransformerImpl(this);
        return trans;
    }

    public ExtensionNamespacesManager getExtensionNamespacesManager() {
        ExtensionNamespacesManager enm = super.getExtensionNamespacesManager();
        if (!this.m_isInstalledDebugENM) {
            String uri = "http://xml.apache.org/xalan/redirect";
            String handlerClassName = "org.apache.xalan.extensions.ExtensionHandlerJavaClass";
            String lang = "javaclass";
            String lib = "com.ibm.debug.transform.impl.DebugRedirect";
            enm.registerExtension(new ExtensionNamespaceSupport(uri, handlerClassName, new Object[]{uri, lang, lib}));
            this.fixupExtensionHandlerClassname(EXTENSION_HANDLER_CLASSNAME);
            this.m_isInstalledDebugENM = true;
        }
        return enm;
    }

    void setSourceDocument(String string) {
        this.m_sourceDocument = string;
    }

    private void fixupDefaultRules() {
        Stylesheet stylesheet = new Stylesheet((Stylesheet)this);
        stylesheet.setLocaterInfo((SourceLocator)new DummySourceLocator(1, 25));
        this.getDefaultRootRule().setLocaterInfo((SourceLocator)new DummySourceLocator(1, 25));
        this.getDefaultRootRule().setEndLocaterInfo((SourceLocator)new DummySourceLocator(3, 16));
        this.getDefaultRootRule().getFirstChildElem().setLocaterInfo((SourceLocator)new DummySourceLocator(2, 24));
        this.getDefaultRootRule().getFirstChildElem().setEndLocaterInfo((SourceLocator)new DummySourceLocator(2, 24));
        this.getDefaultRootRule().setStylesheet(stylesheet);
        this.getDefaultRule().setLocaterInfo((SourceLocator)new DummySourceLocator(5, 25));
        this.getDefaultRule().setEndLocaterInfo((SourceLocator)new DummySourceLocator(7, 16));
        this.getDefaultRule().getFirstChildElem().setLocaterInfo((SourceLocator)new DummySourceLocator(6, 24));
        this.getDefaultRule().getFirstChildElem().setEndLocaterInfo((SourceLocator)new DummySourceLocator(6, 24));
        this.getDefaultRule().setStylesheet(stylesheet);
        this.getDefaultTextRule().setLocaterInfo((SourceLocator)new DummySourceLocator(9, 33));
        this.getDefaultTextRule().setEndLocaterInfo((SourceLocator)new DummySourceLocator(11, 16));
        this.getDefaultTextRule().getFirstChildElem().setLocaterInfo((SourceLocator)new DummySourceLocator(10, 28));
        this.getDefaultTextRule().getFirstChildElem().setEndLocaterInfo((SourceLocator)new DummySourceLocator(10, 28));
        this.getDefaultTextRule().setStylesheet(stylesheet);
    }

    boolean isGenerated() {
        return this.m_generated;
    }

    String getSourceDocument() {
        return this.m_sourceDocument;
    }

    void setGenerated(boolean b) {
        this.m_generated = b;
    }

    void setSourceDocumentHash(Hashtable hashtable) {
        this.m_sourceDocumentHash = hashtable;
    }

    Hashtable getSourceDocumentHash() {
        return this.m_sourceDocumentHash;
    }

    private void fixupExtensionHandlerClassname(String classname) {
        Class[] parmTypes = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        parmTypes[0] = clazz;
        Object[] parms = new Object[]{classname};
        Method m1 = null;
        Class<?> clazz2 = ((Object)((Object)this)).getClass();
        try {
            m1 = clazz2.getMethod("setExtensionHandlerClass", parmTypes);
        }
        catch (Exception exception) {}
        if (m1 == null) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.apache.xalan.templates.ElemExsltFunction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            clazz2 = clazz3;
            try {
                m1 = clazz2.getMethod("setExtensionHandlerClass", parmTypes);
            }
            catch (Exception exception) {}
            try {
                m1.invoke(null, parms);
            }
            catch (Exception exception) {
                String xslProcessor = new XSLProcessorVersionImpl().getNameAndVersion();
                String msg = XDIMessage.getFormattedString("ER_WRONG_XSL_PROCESSOR", xslProcessor);
                XDIMessage.issueMessage(msg);
            }
        } else {
            try {
                m1.invoke((Object)this, parms);
            }
            catch (Exception exception) {
                String xslProcessor = new XSLProcessorVersionImpl().getNameAndVersion();
                String msg = XDIMessage.getFormattedString("ER_WRONG_XSL_PROCESSOR", xslProcessor);
                XDIMessage.issueMessage(msg);
            }
        }
    }

    private class DummySourceLocator
    implements SourceLocator {
        int row = 0;
        int col = 0;

        private DummySourceLocator(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public int getColumnNumber() {
            return this.col;
        }

        public int getLineNumber() {
            return this.row;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return "http://built-in.template.rules/default.xsl";
        }
    }
}

