/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.jaxp.xalan.interpreted;

import com.ibm.debug.transform.impl.DebugDocumentManager;
import com.ibm.debug.transform.impl.DebugEngineManager;
import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugStylesheetHandler;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugStylesheetRoot;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerHandler;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerImpl;
import com.ibm.debug.xdi.messages.XDIMessage;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.w3c.dom.Node;

public class DebugTransformerFactory
extends TransformerFactoryImpl {
    private boolean m_sourceIsGenerated = false;
    private Source m_source = null;
    private byte[] m_sourceBytes = null;
    private DebugDocumentManager m_stylesheetMgr = null;
    private String m_alternateSourceURI;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";
    static /* synthetic */ Class class$0;

    public DebugTransformerFactory() {
        this.setAttribute("http://xml.apache.org/xalan/properties/source-location", Boolean.TRUE);
        this.setAttribute("http://xml.apache.org/xalan/features/optimize", Boolean.FALSE);
        DebugEngineManager manager = DebugEngineManager.getSingleton();
        manager.getDebugSession(Thread.currentThread());
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return super.newTransformer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        DebugTransformerImpl transformer = null;
        try {
            Templates templates = this.newTemplates(source);
            if (templates == null) return transformer;
            DebugStylesheetRoot root = this.getDebugStylesheetRoot(templates);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                DebugTransformerImpl.setDebugTransformerFactory(this);
                DebugTransformerImpl dti = new DebugTransformerImpl(root);
                DebugTransformerImpl.setDebugTransformerFactory(null);
                // ** MonitorExit[var6_8] (shouldn't be in output)
                transformer = dti;
                transformer.setURIResolver(super.getURIResolver());
                return transformer;
            }
        }
        catch (TransformerConfigurationException tce) {
            if (super.getErrorListener() == null) throw tce;
            try {
                super.getErrorListener().fatalError(tce);
                return null;
            }
            catch (TransformerException te) {
                tce = new TransformerConfigurationException(te);
            }
            throw tce;
        }
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        DebugTransformerHandler dth = (DebugTransformerHandler)((Object)super.newTransformerHandler(templates));
        return dth;
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new DebugStylesheetHandler(this, this.m_stylesheetMgr);
    }

    public synchronized Templates newTemplates(Source source) throws TransformerConfigurationException {
        String possibleURI;
        this.m_source = source;
        if (this.m_stylesheetMgr == null) {
            this.m_stylesheetMgr = new DebugDocumentManager();
        }
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        if (source instanceof StreamSource) {
            possibleURI = source.getSystemId();
            possibleURI = possibleURI == null || possibleURI.length() == 0 ? DebugDocumentManager.getURIforXSLfromStream() : "copiedStream:input.xsl";
            this.m_source = DebugTransformerImpl.StreamSource2String((StreamSource)source, outBytes, possibleURI);
            this.m_sourceBytes = outBytes.toByteArray();
        } else {
            DebugDocument doc;
            DOMSource asDOMSource;
            Node n;
            possibleURI = source.getSystemId();
            if (possibleURI == null && source instanceof DOMSource && (n = (asDOMSource = (DOMSource)source).getNode()) instanceof DeferredDocumentImpl) {
                DeferredDocumentImpl xercesNode = (DeferredDocumentImpl)n;
                possibleURI = xercesNode.getDocumentURI();
            }
            if (possibleURI == null || possibleURI.length() == 0) {
                possibleURI = source instanceof DOMSource ? DebugDocumentManager.getURIforXSLfromDOM() : DebugDocumentManager.getURIforXSLfromSAX();
            }
            this.m_source = DebugTransformerImpl.DomSaxSource2StreamSource(source, outBytes, possibleURI);
            if (this.m_stylesheetMgr == null) {
                this.m_stylesheetMgr = new DebugDocumentManager();
            }
            if ((doc = this.m_stylesheetMgr.getDocument(possibleURI)) == null) {
                String sourceSysId;
                this.m_sourceIsGenerated = true;
                doc = this.m_stylesheetMgr.newDocument(possibleURI, true);
                doc.setSerializedDocumentContents(outBytes.toString());
                if (possibleURI != null && !"".equals(possibleURI) && ((sourceSysId = source.getSystemId()) == null || "".equals(sourceSysId))) {
                    this.m_stylesheetMgr.registerDocument("", doc);
                    this.setAlternateSourceURI(possibleURI);
                }
            }
            this.m_sourceBytes = outBytes.toByteArray();
        }
        Templates t = super.newTemplates(this.m_source);
        DebugStylesheetRoot root = this.getDebugStylesheetRoot(t);
        root.setStylesheetManager(this.m_stylesheetMgr);
        this.m_source = null;
        this.m_stylesheetMgr = null;
        return t;
    }

    Source getSource() {
        return this.m_source;
    }

    byte[] getSourceBytes() {
        return this.m_sourceBytes;
    }

    boolean sourceIsGenerated() {
        return this.m_sourceIsGenerated;
    }

    private DebugStylesheetRoot getDebugStylesheetRoot(Object obj) {
        DebugStylesheetRoot root = null;
        if (obj != null) {
            if (obj instanceof DebugStylesheetRoot) {
                root = (DebugStylesheetRoot)((Object)obj);
            } else {
                Class<?> klass = obj.getClass();
                String classname = obj.getClass().getName();
                if ("org.apache.xalan.templates.StylesheetRootProxy".equals(classname)) {
                    try {
                        Method m = klass.getMethod("getStylesheetRoot", null);
                        root = (DebugStylesheetRoot)((Object)m.invoke(obj, null));
                    }
                    catch (Exception exception) {
                        root = null;
                    }
                }
            }
        }
        if (root == null) {
            String msg = XDIMessage.getFormattedString("INTERNAL_TEMPLATE_NOT_DEBUGGABLE");
            throw new RuntimeException(msg);
        }
        return root;
    }

    private void setAlternateSourceURI(String alt) {
        this.m_alternateSourceURI = alt;
    }

    String getAlternateSourceURI() {
        return this.m_alternateSourceURI;
    }
}

