/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.jaxp.xalan.interpreted;

import com.ibm.debug.transform.impl.DebugDocumentManager;
import com.ibm.debug.transform.impl.DebugTraceListener;
import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerImpl;
import com.ibm.debug.xdi.messages.XDIMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.xalan.transformer.TransformerHandlerImpl;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.ToXMLStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DebugTransformerHandler
extends TransformerHandlerImpl {
    private SerializationHandler m_handler = null;
    private ByteArrayOutputStream m_outBytes = new ByteArrayOutputStream();
    private boolean m_done = false;
    private String m_baseSystemID;
    public static final String s_setDTDEntityExpansion = "setDTDEntityExpansion";
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";
    static /* synthetic */ Class class$0;

    public DebugTransformerHandler(TransformerImpl transformer, boolean doFragment, String baseSystemID) {
        super(transformer, doFragment, baseSystemID);
        this.m_handler = new ToXMLStream();
        this.m_handler.setOutputFormat(OutputPropertiesFactory.getDefaultMethodProperties((String)"xml"));
        this.m_handler.setOutputStream((OutputStream)this.m_outBytes);
        DebugTransformerHandler.turnOffSerializerDTDEntityExpansion(this.m_handler);
    }

    private static void turnOffSerializerDTDEntityExpansion(SerializationHandler sh) {
        try {
            Class[] paramTypes = new Class[]{Boolean.TYPE};
            Method m = sh.getClass().getMethod(s_setDTDEntityExpansion, paramTypes);
            if (m != null) {
                Object[] params = new Object[]{new Boolean(false)};
                m.invoke((Object)sh, params);
            }
        }
        catch (Exception exception) {}
    }

    public void setDocumentLocator(Locator arg0) {
        if (this.m_done) {
            super.setDocumentLocator(arg0);
        } else {
            this.m_handler.setDocumentLocator(arg0);
            if (this.m_baseSystemID == null) {
                this.m_baseSystemID = arg0.getSystemId();
            }
        }
    }

    public void startDocument() throws SAXException {
        if (this.m_done) {
            super.startDocument();
        } else {
            this.m_handler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.m_done) {
            super.endDocument();
        } else {
            this.m_handler.endDocument();
            this.m_done = true;
            ByteArrayInputStream inBytes = new ByteArrayInputStream(this.m_outBytes.toByteArray());
            XMLReader reader = XMLReaderFactory.createXMLReader();
            InputSource inputSource = new InputSource(inBytes);
            if (this.m_baseSystemID == null || this.m_baseSystemID.equals("")) {
                this.m_baseSystemID = DebugDocumentManager.getURIforXMLfromSAX();
            }
            DebugTraceListener dtl = ((DebugTransformerImpl)((Object)super.getTransformer())).getTraceListener();
            DebugDocument doc = dtl.getTraceDocManager().newDocument(this.m_baseSystemID, true);
            doc.setSerializedDocumentContents(this.m_outBytes.toString());
            inputSource.setSystemId(this.m_baseSystemID);
            reader.setContentHandler((ContentHandler)((Object)this));
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this);
            reader.setDTDHandler((DTDHandler)((Object)this));
            reader.setProperty("http://xml.org/sax/properties/declaration-handler", (Object)this);
            try {
                reader.parse(inputSource);
            }
            catch (IOException iOException) {
                String msg = XDIMessage.getFormattedString("ER_PARSE_STYLESHEET_DOC", this.m_baseSystemID);
                XDIMessage.issueMessage(msg);
            }
        }
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        if (this.m_done) {
            super.startPrefixMapping(arg0, arg1);
        } else {
            this.m_handler.startPrefixMapping(arg0, arg1);
        }
    }

    public void endPrefixMapping(String arg0) throws SAXException {
        if (this.m_done) {
            super.endPrefixMapping(arg0);
        } else {
            this.m_handler.endPrefixMapping(arg0);
        }
    }

    public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
        if (this.m_done) {
            super.startElement(arg0, arg1, arg2, arg3);
        } else {
            this.m_handler.startElement(arg0, arg1, arg2, arg3);
        }
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        if (this.m_done) {
            super.endElement(arg0, arg1, arg2);
        } else {
            this.m_handler.endElement(arg0, arg1, arg2);
        }
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.m_done) {
            super.characters(arg0, arg1, arg2);
        } else {
            this.m_handler.characters(arg0, arg1, arg2);
        }
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.m_done) {
            super.ignorableWhitespace(arg0, arg1, arg2);
        } else {
            this.m_handler.ignorableWhitespace(arg0, arg1, arg2);
        }
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
        if (this.m_done) {
            super.processingInstruction(arg0, arg1);
        } else {
            this.m_handler.processingInstruction(arg0, arg1);
        }
    }

    public void skippedEntity(String arg0) throws SAXException {
        if (this.m_done) {
            super.skippedEntity(arg0);
        } else {
            this.m_handler.skippedEntity(arg0);
        }
    }

    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.m_done) {
            super.comment(arg0, arg1, arg2);
        } else {
            this.m_handler.comment(arg0, arg1, arg2);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.m_done) {
            super.endCDATA();
        } else {
            this.m_handler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.m_done) {
            super.endDTD();
        } else {
            this.m_handler.endDTD();
        }
    }

    public void endEntity(String arg0) throws SAXException {
        if (this.m_done) {
            super.endEntity(arg0);
        } else {
            this.m_handler.endEntity(arg0);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.m_done) {
            super.startCDATA();
        } else {
            this.m_handler.startCDATA();
        }
    }

    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        if (this.m_done) {
            super.startDTD(arg0, arg1, arg2);
        } else {
            this.m_handler.startDTD(arg0, arg1, arg2);
        }
    }

    public void startEntity(String arg0) throws SAXException {
        if (this.m_done) {
            super.startEntity(arg0);
        } else {
            this.m_handler.startEntity(arg0);
        }
    }

    public void attributeDecl(String arg0, String arg1, String arg2, String arg3, String arg4) throws SAXException {
        if (this.m_done) {
            super.attributeDecl(arg0, arg1, arg2, arg3, arg4);
        } else {
            this.m_handler.attributeDecl(arg0, arg1, arg2, arg3, arg4);
        }
    }

    public void elementDecl(String arg0, String arg1) throws SAXException {
        if (this.m_done) {
            super.elementDecl(arg0, arg1);
        } else {
            this.m_handler.elementDecl(arg0, arg1);
        }
    }

    public void externalEntityDecl(String arg0, String arg1, String arg2) throws SAXException {
        if (this.m_done) {
            super.externalEntityDecl(arg0, arg1, arg2);
        } else {
            this.m_handler.externalEntityDecl(arg0, arg1, arg2);
        }
    }

    public void internalEntityDecl(String arg0, String arg1) throws SAXException {
        if (this.m_done) {
            super.internalEntityDecl(arg0, arg1);
        } else {
            this.m_handler.internalEntityDecl(arg0, arg1);
        }
    }

    public void notationDecl(String arg0, String arg1, String arg2) throws SAXException {
        if (this.m_done) {
            super.notationDecl(arg0, arg1, arg2);
        } else if (this.m_handler instanceof DTDHandler) {
            SerializationHandler h = this.m_handler;
            h.notationDecl(arg0, arg1, arg2);
        }
    }

    public void unparsedEntityDecl(String arg0, String arg1, String arg2, String arg3) throws SAXException {
        if (this.m_done) {
            super.unparsedEntityDecl(arg0, arg1, arg2, arg3);
        } else if (this.m_handler instanceof DTDHandler) {
            SerializationHandler h = this.m_handler;
            h.unparsedEntityDecl(arg0, arg1, arg2, arg3);
        }
    }
}

