/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.jaxp.xalan.interpreted;

import com.ibm.debug.transform.impl.DebugDocumentManager;
import com.ibm.debug.transform.impl.DebugEngineManager;
import com.ibm.debug.transform.impl.DebugSerializationHandler;
import com.ibm.debug.transform.impl.DebugSession;
import com.ibm.debug.transform.impl.DebugTraceListener;
import com.ibm.debug.transform.impl.EventPacket;
import com.ibm.debug.transform.impl.TemplateLocationManager;
import com.ibm.debug.transform.intrface.DebugDocument;
import com.ibm.debug.transform.intrface.DebugResultDocument;
import com.ibm.debug.xdi.impl.XDIExitEventImpl;
import com.ibm.debug.xdi.impl.XDITransformCreateEventImpl;
import com.ibm.debug.xdi.impl.XDITransformTerminateEventImpl;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugStylesheetRoot;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerFactory;
import com.ibm.debug.xdi.jaxp.xalan.interpreted.DebugTransformerHandler;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.CanonicalURI;
import com.ibm.debug.xdi.util.ThreadInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TooManyListenersException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xml.dtm.DTM;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.serializer.ToUnknownStream;
import org.apache.xml.serializer.ToXMLSAXHandler;
import org.apache.xml.serializer.ToXMLStream;
import org.apache.xml.utils.SystemIDResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DebugTransformerImpl
extends TransformerImpl {
    private DebugSession m_debugSession;
    private boolean m_startTransform_was_sent = false;
    private int m_transformerID = -1;
    private ContentHandler m_debugTransformerHandler;
    private DebugTraceListener m_traceListener;
    private final String m_mainStylesheetURIName;
    private final DebugDocumentManager m_stylesheetDocManger;
    private AttachWaitThread m_AttachWaitThread = null;
    private final DebugTransformerFactory m_debugTransformerFactory = m_factory;
    private static DebugTransformerFactory m_factory;
    private final int m_dbgId = this.nextDbgId();
    private static volatile int dbgId;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    DebugTransformerImpl(StylesheetRoot stylesheet) {
        super(stylesheet);
        String mainStylesheetURIName = null;
        if (!(stylesheet instanceof DebugStylesheetRoot)) {
            this.m_stylesheetDocManger = null;
            String msg = XDIMessage.getFormattedString("INTERNAL_INCONSISTENT_JAXP", stylesheet.getSystemId());
            XDIMessage.issueMessage(msg);
        } else {
            String sourceURI;
            DebugDocumentManager styleSheetDocManager;
            DebugStylesheetRoot dsr = (DebugStylesheetRoot)stylesheet;
            this.m_stylesheetDocManger = styleSheetDocManager = dsr.getStylesheetManager();
            this.m_traceListener = new DebugTraceListener();
            mainStylesheetURIName = sourceURI = ((DebugStylesheetRoot)stylesheet).getSystemId();
            String sourceDocument = ((DebugStylesheetRoot)stylesheet).getSourceDocument();
            if (sourceURI != null) {
                DebugDocument doc = null;
                if (styleSheetDocManager != null) {
                    this.m_traceListener.setStyleSheetManager(styleSheetDocManager);
                    doc = styleSheetDocManager.getDocument(sourceURI);
                }
                if (doc != null && doc.isGenerated()) {
                    String contents = doc.generatedFile();
                    DebugDocument newDoc = styleSheetDocManager.newDocument(sourceURI, true);
                    newDoc.setSerializedDocumentContents(contents);
                } else {
                    boolean generated = ((DebugStylesheetRoot)stylesheet).isGenerated();
                    doc = styleSheetDocManager.newDocument(sourceURI, generated);
                    doc.setSerializedDocumentContents(sourceDocument);
                }
            }
            boolean generatedSource = this.m_debugTransformerFactory == null ? false : this.m_debugTransformerFactory.sourceIsGenerated();
            Hashtable sourceHash = ((DebugStylesheetRoot)stylesheet).getSourceDocumentHash();
            Enumeration e2 = sourceHash.keys();
            while (e2.hasMoreElements()) {
                sourceURI = (String)e2.nextElement();
                if (sourceURI == null || (sourceDocument = new String((byte[])sourceHash.get(sourceURI))) == null) continue;
                DebugDocument doc = styleSheetDocManager.newDocument(sourceURI, generatedSource);
                doc.setSerializedDocumentContents(sourceDocument);
            }
        }
        this.m_mainStylesheetURIName = mainStylesheetURIName;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
        String uri;
        this.attachToAdapter();
        String resultTreeURI = outputTarget.getSystemId();
        if (resultTreeURI != null) {
            DebugDocumentManager mgr = this.m_traceListener.getTraceDocManager();
            mgr.setPrimaryResultDocURI(resultTreeURI);
        }
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        boolean generated = false;
        boolean isSAXSource = false;
        boolean isStreamSource = false;
        boolean isEmptyDOM = false;
        if (xmlSource instanceof StreamSource) {
            isStreamSource = true;
            xmlSource = DebugTransformerImpl.StreamSource2String((StreamSource)xmlSource, outBytes, "copiedStream:input.xml");
            generated = false;
        } else if (xmlSource instanceof DOMSource) {
            uri = DebugDocumentManager.getURIforXMLfromDOM();
            if (!this.DOMIsEmpty((DOMSource)xmlSource)) {
                xmlSource = DebugTransformerImpl.DomSaxSource2StreamSource(xmlSource, outBytes, uri);
                xmlSource.setSystemId(uri);
                generated = true;
            } else {
                isEmptyDOM = true;
            }
        } else if (xmlSource instanceof SAXSource) {
            isSAXSource = true;
            uri = DebugDocumentManager.getURIforXMLfromSAX();
            xmlSource = DebugTransformerImpl.DomSaxSource2StreamSource(xmlSource, outBytes, uri);
            xmlSource.setSystemId(uri);
            generated = true;
        }
        String urlOfSource = xmlSource.getSystemId();
        if ((isSAXSource || isStreamSource) && urlOfSource != null) {
            try {
                String abs;
                urlOfSource = abs = SystemIDResolver.getAbsoluteURI((String)urlOfSource);
            }
            catch (Exception exception) {}
        }
        DebugDocument doc = this.m_traceListener.getTraceDocManager().newDocument(urlOfSource, generated);
        doc.setSerializedDocumentContents(outBytes.toString());
        if (!isEmptyDOM) {
            doc.createNodesFromSerializedXML();
        }
        if (!this.m_startTransform_was_sent) {
            this.m_startTransform_was_sent = this.startTransform();
        }
        try {
            try {
                super.transform(xmlSource, outputTarget);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (TransformerException e3) {
                throw e3;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.endTransform();
            this.detachFromAdapter();
            throw throwable;
        }
        {
            Object var11_15 = null;
            this.endTransform();
            this.detachFromAdapter();
            return;
        }
    }

    private boolean DOMIsEmpty(DOMSource ds) {
        Node node = ds.getNode();
        boolean empty = node instanceof Document && ((Document)node).getDocumentElement() == null;
        return empty;
    }

    private boolean startTransform() {
        boolean was_sent;
        if (this.m_debugSession != null) {
            int transformId;
            this.m_transformerID = transformId = this.m_debugSession.addTransformer(this, this.m_traceListener);
            Thread thread = Thread.currentThread();
            this.m_debugSession.setJavaThread(transformId, thread);
            this.m_traceListener.setId(transformId);
            String altURI = null;
            if (this.m_debugTransformerFactory != null) {
                altURI = this.m_debugTransformerFactory.getAlternateSourceURI();
            }
            this.m_traceListener.setTemplateLocationManager(new TemplateLocationManager((DebugStylesheetRoot)this.getStylesheet(), this.m_traceListener, altURI));
            if (this.m_debugSession.isSuspended()) {
                this.m_traceListener.suspendTransform(false);
            }
            EventPacket ep = new EventPacket();
            ep.addEvent(new XDITransformCreateEventImpl(null));
            was_sent = this.m_traceListener.sendEventPacket(ep, null);
        } else {
            was_sent = false;
        }
        return was_sent;
    }

    private void endTransform() {
        EventPacket ep;
        this.m_traceListener.getTransformerThreadId();
        if (this.m_debugSession.getEntryExitMode() && this.m_traceListener.entryEventWasSent()) {
            ep = new EventPacket();
            ep.addEvent(new XDIExitEventImpl(null));
            this.m_traceListener.sendEventPacket(ep, null);
            this.m_traceListener.setEntryEventWasSent(false);
        }
        ep = new EventPacket();
        ep.addEvent(new XDITransformTerminateEventImpl(null));
        this.m_traceListener.sendEventPacket(ep, null);
        this.m_debugSession.suspendTransformation(this.m_transformerID);
        this.m_startTransform_was_sent = false;
    }

    public SerializationHandler createSerializationHandler(Result outputTarget, OutputProperties format) throws TransformerException {
        SerializationHandler handler2 = super.createSerializationHandler(outputTarget, format);
        if (handler2 != null && !(handler2 instanceof DebugSerializationHandler)) {
            DebugResultDocument doc;
            String targetSystemID;
            ToXMLStream xmlStream = null;
            if (!(handler2 instanceof ToStream) && !(handler2 instanceof ToUnknownStream)) {
                xmlStream = new ToXMLStream();
                xmlStream.setIndent(true);
                xmlStream.setWriter(null);
            }
            if ((targetSystemID = outputTarget.getSystemId()) == null) {
                String uri;
                DebugDocumentManager mgr = this.m_traceListener.getTraceDocManager();
                targetSystemID = uri = mgr.getPrimaryResultDocURI();
            }
            if ((doc = this.m_traceListener.getTraceDocManager().getResultDocument(targetSystemID)) == null) {
                doc = this.m_traceListener.getTraceDocManager().newResultDocument(targetSystemID);
            }
            doc.setSerializer((Serializer)handler2);
            handler2 = new DebugSerializationHandler((SerializationHandler)xmlStream, handler2, doc.getUniqueId());
        }
        handler2.setTransformer((Transformer)((Object)this));
        StylesheetRoot srcLocator = this.getStylesheet();
        handler2.setSourceLocator((SourceLocator)srcLocator);
        return handler2;
    }

    public void setContentHandler(ContentHandler handler2) {
        if (handler2 == null) {
            super.setContentHandler(handler2);
        } else {
            super.setContentHandler(handler2);
            ToXMLStream xmlStream = new ToXMLStream();
            xmlStream.setWriter((Writer)new NullWriter());
            DebugSerializationHandler h = new DebugSerializationHandler((SerializationHandler)xmlStream, (SerializationHandler)new ToXMLSAXHandler());
            h.setContentHandler(handler2);
            h.setTransformer((Transformer)((Object)this));
            this.setSerializationHandler(h);
        }
    }

    public int transformToGlobalRTF(ElemTemplateElement templateParent) throws TransformerException {
        this.m_traceListener.setProcessingRequest(true);
        int ret = super.transformToGlobalRTF(templateParent);
        this.m_traceListener.setProcessingRequest(false);
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int transformToRTF(ElemTemplateElement templateParent, DTM dtmFrag) throws TransformerException {
        int resultFragment;
        this.getXPathContext();
        ContentHandler rtfHandler = dtmFrag.getContentHandler();
        SerializationHandler savedRTreeHandler = this.getSerializationHandler();
        ToXMLStream xmlStream = new ToXMLStream();
        xmlStream.setWriter(null);
        DebugSerializationHandler h = new DebugSerializationHandler((SerializationHandler)xmlStream, (SerializationHandler)new ToXMLSAXHandler());
        h.setContentHandler(rtfHandler);
        h.setTransformer((Transformer)((Object)this));
        h.setOmitXMLDeclaration(true);
        this.setSerializationHandler(h);
        SerializationHandler rth = this.getSerializationHandler();
        try {
            try {
                rth.startDocument();
                rth.flushPending();
                this.m_debugSession.pushRTF(this.m_traceListener.getTransformerThreadId(), templateParent, dtmFrag.getDocument());
                try {
                    this.executeChildTemplates(templateParent, true);
                    rth.flushPending();
                    resultFragment = dtmFrag.getDocument();
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    rth.endDocument();
                    throw throwable;
                }
                {
                    Object var9_11 = null;
                    rth.endDocument();
                }
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.setSerializationHandler(savedRTreeHandler);
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        this.setSerializationHandler(savedRTreeHandler);
        this.m_debugSession.popRTF(this.m_traceListener.getTransformerThreadId());
        return resultFragment;
    }

    public String transformToString(ElemTemplateElement elem) throws TransformerException {
        this.m_debugSession.pushRTF(this.m_traceListener.getTransformerThreadId(), null, -1);
        String result = super.transformToString(elem);
        this.m_debugSession.popRTF(this.m_traceListener.getTransformerThreadId());
        return result;
    }

    public ContentHandler getInputContentHandler() {
        return this.getInputContentHandler(false);
    }

    public ContentHandler getInputContentHandler(boolean doDocFrag) {
        if (this.m_debugTransformerHandler == null) {
            this.m_debugTransformerHandler = new DebugTransformerHandler(this, doDocFrag, this.getBaseURLOfSource());
        }
        return this.m_debugTransformerHandler;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.attachToAdapter();
        if (!this.m_startTransform_was_sent) {
            this.m_startTransform_was_sent = this.startTransform();
        }
        try {
            super.run();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.endTransform();
            this.detachFromAdapter();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.endTransform();
            this.detachFromAdapter();
            return;
        }
    }

    public DebugTraceListener getTraceListener() {
        return this.m_traceListener;
    }

    static StreamSource StreamSource2String(StreamSource originalXMLSource, ByteArrayOutputStream outBytes, String possibleURI) {
        String msg_system_id = originalXMLSource.getSystemId();
        try {
            if (originalXMLSource.getInputStream() != null) {
                byte[] byteArray = new byte[1024];
                int len = 0;
                do {
                    if ((len = originalXMLSource.getInputStream().read(byteArray)) <= 0) continue;
                    outBytes.write(byteArray, 0, len);
                } while (len > 0);
            } else if (originalXMLSource.getReader() != null) {
                Reader reader = originalXMLSource.getReader();
                String xmlString = DebugTransformerImpl.extractString(reader);
                try {
                    String enc = DebugTransformerImpl.getEncodingFromXML(xmlString);
                    if (enc == null) {
                        DebugTransformerImpl.assumingUTF8Message(originalXMLSource);
                        enc = "UTF-8";
                    }
                    outBytes.write(xmlString.getBytes(enc));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        DebugTransformerImpl.assumingUTF8Message(originalXMLSource);
                        outBytes.write(xmlString.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException2) {}
                }
            } else if (originalXMLSource.getSystemId() != null) {
                String expandedSystemId = XMLEntityManager.expandSystemId((String)originalXMLSource.getSystemId(), null, (boolean)false);
                URL url = new URL(expandedSystemId);
                InputStream inputStream = url.openStream();
                byte[] byteArray = new byte[1024];
                int len = 0;
                do {
                    if ((len = inputStream.read(byteArray)) <= 0) continue;
                    outBytes.write(byteArray, 0, len);
                } while (len > 0);
            }
            String systemId = originalXMLSource.getSystemId();
            if (originalXMLSource.getSystemId() == null || originalXMLSource.getSystemId().equals("")) {
                systemId = possibleURI;
            }
            StreamSource newXMLSource = new StreamSource(new ByteArrayInputStream(outBytes.toByteArray()), systemId);
            return newXMLSource;
        }
        catch (IOException iOException) {
            String msg = XDIMessage.getFormattedString("ER_PARSE_XML_DOC", msg_system_id);
            XDIMessage.issueMessage(msg);
            return null;
        }
    }

    static Source DomSaxSource2StreamSource(Source xmlSource, ByteArrayOutputStream outBytes, String possibleURI) {
        String msg;
        InputSource is;
        EntityResolver resolver;
        SAXSource sax;
        XMLReader reader;
        if (xmlSource instanceof SAXSource && (reader = (sax = (SAXSource)xmlSource).getXMLReader()) != null && (resolver = reader.getEntityResolver()) != null && (is = sax.getInputSource()) != null) {
            InputStream ibs = is.getByteStream();
            Reader charStream = is.getCharacterStream();
            if (charStream != null) {
                String s = DebugTransformerImpl.extractString(charStream);
                ByteArrayInputStream bais = null;
                try {
                    String enc = DebugTransformerImpl.getEncodingFromXML(s);
                    if (enc == null) {
                        DebugTransformerImpl.assumingUTF8Message(xmlSource);
                        enc = "UTF-8";
                    }
                    bais = new ByteArrayInputStream(s.getBytes(enc));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bais = null;
                }
                if (bais == null) {
                    try {
                        DebugTransformerImpl.assumingUTF8Message(xmlSource);
                        bais = new ByteArrayInputStream(s.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                DebugTransformerImpl.extractBytes(bais, outBytes);
                StringReader sr = new StringReader(s);
                is.setCharacterStream(sr);
                return xmlSource;
            }
            if (ibs != null) {
                DebugTransformerImpl.extractBytes(ibs, outBytes);
                ByteArrayInputStream bais = new ByteArrayInputStream(outBytes.toByteArray());
                is.setByteStream(bais);
                return xmlSource;
            }
            String id = is.getSystemId();
            if (id != null && id.length() > 0) {
                try {
                    URL location = new URL(id);
                    URLConnection connection = location.openConnection();
                    InputStream stream = connection.getInputStream();
                    DebugTransformerImpl.extractBytes(stream, outBytes);
                    return xmlSource;
                }
                catch (Exception e2) {
                    String msg2 = XDIMessage.getFormattedString("INTERNAL_PSEUDO_FILE", id);
                    XDIMessage.issueMessage(msg2);
                    msg2 = e2.toString();
                    XDIMessage.issueMessage(msg2);
                }
            }
        }
        StreamResult streamResult = new StreamResult(outBytes);
        TransformerFactory tf = TransformerFactory.newInstance();
        String originalSystemId = xmlSource.getSystemId();
        boolean noOriginalSystemId = originalSystemId == null || "".equals(originalSystemId);
        String msg_systemid = noOriginalSystemId ? possibleURI : originalSystemId;
        try {
            Transformer trans = tf.newTransformer();
            trans.transform(xmlSource, streamResult);
            String systemId = originalSystemId;
            if (systemId == null || systemId.equals("")) {
                systemId = possibleURI;
            }
            systemId = CanonicalURI.getCanonicalURI(systemId);
            StreamSource newXMLSource = new StreamSource(new ByteArrayInputStream(outBytes.toByteArray()), systemId);
            if (noOriginalSystemId) {
                newXMLSource.setSystemId(originalSystemId);
            }
            return newXMLSource;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            msg = XDIMessage.getFormattedString("INTERNAL_PSEUDO_FILE", msg_systemid);
            XDIMessage.issueMessage(msg);
        }
        catch (TransformerException transformerException) {
            msg = XDIMessage.getFormattedString("INTERNAL_PSEUDO_FILE", msg_systemid);
            XDIMessage.issueMessage(msg);
        }
        return null;
    }

    private static void assumingUTF8Message(Source xmlSource) {
        String msg3;
        String id = xmlSource.getSystemId();
        if (id != null && id.length() > 0) {
            String msg2 = XDIMessage.getFormattedString("INTERNAL_PSEUDO_FILE", id);
            XDIMessage.issueMessage(msg2);
            msg3 = "The XSLT debugger is assuming an encoding of UTF-8 for the input XML document, '" + id + "', being transformed.";
        } else {
            msg3 = "The XSLT debugger is assuming an encoding of UTF-8 for the input XML document being transformed.";
        }
        XDIMessage.issueMessage(msg3);
    }

    private static void extractBytes(InputStream ibs, ByteArrayOutputStream outBytes) {
        byte[] buff = new byte[4000];
        try {
            int numBytes;
            while ((numBytes = ibs.read(buff)) > 0) {
                outBytes.write(buff, 0, numBytes);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String extractString(Reader charStream) {
        char[] cbuff = new char[4000];
        StringBuffer sb = new StringBuffer();
        try {
            int numChars;
            while ((numChars = charStream.read(cbuff)) > 0) {
                sb.append(cbuff, 0, numChars);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        String s = sb.toString();
        return s;
    }

    private static String getEncodingFromXML(String xmlsource) {
        int end;
        String enc = null;
        if (xmlsource.startsWith("<?xml") && (end = xmlsource.indexOf("?>")) > 0) {
            String v = null;
            int encoding = xmlsource.indexOf("encoding=\"");
            int delim = 0;
            if (encoding > 0 && encoding < end) {
                v = xmlsource.substring(encoding + 10, end);
                delim = 34;
            } else {
                encoding = xmlsource.indexOf("encoding='");
                if (encoding > 0 && encoding < end) {
                    v = xmlsource.substring(encoding + 10, end);
                    delim = 39;
                }
            }
            if (delim != 0) {
                int closingQuot = v.indexOf(delim);
                if (closingQuot > 0) {
                    enc = v.substring(0, closingQuot);
                }
            } else {
                enc = "UTF-8";
            }
        }
        return enc;
    }

    public String getStylesheetURIName() {
        return this.m_mainStylesheetURIName;
    }

    public int transformToRTF(ElemTemplateElement templateParent) throws TransformerException {
        DTM dtmFrag = this.getXPathContext().getRTFDTM();
        return this.transformToRTF(templateParent, dtmFrag);
    }

    private void attachToAdapter() {
        this.m_debugSession = DebugEngineManager.getSingleton().createDebugSession();
        Object socket_or_wait_object = DebugEngineManager.getSingleton().getSocketOrWaitObject();
        if (socket_or_wait_object instanceof Socket) {
            Socket socket = (Socket)socket_or_wait_object;
            this.m_debugSession.attachSocket(socket);
        } else if (socket_or_wait_object != null) {
            AttachWaitThread wait_thread;
            Object wait_object = socket_or_wait_object;
            this.m_AttachWaitThread = wait_thread = new AttachWaitThread(wait_object);
            wait_thread.startThread();
        }
        if (this.m_debugSession != null) {
            if (this.m_traceListener == null) {
                this.m_traceListener = new DebugTraceListener();
            }
            this.m_traceListener.setDebugSession(this.m_debugSession);
            this.m_traceListener.setStyleSheetManager(this.m_stylesheetDocManger);
            try {
                this.getTraceManager().addTraceListener((TraceListener)this.m_traceListener);
            }
            catch (TooManyListenersException e2) {
                e2.printStackTrace();
            }
        }
    }

    private void detachFromAdapter() {
        this.killAttachWaitThread();
        this.m_debugSession.removeTransformer(this.m_transformerID);
        this.m_debugSession = null;
        if (this.m_traceListener != null) {
            this.getTraceManager().removeTraceListener((TraceListener)this.m_traceListener);
            this.m_traceListener = null;
        }
    }

    private void killAttachWaitThread() {
        if (this.m_AttachWaitThread != null) {
            this.m_AttachWaitThread.stopThread();
            this.m_AttachWaitThread = null;
        }
    }

    static void setDebugTransformerFactory(DebugTransformerFactory dtf) {
        m_factory = dtf;
    }

    private synchronized int nextDbgId() {
        return ++dbgId;
    }

    private class AttachWaitThread
    implements Runnable,
    ThreadInterface {
        final Object m_WaitObject;
        private boolean m_isDaemon = true;
        private final Thread m_myThread;

        public AttachWaitThread(Object waitObject) {
            this.m_WaitObject = waitObject;
            this.setDaemonThread(true);
            this.m_myThread = new Thread(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.m_WaitObject;
            synchronized (object) {
                try {
                    Thread.currentThread().setName("Thread waiting to attach to debug session " + DebugTransformerImpl.this.m_debugSession.getDebugSessionID());
                    this.m_WaitObject.wait();
                    Object obj = DebugEngineManager.getSingleton().getSocketOrWaitObject();
                    if (obj instanceof Socket) {
                        Socket socket = (Socket)obj;
                        DebugTransformerImpl.this.m_debugSession.attachSocket(socket);
                        if (!DebugTransformerImpl.this.m_startTransform_was_sent) {
                            DebugTransformerImpl.this.m_startTransform_was_sent = DebugTransformerImpl.this.startTransform();
                        }
                    } else {
                        System.out.println("Error: DebugTransformerImpl#" + DebugTransformerImpl.this.m_dbgId + " was woken to attach" + " but no Socket was provided");
                    }
                }
                catch (InterruptedException interruptedException) {}
                return;
            }
        }

        public void stopThread() {
            this.m_myThread.interrupt();
        }

        public void startThread() {
            this.m_myThread.setDaemon(this.m_isDaemon);
            this.m_myThread.start();
        }

        public void setDaemonThread(boolean b) {
            this.m_isDaemon = b;
        }

        public boolean isAliveThread() {
            boolean alive = this.m_myThread.isAlive();
            return alive;
        }
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(int c) throws IOException {
        }

        public void write(char[] cbuf) throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void write(String str) throws IOException {
        }

        public void write(String str, int off, int len) throws IOException {
        }
    }
}

