/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.messages;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class XDIMessage {
    private static ResourceBundle m_resourceBundle = null;
    private static final String RESOURCE_BUNDLE = "com.ibm.debug.xdi.messages.XDIMessages";
    private static final String RESOURCE_BUNDLE_ERROR = "Internal Error, XDIMessage could not load the messages from com.ibm.debug.xdi.messages.XDIMessages";
    public static final String ER_CLEAR_STEP_WHEN_TERMINATED = "ER_CLEAR_STEP_WHEN_TERMINATED";
    public static final String ER_DISC_WHEN_TERMINATED = "ER_DISC_WHEN_TERMINATED";
    public static final String ER_EXPR_EVAL = "ER_EXPR_EVAL";
    public static final String ER_EXPR_EVAL_WHEN_TERMINATED = "ER_EXPR_EVAL_WHEN_TERM";
    public static final String ER_GET_MAIN_DOC_SRC_URI_WHEN_TERMINATED = "ER_GET_MAIN_DOC_SRC_URI_WHEN_TERMINATED";
    public static final String ER_GET_MAIN_DOC_SRC_WHEN_TERMINATED = "ER_GET_MAIN_DOC_SRC_WHEN_TERMINATED";
    public static final String ER_GET_STACK = "ER_GET_STACK";
    public static final String ER_GET_STACK_WHEN_TERMINATED = "ER_GET_STACK_WHEN_TERM";
    public static final String ER_GET_STACK_WHEN_NOT_SUSPENDED = "ER_GET_STACK_WHEN_NOT_SUSPENDED";
    public static final String ER_GET_THREAD_NAME = "ER_GET_THREAD_NAME";
    public static final String ER_GET_THREAD_NAME_WHEN_TERMINATED = "ER_GET_THREAD_NAME_WHEN_TERMINATED";
    public static final String ER_INVALID_STACK_FRAME = "ER_INVALID_STACK_FRAME";
    public static final String ER_IS_SUSPENDED_FAILED = "ER_IS_SUSPENDED_FAILED";
    public static final String ER_INTERRUPTED_SUSPEND = "ER_INTERRUPTED_SUSPEND";
    public static final String ER_INTERRUPTED_FETCH_THREAD_NAME = "ER_INTERRUPTED_FETCH_THREAD_NAME";
    public static final String ER_INTERRUPTED_GENEERATING_FILE = "ER_INTERRUPTED_GENEERATING_FILE";
    public static final String ER_INTERRUPTED_GET_DOC_TYPE = "ER_INTERRUPTED_GET_DOC_TYPE";
    public static final String ER_INTERRUPTED_IS_SUSPENDED = "ER_INTERRUPTED_IS_SUSPENDED";
    public static final String ER_INTERRUPTED_WAITING_EXPR_EVAL = "ER_INTERRUPT_WAITING__FOR_EXPR_EVAL";
    public static final String ER_INTURRUPTED_WAITING_FOR_FRAMES = "ER_INTURRUPTED_WAITING_FOR_FRAMES";
    public static final String ER_RESUME_WHEN_TERMINATED = "ER_RESUME_WHEN_TERMINATED";
    public static final String ER_SUSPEND_WHEN_TERMINATED = "ER_SUSPEND_WHEN_TERMINATED";
    public static final String ER_SUSPEND_FAILED = "ER_SUSPEND_FAILED";
    public static final String ER_SUSPEND_IMMEDIATE_FAILED = "ER_SUSPEND_IMMEDIATE_FAILED";
    public static final String ER_GET_VERSION_WHEN_TERMINATED = "ER_GET_VERSION_WHEN_TERMINATED";
    public static final String ER_GET_PRODUCT_WHEN_TERMINATED = "ER_GET_PRODUCT_WHEN_TERMINATED";
    public static final String ER_TERM_WHEN_TERMINATED = "ER_TERM_WHEN_TERMINATED";
    public static final String ER_MESSAGE_NOT_FOUND = "ER_MESSAGE_NOT_FOUND";
    public static final String ER_DOMSRC_HAS_NO_SYSTEMID = "ER_DOMSRC_HAS_NO_SYSTEMID";
    public static final String NORMAL_DISCONNECT = "NORMAL_DISCONNECT";
    public static final String ER_UNABLE_TO_LOCATE_XML_DOC = "ER_UNABLE_TO_LOCATE_XML_DOC";
    public static final String ER_PARSE_XML_DOC = "ER_PARSE_XML_DOC";
    public static final String ER_GET_ABS_URI = "ER_GET_ABS_URI";
    public static final String ER_SOCKET_CONNECT_HOST = "ER_SOCKET_CONNECT_HOST";
    public static final String ER_SOCKET_CONNECT = "ER_SOCKET_CONNECT";
    public static final String ER_PORT_NOT_INTEGER = "ER_PORT_NOT_INTEGER";
    public static final String ER_SETTING_SOCKET = "ER_SETTING_SOCKET";
    public static final String ER_STARTING_SOCKET_THREAD = "ER_STARTING_SOCKET_THREAD";
    public static final String ER_COULD_NOT_RESUME_TRANS = "ER_COULD_NOT_RESUME_TRANS";
    public static final String ER_COULD_NOT_SUSPEND_TRANS = "ER_COULD_NOT_SUSPEND_TRANS";
    public static final String ER_FAIL_VARIABLE_EVAL = "ER_FAIL_VARIABLE_EVAL";
    public static final String ER_XPATH_REPRESENTATION = "ER_XPATH_REPRESENTATION";
    public static final String ER_CREATE_BREAKPOINT = "ER_CREATE_BREAKPOINT";
    public static final String ER_DELETE_BREAKPOINT = "ER_DELETE_BREAKPOINT";
    public static final String ER_ENABLE_BREAKPOINT = "ER_ENABLE_BREAKPOINT";
    public static final String ER_INVALID_TRANID = "ER_INVALID_TRANID";
    public static final String ER_STEP_PENDING = "ER_STEP_PENDING";
    public static final String ER_NPE_IN_TRAN = "ER_NPE_IN_TRAN";
    public static final String ER_FETCH_CHILD_NODES_ID = "ER_FETCH_CHILD_NODES_ID";
    public static final String ER_FETCH_CHILD_NODES_NPE = "ER_FETCH_CHILD_NODES_NPE";
    public static final String ER_RESUME_TRAN = "ER_RESUME_TRAN";
    public static final String ER_ALREADY_STEP_PENDING = "ER_ALREADY_STEP_PENDING";
    public static final String INTERNAL_CLEAR_PENDING_STEP = "INTERNAL_CLEAR_PENDING_STEP";
    public static final String INTERNAL_GET_THREADNAME = "INTERNAL_GET_THREADNAME";
    public static final String INTERNAL_GET_THREADGROUPNAME = "INTERNAL_GET_THREADGROUPNAME";
    public static final String ER_GET_SHEET_URI = "ER_GET_SHEET_URI";
    public static final String ER_GET_PROCESSOR_NAME = "ER_GET_PROCESSOR_NAME";
    public static final String INTERNAL_SET_STEP_REQUEST = "INTERNAL_SET_STEP_REQUEST";
    public static final String INTERNAL_CLEAR_STEP_REQUEST = "INTERNAL_CLEAR_STEP_REQUEST";
    public static final String INTERNAL_EXCEPTION_STACK = "INTERNAL_EXCEPTION_STACK";
    public static final String INTERNAL_CONTEXT_POSITION = "INTERNAL_CONTEXT_POSITION";
    public static final String ER_PROCESS_INCLUDE = "ER_PROCESS_INCLUDE";
    public static final String ER_RESOLVE_HREF = "ER_RESOLVE_HREF";
    public static final String INTERNAL_BAD_STACKFRAME = "INTERNAL_BAD_STACKFRAME";
    public static final String ER_RESOLVE_URI = "ER_RESOLVE_URI";
    public static final String INTERNAL_BAD_MESSAGE_FORMAT = "INTERNAL_BAD_MESSAGE_FORMAT";
    public static final String ER_NO_SYSTEM_ID = "ER_NO_SYSTEM_ID";
    public static final String ER_PARSE_STYLESHEET_DOC = "ER_PARSE_STYLESHEET_DOC";
    public static final String INTERNAL_INCONSISTENT_JAXP = "INTERNAL_INCONSISTENT_JAXP";
    public static final String INTERNAL_PSEUDO_FILE = "INTERNAL_PSEUDO_FILE";
    public static final String ER_SOCKET_EXCEPTION_WRITE = "ER_SOCKET_EXCEPTION_WRITE";
    public static final String ER_SOCKET_EXCEPTION_READ = "ER_SOCKET_EXCEPTION_READ";
    public static final String INTERNAL_TEMPLATE_NOT_DEBUGGABLE = "INTERNAL_TEMPLATE_NOT_DEBUGGABLE";
    public static final String ER_SERVER_SOCKET_PORT = "ER_SERVER_SOCKET_PORT";
    public static final String ER_WRONG_XSL_PROCESSOR = "ER_WRONG_XSL_PROCESSOR";
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    private XDIMessage() {
    }

    public static String getFormattedString(String key) {
        return XDIMessage.getResourceString(key);
    }

    public static String getFormattedString(String key, String arg) {
        String string = XDIMessage.getResourceString(key);
        return MessageFormat.format(string, arg);
    }

    public static String getFormattedString(String key, String[] args) {
        String string = XDIMessage.getResourceString(key);
        return MessageFormat.format(string, args);
    }

    private static String getResourceString(String key) {
        String retval;
        if (m_resourceBundle == null) {
            m_resourceBundle = XDIMessage.getResourceBundle();
        }
        if (m_resourceBundle != null) {
            retval = m_resourceBundle.getString(key);
            if (retval == null) {
                retval = m_resourceBundle.getString(ER_MESSAGE_NOT_FOUND);
                retval = retval == null ? "Couldn't find the message to say that the message with key " + key + " was not found" : String.valueOf(retval) + " : " + key;
            }
        } else {
            retval = "Internal Error, XDIMessage could not load the messages from com.ibm.debug.xdi.messages.XDIMessages : " + key;
        }
        return retval;
    }

    private static ResourceBundle getResourceBundle() {
        try {
            return ResourceBundle.getBundle(RESOURCE_BUNDLE);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(RESOURCE_BUNDLE_ERROR);
            return null;
        }
    }

    public static String getFormattedString2(String key, String arg1, String arg2) {
        String string = XDIMessage.getResourceString(key);
        return MessageFormat.format(string, arg1, arg2);
    }

    public static String getFormattedString3(String key, String arg1, String arg2, String arg3) {
        String string = XDIMessage.getResourceString(key);
        return MessageFormat.format(string, arg1, arg2, arg3);
    }

    public static void issueMessage(String msg) {
        System.out.println(msg);
    }
}

