/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.util;

import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class CanonicalURI {
    private static final CanonicalURI m_nullURI;
    private static final boolean m_filenamesAreCaseSensitive;
    private static final String CANONICAL_SEPARATOR = "/";
    private static Hashtable m_String2URI;
    private final String m_canonicalURI;
    private final boolean m_isAbsolute;
    private CanonicalURI m_otherAbsoluteURI = null;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    static {
        m_String2URI = new Hashtable();
        String lineSep = System.getProperty("line.separator");
        m_filenamesAreCaseSensitive = lineSep.length() != 2;
        m_nullURI = new CanonicalURI("");
        m_String2URI.put("", m_nullURI);
    }

    public final String getURIString() {
        return this.m_canonicalURI;
    }

    public final CanonicalURI getAbsouluteURI() {
        return this.m_otherAbsoluteURI;
    }

    public final void setAbsouluteURI(CanonicalURI abs) {
        this.m_otherAbsoluteURI = abs;
    }

    private CanonicalURI() {
        this.m_canonicalURI = null;
        this.m_isAbsolute = false;
    }

    private CanonicalURI(String uriString) {
        this.m_canonicalURI = uriString;
        this.m_isAbsolute = uriString.startsWith("file:") || uriString.startsWith("ftp:") || uriString.startsWith("http:") || CanonicalURI.hasScheme(uriString);
    }

    private static boolean hasScheme(String uriString) {
        int colon = uriString.indexOf(58);
        if (colon >= 1) {
            int i = 0;
            while (i < colon) {
                char ch = uriString.charAt(i);
                if (!('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || i > 0 && ('0' <= ch && ch <= '9' || ch == '+' || ch == '-' || ch == '.'))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static CanonicalURI getInstance(String uriString) {
        if (uriString == null) {
            return m_nullURI;
        }
        CanonicalURI uri = (CanonicalURI)m_String2URI.get(uriString);
        if (uri == null) {
            String key;
            int colonIndex = CanonicalURI.hasScheme(uriString) ? uriString.indexOf(58) : -1;
            String normalizedURIString = String.valueOf(uriString.substring(0, colonIndex + 1)) + URLDecoder.decode(uriString.substring(colonIndex + 1));
            if (uriString != null && !m_filenamesAreCaseSensitive && normalizedURIString.startsWith("file:///")) {
                char[] chars = normalizedURIString.toCharArray();
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < chars.length) {
                    char ch = chars[i];
                    if (ch == '\\') {
                        sb.append('/');
                    } else {
                        sb.append(ch);
                    }
                    ++i;
                }
                normalizedURIString = sb.toString();
            }
            if (normalizedURIString.startsWith("file:///") && !m_filenamesAreCaseSensitive) {
                Enumeration list = m_String2URI.keys();
                while (list.hasMoreElements()) {
                    key = (String)list.nextElement();
                    if (!key.equalsIgnoreCase(normalizedURIString)) continue;
                    uri = (CanonicalURI)m_String2URI.get(key);
                    m_String2URI.put(uriString, uri);
                    break;
                }
            } else {
                uri = (CanonicalURI)m_String2URI.get(normalizedURIString);
            }
            if (uri == null) {
                uri = new CanonicalURI(normalizedURIString);
                Enumeration keys = m_String2URI.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    CanonicalURI previousURI = (CanonicalURI)m_String2URI.get(key);
                    if (previousURI.isRelativeUriOf(uri)) {
                        previousURI.setAbsouluteURI(uri);
                    }
                    if (!uri.isRelativeUriOf(previousURI)) continue;
                    uri.setAbsouluteURI(previousURI);
                }
                m_String2URI.put(uriString, uri);
                m_String2URI.put(normalizedURIString, uri);
            }
        }
        return uri;
    }

    public static String getCanonicalURI(String uri) {
        CanonicalURI canonicalURI = CanonicalURI.getInstance(uri);
        return canonicalURI.getURIString();
    }

    public final boolean isRelativeUriOf(CanonicalURI absoluteURI) {
        boolean relative;
        if (this.isAbsoluteURI() || !absoluteURI.isAbsoluteURI() || this.getURIString().length() == 0) {
            relative = false;
        } else {
            String absUriString;
            String myUriString = this.getURIString();
            if (myUriString.charAt(0) != '/') {
                myUriString = CANONICAL_SEPARATOR + myUriString;
            }
            if (CanonicalURI.hasScheme(absUriString = absoluteURI.getURIString()) && (absUriString = absUriString.substring(absUriString.indexOf(58) + 1)).charAt(0) != '/') {
                absUriString = CANONICAL_SEPARATOR + absUriString;
            }
            relative = m_filenamesAreCaseSensitive ? absUriString.endsWith(myUriString) : absUriString.toLowerCase().endsWith(myUriString.toLowerCase());
        }
        return relative;
    }

    private boolean isAbsoluteURI() {
        boolean ret = this.m_isAbsolute;
        return ret;
    }

    private boolean isAbsoluteURI(String uriString) {
        boolean ret;
        if (uriString.startsWith("file:") || uriString.startsWith("http:") || uriString.startsWith("ftp:")) {
            ret = true;
        } else {
            boolean abs = false;
            int i = 0;
            while (i < uriString.length()) {
                char c = uriString.charAt(i);
                if (!('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z')) {
                    if (c == ':') {
                        if (i <= 0 || i + 1 >= uriString.length()) break;
                        abs = true;
                        break;
                    }
                    abs = false;
                    break;
                }
                ++i;
            }
            ret = abs;
        }
        return ret;
    }
}

