/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.apache.xalan.trace.TracerEvent;

public class DbgTrace {
    public static final boolean ADAPTER_TRAN = false;
    public static final boolean ENGINE_TRACE_LISTENER = false;
    public static final boolean TEST_ATTACH = false;
    public static final boolean THREAD = false;
    public static final boolean BREAKPOINT = false;
    public static final boolean SOCKETS = false;
    public static final boolean SOCKET_WRITER = false;
    public static final boolean SOCKET_LISTENER = false;
    public static final boolean DEBUG_SESSION = false;
    public static final boolean ENGINE_MGR = false;
    public static final boolean ENGINE_MESSAGES = false;
    public static final boolean ADAPTER_MESSAGES = false;
    public static final boolean ENGINE_NODE_LOC = false;
    public static final boolean ADAPTER_TRAN_MGR = false;
    public static final boolean ADAPTER_ENGINE_MGR = false;
    public static final boolean DOCUMENTS = false;
    public static final boolean ENGINE_DOC = false;
    public static final boolean ADAPTER_DOC = false;
    public static final boolean ENGINE_TRANSFORMER_IMPL = false;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public static void println(String s) {
        DbgTrace.print(s);
        System.out.println("");
        System.out.flush();
    }

    public static void print(String s) {
        Thread thread = Thread.currentThread();
        int depth = thread.countStackFrames();
        int i = 0;
        while (i < depth) {
            System.out.print("..");
            ++i;
        }
        System.out.print("DBG> ");
        System.out.print(s);
        System.out.flush();
    }

    public static synchronized void printStack(String msg) {
        Thread thread = Thread.currentThread();
        thread.countStackFrames();
        DbgTrace.println("---- STACK TRACE -------------------------------------------");
        DbgTrace.println(msg);
        RuntimeException re = new RuntimeException();
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        re.printStackTrace(pw);
        pw.flush();
        StringBuffer sb = w.getBuffer();
        String s = sb.toString();
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            String stackLine = st.nextToken();
            if (stackLine.indexOf("java.lang.RuntimeException") >= 0 || stackLine.indexOf("DbgTrace.printStack") >= 0) continue;
            int cr = stackLine.indexOf(13);
            if (cr >= 0) {
                stackLine = stackLine.substring(0, cr);
            }
            DbgTrace.println(stackLine);
        }
        System.out.flush();
    }

    private static String caller(int depth) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        RuntimeException re = new RuntimeException();
        re.printStackTrace(pw);
        pw.flush();
        StringBuffer buff = sw.getBuffer();
        String ret = buff.toString();
        int len = buff.length();
        int dep = 0;
        int first = -1;
        int last = -1;
        int i = 0;
        while (i < len) {
            char c = buff.charAt(i);
            if (c == ' ') {
                first = i + 1;
                if (++dep == depth) {
                    last = first + 1;
                    while (last < len && buff.charAt(last) != '\r') {
                        ++last;
                    }
                    break;
                }
            }
            ++i;
        }
        ret = first >= 0 && first < last && last < len ? buff.substring(first, last) : "";
        return ret;
    }

    public static void assert2(boolean b, String msg) {
        if (!b) {
            DbgTrace.println("assert failed: " + msg);
            DbgTrace.printStack(msg);
        }
    }

    private DbgTrace() {
    }

    public static String toDbgString(TracerEvent ev) {
        int type = ev.m_styleNode.getXSLToken();
        String val = "*** UNDEFINED ***";
        switch (type) {
            case -1: {
                val = "*** UNDEFINED ***";
                break;
            }
            case 2: {
                val = "XSL:WITHPARAM";
                break;
            }
            case 4: {
                val = "XSL:ADDATTRIBUTE";
                break;
            }
            case 22: {
                val = "XSL:ANCHOR";
                break;
            }
            case 50: {
                val = "XSL:APPLY_TEMPLATES";
                break;
            }
            case 34: {
                val = "XSL:USE";
                break;
            }
            case 6: {
                val = "XSL:CHILDREN";
                break;
            }
            case 37: {
                val = "XSL:CHOOSE";
                break;
            }
            case 59: {
                val = "XSL:COMMENT";
                break;
            }
            case 7: {
                val = "XSL:CONSTRUCT";
                break;
            }
            case 8: {
                val = "XSL:CONTENTS";
                break;
            }
            case 9: {
                val = "XSL:COPY";
                break;
            }
            case 74: {
                val = "XSL:COPY_OF";
                break;
            }
            case 83: {
                val = "XSL:DECIMALFORMAT";
                break;
            }
            case 40: {
                val = "XSL:DEFINEATTRIBUTESET";
                break;
            }
            case 11: {
                val = "XSL:DEFINESCRIPT";
                break;
            }
            case 12: {
                val = "XSL:DISPLAYIF";
                break;
            }
            case 14: {
                val = "XSL:EMPTY";
                break;
            }
            case 15: {
                val = "XSL:EVAL";
                break;
            }
            case 16: {
                val = "XSL:EXPECTEDCHILDREN";
                break;
            }
            case 54: {
                val = "XSL:EXTENSION";
                break;
            }
            case 63: {
                val = "XSL:EXTENSIONHANDLER";
                break;
            }
            case 28: {
                val = "XSL:FOREACH";
                break;
            }
            case 31: {
                val = "XSL:KEY";
                break;
            }
            case 36: {
                val = "XSL:IF";
                break;
            }
            case 26: {
                val = "";
                break;
            }
            case 27: {
                val = "XSL:INCLUDE";
                break;
            }
            case 17: {
                val = "XSL:CALLTEMPLATE";
                break;
            }
            case 41: {
                val = "XSL:PARAMVARIABLE";
                break;
            }
            case 35: {
                val = "XSL:NUMBER";
                break;
            }
            case 84: {
                val = "XSL:NSALIAS";
                break;
            }
            case 39: {
                val = "XSL:OTHERWISE";
                break;
            }
            case 58: {
                val = "XSL:PI";
                break;
            }
            case 33: {
                val = "XSL:PRESERVESPACE";
                break;
            }
            case 5: {
                val = "XSL:REMOVEATTRIBUTE";
                break;
            }
            case 19: {
                val = "XSL:TEMPLATE";
                break;
            }
            case 64: {
                val = "XSL:SORT";
                break;
            }
            case 32: {
                val = "XSL:STRIPSPACE";
                break;
            }
            case 25: {
                val = "XSL:STYLESHEET";
                break;
            }
            case 42: {
                val = "XSL:TEXT";
                break;
            }
            case 30: {
                val = "XSL:VALUEOF";
                break;
            }
            case 38: {
                val = "XSL:WHEN";
                break;
            }
            case 44: {
                val = "XSL:ROOT";
                break;
            }
            case 45: {
                val = "XSL:ANY";
                break;
            }
            case 46: {
                val = "XSL:ELEMENT";
                break;
            }
            case 47: {
                val = "XSL:TARGETELEMENT";
                break;
            }
            case 48: {
                val = "XSL:ATTRIBUTE";
                break;
            }
            case 49: {
                val = "XSL:TARGETATTRIBUTE";
                break;
            }
            case 52: {
                val = "XSL:URL";
                break;
            }
            case 55: {
                val = "XSL:CALL";
                break;
            }
            case 57: {
                val = "XSL:FALLBACK";
                break;
            }
            case 60: {
                val = "XSL:TARGETPI";
                break;
            }
            case 61: {
                val = "XSL:TARGETCOMMENT";
                break;
            }
            case 62: {
                val = "XSL:TARGETTEXT";
                break;
            }
            case 65: {
                val = "XSL:CSSSTYLECONVERSION";
                break;
            }
            case 66: {
                val = "XSL:COUNTER";
                break;
            }
            case 67: {
                val = "XSL:COUNTERS";
                break;
            }
            case 68: {
                val = "XSL:COUNTERINCREMENT";
                break;
            }
            case 69: {
                val = "XSL:COUNTERRESET";
                break;
            }
            case 71: {
                val = "XSL:COUNTERSCOPE";
                break;
            }
            case 72: {
                val = "XSL:APPLY_IMPORTS";
                break;
            }
            case 73: {
                val = "XSL:VARIABLE";
                break;
            }
            case 75: {
                val = "XSL:MESSAGE";
                break;
            }
            case 76: {
                val = "XSL:LOCALE";
                break;
            }
            case 77: {
                val = "XSL:LITERALRESULT";
                break;
            }
            case 78: {
                val = "XSL:TEXTLITERALRESULT";
                break;
            }
            case 79: {
                val = "XSL:EXTENSIONCALL";
                break;
            }
            case 85: {
                val = "XSL:EXTENSIONDECL";
                break;
            }
            case 86: {
                val = "XSL:EXTENSIONSCRIPT";
                break;
            }
            case 80: {
                val = "XSL:OUTPUT";
                break;
            }
            case 81: {
                val = "XSL:COMPONENT";
                break;
            }
            case 82: {
                val = "XSL:SCRIPT";
            }
        }
        return val;
    }
}

