/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.util;

import java.lang.reflect.Method;
import java.util.Hashtable;

public class SignatureGenerator {
    private static Hashtable m_typeEncodingHash = new Hashtable();
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    static {
        m_typeEncodingHash.put("boolean", "Z");
        m_typeEncodingHash.put("byte", "B");
        m_typeEncodingHash.put("char", "C");
        m_typeEncodingHash.put("short", "S");
        m_typeEncodingHash.put("int", "I");
        m_typeEncodingHash.put("long", "J");
        m_typeEncodingHash.put("float", "F");
        m_typeEncodingHash.put("double", "D");
        m_typeEncodingHash.put("void", "V");
    }

    public static String generate(Method method2) {
        StringBuffer sb = new StringBuffer("(");
        int i = 0;
        while (i < method2.getParameterTypes().length) {
            sb.append(SignatureGenerator.generate(method2.getParameterTypes()[i]));
            ++i;
        }
        sb.append(')');
        sb.append(SignatureGenerator.generate(method2.getReturnType()));
        return sb.toString();
    }

    public static String generate(Class cl) {
        StringBuffer sb = new StringBuffer();
        if (cl.isArray()) {
            sb.append(cl.getName());
        } else if (m_typeEncodingHash.get(cl.getName()) != null) {
            sb.append((String)m_typeEncodingHash.get(cl.getName()));
        } else {
            sb.append("L" + cl.getName().replace('.', '/') + ";");
        }
        return sb.toString();
    }
}

