/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.util;

import com.ibm.debug.xdi.impl.DebugPacket;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.FragmentingDataInputStream;
import com.ibm.debug.xdi.util.SocketManager;
import com.ibm.debug.xdi.util.SocketUtil;
import com.ibm.debug.xdi.util.ThreadInterface;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SocketListener
implements Runnable,
ThreadInterface {
    private final int m_debugSessionID;
    private Thread m_thread;
    private boolean m_RunListener = true;
    private boolean m_daemonThread = false;
    private SocketManager m_parent = null;
    private FragmentingDataInputStream m_in = null;
    private List m_readQueue = Collections.synchronizedList(new LinkedList());
    private RequestDispatcher m_requestProcessor = null;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public SocketListener(SocketManager parent2, Socket socket, int debugSessionID) throws IOException {
        this.m_in = new FragmentingDataInputStream(socket.getInputStream());
        this.m_debugSessionID = debugSessionID;
        this.m_parent = parent2;
    }

    public void run() {
        String thread_name = SocketUtil.SOCKET_LISTENER;
        if (this.m_debugSessionID > 0) {
            thread_name = String.valueOf(thread_name) + " for XSLT session " + this.m_debugSessionID;
        }
        Thread.currentThread().setName(thread_name);
        this.m_requestProcessor = new RequestDispatcher();
        this.m_requestProcessor.startThread();
        byte[] header2 = new byte[8];
        while (this.keepRunning()) {
            try {
                DebugPacket packet = DebugPacket.debugPacketRead(this.m_in, header2);
                int messageType = packet.getMessageType();
                switch (messageType) {
                    case -102: 
                    case 101: {
                        this.m_parent.replyReceived(packet);
                        break;
                    }
                    case 100: {
                        this.m_readQueue.add(packet);
                    }
                }
                Thread.sleep(10L, 0);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            catch (Exception e2) {
                this.m_parent.listenExceptionReceived(e2);
                break;
            }
        }
        this.m_requestProcessor.stopThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keepRunning() {
        boolean ret;
        SocketListener socketListener = this;
        synchronized (socketListener) {
            ret = this.m_RunListener;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        SocketListener socketListener = this;
        synchronized (socketListener) {
            this.m_RunListener = false;
        }
        this.m_requestProcessor.stopThread();
        this.m_thread.interrupt();
    }

    public void startThread() {
        this.m_thread = new Thread(this);
        this.m_thread.setDaemon(this.m_daemonThread);
        this.m_thread.start();
    }

    public boolean isAliveThread() {
        boolean alive = this.m_thread.isAlive();
        return alive;
    }

    public void setDaemonThread(boolean b) {
        this.m_daemonThread = b;
        if (this.m_thread != null) {
            this.m_thread.setDaemon(b);
        }
    }

    private class RequestDispatcher
    implements Runnable,
    ThreadInterface {
        private Thread m_dispatcher;
        private boolean m_daemonDispatcherThread = false;
        private boolean m_KeepDispatcherRunning = true;

        private RequestDispatcher() {
        }

        public void run() {
            String thr_name = SocketUtil.REQUEST_DISPATCHER;
            if (SocketListener.this.m_debugSessionID > 0) {
                thr_name = String.valueOf(thr_name) + " for XSLT session " + SocketListener.this.m_debugSessionID;
            }
            Thread.currentThread().setName(thr_name);
            while (this.keepRunning()) {
                try {
                    if (!SocketListener.this.m_readQueue.isEmpty()) {
                        DebugPacket packet = (DebugPacket)SocketListener.this.m_readQueue.get(0);
                        SocketListener.this.m_parent.requestReceived(packet);
                        SocketListener.this.m_readQueue.remove(0);
                    }
                    Thread.sleep(10L, 0);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (Exception e2) {
                    String s = e2.toString();
                    XDIMessage.getFormattedString("ER_SOCKET_EXCEPTION_READ", s);
                }
            }
        }

        public void startThread() {
            this.m_dispatcher = new Thread(this);
            this.m_dispatcher.setDaemon(this.m_daemonDispatcherThread);
            this.m_dispatcher.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopThread() {
            RequestDispatcher requestDispatcher = this;
            synchronized (requestDispatcher) {
                this.m_KeepDispatcherRunning = false;
            }
            this.m_dispatcher.interrupt();
        }

        public void setDaemonThread(boolean b) {
            this.m_daemonDispatcherThread = b;
            if (this.m_dispatcher != null) {
                this.m_dispatcher.setDaemon(b);
            }
        }

        public boolean isAliveThread() {
            boolean alive = this.m_dispatcher.isAlive();
            return alive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean keepRunning() {
            boolean ret;
            RequestDispatcher requestDispatcher = this;
            synchronized (requestDispatcher) {
                ret = this.m_KeepDispatcherRunning;
            }
            return ret;
        }
    }
}

