/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xdi.util;

import com.ibm.debug.xdi.impl.DebugPacket;
import com.ibm.debug.xdi.messages.XDIMessage;
import com.ibm.debug.xdi.util.FragmentingDataOutputStream;
import com.ibm.debug.xdi.util.SocketManager;
import com.ibm.debug.xdi.util.SocketUtil;
import com.ibm.debug.xdi.util.ThreadInterface;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SocketWriter
implements Runnable,
ThreadInterface {
    private final int m_debugSessionID;
    private Thread m_thread;
    private boolean m_daemonThread = false;
    private FragmentingDataOutputStream m_out = null;
    private List m_writeQueue = Collections.synchronizedList(new LinkedList());
    private SocketManager m_parent = null;
    private boolean m_keepRunning = true;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public SocketWriter(SocketManager parent2, Socket socket, int debugSessionID) throws IOException {
        this.m_parent = parent2;
        this.m_debugSessionID = debugSessionID;
        this.m_out = new FragmentingDataOutputStream(socket.getOutputStream());
    }

    public void run() {
        String thread_name = SocketUtil.SOCKET_WRITER;
        if (this.m_debugSessionID > 0) {
            thread_name = String.valueOf(thread_name) + " for XSLT session " + this.m_debugSessionID;
        }
        Thread.currentThread().setName(thread_name);
        byte[] header2 = new byte[8];
        while (this.keepRunning()) {
            try {
                if (!this.m_writeQueue.isEmpty()) {
                    DebugPacket packet = (DebugPacket)this.m_writeQueue.get(0);
                    packet.debugPacketWrite(this.m_out, header2);
                    this.m_writeQueue.remove(0);
                    this.m_out.flush();
                }
                Thread.sleep(10L, 0);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            catch (IOException ioe) {
                this.m_parent.writeExceptionReceived(ioe);
                break;
            }
            catch (Exception e2) {
                String s = e2.toString();
                String msg = XDIMessage.getFormattedString("ER_SOCKET_EXCEPTION_WRITE", s);
                XDIMessage.issueMessage(msg);
            }
        }
        this.m_parent.threadRunHasEnded();
    }

    public void send(DebugPacket packet) {
        this.m_writeQueue.add(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        SocketWriter socketWriter = this;
        synchronized (socketWriter) {
            this.m_keepRunning = false;
        }
        this.m_thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keepRunning() {
        boolean ret;
        SocketWriter socketWriter = this;
        synchronized (socketWriter) {
            ret = this.m_keepRunning;
        }
        return ret;
    }

    public void startThread() {
        this.m_thread = new Thread(this);
        this.m_thread.setDaemon(this.m_daemonThread);
        this.m_thread.start();
    }

    public void setDaemonThread(boolean b) {
        this.m_daemonThread = b;
        if (this.m_thread != null) {
            this.m_thread.setDaemon(b);
        }
    }

    public boolean isAliveThread() {
        boolean alive = this.m_thread.isAlive();
        return alive;
    }
}

