/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xslt.commpacket;

import com.ibm.debug.xslt.commpacket.Packet;
import java.util.StringTokenizer;

public class PacketLineBreakPoint
extends Packet {
    private final String m_data;
    private final String m_docURI;
    private final int m_lineNumber;
    private final int m_charStart;
    private final int m_charEnd;
    private final boolean m_setEnable;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public PacketLineBreakPoint(String uri, int lineNumber, int charStart, int charEnd, boolean setEnable) {
        this.m_docURI = uri;
        this.m_lineNumber = lineNumber;
        this.m_charStart = charStart;
        this.m_charEnd = charEnd;
        this.m_setEnable = setEnable;
        StringBuffer data = new StringBuffer();
        data.append(uri).append(",").append(lineNumber).append(",");
        data.append(charStart).append(",").append(charEnd);
        if (setEnable) {
            data.append(",1");
        } else {
            data.append(",0");
        }
        this.m_data = data.toString();
    }

    public PacketLineBreakPoint(String data) {
        this.m_data = data;
        StringTokenizer replyFrame = new StringTokenizer(this.m_data, ",");
        this.m_docURI = replyFrame.nextToken();
        this.m_lineNumber = Integer.parseInt(replyFrame.nextToken());
        this.m_charStart = Integer.parseInt(replyFrame.nextToken());
        this.m_charEnd = Integer.parseInt(replyFrame.nextToken());
        String enable = replyFrame.nextToken();
        this.m_setEnable = "1".equals(enable);
    }

    public String getDocURI() {
        return this.m_docURI;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public int getCharStart() {
        return this.m_charStart;
    }

    public int getCharEnd() {
        return this.m_charEnd;
    }

    public boolean getEnable() {
        return this.m_setEnable;
    }

    public String getData() {
        return this.m_data;
    }
}

