/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xslt.commpacket;

import com.ibm.debug.xslt.commpacket.Packet;
import java.util.StringTokenizer;

public class PacketResultDocUpdate
extends Packet {
    private final String m_data;
    private String m_docURI = null;
    private int m_docId;
    private boolean m_isGenerated;
    private boolean m_isCurrent;
    private String m_outputMethod;
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2004. All rights reserved.";

    public PacketResultDocUpdate(String data) {
        this.m_data = data;
        this.populate();
    }

    public PacketResultDocUpdate(String absoluteURI, int uniqueDocId, boolean isGenerated, boolean isCurrent, String outputMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append(absoluteURI);
        sb.append(",");
        sb.append(uniqueDocId);
        sb.append(isGenerated ? ",1" : ",0");
        sb.append(isCurrent ? ",1" : ",0");
        sb.append(",");
        sb.append(outputMethod);
        this.m_data = sb.toString();
    }

    private void populate() {
        StringTokenizer replyFrame = new StringTokenizer(this.m_data, ",");
        this.m_docURI = replyFrame.nextToken();
        if ("#".equals(this.m_docURI)) {
            return;
        }
        this.m_docId = Integer.parseInt(replyFrame.nextToken());
        int generated = Integer.parseInt(replyFrame.nextToken());
        this.m_isGenerated = generated == 1;
        int current = Integer.parseInt(replyFrame.nextToken());
        this.m_isCurrent = current == 1;
        this.m_outputMethod = replyFrame.nextToken();
    }

    public String getDocURI() {
        return this.m_docURI;
    }

    public boolean getIsGenerated() {
        return this.m_isGenerated;
    }

    public boolean getIsMostRecentlyUpdated() {
        return this.m_isCurrent;
    }

    public int getUniqueDocId() {
        return this.m_docId;
    }

    public String getOutputMethod() {
        return this.m_outputMethod;
    }

    public String getData() {
        return this.m_data;
    }
}

