/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm;

import com.ibm.ejs.cm.CMXAResourceInfo;
import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.cm.portability.MerantPortabilityLayer;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.DestroyXAResourceException;
import com.ibm.ws.Transaction.XAResourceFactory;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.Transaction.XAResourceNotAvailableException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class CMXAResourceFactory
implements XAResourceFactory {
    private static TraceComponent tc = Tr.register(CMXAResourceFactory.class);
    private static Hashtable xaResConnection = new Hashtable();

    public XAResource getXAResource(XAResourceInfo xAResourceInfo) throws XAResourceNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXAResource", xAResourceInfo);
        }
        CMXAResourceInfo cMXAResourceInfo = (CMXAResourceInfo)xAResourceInfo;
        DataSourceProperties dataSourceProperties = cMXAResourceInfo.getDataSourceProperties();
        XADataSource xADataSource = null;
        XAConnection xAConnection = null;
        XAResource xAResource = null;
        Connection connection = null;
        try {
            xADataSource = dataSourceProperties.getXADataSource();
            xAConnection = dataSourceProperties.getProperty("user") == null ? xADataSource.getXAConnection() : xADataSource.getXAConnection(dataSourceProperties.getProperty("user"), dataSourceProperties.getProperty("password"));
            xAResource = xAConnection.getXAResource();
            String string = dataSourceProperties.getDataSourceClassName();
            if (string.startsWith("com.merant.sequelink") || string.startsWith("com.ddtek.jdbcx.sequelink") || string.startsWith("com.ibm.websphere")) {
                connection = xAConnection.getConnection();
                MerantPortabilityLayer.unlockJDBCDriver(connection, string);
            }
        }
        catch (SQLException sQLException) {
            Tr.warning(tc, "WTRN0005_ERR_CREATING_XACONNECTION_AND_XARESOURCE", sQLException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXAResource");
            }
            throw new XAResourceNotAvailableException(sQLException);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        xaResConnection.put(xAResource, xAConnection);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXAResource");
        }
        return xAResource;
    }

    public void destroyXAResource(XAResource xAResource) throws DestroyXAResourceException {
        XAConnection xAConnection;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyXAResource");
        }
        if ((xAConnection = (XAConnection)xaResConnection.get(xAResource)) == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "xacon has already been closed.");
            }
            return;
        }
        try {
            xAConnection.close();
            xaResConnection.remove(xAResource);
        }
        catch (SQLException sQLException) {
            Tr.warning(tc, "WTRN0006_ERR_CLOSING_XA_CONNECTION", new Object[]{xAConnection, sQLException});
            throw new DestroyXAResourceException(sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyXAResource");
        }
    }
}

