/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm;

import com.ibm.ejs.cm.CMProperties;
import com.ibm.ejs.cm.CMPropertiesImpl;
import com.ibm.ejs.cm.CMXAResourceInfo;
import com.ibm.ejs.cm.DSFactory;
import com.ibm.ejs.cm.DataSourceImpl;
import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.cm.JDBC1PhaseRF;
import com.ibm.ejs.cm.JDBC2PhaseRF;
import com.ibm.ejs.cm.JDBCRRSTransactionalRF;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.advanced.cm.factory.CMFactoryException;
import com.ibm.websphere.advanced.cm.factory.DataSourceFactory;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;

public final class DSFactoryImpl
implements DSFactory {
    private static Hashtable dataSources = new Hashtable();
    private static final TraceComponent tc = Tr.register(DSFactoryImpl.class, null, "com.ibm.ejs.resources.CONMMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        Hashtable hashtable = dataSources;
        synchronized (hashtable) {
            Enumeration enumeration = dataSources.elements();
            while (enumeration.hasMoreElements()) {
                ((DataSourceImpl)enumeration.nextElement()).destroy();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DataSource getDataSource(CMProperties cMProperties) throws ClassNotFoundException, CMFactoryException {
        String string = cMProperties.getName();
        DataSource dataSource = (DataSource)dataSources.get(string);
        if (dataSource != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using cached DataSource");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new DataSource");
            }
            dataSource = DSFactoryImpl.createDataSource(cMProperties);
            Hashtable hashtable = dataSources;
            synchronized (hashtable) {
                DataSource dataSource2 = (DataSource)dataSources.get(string);
                if (dataSource2 != null) {
                    dataSource = dataSource2;
                } else {
                    dataSources.put(string, dataSource);
                }
            }
        }
        return dataSource;
    }

    public synchronized DataSource removeDataSource(String string) {
        return (DataSource)dataSources.remove(string);
    }

    private static DataSource createDataSource(CMProperties cMProperties) throws ClassNotFoundException, CMFactoryException {
        DataSourceProperties dataSourceProperties = ((CMPropertiesImpl)cMProperties).getDataSourceProperties();
        String string = dataSourceProperties.getProperty("driverType");
        if (DataSourceFactory.isRRSTransactional(cMProperties, string)) {
            return DSFactoryImpl.createRRSTransactionalDataSource(cMProperties);
        }
        if (DataSourceFactory.isJTAEnabled(cMProperties)) {
            return DSFactoryImpl.create2PhaseDataSource(cMProperties);
        }
        return DSFactoryImpl.create1PhaseDataSource(cMProperties);
    }

    private static DataSource create1PhaseDataSource(CMProperties cMProperties) throws CMFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create1PhaseDataSource", cMProperties);
        }
        JDBC1PhaseRF jDBC1PhaseRF = new JDBC1PhaseRF(cMProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create1PhaseDataSource", jDBC1PhaseRF);
        }
        return jDBC1PhaseRF;
    }

    private static DataSource create2PhaseDataSource(CMProperties cMProperties) throws CMFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create2PhaseDataSource", cMProperties);
        }
        JDBC2PhaseRF jDBC2PhaseRF = new JDBC2PhaseRF(cMProperties);
        DataSourceProperties dataSourceProperties = null;
        Properties properties = ((CMPropertiesImpl)cMProperties).getXaRecoveryCredentials();
        if (properties != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Replacing user and pwd with recovery user and pwd");
            }
            dataSourceProperties = (DataSourceProperties)((CMPropertiesImpl)cMProperties).getDataSourceProperties().clone();
            dataSourceProperties.setProperty("user", (String)properties.get("user"));
            dataSourceProperties.setProperty("password", (String)properties.get("password"));
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No recovery user and password, using default user and password");
            }
            dataSourceProperties = ((CMPropertiesImpl)cMProperties).getDataSourceProperties();
        }
        CMXAResourceInfo cMXAResourceInfo = new CMXAResourceInfo(dataSourceProperties);
        jDBC2PhaseRF.initialize(cMXAResourceInfo, "com.ibm.ejs.cm.CMXAResourceFactory");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create2PhaseDataSource", jDBC2PhaseRF);
        }
        return jDBC2PhaseRF;
    }

    private static DataSource createRRSTransactionalDataSource(CMProperties cMProperties) throws CMFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRRSTransactionalDataSource", cMProperties);
        }
        JDBCRRSTransactionalRF jDBCRRSTransactionalRF = new JDBCRRSTransactionalRF(cMProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRRSTransactionalDataSource", jDBCRRSTransactionalRF);
        }
        return jDBCRRSTransactionalRF;
    }

    public void verifyConfiguration() throws NamingException {
        WebModuleMetaData webModuleMetaData;
        ContainerComponentMetaData containerComponentMetaData = null;
        containerComponentMetaData = (ContainerComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (containerComponentMetaData == null) {
            throw new IllegalStateException("Null ComponentMetaData");
        }
        if (containerComponentMetaData instanceof EJBComponentMetaData) {
            EJBComponentMetaData eJBComponentMetaData = (EJBComponentMetaData)containerComponentMetaData;
            int n = eJBComponentMetaData.getEJBModuleVersion();
            if (n >= 20) {
                Tr.error(tc, "MSG_CONM_7018E" + n);
                NamingException namingException = new NamingException("Attempted to use a 4.0 DataSource in EJB 2.0 or higher Module. Invalid configuration.");
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ejs.DSFactoryImpl.verifyConfiguration", "%c%", this);
                throw namingException;
            }
        } else if (containerComponentMetaData instanceof WebComponentMetaData && (webModuleMetaData = (WebModuleMetaData)containerComponentMetaData.getModuleMetaData()).isServlet23OrHigher()) {
            Tr.error(tc, "MSG_CONM_7019E");
            NamingException namingException = new NamingException("Attempted to use a 4.0 DataSource from a 2.3 (or higher) servlet. Invalid configuration.");
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ejs.DSFactoryImpl.verifyConfiguration", "%c%", this);
            throw namingException;
        }
    }

    public static Enumeration getDataSources() {
        return dataSources == null ? null : dataSources.elements();
    }
}

