/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.security.util.AccessController;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class DataSourceProperties
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8336911552307721517L;
    public static final int DATASOURCE = 1;
    public static final int CONNECTIONPOOL_DATASOURCE = 2;
    public static final int XA_DATASOURCE = 4;
    private String className;
    private transient Class dataSourceClass = null;
    private transient int dataSourceType = 0;
    private Properties props;
    private static final String bundleName = "com.ibm.ejs.resources.CONMMessages";
    private static final TraceComponent tc = Tr.register(DataSourceProperties.class, null, "com.ibm.ejs.resources.CONMMessages");

    public DataSourceProperties() {
        this.props = new Properties();
    }

    public DataSourceProperties(String string, Properties properties) {
        this.setDataSourceClassName(string);
        this.props = properties;
    }

    public String getDataSourceClassName() {
        return this.className;
    }

    public void setDataSourceClassName(String string) {
        this.className = string;
        this.dataSourceClass = null;
        this.dataSourceType = 0;
    }

    public DataSource getDataSource() throws SQLException {
        DataSource dataSource = null;
        try {
            dataSource = (DataSource)this.getGenericDataSource();
        }
        catch (ClassCastException classCastException) {
            Tr.error(tc, "MSG_CONM_7005E", this.className);
            String string = "The class (" + this.className + ") does not implement" + " javax.sql.DataSource";
            throw new SQLException(TraceNLS.getTraceNLS(bundleName).getFormattedMessage("MSG_CONM_7005E", new Object[]{this.className}, string));
        }
        return dataSource;
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = null;
        try {
            connectionPoolDataSource = (ConnectionPoolDataSource)this.getGenericDataSource();
        }
        catch (ClassCastException classCastException) {
            Tr.error(tc, "MSG_CONM_7005E", this.className);
            String string = "The class (" + this.className + ") does not implement" + " javax.sql.ConnectionPoolDataSource";
            throw new SQLException(TraceNLS.getTraceNLS(bundleName).getFormattedMessage("MSG_CONM_7005E", new Object[]{this.className}, string));
        }
        return connectionPoolDataSource;
    }

    public XADataSource getXADataSource() throws SQLException {
        XADataSource xADataSource = null;
        try {
            xADataSource = (XADataSource)this.getGenericDataSource();
        }
        catch (ClassCastException classCastException) {
            Tr.error(tc, "MSG_CONM_7005E", this.className);
            String string = "The class (" + this.className + ") does not implement" + " javax.sql.XADataSource";
            throw new SQLException(TraceNLS.getTraceNLS(bundleName).getFormattedMessage("MSG_CONM_7005E", new Object[]{this.className}, string));
        }
        return xADataSource;
    }

    private Object getGenericDataSource() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGenericDataSource");
        }
        Object object = this.instantiateObject(this.getDataSourceClassName());
        this.setGenericDataSourceProperties(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericDataSource", object);
        }
        return object;
    }

    public int getDataSourceType() throws SQLException {
        if (this.dataSourceType == 0) {
            if (this.dataSourceClass == null) {
                this.loadDataSourceClass();
            }
            if (DataSource.class.isAssignableFrom(this.dataSourceClass)) {
                ++this.dataSourceType;
            }
            if (ConnectionPoolDataSource.class.isAssignableFrom(this.dataSourceClass)) {
                this.dataSourceType += 2;
            }
            if (XADataSource.class.isAssignableFrom(this.dataSourceClass)) {
                this.dataSourceType += 4;
            }
        }
        return this.dataSourceType;
    }

    public Object setProperty(String string, String string2) {
        return this.props.setProperty(string, string2);
    }

    public String getProperty(String string) {
        if (string.equals("password")) {
            return PasswordUtil.passwordDecode(this.props.getProperty(string));
        }
        return this.props.getProperty(string);
    }

    public Enumeration propertyNames() {
        return this.props.propertyNames();
    }

    public Object remove(Object object) {
        return this.props.remove(object);
    }

    public boolean equals(Object object) {
        try {
            DataSourceProperties dataSourceProperties = (DataSourceProperties)object;
            return (this.className == null && dataSourceProperties.className == null || this.className.equals(dataSourceProperties.className)) && this.props.equals(dataSourceProperties.props);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public Object clone() {
        DataSourceProperties dataSourceProperties = null;
        try {
            dataSourceProperties = (DataSourceProperties)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.props != null) {
            dataSourceProperties.props = (Properties)this.props.clone();
        }
        return dataSourceProperties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataSource Properties [" + this.getDataSourceClassName() + "]: {");
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("password")) {
                stringBuffer.append("password=XXXXXXXX");
            } else if (string.equals("tmpPassword")) {
                stringBuffer.append("tmpPassword=XXXXXXXX");
            } else {
                stringBuffer.append(string + "=" + this.props.getProperty(string));
            }
            stringBuffer.append(";");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private Object instantiateObject(String string) throws SQLException {
        Object var2_2 = null;
        if (this.dataSourceClass == null) {
            this.loadDataSourceClass();
        }
        try {
            var2_2 = this.dataSourceClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            Tr.error(tc, "MSG_CONM_7006E", new Object[]{string, "<unknown>", instantiationException});
            throw new SQLException(TraceNLS.getTraceNLS(bundleName).getFormattedMessage("MSG_CONM_7006E", new Object[]{string, "<unknown>", instantiationException}, "MSG_CONM_7006E"));
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.error(tc, "MSG_CONM_7006E", new Object[]{string, "<unknown>", illegalAccessException});
            throw new SQLException(TraceNLS.getTraceNLS(bundleName).getFormattedMessage("MSG_CONM_7006E", new Object[]{string, "<unknown>", illegalAccessException}, "MSG_CONM_7006E"));
        }
        return var2_2;
    }

    private void loadDataSourceClass() throws SQLException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            this.dataSourceClass = classLoader.loadClass(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.error(tc, "MSG_CONM_1006E", new Object[]{this.className, "<unknown>"});
            throw new SQLException(TraceNLS.getTraceNLS(bundleName).getFormattedMessage("MSG_CONM_1006E", new Object[]{this.className, "<unknown>"}, "MSG_CONM_1006E"));
        }
    }

    private void setGenericDataSourceProperties(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGenericDataSourceProperties", object);
        }
        Class<?> clazz = object.getClass();
        PropertyDescriptor[] propertyDescriptorArray = null;
        try {
            propertyDescriptorArray = this.getPropertyDescriptors(clazz);
        }
        catch (IntrospectionException introspectionException) {
            Tr.error(tc, "MSG_CONM_7001E", new Object[]{clazz.getName(), introspectionException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setGenericDataSourceProperties", introspectionException);
            }
            return;
        }
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.props.getProperty(string);
            if (string.equals("tmpUser") || string.equals("tmpPassword") || string2.equals("") || string2 == null) continue;
            this.setProperty(string, string2, object, propertyDescriptorArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setGenericDataSourceProperties");
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class propertyDescriptorArray) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptorArray2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyDescriptors", propertyDescriptorArray);
        }
        BeanInfo beanInfo = null;
        try {
            propertyDescriptorArray2 = propertyDescriptorArray;
            beanInfo = (BeanInfo)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Class)propertyDescriptorArray2){
                private final /* synthetic */ Class val$fc;
                {
                    this.val$fc = clazz;
                }

                public Object run() throws IntrospectionException {
                    return Introspector.getBeanInfo(this.val$fc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IntrospectionException)privilegedActionException.getException();
        }
        propertyDescriptorArray2 = beanInfo.getPropertyDescriptors();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyDescriptors");
        }
        return propertyDescriptorArray2;
    }

    private PropertyDescriptor findPropertyDescriptorFor(String string, PropertyDescriptor[] propertyDescriptorArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findPropertyDescriptorFor", new Object[]{string, propertyDescriptorArray});
        }
        PropertyDescriptor propertyDescriptor = null;
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!propertyDescriptorArray[i].getName().equals(string)) continue;
            propertyDescriptor = propertyDescriptorArray[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findPropertyDescriptorFor", propertyDescriptor);
        }
        return propertyDescriptor;
    }

    private boolean setProperty(String string, String string2, Object object, PropertyDescriptor[] propertyDescriptorArray) {
        if (string == null) {
            return false;
        }
        if (tc.isEntryEnabled()) {
            if (!string.equalsIgnoreCase("password")) {
                Tr.entry(tc, "setProperty", new Object[]{string, string2});
            } else {
                Tr.entry(tc, "setProperty", new Object[]{string, "XXXXXX"});
            }
        }
        Class<?> clazz = object.getClass();
        PropertyDescriptor propertyDescriptor = this.findPropertyDescriptorFor(string, propertyDescriptorArray);
        if (propertyDescriptor == null) {
            Tr.warning(tc, "MSG_CONM_7002W", new Object[]{string, clazz.getName()});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty", "false");
            }
            return false;
        }
        Object object2 = this.convertToDeclaredPropertyType(string2, propertyDescriptor);
        Method method2 = propertyDescriptor.getWriteMethod();
        if (method2 == null) {
            Tr.warning(tc, "MSG_CONM_7003W", new Object[]{string, clazz.getName()});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty", "false");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got write method", method2);
        }
        Object[] objectArray = new Object[]{object2};
        try {
            method2.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.warning(tc, "MSG_CONM_7004W", new Object[]{string, clazz.getName(), illegalAccessException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty", "false");
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Tr.warning(tc, "MSG_CONM_7004W", new Object[]{string, clazz.getName(), illegalArgumentException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty", "false");
            }
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Tr.warning(tc, "MSG_CONM_7004W", new Object[]{string, clazz.getName(), invocationTargetException.getTargetException()});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty", "false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty", "true");
        }
        return true;
    }

    private Object convertToDeclaredPropertyType(String string, PropertyDescriptor propertyDescriptor) {
        Object object;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "convertToDeclaredPropertyType", propertyDescriptor);
            }
            object = string;
            Class<Constable> clazz = propertyDescriptor.getPropertyType();
            if (clazz.isAssignableFrom(String.class)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "convertToDeclaredPropertyType");
                }
                return string;
            }
            Class<?> clazz2 = string.getClass();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GivenPropertyType=" + clazz2.getName() + "; DeclaredPropertyType = " + clazz.getName());
            }
            try {
                if (clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Integer.class)) {
                    object = Integer.valueOf(string);
                } else if (clazz.isAssignableFrom(Boolean.TYPE) || clazz.isAssignableFrom(Boolean.class)) {
                    object = Boolean.valueOf(string);
                } else if (clazz.isAssignableFrom(Properties.class)) {
                    object = this.convertStringToProperties(string);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Conversion to declared method type " + clazz.getName() + " will not occur because class is unknown.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "Attempt to convert property to Integer because the declared method is int/Integer failed", numberFormatException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToDeclaredPropertyType", object);
        }
        return object;
    }

    private Properties convertStringToProperties(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertStringToProperties", string);
        }
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=");
        while (stringTokenizer.hasMoreTokens()) {
            properties.setProperty(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertStringToProperties", properties);
        }
        return properties;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        String string = this.getProperty("password");
        if (string != null) {
            this.setProperty("password", PasswordUtil.passwordEncode(string));
        }
        objectOutputStream.defaultWriteObject();
        if (string != null) {
            this.setProperty("password", PasswordUtil.passwordDecode(string));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = this.getProperty("password");
        if (string != null) {
            this.setProperty("password", PasswordUtil.passwordDecode(string));
        }
    }
}

