/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm;

import com.ibm.ejs.cm.CMProperties;
import com.ibm.ejs.cm.DataSourceImpl;
import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.cm.pool.ConnectionFactory;
import com.ibm.ejs.cm.pool.JDBC1xConnectionFactory;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;

class JDBC1PhaseRF
extends DataSourceImpl {
    private static final TraceComponent tc = Tr.register(JDBC1PhaseRF.class);

    JDBC1PhaseRF(CMProperties cMProperties) {
        super(cMProperties);
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionFactory");
        }
        DataSourceProperties dataSourceProperties = this.attrs.getDataSourceProperties();
        PortabilityLayer portabilityLayer = PortabilityLayerFactory.getPortabilityLayer(dataSourceProperties);
        ConnectionPoolDataSource connectionPoolDataSource = portabilityLayer.getDataSource(dataSourceProperties);
        TraceWriter traceWriter = new TraceWriter("jdbc." + this.attrs.getName());
        if (traceWriter.isTraceEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting DataSource PrintWriter");
            }
            connectionPoolDataSource.setLogWriter(new PrintWriter(traceWriter));
        }
        JDBC1xConnectionFactory jDBC1xConnectionFactory = new JDBC1xConnectionFactory(connectionPoolDataSource);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnectionFactory", jDBC1xConnectionFactory);
        }
        return jDBC1xConnectionFactory;
    }
}

