/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.cache;

import com.ibm.ejs.cm.cache.CachedStatement;
import com.ibm.ejs.cm.exception.ConnectionPoolInternalErrorException;
import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.ResourceAllocationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.CastoutPolicy;
import com.ibm.ejs.util.LRUCache;
import com.ibm.ejs.util.LRUCacheElement;
import com.ibm.websphere.pmi.ConnPoolPerf;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public final class StatementCache {
    private static final int RESOURCE_ALLOCATION_RETRY_LIMIT = 4;
    private final LRUCache freeStatements;
    private final ArrayList busyStatements;
    private final ConnPoolPerf connPoolData;
    private final ConnectO connectO;
    private final Connection conn;
    private static final TraceComponent tc = Tr.register(StatementCache.class);

    public StatementCache(Connection connection, ConnPoolPerf connPoolPerf, ConnectO connectO, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{connection});
        }
        this.connectO = connectO;
        this.connPoolData = connPoolPerf;
        this.conn = connection;
        CastoutPolicy castoutPolicy = new CastoutPolicy(){

            public void castout(LRUCacheElement lRUCacheElement) {
                CachedStatement cachedStatement = (CachedStatement)lRUCacheElement;
                cachedStatement.destroy();
                if (StatementCache.this.connPoolData != null) {
                    StatementCache.this.connPoolData.preparedStmtCacheDiscard();
                }
            }
        };
        this.freeStatements = new LRUCache(n, castoutPolicy);
        this.busyStatements = new ArrayList(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareStatement", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sql, type, and concurrency", new Object[]{string, new Integer(n), new Integer(n2)});
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 25);
        stringBuffer.append(string).append(n).append(n2);
        String string2 = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key for Hashtable ", string2);
        }
        CachedStatement cachedStatement = null;
        StatementCache statementCache = this;
        synchronized (statementCache) {
            cachedStatement = (CachedStatement)this.freeStatements.remove(string2);
        }
        if (cachedStatement == null) {
            cachedStatement = this.reallyPrepareStatement(string2, string, n, n2);
        } else {
            statementCache = this;
            synchronized (statementCache) {
                this.busyStatements.add(cachedStatement);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareStatement", cachedStatement);
        }
        return cachedStatement;
    }

    public void releaseStatements() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseStatements");
        }
        if (this.busyStatements != null) {
            Iterator iterator = this.busyStatements.iterator();
            while (iterator.hasNext()) {
                CachedStatement cachedStatement = (CachedStatement)iterator.next();
                this.freeStatements.put(cachedStatement.getStatementString(), cachedStatement);
            }
            this.busyStatements.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseStatements");
        }
    }

    synchronized void releaseStatement(CachedStatement cachedStatement) throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseStatement", cachedStatement);
        }
        if (!(bl = this.busyStatements.remove(cachedStatement))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "releaseStatement: Unknown statement");
            }
            throw new ConnectionPoolInternalErrorException(cachedStatement + " doesn't belong to this cache");
        }
        cachedStatement.clearParameters();
        PortabilityLayer portabilityLayer = (PortabilityLayer)this.connectO.getPortabilityLayer();
        portabilityLayer.resetStatement(cachedStatement);
        this.freeStatements.put(cachedStatement.getStatementString(), cachedStatement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseStatement");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        Object object = this.freeStatements.elements();
        while (object.hasMoreElements()) {
            ((CachedStatement)object.nextElement()).destroy();
        }
        object = this.busyStatements.iterator();
        while (object.hasNext()) {
            ((CachedStatement)object.next()).destroy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedStatement reallyPrepareStatement(String string, String string2, int n, int n2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reallyPrepareStatement", new Object[]{string, string2});
        }
        int n3 = 0;
        while (true) {
            try {
                CachedStatement cachedStatement = n == 1003 && n2 == 1007 ? new CachedStatement(this, string, this.conn.prepareStatement(string2)) : new CachedStatement(this, string, this.conn.prepareStatement(string2, n, n2));
                StatementCache statementCache = this;
                synchronized (statementCache) {
                    this.busyStatements.add(cachedStatement);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "reallyPrepareStatement", cachedStatement);
                }
                return cachedStatement;
            }
            catch (ResourceAllocationException resourceAllocationException) {
                if (++n3 <= 4) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "reallyPrepareStatement: hit retry limit", resourceAllocationException.getNativeException());
                }
                throw resourceAllocationException.getNativeException();
            }
            catch (SQLException sQLException) {
                if (this.connectO != null) {
                    throw this.connectO.translateException(sQLException);
                }
                throw sQLException;
            }
            break;
        }
    }
}

