/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.logger;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayOutputStream;

public class TraceOutputStream
extends ByteArrayOutputStream {
    private final TraceComponent destination;
    private StringBuffer textBuf = new StringBuffer();
    private static final TraceComponent tc = Tr.register(TraceOutputStream.class);

    public TraceOutputStream(String string) {
        this.destination = Tr.register(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) {
        if (this.destination.isDebugEnabled()) {
            TraceOutputStream traceOutputStream = this;
            synchronized (traceOutputStream) {
                super.write(n);
                if (this.count > 32) {
                    this.formatTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) {
        if (this.destination.isDebugEnabled()) {
            TraceOutputStream traceOutputStream = this;
            synchronized (traceOutputStream) {
                super.write(byArray, n, n2);
                this.formatTrace();
            }
        }
    }

    public boolean isTraceEnabled() {
        return this.destination.isDebugEnabled();
    }

    private synchronized void formatTrace() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatTrace");
        }
        this.textBuf.append(this.toString());
        this.reset();
        int n = 0;
        for (int i = 0; i < this.textBuf.length(); ++i) {
            if (this.textBuf.charAt(i) != '\n') continue;
            String string = this.textBuf.substring(n, i);
            n = i + 1;
            if (!this.destination.isDebugEnabled()) continue;
            Tr.debug(this.destination, string);
        }
        if (n > 0 && n < this.textBuf.length()) {
            this.textBuf = new StringBuffer(this.textBuf.substring(n));
        } else if (n >= this.textBuf.length()) {
            this.textBuf = new StringBuffer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatTrace");
        }
    }
}

