/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.pool;

import com.ibm.ejs.cm.CMPropertiesImpl;
import com.ibm.ejs.cm.CMXAResourceImpl;
import com.ibm.ejs.cm.ConnectionManagerTracer;
import com.ibm.ejs.cm.cache.StatementCache;
import com.ibm.ejs.cm.exception.IllegalConnectionUseException;
import com.ibm.ejs.cm.exception.IllegalTransactionStateException;
import com.ibm.ejs.cm.exception.TransactionAbortedException;
import com.ibm.ejs.cm.exception.WorkRolledbackException;
import com.ibm.ejs.cm.pool.ConnectOEventListener;
import com.ibm.ejs.cm.pool.ConnectionPool;
import com.ibm.ejs.cm.pool.ExtendedConnection;
import com.ibm.ejs.cm.pool.IllegalIsolationLevelChangeException;
import com.ibm.ejs.cm.pool.InvocationCollaborator;
import com.ibm.ejs.cm.portability.OraclePortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerExt;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.QueueElement;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.ws.LocalTransaction.LTCSystemException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.IllegalResourceIn2PCTransactionException;
import com.ibm.ws.Transaction.OnePhaseXAResource;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.SystemException;

public class ConnectO
extends QueueElement
implements ExtendedConnection,
OnePhaseXAResource,
Synchronization,
AlarmListener,
InvocationCollaborator {
    private Xid xid;
    private boolean rolledBack = false;
    protected Connection connection;
    protected final ConnectionPool pool;
    private final String username;
    private final String password;
    protected UOWCoordinator uowCoord;
    private boolean isGlobalCoordinator = false;
    private StatementCache statementCache;
    protected int state = 0;
    protected static final int FREE = 0;
    protected static final int ALLOCATED = 1;
    protected static final int ALLOCATED_REG_SYNC = 2;
    protected static final int ALLOCATED_TX = 3;
    protected static final int PREPARING = 4;
    protected static final int DESTROYED = 5;
    private static final String[] stateStrings = new String[]{"FREE", "ALLOCATED", "ALLOCATED_REG_SYNC", "ALLOCATED_TX", "PREPARING", "DESTROYED"};
    private boolean autoCommit = true;
    private boolean autoCommit_Last = true;
    private int isolationLevel = 0;
    private boolean isolationLevelChanged = false;
    private boolean readOnlyChanged = false;
    private Alarm idleAlarm;
    private static final Object IDLE_ALARM = new Object();
    private Vector listeners = new Vector(4);
    private boolean canAddListener = true;
    protected boolean dirty = false;
    protected int refCount = 0;
    protected int numInUse = 0;
    protected boolean orphaned = false;
    protected int aged = 0;
    protected boolean cleanwarning = false;
    protected boolean maybeStale = false;
    protected boolean alreadyDestroyed = false;
    protected static final int ENLISTED_IN_NOTRAN = 0;
    protected static final int INVOLVED_IN_LOCALTRAN = 1;
    protected static final int ENLISTED_IN_LOCALTRAN = 2;
    protected static final int ENLISTED_IN_GLOBALTRAN = 3;
    protected static final int INVOLVED_IN_RRSLOCALTRAN = 4;
    protected static final int INVOLVED_IN_RRSGLOBALTRAN = 5;
    protected int transactionState = 0;
    private static final String[] tranStateStrings = new String[]{"ENLISTED_IN_NOTRAN", "INVOLVED_IN_LOCALTRAN", "ENLISTED_IN_LOCALTRAN", "ENLISTED_IN_GLOBALTRAN", "INVOLVED_IN_RRSLOCALTRAN", "INVOLVED_IN_RRSGLOBALTRAN"};
    private XAConnection xaConnection = null;
    private PooledConnection pooledConnection = null;
    boolean supports2PC = false;
    boolean rrsTransactional = false;
    public boolean oraTransLoose = false;
    private Method getCurrentUOW = null;
    private static EJBContainer ejbContainer;
    private ConnectionManagerTracer tracer = null;
    private static final TraceComponent tc;

    public void setHoldability(int n) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "setHoldability(int)");
        throw new SQLException("This method is not supported.");
    }

    public int getHoldability() throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "getHoldability()");
        throw new SQLException("This method is not supported.");
    }

    public Savepoint setSavepoint() throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "setSavepoint()");
        throw new SQLException("This method is not supported.");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "setSavepoint(String)");
        throw new SQLException("This method is not supported.");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "rollback(Savepoint)");
        throw new SQLException("This method is not supported.");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "releaseSavepoint(Savepoint)");
        throw new SQLException("This method is not supported.");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "createStatement(int, int, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, int, int, int)");
        throw new SQLException("This method is not supported.");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareCall(String, int, int, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, int[])");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, String[])");
        throw new SQLException("This method is not supported.");
    }

    protected ConnectO(PooledConnection pooledConnection, ConnectionPool connectionPool, String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "1 Phase ConnectO Constructor");
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass("com.ibm.ejs.j2c.ConnectorRuntime");
            this.getCurrentUOW = clazz.getMethod("getCurrentUOW", null);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find getCurrentUOW in ConnectorRuntime");
            }
            throw new SQLException(exception.getMessage());
        }
        this.pooledConnection = pooledConnection;
        ((PortabilityLayer)connectionPool.getPortabilityLayer()).configurePooledConnection(pooledConnection, (CMPropertiesImpl)connectionPool.getAttributes());
        this.connection = pooledConnection.getConnection();
        this.supports2PC = false;
        this.pool = connectionPool;
        this.username = string != null ? string : "_null_username";
        this.password = string2 != null ? string2 : "_null_password";
        this.initialize(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "1 Phase ConnectO Constructor");
        }
    }

    protected ConnectO(XAConnection xAConnection, ConnectionPool connectionPool, String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "2PC Constructor");
        }
        CMPropertiesImpl cMPropertiesImpl = (CMPropertiesImpl)connectionPool.getAttributes();
        this.oraTransLoose = cMPropertiesImpl.getOraTransLoose();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass("com.ibm.ejs.j2c.ConnectorRuntime");
            this.getCurrentUOW = clazz.getMethod("getCurrentUOW", null);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find getCurrentUOW in ConnectorRuntime");
            }
            throw new SQLException(exception.getMessage());
        }
        this.xaConnection = xAConnection;
        ((PortabilityLayer)connectionPool.getPortabilityLayer()).configureXAConnection(xAConnection, (CMPropertiesImpl)connectionPool.getAttributes());
        this.connection = xAConnection.getConnection();
        this.supports2PC = true;
        this.pool = connectionPool;
        this.username = string != null ? string : "_null_username";
        this.password = string2 != null ? string2 : "_null_password";
        this.initialize(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "2PC Constructor");
        }
    }

    protected ConnectO(PooledConnection pooledConnection, ConnectionPool connectionPool, String string, String string2, String string3) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RRSTransactional ConnectO Constructor");
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass("com.ibm.ejs.j2c.ConnectorRuntime");
            this.getCurrentUOW = clazz.getMethod("getCurrentUOW", null);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find getCurrentUOW in ConnectorRuntime");
            }
            throw new SQLException(exception.getMessage());
        }
        this.pooledConnection = pooledConnection;
        ((PortabilityLayer)connectionPool.getPortabilityLayer()).configurePooledConnection(pooledConnection, (CMPropertiesImpl)connectionPool.getAttributes());
        this.connection = pooledConnection.getConnection();
        this.supports2PC = false;
        this.rrsTransactional = true;
        this.pool = connectionPool;
        this.username = string != null ? string : "_null_username";
        this.password = string2 != null ? string2 : "_null_password";
        this.initialize(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RRSTransactional ConnectO Constructor");
        }
    }

    public void setCurrentSQLID(String string) throws SQLException {
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting currentSQLID to " + string);
            }
            String string2 = "set current sqlid = '" + string + "'";
            Statement statement = this.connection.createStatement();
            statement.executeUpdate(string2);
            statement.close();
        }
    }

    private void initialize(String string, String string2) throws SQLException {
        this.isolationLevel = this.connection.getTransactionIsolation();
        this.autoCommit = this.connection.getAutoCommit();
        ((PortabilityLayer)this.pool.getPortabilityLayer()).configureConnection(this.connection, (CMPropertiesImpl)this.pool.getAttributes());
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Initial settings: isolattionLevel, autoCommit, 2PC, RRSTransactional, user ", new Object[]{new Integer(this.isolationLevel), new Boolean(this.autoCommit), new Boolean(this.supports2PC), new Boolean(this.rrsTransactional), new String(this.username)});
        }
    }

    public final void addEventListener(ConnectOEventListener connectOEventListener) throws SQLException {
        if (!this.canAddListener) {
            throw new StaleConnectionException("ConnectO is no longer available.");
        }
        this.listeners.addElement(connectOEventListener);
    }

    public final void removeEventListener(ConnectOEventListener connectOEventListener) {
        this.listeners.removeElement(connectOEventListener);
    }

    public final ConnectionPool getPool() {
        return this.pool;
    }

    public final String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + " [supports2PC=" + this.supports2PC() + ", rrsTransactional=" + this.supportsRRSTransactional() + ", " + this.getStateString() + ", " + this.getTransactionStateString() + ", RefCNT=" + this.refCount + "]";
    }

    protected final String getStateString() {
        return stateStrings[this.state];
    }

    protected final String getTransactionStateString() {
        return tranStateStrings[this.transactionState];
    }

    protected boolean supports2PC() {
        return this.supports2PC;
    }

    protected boolean supportsRRSTransactional() {
        return this.rrsTransactional;
    }

    protected synchronized void incRef() {
        switch (this.state) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                ++this.refCount;
                break;
            }
            default: {
                Error error = new Error("Illegal ConnectO state: " + this.getStateString());
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Illegal ConnectO state", error);
                }
                throw error;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decRef() throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        ConnectO connectO = this;
        synchronized (connectO) {
            if (this.refCount == 0) {
                Error error = new Error("Reference counting error");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Reference counting error", error);
                }
                throw error;
            }
            if (this.refCount == 1 && (this.rolledBack || this.transactionState == 0 && this.dirty)) {
                try {
                    if (this.connection != null) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "decRef(): Performing delayed 1PC rollback");
                        }
                        this.connection.rollback();
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "decRef(): Delayed 1PC rollback is complete");
                        }
                    } else if (tc.isEventEnabled()) {
                        Tr.event(tc, "decRef(): Null Connection, rollback not performed.");
                    }
                }
                catch (SQLException sQLException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "decRef(): Exception rolling back connection", sQLException);
                    }
                }
                finally {
                    this.dirty = false;
                    if (!this.rolledBack) {
                        bl2 = true;
                    }
                    this.rolledBack = false;
                }
            }
            switch (this.state) {
                case 1: {
                    --this.refCount;
                    bl = this.refCount == 0;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    if (this.refCount == 1) {
                        Error error = new Error("Reference counting error");
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "decRef(): Attempted to drop final reference while associated with transaction", error);
                        }
                        throw error;
                    }
                }
                case 5: {
                    --this.refCount;
                    break;
                }
                default: {
                    Error error = new Error("Illegal ConnectO state: " + this.getStateString());
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "decRef():  Illegal ConnectO state", error);
                    }
                    throw error;
                }
            }
        }
        if (bl) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "decRef(): Ref count dropped to 0; freeing connection back to pool.");
            }
            this.free();
        }
        if (bl2) {
            throw new WorkRolledbackException();
        }
    }

    public int getRefCount() {
        return this.refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean incNumInUse() throws IllegalConnectionUseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "incNumInUse()");
        }
        ConnectO connectO = this;
        synchronized (connectO) {
            if (this.state == 0) {
                return false;
            }
            ++this.numInUse;
            if (this.numInUse > 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error: Multi-threaded access of connection detected, a connection may have been leaked", new Object[]{this});
                }
                throw new IllegalConnectionUseException();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "incNumInUse: New numInUse=" + this.numInUse);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decNumInUse() {
        ConnectO connectO = this;
        synchronized (connectO) {
            --this.numInUse;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "decNumInUse: New numInUse=" + this.numInUse);
        }
    }

    protected final void enlist() throws SQLException {
        if (this.uowCoord == null) {
            UOWCurrent uOWCurrent = TransactionManagerFactory.getUOWCurrent();
            this.uowCoord = uOWCurrent.getUOWCoord();
        }
        this.enlist(this.uowCoord, false);
    }

    protected synchronized void enlist(UOWCoordinator uOWCoordinator, boolean bl) throws SQLException {
        if (tc.isEntryEnabled()) {
            if (uOWCoordinator == null) {
                Tr.entry(tc, "enlist", new Object[]{uOWCoordinator, new Boolean(bl)});
            } else {
                Tr.entry(tc, "enlist", new Object[]{uOWCoordinator, new Boolean(uOWCoordinator.isGlobal()), new Boolean(bl)});
            }
        }
        if (uOWCoordinator == null && (this.state == 1 || this.state == 2)) {
            this.transactionState = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enlist(): connection enlisted in No Transanaction.", this);
            }
            return;
        }
        if (this.rrsTransactional && this.state == 2) {
            if (!this.isolationLevelChanged()) {
                this.setConnectionIsolation(uOWCoordinator);
            }
            return;
        }
        switch (this.state) {
            case 1: 
            case 2: {
                Object object;
                if (this.state == 1) {
                    try {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist(): about to register for synchronization with Tran. ", uOWCoordinator);
                        }
                        try {
                            if (uOWCoordinator == null) {
                                throw new SQLException("INTERNAL ERROR: No valid transaction context present");
                            }
                            if (uOWCoordinator.isGlobal()) {
                                TransactionManagerFactory.getTransactionManager().registerSynchronization(uOWCoordinator, this);
                                this.isGlobalCoordinator = true;
                                if (this.rrsTransactional) {
                                    this.transactionState = 5;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "enlist(): connection involved in RRS Global Transanaction.", this);
                                    }
                                }
                            } else {
                                object = (LocalTransactionCoordinator)((Object)uOWCoordinator);
                                object.enlistSynchronization(this);
                                this.isGlobalCoordinator = false;
                                if (this.rrsTransactional) {
                                    this.transactionState = 4;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "enlist(): connection involved in RRS Local Transanaction.", this);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (this.refCount == 0) {
                                this.free();
                            }
                            throw exception;
                        }
                        this.incRef();
                        this.uowCoord = uOWCoordinator;
                        this.state = 2;
                        this.fireConnectionEnlisted(uOWCoordinator);
                        if (bl) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "enlist");
                            }
                            return;
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist: Can't register now", illegalStateException);
                        }
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"IllegalStateException", "enlist", "IllegalTransactionStateException", illegalStateException});
                        throw new IllegalTransactionStateException();
                    }
                    catch (RollbackException rollbackException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist: Transaction rolled back", (Object)rollbackException);
                        }
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"RollbackException", "enlist", "TransactionAbortedException", rollbackException});
                        throw new TransactionAbortedException();
                    }
                    catch (javax.transaction.SystemException systemException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist: System exception", (Object)systemException);
                        }
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"SystemException", "enlist", "TransactionAbortedException", systemException});
                        throw new TransactionAbortedException();
                    }
                    catch (LTCSystemException lTCSystemException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist: LTC System exception", lTCSystemException);
                        }
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"LTCSystemException", "enlist", "TransactionAbortedException", lTCSystemException});
                        throw new TransactionAbortedException();
                    }
                    catch (Exception exception) {
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"Exception", "enlist", "TransactionAbortedException", exception});
                        TransactionAbortedException transactionAbortedException = new TransactionAbortedException();
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "enlist:", transactionAbortedException);
                        }
                        throw transactionAbortedException;
                    }
                }
                if (bl) break;
                if (uOWCoordinator == null) {
                    throw new SQLException("INTERNAL ERROR: No valid transaction context present");
                }
                if (uOWCoordinator.isGlobal()) {
                    if (this.dirty) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist: Connection is dirty: cannot join global transaction");
                        }
                        Tr.error(tc, "MSG_CONM_6013E", this.pool.getAttributes().getName());
                        throw new IllegalStateException("Connection is dirty: cannot join global transaction");
                    }
                    if (this.supports2PC() && this.getPortabilityLayer() instanceof OraclePortabilityLayer) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Oracle XAConnection detected, autocommit is already set to false");
                        }
                    } else if (this.rrsTransactional) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Global tran using RRS detected .... setAutoCommit() is skipped when in RRS Global tran.");
                        }
                    } else {
                        this.setAutoCommit(false);
                    }
                    if (!this.isolationLevelChanged()) {
                        this.setConnectionIsolation(uOWCoordinator);
                    }
                    if (this.supports2PC()) {
                        object = new CMXAResourceImpl(this.xaConnection.getXAResource(), this);
                        Class clazz = null;
                        try {
                            clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                public Object run() throws ClassNotFoundException {
                                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                                    if (classLoader == null) {
                                        classLoader = ClassLoader.getSystemClassLoader();
                                    }
                                    return classLoader.loadClass(ConnectO.this.pool.getXAResourceFactoryName());
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Tr.error(tc, "MSG_CONM_6015E", new Object[]{"enlist", this.pool.getXAResourceFactoryName(), "TransactionAbortedException"});
                            throw (TransactionAbortedException)new TransactionAbortedException().initCause(privilegedActionException.getException());
                        }
                        try {
                            boolean bl2;
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "enlist(): about to Enlist XAResource in Global Tran. " + this.toString(), uOWCoordinator);
                            }
                            try {
                                bl2 = TransactionManagerFactory.getTransactionManager().enlist(uOWCoordinator, (XAResource)object, this.pool.getXAResourceFactoryName(), this.pool.getXAResourceInfo());
                            }
                            catch (SystemException systemException) {
                                this.pool.destroyConnection(this);
                                throw new TransactionAbortedException();
                            }
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Enlist completed with return code: " + bl2);
                            }
                            if (!bl2) {
                                Tr.error(tc, "MSG_CONM_6016E", "TransactionAbortedException");
                                this.pool.destroyConnection(this);
                                throw new TransactionAbortedException();
                            }
                            this.state = 3;
                            this.transactionState = 3;
                            this.incRef();
                            break;
                        }
                        catch (Exception exception) {
                            this.pool.destroyConnection(this);
                            Tr.error(tc, "MSG_CONM_6016E", "TransactionAbortedException");
                            throw new TransactionAbortedException();
                        }
                    }
                    if (this.supportsRRSTransactional()) {
                        if (!tc.isEventEnabled()) break;
                        Tr.event(tc, "RRS transactional already enlisted in transaction.");
                        break;
                    }
                    try {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist(): about to Enlist in GlobalTran. " + this.toString(), uOWCoordinator);
                        }
                        TransactionManagerFactory.getTransactionManager().enlistOnePhase(uOWCoordinator, this);
                        this.state = 3;
                        this.transactionState = 3;
                        this.incRef();
                        break;
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist(): Can't enlist now", illegalStateException);
                        }
                        if (illegalStateException instanceof IllegalResourceIn2PCTransactionException) {
                            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.cm.pool.ConnectO.enlist", "1054", this);
                        }
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"IllegalStateException", "enlist", "IllegalTransactionStateException", illegalStateException});
                        throw new IllegalTransactionStateException();
                    }
                    catch (RollbackException rollbackException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist(): Transaction rolled back", (Object)rollbackException);
                        }
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"RollbackException", "enlist", "TransactionAbortedException", rollbackException});
                        throw new TransactionAbortedException();
                    }
                    catch (javax.transaction.SystemException systemException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist(): System exception", (Object)systemException);
                        }
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"SystemException", "enlist", "TransactionAbortedException", systemException});
                        throw new TransactionAbortedException();
                    }
                }
                if (this.getAutoCommit()) break;
                try {
                    if (!this.isolationLevelChanged()) {
                        this.setConnectionIsolation(uOWCoordinator);
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "enlist(): about to Enlist in LocalTran. " + this.toString(), uOWCoordinator);
                    }
                    object = (LocalTransactionCoordinator)((Object)uOWCoordinator);
                    object.enlistForCleanup(this);
                    this.state = 3;
                    this.transactionState = 2;
                    this.incRef();
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "enlist: Can't enlist now", illegalStateException);
                    }
                    Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"IllegalStateException", "enlist", "IllegalTransactionStateException", illegalStateException});
                    throw new IllegalTransactionStateException();
                }
                catch (Exception exception) {
                    Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"Exception", "enlist", "TransactionAbortedException", exception});
                    TransactionAbortedException transactionAbortedException = new TransactionAbortedException();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "enlist:", transactionAbortedException);
                    }
                    throw transactionAbortedException;
                }
            }
            case 3: {
                Object object;
                if (this.transactionState == 1 && !this.autoCommit) {
                    try {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist(): about to reEnlist in LocalTran. " + this.toString(), uOWCoordinator);
                        }
                        object = (LocalTransactionCoordinator)((Object)uOWCoordinator);
                        object.enlistForCleanup(this);
                        this.incRef();
                        this.transactionState = 2;
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist(): Can't enlist now", illegalStateException);
                        }
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"IllegalStateException", "enlist", "IllegalTransactionStateException", illegalStateException});
                        throw new IllegalTransactionStateException();
                    }
                    catch (LTCSystemException lTCSystemException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "enlist(): LTC System exception", lTCSystemException);
                        }
                        Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"LTCSystemException", "enlist", "TransactionAbortedException", lTCSystemException});
                        throw new TransactionAbortedException();
                    }
                }
            }
            case 4: {
                if (uOWCoordinator == null || this.transactionState != 3 && this.transactionState != 1 || uOWCoordinator.equals(this.uowCoord)) break;
                Tr.error(tc, "MSG_CONM_6017E");
                Object object = new IllegalStateException("Connection already associated with transaction");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlist:", object);
                }
                throw object;
            }
            default: {
                Tr.error(tc, "MSG_CONM_6011E", new Object[]{this.getStateString(), this.pool.getAttributes().getName()});
                Error error = new Error("Illegal ConnectO state: " + this.getStateString());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlist:", error);
                }
                throw error;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enlist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allocate(UOWCoordinator uOWCoordinator) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "allocate", uOWCoordinator);
        }
        ConnectO connectO = this;
        synchronized (connectO) {
            if (this.state != 0) {
                Tr.error(tc, "MSG_CONM_6011E", new Object[]{this.getStateString(), this.pool.getAttributes().getName()});
                Error error = new Error("Illegal ConnectO state: " + this.getStateString());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "allocate:", error);
                }
                throw error;
            }
            this.state = 1;
            this.isolationLevelChanged = false;
            if (this.idleAlarm != null) {
                this.idleAlarm.cancel();
                this.idleAlarm = null;
            }
            this.enlist(uOWCoordinator, true);
        }
        try {
            if (uOWCoordinator != null && uOWCoordinator.isGlobal()) {
                if (this.supports2PC() && this.getPortabilityLayer() instanceof OraclePortabilityLayer) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Oracle XAConnection detected, autocommit is already set to false");
                    }
                } else if (this.rrsTransactional) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Global tran using RRS detected .... setAutoCommit() is skipped when in RRS Global tran.");
                    }
                } else {
                    this.setAutoCommit(false);
                }
            } else if (this.supports2PC() && this.getPortabilityLayer() instanceof OraclePortabilityLayer) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Oracle XAConnection detected, autocommit was not set to true for Local Transaction");
                }
            } else {
                this.setAutoCommit(true);
            }
        }
        catch (SQLException sQLException) {
            if (this.refCount == 0) {
                this.free();
            }
            Tr.error(tc, "MSG_CONM_6012E", this.pool.getAttributes().getName());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "allocate: Error", sQLException);
            }
            throw this.translateException(sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "allocate");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void free() {
        SQLWarning sQLWarning;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "free");
            }
            sQLWarning = null;
            ConnectO connectO = this;
            synchronized (connectO) {
                if (this.refCount != 0) {
                    Error error = new Error("Reference counting error");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "free():", error);
                    }
                    throw error;
                }
                if (this.state == 5) {
                    return;
                }
                if (this.state != 1) {
                    Error error = new Error("Illegal ConnectO state: " + this.getStateString());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "free():", error);
                    }
                    throw error;
                }
                if (this.statementCache != null) {
                    this.statementCache.releaseStatements();
                }
                if (this.pool.getIdleTimeoutInMillis() > 0) {
                    this.idleAlarm = AlarmManager.create(this.pool.getIdleTimeoutInMillis(), this, IDLE_ALARM);
                }
                this.state = 0;
                this.canAddListener = true;
            }
            try {
                sQLWarning = this.connection.getWarnings();
            }
            catch (SQLException sQLException) {
                if (!tc.isEventEnabled()) break block17;
                Tr.event(tc, "free(): SQLException while getting warnings");
            }
        }
        if (this.cleanwarning || sQLWarning != null) {
            try {
                this.connection.clearWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.cleanwarning = false;
        }
        this.pool.returnConnection(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "free");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void checkForOrphan() {
        if (ConnectO.tc.isEntryEnabled()) {
            Tr.entry(ConnectO.tc, "checkForOrphan");
        }
        var1_1 = -1;
        var2_2 = this;
        synchronized (var2_2) {
            if (!this.orphaned) {
                if (this.numInUse == 0) {
                    this.orphaned = true;
                }
                if (ConnectO.tc.isEntryEnabled()) {
                    Tr.exit(ConnectO.tc, "checkForOrphan");
                }
                return;
            }
            this.orphaned = false;
            var1_1 = this.state;
        }
        switch (var1_1) {
            case 1: {
                var2_2 = (CMPropertiesImpl)this.pool.getAttributes();
                if (!var2_2.isDiagOptionEnabled(1 | 2)) ** GOTO lbl35
                if (this.tracer == null) ** GOTO lbl-1000
                if (var2_2.isDiagOptionEnabled(2)) {
                    Tr.warning(ConnectO.tc, "MSG_CONM_6020W", new Object[]{this.pool.getAttributes().getName(), this.tracer});
                } else lbl-1000:
                // 2 sources

                {
                    v0 = new Object[3];
                    v0[0] = "diagOptions";
                    v0[1] = new Integer(2);
                    v0[2] = this.pool.getAttributes().getName();
                    Tr.warning(ConnectO.tc, "MSG_CONM_6027W", v0);
                }
lbl35:
                // 3 sources

                this.fireOrphanTimeoutEvent();
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (!ConnectO.tc.isDebugEnabled()) break;
                Tr.debug(ConnectO.tc, "checkForOrphan(): ignore OrphanTimeout alarm", this);
                break;
            }
            default: {
                var3_4 = new IllegalStateException(this.getStateString());
                if (ConnectO.tc.isEventEnabled()) {
                    Tr.event(ConnectO.tc, "checkForOrphan(): Illegal state", var3_4);
                }
                throw var3_4;
            }
        }
        if (ConnectO.tc.isEntryEnabled()) {
            Tr.exit(ConnectO.tc, "checkForOrphan");
        }
    }

    protected void checkForAged() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForAged");
        }
        if (this.aged == 0) {
            this.aged = 1;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkForAged - Marked Aged");
            }
            return;
        }
        int n = this.state;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.aged = -1;
                break;
            }
            case 0: {
                this.fireConnectionAgedTimeout();
                break;
            }
            case 5: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "checkForAged(): ignore AgedTimeout alarm", this);
                break;
            }
            default: {
                IllegalStateException illegalStateException = new IllegalStateException(this.getStateString());
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "checkForAged): Illegal state", illegalStateException);
                }
                throw illegalStateException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForAged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void destroy() {
        block54: {
            if (ConnectO.tc.isEntryEnabled()) {
                Tr.entry(ConnectO.tc, "destroy");
            }
            var1_1 = false;
            var2_2 = this;
            synchronized (var2_2) {
                var3_6 = (Vector)this.listeners.clone();
                if (ConnectO.tc.isEventEnabled()) {
                    Tr.event(ConnectO.tc, ": number of listeners " + var3_6.size());
                }
                for (var4_7 = 0; var4_7 < var3_6.size(); ++var4_7) {
                    ((ConnectOEventListener)var3_6.elementAt(var4_7)).setDestroyed(this);
                }
                if (this.xaConnection != null && this.transactionState == 3 && this.supports2PC()) {
                    try {
                        var4_8 = new CMXAResourceImpl(this.xaConnection.getXAResource(), this);
                        if (ConnectO.tc.isEventEnabled()) {
                            Tr.event(ConnectO.tc, "destroy(): about to delist from GlobalTran. ", this.uowCoord);
                        }
                        if (this.state == 3) {
                            this.decRef();
                        }
                    }
                    catch (SQLException var4_9) {
                        if (ConnectO.tc.isDebugEnabled()) {
                            Tr.debug(ConnectO.tc, "destroy(): failed during delist from GlobalTran", var4_9);
                        }
                        Tr.warning(ConnectO.tc, "MSG_CONM_6002W", var4_9);
                    }
                } else if (this.transactionState == 2) {
                    try {
                        if (ConnectO.tc.isEventEnabled()) {
                            Tr.event(ConnectO.tc, "destroy(): about to delist from LocalTran. ", this.uowCoord);
                        }
                        var4_10 = (LocalTransactionCoordinator)this.uowCoord;
                        var4_10.delistFromCleanup(this);
                        this.decRef();
                    }
                    catch (SQLException var4_11) {
                        if (ConnectO.tc.isDebugEnabled()) {
                            Tr.debug(ConnectO.tc, "destroy(): failed during delist from LocalTran", var4_11);
                        }
                        Tr.warning(ConnectO.tc, "MSG_CONM_7016W", var4_11);
                    }
                } else if (this.transactionState == 3 && !this.supports2PC()) {
                    try {
                        if (ConnectO.tc.isEventEnabled()) {
                            Tr.event(ConnectO.tc, "destroy(): about to delist from Global Tran. ", this.uowCoord);
                        }
                        this.decRef();
                    }
                    catch (SQLException var4_12) {
                        if (ConnectO.tc.isDebugEnabled()) {
                            Tr.debug(ConnectO.tc, "destroy(): failed during delist from LocalTran", var4_12);
                        }
                        Tr.warning(ConnectO.tc, "MSG_CONM_7016W", var4_12);
                    }
                }
                var4_13 = this.state;
                this.state = 5;
                switch (var4_13) {
                    case 2: {
                        if (ConnectO.tc.isEventEnabled()) {
                            Tr.event(ConnectO.tc, "destroy: ALLOCATED_REG_SYNC");
                        }
                    }
                    case 3: {
                        if (ConnectO.tc.isEventEnabled()) {
                            Tr.event(ConnectO.tc, "destroy: ALLOCATED_TX");
                        }
                    }
                    case 4: {
                        if (ConnectO.tc.isEventEnabled()) {
                            Tr.event(ConnectO.tc, "destroy: PREPARING");
                        }
                        var1_1 = true;
                        break;
                    }
                    case 1: {
                        if (ConnectO.tc.isEventEnabled()) {
                            Tr.event(ConnectO.tc, "destroy: ALLOCATED");
                        }
                        if (this.connection == null) ** GOTO lbl75
                        try {
                            this.connection.rollback();
                        }
                        catch (SQLException var5_14) {
                            if (!ConnectO.tc.isDebugEnabled()) ** GOTO lbl75
                            Tr.debug(ConnectO.tc, "destroy(): failed during rollback of connection. ", var5_14);
                        }
                    }
lbl75:
                    // 5 sources

                    case 0: {
                        if (ConnectO.tc.isEventEnabled()) {
                            Tr.event(ConnectO.tc, "destroy: FREE");
                        }
                        this.destroyFinally();
                        break;
                    }
                    case 5: {
                        if (ConnectO.tc.isEntryEnabled()) {
                            Tr.exit(ConnectO.tc, "destroy(): Already destroyed");
                        }
                        return;
                    }
                    default: {
                        var5_15 = new Error("Illegal ConnectO state: " + this.getStateString());
                        if (ConnectO.tc.isEntryEnabled()) {
                            Tr.exit(ConnectO.tc, "destroy(): Illegal state", var5_15);
                        }
                        throw var5_15;
                    }
                }
            }
            if (var1_1) {
                try {
                    if (this.isGlobalCoordinator) {
                        TransactionManagerFactory.getTransactionManager().getTransaction().setRollbackOnly();
                    } else {
                        ((LocalTransactionCoordinator)this.uowCoord).setRollbackOnly();
                    }
                }
                catch (Exception var2_3) {
                    if (!ConnectO.tc.isEventEnabled()) break block54;
                    Tr.event(ConnectO.tc, "destroy(): Exception from rollback_only", var2_3);
                }
            }
        }
        if (this.xaConnection != null) {
            block55: {
                try {
                    this.xaConnection.close();
                }
                catch (SQLException var2_4) {
                    if (!ConnectO.tc.isEventEnabled()) break block55;
                    Tr.event(ConnectO.tc, "destroy(): Exception closing XAConnection", var2_4);
                }
            }
            this.xaConnection = null;
        }
        if (this.pooledConnection != null) {
            block56: {
                try {
                    this.pooledConnection.close();
                }
                catch (SQLException var2_5) {
                    if (!ConnectO.tc.isEventEnabled()) break block56;
                    Tr.event(ConnectO.tc, "destroy(): Exception closing PooledConnection", var2_5);
                }
            }
            this.pooledConnection = null;
        }
        this.fireConnectionDestroyed();
        if (ConnectO.tc.isEntryEnabled()) {
            Tr.exit(ConnectO.tc, "destroy");
        }
    }

    final String getUsername() {
        return this.username;
    }

    final String getPassword() {
        return this.password;
    }

    public final synchronized void preInvoke(boolean bl) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke: " + this.toString(), new Boolean(bl));
        }
        this.incRef();
        this.orphaned = false;
        this.incNumInUse();
        switch (this.state) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.enlist();
                if (this.autoCommit) break;
                this.dirty = true;
                break;
            }
            default: {
                IllegalStateException illegalStateException = new IllegalStateException(this.getStateString());
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "preInvoke(): Illegal state", illegalStateException);
                }
                throw illegalStateException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke");
        }
    }

    public final void postInvoke(SQLException sQLException) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke", sQLException);
        }
        this.decRef();
        this.orphaned = false;
        this.decNumInUse();
        if (sQLException != null) {
            if (sQLException instanceof SQLWarning) {
                this.cleanwarning = true;
            } else if (sQLException instanceof SQLException) {
                try {
                    if (this.autoCommit && this.getPortabilityLayer() instanceof OraclePortabilityLayer) {
                        this.connection.rollback();
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        if (object == IDLE_ALARM) {
            ConnectO connectO = this;
            synchronized (connectO) {
                this.idleAlarm = null;
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            this.fireConnectionIdleTimeout();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    public synchronized void beforeCompletion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion");
        }
        switch (this.state) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                this.state = 4;
                break;
            }
            default: {
                Tr.error(tc, "MSG_CONM_6011E", new Object[]{this.getStateString(), this.pool.getAttributes().getName()});
                Error error = new Error("Illegal ConnectO state: " + this.getStateString());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeCompletion():", error);
                }
                throw error;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeCompletion");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void afterCompletion(int var1_1) {
        block18: {
            if (ConnectO.tc.isEntryEnabled()) {
                Tr.entry(ConnectO.tc, "afterCompletion", new Integer(var1_1));
            }
            this.fireConnectionTxComplete(var1_1, this.uowCoord);
            var2_2 = this;
            synchronized (var2_2) {
                switch (this.state) {
                    case 3: {
                        if (var1_1 != 4) {
                            Tr.error(ConnectO.tc, "MSG_CONM_6011E", new Object[]{this.getStateString(), this.pool.getAttributes().getName()});
                            if (ConnectO.tc.isEntryEnabled()) {
                                Tr.exit(ConnectO.tc, "afterCompletion(): illegal state for commit");
                            }
                            throw new Error("Illegal ConnectO state" + this.getStateString());
                        }
                    }
                    case 4: {
                        this.state = 1;
                        this.uowCoord = null;
                        this.isGlobalCoordinator = false;
                        this.dirty = false;
                        if (!this.supports2PC() || this.transactionState != 3) ** GOTO lbl26
                        try {
                            this.decRef();
                        }
                        catch (SQLException var3_4) {
                            if (!ConnectO.tc.isEntryEnabled()) ** GOTO lbl26
                            Tr.exit(ConnectO.tc, "afterCompletion():", var3_4);
                        }
lbl26:
                        // 4 sources

                        this.transactionState = 0;
                        break;
                    }
                    case 5: {
                        this.uowCoord = null;
                        this.destroyFinally();
                        break;
                    }
                    case 2: {
                        this.uowCoord = null;
                        this.isGlobalCoordinator = false;
                        this.dirty = false;
                        this.state = 1;
                        break;
                    }
                    default: {
                        Tr.error(ConnectO.tc, "MSG_CONM_6011E", new Object[]{this.getStateString(), this.pool.getAttributes().getName()});
                        var3_5 = new Error("Illegal ConnectO state: " + this.getStateString());
                        if (ConnectO.tc.isEntryEnabled()) {
                            Tr.exit(ConnectO.tc, "afterCompletion():", var3_5);
                        }
                        throw var3_5;
                    }
                }
            }
            try {
                this.decRef();
            }
            catch (SQLException var2_3) {
                if (!ConnectO.tc.isEntryEnabled()) break block18;
                Tr.exit(ConnectO.tc, "afterCompletion():", var2_3);
            }
        }
        if (ConnectO.tc.isEntryEnabled()) {
            Tr.exit(ConnectO.tc, "afterCompletion");
        }
    }

    public final Connection getPhysicalConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unilateralCommit() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unilateralCommit");
        }
        if (this.supports2PC() && this.transactionState == 3) {
            Tr.error(tc, "MSG_CONM_6018E");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unilateralCommit(): unilateralCommit not allowed for 2PC global tran.");
            }
            throw new SQLException("Illegal operation");
        }
        try {
            ConnectO connectO = this;
            synchronized (connectO) {
                switch (this.state) {
                    case 3: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unilateralCommit(): commiting connection");
                        }
                        this.connection.commit();
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        throw new IllegalStateException("Illegal operation for state " + this.getStateString());
                    }
                    default: {
                        throw new Error("Illegal ConnectO state: " + this.getStateString());
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            block18: {
                try {
                    ((Transaction)this.uowCoord).setRollbackOnly();
                }
                catch (javax.transaction.SystemException systemException) {
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "unilateralCommit(): Exception from setRollbackOnly", (Object)systemException);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unilateralCommit(): Exception committing connection", sQLException);
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unilateralCommit");
        }
    }

    public final PortabilityLayerExt getPortabilityLayer() throws SQLException {
        return this.pool.getPortabilityLayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLException translateException(SQLException sQLException) throws SQLException {
        SQLException sQLException2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "translateException");
        }
        if ((sQLException2 = this.pool.getErrorMap().translateException(sQLException)) instanceof StaleConnectionException) {
            if (!this.alreadyDestroyed) {
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    if (this.maybeStale) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Connection was marked stale. Destroying");
                        }
                        this.pool.destroyConnection(this);
                    } else {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "StaleConnectionException caught - purging the pool");
                        }
                        this.pool.destroyConnection(this);
                        this.pool.destroyAllFreeConnections();
                    }
                }
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Connection was already in process of destruction, skipped destroy calls");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "translateException");
        }
        return sQLException2;
    }

    public final String getColumnTypeSpec(int n) throws SQLException {
        return ((PortabilityLayer)this.pool.getPortabilityLayer()).getColumnTypeSpec(n);
    }

    public final String addRowLockHint(String string) {
        return ((PortabilityLayer)this.pool.getPortabilityLayer()).addRowLockHint(string);
    }

    public final Statement createStatement(int n, int n2) throws SQLException {
        return this.connection.createStatement(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        CMPropertiesImpl cMPropertiesImpl = (CMPropertiesImpl)this.pool.getAttributes();
        if (cMPropertiesImpl.getMaxStatementCacheSize() > 0) {
            ConnectO connectO = this;
            synchronized (connectO) {
                if (this.statementCache == null) {
                    this.statementCache = this.pool.createStatementCache(this.connection, this);
                }
            }
            return this.statementCache.prepareStatement(string, n, n2);
        }
        if (n == 1003 && n2 == 1007) {
            return this.connection.prepareStatement(string);
        }
        return this.connection.prepareStatement(string, n, n2);
    }

    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.connection.prepareCall(string, n, n2);
    }

    public final Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    public final Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        return this.connection.prepareCall(string);
    }

    public final String nativeSQL(String string) throws SQLException {
        return this.connection.nativeSQL(string);
    }

    public final synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAutoCommit", new Boolean(bl));
        }
        boolean bl2 = this.autoCommit;
        switch (this.state) {
            case 3: {
                if (bl && this.transactionState == 3) {
                    IllegalStateException illegalStateException = new IllegalStateException("Cannot enable auto commit within JTS transaction");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "setAutoCommit: Illegal state", illegalStateException);
                    }
                    throw illegalStateException;
                }
            }
            case 1: 
            case 2: {
                if (bl && this.transactionState == 5) {
                    IllegalStateException illegalStateException = new IllegalStateException("Cannot enable auto commit within RRS Global transaction");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "setAutoCommit: Illegal state", illegalStateException);
                    }
                    throw illegalStateException;
                }
                if (this.autoCommit == bl) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setAutoCommit(): changing autoCommit to:", new Boolean(bl));
                }
                this.connection.setAutoCommit(bl);
                this.autoCommit = bl;
                this.dirty = false;
                break;
            }
            default: {
                IllegalStateException illegalStateException = new IllegalStateException(this.getStateString());
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "setAutoCommit: Illegal state", illegalStateException);
                }
                throw illegalStateException;
            }
        }
        if (!bl2 && bl && this.transactionState == 2) {
            this.dirty = false;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "setAutoCommit(): about to delist from LocalTran. " + this.toString(), this.uowCoord);
            }
            LocalTransactionCoordinator localTransactionCoordinator = (LocalTransactionCoordinator)((Object)this.uowCoord);
            localTransactionCoordinator.delistFromCleanup(this);
            this.decRef();
            this.transactionState = 1;
            if (this.state == 3) {
                this.state = 2;
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "delisted ConnectO from local tran", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoCommit");
        }
    }

    public final boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void commit() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit - connection local");
        }
        switch (this.state) {
            case 1: 
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "commiting connection");
                }
                try {
                    this.connection.commit();
                    break;
                }
                catch (SQLException sQLException) {
                    if (this.supports2PC() && this.getPortabilityLayer() instanceof OraclePortabilityLayer) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "It is illegal to use a connection commit with an Oracle XAConnection");
                        }
                        if (!tc.isEntryEnabled()) throw new IllegalConnectionUseException();
                        Tr.exit(tc, "commit(): Error", sQLException);
                        throw new IllegalConnectionUseException();
                    }
                    if (!tc.isEntryEnabled()) throw this.translateException(sQLException);
                    Tr.exit(tc, "commit(): Error", sQLException);
                    throw this.translateException(sQLException);
                }
                finally {
                    this.dirty = false;
                    this.isolationLevelChanged = false;
                }
            }
            case 3: {
                if (this.transactionState != 1 && this.transactionState != 2) throw new IllegalStateException("Illegal operation: tried to commit connection in global tran");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "commiting connection");
                }
                try {
                    this.connection.commit();
                }
                catch (SQLException sQLException) {
                    if (!tc.isEntryEnabled()) throw this.translateException(sQLException);
                    Tr.exit(tc, "commit(): Error", sQLException);
                    throw this.translateException(sQLException);
                }
                finally {
                    this.dirty = false;
                    this.isolationLevelChanged = false;
                }
                try {
                    if (this.transactionState != 2) break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "commit(): about to delist from LocalTran. " + this.toString(), this.uowCoord);
                    }
                    LocalTransactionCoordinator localTransactionCoordinator = (LocalTransactionCoordinator)((Object)this.uowCoord);
                    localTransactionCoordinator.delistFromCleanup(this);
                    this.decRef();
                    this.transactionState = 1;
                    this.state = 2;
                    if (!tc.isEventEnabled()) break;
                    Tr.event(tc, "delisted ConnectO from local tran", this);
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    if (!tc.isEventEnabled()) throw new IllegalTransactionStateException();
                    Tr.event(tc, "delist: Can't delist now", illegalStateException);
                    throw new IllegalTransactionStateException();
                }
                catch (Exception exception) {
                    Tr.error(tc, "MSG_CONM_7017E", exception);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception on delistResource for Local Tran", exception);
                    }
                    TransactionAbortedException transactionAbortedException = new TransactionAbortedException();
                    if (!tc.isEntryEnabled()) throw transactionAbortedException;
                    Tr.exit(tc, "enlist:", transactionAbortedException);
                    throw transactionAbortedException;
                }
            }
            default: {
                throw new IllegalStateException("Illegal operation");
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "commit");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void rollback() throws SQLException {
        switch (this.state) {
            case 1: 
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rolling back connection");
                }
                try {
                    this.connection.rollback();
                    return;
                }
                catch (SQLException sQLException) {
                    if (!tc.isEntryEnabled()) throw this.translateException(sQLException);
                    Tr.exit(tc, "rollback: Error", sQLException);
                    throw this.translateException(sQLException);
                }
                finally {
                    this.dirty = false;
                    this.isolationLevelChanged = false;
                }
            }
            case 3: {
                if (this.transactionState != 1 && this.transactionState != 2) throw new IllegalStateException("Illegal operation: tried to commit connection in global tran");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rolling back connection");
                }
                try {
                    this.connection.rollback();
                }
                catch (SQLException sQLException) {
                    if (!tc.isEntryEnabled()) throw this.translateException(sQLException);
                    Tr.exit(tc, "rollback: Error", sQLException);
                    throw this.translateException(sQLException);
                }
                finally {
                    this.dirty = false;
                    this.isolationLevelChanged = false;
                }
                try {
                    if (this.transactionState != 2) return;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "rollback(): about to delist from LocalTran. " + this.toString(), this.uowCoord);
                    }
                    LocalTransactionCoordinator localTransactionCoordinator = (LocalTransactionCoordinator)((Object)this.uowCoord);
                    localTransactionCoordinator.delistFromCleanup(this);
                    this.decRef();
                    this.transactionState = 1;
                    this.state = 2;
                    if (!tc.isEventEnabled()) return;
                    Tr.event(tc, "delisted ConnectO from local tran", this);
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    if (!tc.isEventEnabled()) throw new IllegalTransactionStateException();
                    Tr.event(tc, "delist: Can't delist now", illegalStateException);
                    throw new IllegalTransactionStateException();
                }
                catch (Exception exception) {
                    Tr.error(tc, "MSG_CONM_7017E", exception);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception on delistResource for Local Tran", exception);
                    }
                    TransactionAbortedException transactionAbortedException = new TransactionAbortedException();
                    if (!tc.isEntryEnabled()) throw transactionAbortedException;
                    Tr.exit(tc, "enlist:", transactionAbortedException);
                    throw transactionAbortedException;
                }
            }
            default: {
                throw new IllegalStateException("Illegal operation");
            }
        }
    }

    public final void close() {
        throw new Error("Illegal call to ConnectO.close");
    }

    public final boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        this.readOnlyChanged = bl;
        this.connection.setReadOnly(bl);
    }

    public final boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public final void setCatalog(String string) throws SQLException {
        this.connection.setCatalog(string);
    }

    public final String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public final synchronized void setTransactionIsolation(int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactionIsolation", new Integer(n));
        }
        this.isolationLevelChanged = true;
        switch (this.state) {
            case 1: 
            case 2: {
                if (this.isolationLevel == n) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting isolation level");
                }
                ((PortabilityLayer)this.pool.getPortabilityLayer()).setTransactionIsolation(this.connection, n);
                this.isolationLevel = n;
                break;
            }
            case 3: {
                if (this.isolationLevel == n) break;
                if (this.transactionState == 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting isolation level");
                    }
                    ((PortabilityLayer)this.pool.getPortabilityLayer()).setTransactionIsolation(this.connection, n);
                    this.isolationLevel = n;
                    break;
                }
                throw new IllegalIsolationLevelChangeException();
            }
            default: {
                IllegalStateException illegalStateException = new IllegalStateException(this.getStateString());
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "setTransactionIsolation: Illegal state", illegalStateException);
                }
                throw illegalStateException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTransactionIsolation");
        }
    }

    public final int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public final void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    private void setConnectionIsolation(Object object) throws SQLException {
        try {
            if (ejbContainer == null) {
                ejbContainer = (EJBContainer)new InitialContext().lookup("services:websphere/EJBContainer");
            }
            int n = ejbContainer.getIsolationLevel(this.uowCoord, this.getPortabilityLayer());
            this.setTransactionIsolation(n);
        }
        catch (NamingException namingException) {
            throw new SQLException(namingException.getMessage());
        }
    }

    protected boolean isolationLevelChanged() {
        return this.isolationLevelChanged;
    }

    protected boolean isReadOnlyChanged() {
        return this.readOnlyChanged;
    }

    private final void destroyFinally() {
        if (this.idleAlarm != null) {
            this.idleAlarm.cancel();
            this.idleAlarm = null;
        }
        if (this.statementCache != null) {
            this.statementCache.destroy();
            this.statementCache = null;
        }
        if (this.connection != null) {
            block5: {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    if (!tc.isEventEnabled()) break block5;
                    Tr.event(tc, "Exception closing connection", sQLException);
                }
            }
            this.connection = null;
        }
    }

    private final void fireConnectionDestroyed() {
        this.canAddListener = false;
        Vector vector = (Vector)this.listeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((ConnectOEventListener)vector.elementAt(i)).connectionDestroyed(this);
        }
        this.listeners.removeAllElements();
        this.canAddListener = true;
    }

    private final void fireConnectionEnlisted(Object object) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ConnectOEventListener)this.listeners.elementAt(i)).connectionEnlisted(this, object);
        }
    }

    private final void fireConnectionIdleTimeout() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            boolean bl = ((ConnectOEventListener)this.listeners.elementAt(i)).connectionIdleTimeout(this);
            if (bl) continue;
            this.idleAlarm = AlarmManager.create(this.pool.getIdleTimeoutInMillis(), this, IDLE_ALARM);
        }
    }

    private final void fireConnectionAgedTimeout() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            boolean bl = ((ConnectOEventListener)this.listeners.elementAt(i)).connectionAgedTimeout(this);
        }
    }

    private final void fireConnectionTxComplete(int n, Object object) {
        this.canAddListener = false;
        Vector vector = (Vector)this.listeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((ConnectOEventListener)vector.elementAt(i)).connectionTxComplete(this, n, object);
        }
        this.canAddListener = true;
    }

    private final void fireOrphanTimeoutEvent() {
        this.canAddListener = false;
        Vector vector = (Vector)this.listeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((ConnectOEventListener)vector.elementAt(i)).connectionOrphaned(this);
        }
        this.canAddListener = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        boolean bl = true;
        String string = ((CMPropertiesImpl)this.pool.getAttributes()).getValidateSQL();
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (SQLException sQLException) {
            Tr.warning(tc, "MSG_CONM_6019W", new Object[]{this.pool.getAttributes().getName(), sQLException});
            bl = false;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    public void setMaybeStale(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMaybeStale", new Boolean(bl));
        }
        this.maybeStale = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMaybeStale", new Boolean(this.maybeStale));
        }
    }

    public final int prepare(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", xid);
        }
        Tr.warning(tc, "MSG_CONM_6000W", this.pool.getAttributes().getName());
        XAException xAException = new XAException(103);
        FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.cm.pool.ConnectO.prepare", "3383", this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare", xAException);
        }
        throw xAException;
    }

    public final synchronized void commit(Xid xid, boolean bl) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Object[]{xid, new Boolean(bl)});
        }
        if (this.xid != null && !xid.equals(this.xid)) {
            XAException xAException = new XAException(-4);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Error: Connection is already involved in different transaction.", xAException);
            }
            throw xAException;
        }
        if (!bl) {
            XAException xAException = new XAException(-6);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Illegal 2PC commit attempt", xAException);
            }
            throw xAException;
        }
        if (this.state != 4) {
            Error error = new Error("Illegal ConnectO state: " + this.getStateString());
            if (tc.isEventEnabled()) {
                Tr.event(tc, "commit:", error);
            }
            throw error;
        }
        try {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Performing 1PC commit");
            }
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "1PC commit failed", sQLException);
            }
            throw new XAException(100);
        }
        finally {
            block20: {
                this.xid = null;
                this.dirty = false;
                try {
                    this.decRef();
                }
                catch (SQLException sQLException) {
                    if (!tc.isEventEnabled()) break block20;
                    Tr.event(tc, "decRef failed", sQLException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final synchronized void rollback(Xid var1_1) throws XAException {
        if (ConnectO.tc.isEntryEnabled()) {
            Tr.entry(ConnectO.tc, "rollback", var1_1);
        }
        if (this.xid != null && !var1_1.equals(this.xid)) {
            var2_2 = new XAException(-4);
            if (ConnectO.tc.isEventEnabled()) {
                Tr.event(ConnectO.tc, "Mismatched Xid", var2_2);
            }
            throw var2_2;
        }
        this.xid = null;
        switch (this.state) {
            case 3: 
            case 4: 
            case 5: {
                if (this.refCount == 0) {
                    try {
                        if (ConnectO.tc.isEventEnabled()) {
                            Tr.event(ConnectO.tc, "Performing 1PC rollback");
                        }
                        this.connection.rollback();
                    }
                    catch (SQLException var2_3) {
                        if (!ConnectO.tc.isEventEnabled()) ** GOTO lbl27
                        Tr.event(ConnectO.tc, "Exception rolling back connection", var2_3);
                    }
                    finally {
                        this.dirty = false;
                    }
                } else {
                    if (ConnectO.tc.isEventEnabled()) {
                        Tr.event(ConnectO.tc, "Calls outstanding: delaying 1PC rollback");
                    }
                    this.rolledBack = true;
                }
lbl27:
                // 4 sources

                try {
                    this.decRef();
                }
                catch (SQLException var2_4) {
                    if (!ConnectO.tc.isEventEnabled()) break;
                    Tr.event(ConnectO.tc, "decRef Exception rolling back connection", var2_4);
                }
                break;
            }
            default: {
                var2_5 = new Error("Illegal ConnectO state: " + this.getStateString());
                if (ConnectO.tc.isEntryEnabled()) {
                    Tr.exit(ConnectO.tc, "rollback:", var2_5);
                }
                throw var2_5;
            }
        }
        if (ConnectO.tc.isEntryEnabled()) {
            Tr.exit(ConnectO.tc, "rollback");
        }
    }

    public final void start(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", new Object[]{xid, new Integer(n)});
        }
        if (this.state != 2) {
            Error error = new Error("Illegal ConnectO state: " + this.getStateString());
            if (tc.isEventEnabled()) {
                Tr.event(tc, "start:", error);
            }
            throw error;
        }
        if (this.xid != null) {
            XAException xAException = new XAException(-6);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "start: Already associated with tx", xAException);
            }
            throw xAException;
        }
        this.xid = xid;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public final void end(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "end", new Object[]{xid, new Integer(n)});
        }
        if (this.state != 4 && this.state != 3) {
            Error error = new Error("Illegal ConnectO state: " + this.getStateString());
            if (tc.isEventEnabled()) {
                Tr.event(tc, "end:", error);
            }
            throw error;
        }
        if (!xid.equals(this.xid)) {
            XAException xAException = new XAException(-4);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Mismatched Xid", xAException);
            }
            throw xAException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "end");
        }
    }

    public final void forget(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forget", xid);
        }
        if (this.state != 3) {
            Error error = new Error("Illegal ConnectO state: " + this.getStateString());
            if (tc.isEventEnabled()) {
                Tr.event(tc, "forget:", error);
            }
            throw error;
        }
        if (!xid.equals(this.xid)) {
            XAException xAException = new XAException(-4);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Mismatched Xid", xAException);
            }
            throw xAException;
        }
        this.xid = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forget");
        }
    }

    public final Xid[] recover(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", new Integer(n));
            Tr.exit(tc, "recover");
        }
        return new Xid[0];
    }

    public final boolean isSameRM(XAResource xAResource) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSameRM", xAResource);
        }
        boolean bl2 = bl = xAResource == this;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSameRM", new Boolean(bl));
        }
        return bl;
    }

    public final int getTransactionTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionTimeout");
            Tr.exit(tc, "getTransactionTimeout", new Integer(0));
        }
        return 0;
    }

    public final boolean setTransactionTimeout(int n) {
        return false;
    }

    public String getResourceName() {
        return this.pool.getAttributes().getName();
    }

    void setTracer(String string) {
        this.tracer = new ConnectionManagerTracer(string);
    }

    void setTracer() {
        this.tracer = new ConnectionManagerTracer();
    }

    void unsetTracer() {
        this.tracer = null;
    }

    ConnectionManagerTracer getTracer() {
        return this.tracer;
    }

    static {
        tc = Tr.register(ConnectO.class, null, "com.ibm.ejs.resources.CONMMessages");
    }
}

