/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.pool;

import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.IncidentStream;
import java.sql.SQLException;
import java.util.Vector;

public class DiagnosticModuleForCMPool
extends DiagnosticModule {
    public void ffdcDumpDefaultCM(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        if (string.equals("com.ibm.ejs.cm.pool.ConnectO.prepare") || string.equals("com.ibm.ejs.cm.pool.ConnectO.enlist")) {
            ConnectO connectO;
            incidentStream.writeLine("CONM6000W CONM6014I WTRN0062E ", "Possible misuse of connection manager may have caused 2PC transaction when 1PC tran was desired");
            ConnectO connectO2 = connectO = (ConnectO)object;
            UOWCurrent uOWCurrent = TransactionManagerFactory.getUOWCurrent();
            UOWCoordinator uOWCoordinator = uOWCurrent.getUOWCoord();
            Vector vector = connectO.pool.getConnectionsForTransaction(uOWCoordinator);
            if (vector != null && vector.size() > 1) {
                String string2 = connectO.getPassword();
                this.printConnectO(connectO, incidentStream, string2);
                for (int i = 0; i < vector.size(); ++i) {
                    connectO = (ConnectO)vector.elementAt(i);
                    if (connectO == connectO2) continue;
                    this.printConnectO(connectO, incidentStream, string2);
                }
            } else if (vector != null && vector.size() == 1) {
                incidentStream.writeLine("CONM6000W: Attempting to use a 1PC JDBC connection in a 2PC transaction.", "");
                incidentStream.writeLine("Driver used: ", connectO.getPhysicalConnection().getClass().getName());
                incidentStream.writeLine("Data Source Name: ", connectO.getPool().getAttributes().getName());
            }
        }
    }

    private void printConnectO(ConnectO connectO, IncidentStream incidentStream, String string) {
        incidentStream.writeLine("Connection ", "");
        incidentStream.writeLine("Username ", connectO.getUsername());
        incidentStream.writeLine("Same Password", string.equals(connectO.getPassword()) ? "Yes" : "No");
        try {
            incidentStream.writeLine("Isolation Level ", connectO.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            incidentStream.writeLine("Isolation Level ", sQLException.getMessage());
        }
        try {
            incidentStream.writeLine("Auto Commit ", connectO.getAutoCommit());
        }
        catch (SQLException sQLException) {
            incidentStream.writeLine("Auto Commit ", sQLException.getMessage());
        }
        try {
            incidentStream.writeLine("Read Only", connectO.isReadOnly());
        }
        catch (SQLException sQLException) {
            incidentStream.writeLine("Read Only", sQLException.getMessage());
        }
        try {
            incidentStream.writeLine("Catalog", connectO.getCatalog());
        }
        catch (SQLException sQLException) {
            incidentStream.writeLine("Catalog", sQLException.getMessage());
        }
        incidentStream.writeLine("Resource Name ", connectO.getResourceName());
        incidentStream.writeLine("", "");
    }
}

