/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.portability.DB2PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;

class DB2ConnectPortabilityLayer
extends DB2PortabilityLayer {
    private static DB2ConnectPortabilityLayer instance;
    private int is390 = 0;
    private static final String RRString = " WITH RR KEEP UPDATE LOCKS";
    private static final String RSString = " WITH RS KEEP UPDATE LOCKS";
    private static final TraceComponent tc;

    protected DB2ConnectPortabilityLayer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.typeMap.setElementAt(" VARCHAR(255) NOT NULL ", 3);
        this.typeMap.setElementAt(" VARCHAR(255) ", 4);
        this.typeMap.setElementAt(" VARCHAR(255) NOT NULL ", 11);
        this.typeMap.setElementAt(" VARCHAR(255) ", 12);
        this.typeMap.setElementAt(" LONG VARCHAR FOR BIT DATA ", 10);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    protected void setIs390(int n) {
        this.is390 = n;
    }

    public void createTable(Connection connection, String string, String string2, String string3) throws SQLException {
        block43: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createTable", new Object[]{connection, string, string2, string3});
            }
            boolean bl = connection.getAutoCommit();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "autocommit: " + bl);
            }
            if (bl) {
                connection.setAutoCommit(false);
            }
            Statement statement = null;
            try {
                String string4;
                if (string3.indexOf("BLOB") != -1) {
                    String string5;
                    string4 = string3.toUpperCase();
                    int n = string4.indexOf("PRIMARY KEY");
                    String string6 = string2;
                    if (string2.length() > 12) {
                        string6 = string2.substring(0, 12);
                    }
                    String string7 = " " + string6 + "_rowid ROWID GENERATED ALWAYS, ";
                    if (n == -1) {
                        throw new SQLException("not a valid sql create table string, needs primary key field.");
                    }
                    string4 = string4.substring(0, n) + string7 + string4.substring(n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new sql createtable string:", string4);
                    }
                    try {
                        statement = connection.createStatement();
                        statement.executeUpdate(string4);
                    }
                    catch (SQLException sQLException) {
                        if (tc.isEventEnabled() && sQLException.getErrorCode() == -601) {
                            Tr.event(tc, "table already exists", string4);
                        }
                        throw sQLException;
                    }
                    String string8 = this.getPrimaryKey(string3);
                    if (string8 != null) {
                        string5 = string2;
                        if (string2.length() > 14) {
                            string5 = string2.substring(0, 14);
                        }
                        String string9 = "create unique index " + string5 + "_idx" + " on " + string2 + " (" + string8 + ")";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "create idx: ", string9);
                        }
                        try {
                            statement = connection.createStatement();
                            statement.executeUpdate(string9);
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getErrorCode() == -601) {
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "idx already exists", string9);
                                }
                                throw new SQLException("idx already exists: " + string9);
                            }
                            throw sQLException;
                        }
                    }
                    string5 = null;
                    string5 = string.endsWith(".") ? string.substring(0, string.length() - 1) : string;
                    boolean bl2 = n != -1;
                    String string10 = string3;
                    int n2 = 0;
                    while (bl2) {
                        n = (string10 = this.createAuxTable(connection, string10, string2, string5, n2)).indexOf("BLOB");
                        bl2 = n != -1;
                        ++n2;
                    }
                    break block43;
                }
                try {
                    statement = connection.createStatement();
                    statement.executeUpdate(string3);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -601 && tc.isEventEnabled()) {
                        Tr.event(tc, "table already exists", string3);
                    }
                    throw sQLException;
                }
                string4 = this.getPrimaryKey(string3);
                if (string4 == null) break block43;
                String string11 = string2;
                if (string2.length() > 14) {
                    string11 = string2.substring(0, 14);
                }
                String string12 = "create unique index " + string11 + "_idx" + " on " + string2 + " (" + string4 + ")";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create idx: ", string12);
                }
                try {
                    statement = connection.createStatement();
                    statement.executeUpdate(string12);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -601) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "idx already exists", string12);
                        }
                        throw new SQLException("idx already exists: " + string12);
                    }
                    throw sQLException;
                }
            }
            catch (SQLException sQLException) {
                block44: {
                    if (sQLException.getErrorCode() == -601) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "name already exists; rollback connection");
                        }
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException2) {
                            if (!tc.isEventEnabled()) break block44;
                            Tr.event(tc, "Error rolling back connection", sQLException2);
                        }
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createTable", sQLException);
                }
                throw this.translateException(sQLException);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        try {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "commit connection");
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Error commit connection", sQLException);
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTable");
        }
    }

    private String getPrimaryKey(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrimaryKey");
        }
        String string2 = string.toUpperCase();
        String string3 = null;
        int n = string2.indexOf("PRIMARY KEY");
        if (n != -1) {
            String string4 = string2.substring(n);
            int n2 = string4.indexOf("(");
            int n3 = string4.indexOf(")");
            string3 = string4.substring(n2 + 1, n3);
            string3 = string3.trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrimaryKey: ", string3);
        }
        return string3;
    }

    private String createAuxTable(Connection connection, String string, String string2, String string3, int n) throws SQLException {
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuxTable: ", string);
        }
        if (n > 9) {
            throw new SQLException("can not handle more than 10 BLOB datatype fields in a table.");
        }
        String string4 = string2.substring(0, 7);
        char c = Integer.toString(n).charAt(0);
        if ((string4 = string4 + n).indexOf("_") != -1) {
            string4 = string4.replace('_', c);
        }
        String string5 = new String("CREATE LOB TABLESPACE ");
        string5 = string5 + string4;
        int n3 = string.indexOf("BLOB");
        String string6 = string.substring(0, n3);
        String string7 = string.substring(n3);
        String string8 = string.substring(n3 + 4);
        int n4 = string6.lastIndexOf(",");
        int n5 = n4 > (n2 = string6.indexOf("(")) ? n4 : n2;
        String string9 = null;
        String string10 = null;
        if (n5 != -1) {
            string9 = string.substring(n4 + 1, n3);
            string9 = string9.trim();
            String string11 = string4 + "_" + string9;
            if (string11.length() > 18) {
                string11 = string11.substring(0, 18);
            }
            string10 = "create aux table " + string11 + " in " + string4 + " stores " + string2 + " column " + string9;
            Statement statement = null;
            String string12 = null;
            try {
                statement = connection.createStatement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create lob table space: ", string5);
                }
                string12 = string5;
                statement.executeUpdate(string5);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create aux table: ", string10);
                }
                string12 = string10;
                statement.executeUpdate(string10);
                String string13 = string11;
                if (string11.length() > 14) {
                    string13 = string11.substring(0, 14);
                }
                String string14 = "create unique index " + string13 + "_idx" + " on " + string11;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create idx: ", string14);
                }
                string12 = string14;
                statement.executeUpdate(string14);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -601) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "object already exists: ", string12);
                    }
                    throw new SQLException("object already exists: " + string12);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createAuxTable", sQLException);
                }
                throw sQLException;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        } else {
            throw new SQLException("create aux table fails", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuxTable", string8);
        }
        return string8;
    }

    public void createTableForPersister(Connection connection, String string, String string2, String string3) throws SQLException {
        this.createTable(connection, string, string2, string3);
    }

    public static PortabilityLayer getInstance() throws SQLException {
        if (instance == null) {
            instance = new DB2ConnectPortabilityLayer();
        }
        return instance;
    }

    public boolean supportsExtendedForUpdate(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supportsExtendedForUpdate(Connection)");
        }
        switch (this.is390) {
            case 0: {
                String string;
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    string = databaseMetaData.getDatabaseProductName();
                }
                catch (SQLException sQLException) {
                    throw this.translateException(sQLException);
                }
                if (string.equalsIgnoreCase("DB2") || string.substring(0, 3).equalsIgnoreCase("DSN")) {
                    this.is390 = 1;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "supportsExtendedForUpdate(Connection)", new Boolean(true));
                    }
                    return true;
                }
                this.is390 = -1;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "supportsExtendedForUpdate(Connection)", new Boolean(false));
                }
                return false;
            }
            case 1: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "supportsExtendedForUpdate(Connection)", new Boolean(true));
                }
                return true;
            }
            case -1: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "supportsExtendedForUpdate(Connection)", new Boolean(false));
                }
                return false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The is390 variable is set to an incorrect value of " + this.is390);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supportsExtendedForUpdate(Connection)", new Boolean(false));
        }
        return false;
    }

    public synchronized Object extendedForUpdateInfo(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extendedForUpdateInfo(Connection)");
        }
        try {
            Integer n = new Integer(connection.getTransactionIsolation());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "extendedForUpdateInfo(Connection)", n);
            }
            return n;
        }
        catch (SQLException sQLException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "extendedForUpdateInfo(Connection)");
            }
            throw this.translateException(sQLException);
        }
    }

    public synchronized String processSQLForExtendedUpdate(String string, int n) {
        if (n == 4) {
            return string + RSString;
        }
        if (n == 8) {
            return string + RRString;
        }
        return string;
    }

    public String processSQL(String string, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSQL - sqlString, isolevel, addForUpdate, addextendedforupdate: ", new Object[]{string, new Integer(n), new Boolean(bl), new Boolean(bl2)});
        }
        if (!bl && !bl2 || string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" FOR UPDATE");
        }
        if (bl2) {
            block0 : switch (this.is390) {
                case 0: {
                    Tr.warning(tc, "MSG_CONM_7020W");
                    break;
                }
                case 1: {
                    switch (n) {
                        case 4: {
                            stringBuffer.append(RSString);
                            break block0;
                        }
                        case 8: {
                            stringBuffer.append(RRString);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSQL - The modified sqlString is: ", stringBuffer);
        }
        return new String(stringBuffer);
    }

    static {
        tc = Tr.register(DB2ConnectPortabilityLayer.class, null, "com.ibm.ejs.resources.CONMMessages");
    }
}

